<div style="margin: 0 auto; width: 650px">
	<?php
	$cancel_err = __('cancel_err', true, false);
	$payment_methods = __('payment_methods', true, false);
	if (isset($tpl['status']))
	{
		switch ($tpl['status'])
		{
			case 1:
				?><p><?php echo $cancel_err[1]; ?></p><?php
				break;
			case 2:
				?><p><?php echo $cancel_err[2]; ?></p><?php
				break;
			case 3:
				?><p><?php echo $cancel_err[3]; ?></p><?php
				break;
			case 4:
				?><p><?php echo $cancel_err[4]; ?></p><?php
				break;
		}
	} else {
		
		if (isset($_GET['err']))
		{
			switch ((int) $_GET['err'])
			{
				case 200:
					?><p><?php echo $cancel_err[200]; ?></p><?php
					break;
			}
		}
		
		if (isset($tpl['arr']))
		{
			$name_titles = __('personal_titles', true, false);
			?>
			<table cellspacing="2" cellpadding="5" style="width: 100%">
				<thead>
					<tr>
						<th colspan="2" style="text-transform: uppercase; text-align: left"><?php __('front_cancel_heading'); ?></th>
					</tr>
				</thead>
				<tbody>	
					<tr>
						<td><?php __('res_uuid'); ?></td>
						<td><?php echo $tpl['arr']['uuid']; ?></td>
					</tr>
					<tr>
						<td><?php __('lblReservationListing'); ?></td>
						<td><?php echo $tpl['arr']['listing_title']; ?></td>
					</tr>
					<tr>
						<td><?php __('front_booking_pm');?></td>
						<td><?php $payment_methods = __('payment_methods', true, false); echo $payment_methods[$tpl['arr']['payment_method']]; ?></td>
					</tr>
					<tr style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
						<td><?php __('lblReservationCCType'); ?></td>
						<td><?php $cc_types = __('cc_types', true, false); echo $cc_types[$tpl['arr']['cc_type']]; ?></td>
					</tr>
					<tr style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
						<td><?php __('lblReservationCCNum'); ?></td>
						<td><?php echo stripslashes($tpl['arr']['cc_num']); ?></td>
					</tr>
					<tr style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
						<td><?php __('lblReservationCCCode'); ?></td>
						<td><?php echo stripslashes($tpl['arr']['cc_code']); ?></td>
					</tr>
					<tr style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
						<td><?php __('lblReservationCCExp'); ?></td>
						<td><?php echo $tpl['arr']['cc_exp']; ?></td>
					</tr>
					<tr>
						<td><?php __('lblReservationFrom'); ?></td>
						<td><?php echo pjUtil::formatDate($tpl['arr']['date_from'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?></td>
					</tr>
					<tr>
						<td><?php __('lblReservationTo'); ?></td>
						<td><?php echo pjUtil::formatDate($tpl['arr']['date_to'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?></td>
					</tr>
					<tr>
						<td><?php __('lblReservationAmount'); ?></td>
						<td><?php echo pjUtil::formatCurrencySign($tpl['arr']['amount'], $tpl['option_arr']['o_currencty']); ?></td>
					</tr>
					<tr>
						<td><?php __('lblReservationDeposit'); ?></td>
						<td><?php echo pjUtil::formatCurrencySign($tpl['arr']['deposit'], $tpl['option_arr']['o_currencty']); ?></td>
					</tr>
					<tr>
						<td><?php __('lblReservationSecurity'); ?></td>
						<td><?php echo pjUtil::formatCurrencySign($tpl['arr']['security'], $tpl['option_arr']['o_currencty']); ?></td>
					</tr>
					<tr>
						<td><?php __('lblReservationTax'); ?></td>
						<td><?php echo pjUtil::formatCurrencySign($tpl['arr']['tax'], $tpl['option_arr']['o_currencty']); ?></td>
					</tr>
					<tr>
						<td><?php __('lblReservationName'); ?></td>
						<td><?php echo htmlspecialchars(stripslashes($tpl['arr']['name'])); ?></td>
					</tr>
					<tr>
						<td><?php __('lblReservationEmail'); ?></td>
						<td><?php echo htmlspecialchars(stripslashes($tpl['arr']['email'])); ?></td>
					</tr>
					<tr>
						<td><?php __('lblReservationPhone'); ?></td>
						<td><?php echo htmlspecialchars(stripslashes($tpl['arr']['phone'])); ?></td>
					</tr>
					<tr>
						<td><?php __('lblReservationNotes'); ?></td>
						<td><?php echo nl2br(stripslashes($tpl['arr']['notes'])); ?></td>
					</tr>
				</tbody>
				<tfoot>
					<tr>
						<td>&nbsp;</td>
						<td>
							<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjListings&amp;action=pjActionCancel" method="post">
								<input type="hidden" name="reservation_cancel" value="1" />
								<input type="hidden" name="id" value="<?php echo $_GET['id']; ?>" />
								<input type="hidden" name="hash" value="<?php echo $_GET['hash']; ?>" />
								<input type="submit" value="<?php __('front_button_cancel'); ?>" />
							</form>
						</td>
					</tr>
				</tfoot>
			</table>
			<?php
		}
	}
	?>
</div>
	