var jQuery_1_8_2 = $.noConflict();
(function ($, undefined) {
	$(function () {
		var tabs = ($.fn.tabs !== undefined),
			dialog = ($.fn.dialog !== undefined),
			validate = ($.fn.validate !== undefined),
			spinner = ($.fn.spinner !== undefined),
			tipsy = ($.fn.tipsy !== undefined),
			$dialogDeletePeriod = $("#dialogDeletePeriod"),
			$frmOptions = $("#frmOptions"),
			$frmEmailNotify = $('#frmEmailNotify'),
			$fieldInt = $(".field-int"),
			$tabs = $("#tabs"),
			$seo_tabs = $("#seo_tabs"),
			seo_tOpt = {
				activate: function (event, ui) {
					$(":input[name='seo_tab_id']").val($(ui.newPanel).prop('id'));
				}
			};
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		if ($seo_tabs.length > 0 && tabs) {
			$seo_tabs.tabs(seo_tOpt);
		}
		if ($frmOptions.length > 0 && validate) {
			$frmOptions.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if (tipsy) {
			$(".center-langbar-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				className: "tipsy-listing-center"
			});
		}
		if (spinner && $fieldInt.length > 0) {
			$fieldInt.spinner();
			$fieldInt.each(function () {
				var min = $(this).data("min");
				$(this).spinner("option", "min", min)
			});
		}
		if ($frmEmailNotify.length > 0) {
			var type = $("select[name='email_types']").val();
			$("div[class^='emailBox']").hide();
			$('.emailBox_' + type).show();
		}
		$("#content").on("focus", ".textarea_install", function (e) {
			var $this = $(this);
			$this.select();
			$this.mouseup(function() {
				$this.unbind("mouseup");
				return false;
			});
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("click", ".btnAddPeriod", function () {
			var $c = $("#tblPeriodClone tbody").clone(),
				r = $c.html().replace(/\{INDEX\}/g, 'new_' + Math.ceil(Math.random() * 99999));
			$(this).closest("form").find("table").find("tbody").append(r);
		}).on("click", ".btnDeletePeriod", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if ($dialogDeletePeriod.length > 0 && dialog) {
				$dialogDeletePeriod.data("link", $(this)).dialog("open");
			}
			return false;
		}).on("click", ".btnRemovePeriod", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $tr = $(this).closest("tr");
			$tr.css("backgroundColor", "#FFB4B4").fadeOut("slow", function () {
				$tr.remove();
			});			
			return false;
		}).on("change", "select.install_locale", function (e) {
			var $this = $(this),
				loc = $this.find("option:selected").val(),
				new_code = $( $this.data("box") ).text();
			if (loc.length > 0) {
				new_code = new_code.replace(/{LOCALE_START}/g, '\n$VRL_Locale = ' + loc + ';\n').replace(/{LOCALE_END}/, '\n');
			} else {
				new_code = new_code.replace(/{LOCALE_START}/g, ' ').replace(/{LOCALE_END}/, ' ');
			}
			
			$( $this.data("area") ).text(new_code);
		}).on("click", ".pj-use-theme", function (e) {
			var theme = $(this).attr('data-theme');
			$('.pj-loader').css('display', 'block');
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminOptions&action=pjActionUpdateTheme&theme=' + theme,
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
				}
			});
		}).on("change", "select[name='email_types']", function (e) {
			var type = $(this).val();
			$("div[class^='emailBox']").hide();
			$('.emailBox_' + type).show();	
			return false;
		}).on("change", "select[name='integrate_search_form']", function (e) {
			var having_search_form = $(this).val();
			if(having_search_form == 'T')
			{
				$('#featured_ob_start').val("<?php\nob_start();\n$VRL_SearchForm = true;\n?>");
			}else{
				$('#featured_ob_start').val("<?php\nob_start();\n?>");
			}
			return false;
		});
		
		if ($dialogDeletePeriod.length > 0 && dialog) {
			var buttons = {};
			buttons[myLabel.btn_delete] = function () {
				var $this = $(this),
					$link = $this.data("link"),
					$tr = $link.closest("tr"),
					id = $link.data("id");
				
				$.post("index.php?controller=pjAdminOptions&action=pjActionDeletePeriod", {
					"id": id
				}).done(function (data) {
					if (data.code === undefined) {
						return;
					}
					switch (data.code) {
						case 200:
							$tr.css("backgroundColor", "#FFB4B4").fadeOut("slow", function () {
								$tr.remove();
								$this.dialog("close");
							});
							break;
					}
				});
			};
			buttons[myLabel.btn_cancel] = function () {
				$(this).dialog("close");
			};
			$dialogDeletePeriod.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				buttons: buttons
			});
		}
		
	});
})(jQuery_1_8_2);