<?php
if ((int) $tpl['arr']['o_accept_bookings'] === 1)
{
	include_once dirname(__FILE__) . '/urlLanguage.php';

	if (isset($_SESSION[$controller->defaultSearch]))
	{
		if (!isset($_POST['date_from']) && isset($_SESSION[$controller->defaultSearch]['date_from']))
		{
			$_POST['date_from'] = $_SESSION[$controller->defaultSearch]['date_from'];
		}
		if (!isset($_POST['date_to']) && isset($_SESSION[$controller->defaultSearch]['date_to']))
		{
			$_POST['date_to'] = $_SESSION[$controller->defaultSearch]['date_to'];
		}
	}
	$months = __('months', true);
	$short_months = __('short_months', true);
	ksort($months);
	ksort($short_months);
	$days = __('days', true);
	$short_days = __('short_days', true);

	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);

	$front_sys = str_replace(array('"', "'"), array('\"', "\'"), __('front_sys', true, true));
	if(!isset($index) && isset($_GET['index']))
	{
		$index = $_GET['index'];
	}
	?>
	<div class="panel panel-default pjVrProductSection">
		<header class="panel-heading pjVrProductSectionHead">
			<strong><?php __('front_view_booking_form'); ?></strong>
		</header><!-- /.panel-heading pjVrProductSectionHead -->

		<div class="panel-body pjVrProductSectionBody">
			<div class="row">
				<div id="pjVrPaymentForm" class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
					<form action="?controller=pjListings&amp;action=pjActionView<?php echo $QS_LANG; ?>&amp;id=<?php echo $tpl['listing_id']; ?>" method="post" id="frmVrBooking_<?php echo $index;?>" name="frmPLBooking" class="form-horizontal pjVrFormReservation">
					
						<input type="hidden" name="booking_form" value="1" />
						<input type="hidden" name="booking_url" value="<?php echo PJ_INSTALL_FOLDER; ?>index.php?controller=pjListings&amp;action=pjActionSendRequest" />
						<input type="hidden" name="folder" value="<?php echo PJ_INSTALL_FOLDER; ?>" />
						<input type="hidden" name="listing_id" value="<?php echo $tpl['listing_id']; ?>" />
						
						<div class="form-group">
							<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_period');?></label>

							<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">
								<div class="input-group pjVrCalendar pjVrGroupCalendar">
									<span class="input-group-addon pjVrCalendarTrigger pjVrCalendarTriggerFrom">
										<i class="fa fa-calendar"></i>
									</span>
									<input type="text" name="date_from" value="<?php echo isset($_POST['date_from']) ? htmlspecialchars($_POST['date_from']) : NULL; ?>" data-fday="<?php echo $week_start; ?>" data-dformat="<?php echo $jqDateFormat; ?>" class="form-control pjVrCalendarInput pjVrCalendarInputFrom" placeholder="<?php __('front_booking_from');?>" readonly data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>" />
										
									<span class="input-group-addon pjVrCalendarTrigger pjVrCalendarTriggerTo">
										<i class="fa fa-calendar"></i>
									</span>
									<input type="text" name="date_to" value="<?php echo isset($_POST['date_to']) ? htmlspecialchars($_POST['date_to']) : NULL; ?>" data-fday="<?php echo $week_start; ?>" data-dformat="<?php echo $jqDateFormat; ?>" class="form-control pjVrCalendarInput pjVrCalendarInputTo" placeholder="<?php __('front_booking_to');?>" readonly data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>" />
								</div><!-- /.input-group pjVrCalendar pjVrGroupCalendar -->
								<input type="hidden" name="period" value="" data-msg-required="<?php echo $front_sys['bf_period'];?>"/>
								<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->
						</div><!-- /.form-group -->
						
						<div class="pjVrPriceBox"><?php include dirname(__FILE__) . '/../pjActionGetPrice.php'; ?></div>
						
						<div class="form-group">
							<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_booking_name'); ?></label>

							<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">
								<input type="text" name="name" class="form-control required" value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : NULL; ?>" data-msg-required="<?php echo $front_sys['bf_name'];?>"/>
								<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->
						</div><!-- /.form-group -->

						<div class="form-group">
							<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_booking_email'); ?></label>

							<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">
								<input type="text" name="email" class="form-control required email" value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : NULL; ?>" data-msg-required="<?php echo $front_sys['bf_email'];?>" data-msg-email="<?php echo $front_sys['bf_email_inv'];?>"/>
								<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->

						</div><!-- /.form-group -->

						<div class="form-group">
							<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_booking_phone'); ?></label>

							<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">
								<input type="text" name="phone" class="form-control" value="<?php echo isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : NULL; ?>"/>
							</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->
						</div><!-- /.form-group -->

						<div class="form-group">
							<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_booking_notes'); ?></label>

							<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">
								<textarea name="notes" rows="4" class="form-control required" data-msg-required="<?php echo $front_sys['bf_note'];?>" ><?php echo isset($_POST['notes']) ? htmlspecialchars($_POST['notes']) : NULL; ?></textarea>
								<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->
						</div><!-- /.form-group -->
						<?php 
						if ((int) $tpl['arr']['o_disable_payments'] == 0)
						{ 
							?>
							<div class="form-group">
								<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_booking_pm'); ?></label>

								<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">
									<select name="payment_method" class="form-control required" data-msg-required="<?php echo $front_sys['bf_pm'];?>" >
										<option value=""><?php __('front_booking_pm_empty'); ?></option>
										<?php
										foreach (__('payment_methods', true) as $k => $v)
										{
											if (!isset($tpl['arr']['o_allow_'.$k]) || $tpl['arr']['o_allow_'.$k] == 0) continue;
											?><option value="<?php echo $k; ?>"<?php echo isset($_POST['payment_method']) && $_POST['payment_method'] == $k ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
										}
										?>
									</select>
									<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
								</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->
							</div><!-- /.form-group -->
							
							<div class="form-group vrCC" style="display: <?php echo isset($_POST['payment_method']) && $_POST['payment_method'] == 'creditcard' ? 'block' : 'none'; ?>">
								<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_booking_cc_type'); ?></label>

								<div class="col-lg-5 col-md-5 col-sm-5 col-xs-12">
									<select name="cc_type" class="form-control">
										<?php
										foreach (__('cc_types', true) as $k => $v)
										{
											?><option value="<?php echo $k; ?>"<?php echo isset($_POST['cc_type']) && $_POST['cc_type'] == $k ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
										}
										?>
									</select>
								</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->
							</div><!-- /.form-group -->
							<div class="form-group vrCC" style="display: <?php echo isset($_POST['payment_method']) && $_POST['payment_method'] == 'creditcard' ? 'block' : 'none'; ?>">
								<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_booking_cc_num'); ?></label>

								<div class="col-lg-5 col-md-5 col-sm-5 col-xs-12">
									<input type="text" name="cc_num" class="form-control" value="<?php echo isset($_POST['cc_num']) ? (int) $_POST['cc_num'] : NULL; ?>" data-msg-required="<?php echo $front_sys['bf_cc_num'];?>" />
									<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
								</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->
							</div><!-- /.form-group -->
							<div class="form-group vrCC" style="display: <?php echo isset($_POST['payment_method']) && $_POST['payment_method'] == 'creditcard' ? 'block' : 'none'; ?>">
								<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_booking_cc_code'); ?></label>

								<div class="col-lg-5 col-md-5 col-sm-5 col-xs-12">
									<input type="text" name="cc_code" class="form-control" value="<?php echo isset($_POST['cc_code']) ? (int) $_POST['cc_code'] : NULL; ?>" data-msg-required="<?php echo $front_sys['bf_cc_code'];?>" />
									<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
								</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->
							</div><!-- /.form-group -->
							<div class="form-group vrCC" style="display: <?php echo isset($_POST['payment_method']) && $_POST['payment_method'] == 'creditcard' ? 'block' : 'none'; ?>">
								<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_booking_cc_exp'); ?></label>

								<div class="col-lg-5 col-md-5 col-sm-5 col-xs-12">
									<input type="text" name="cc_exp" class="form-control" value="<?php echo isset($_POST['cc_exp']) ? htmlspecialchars($_POST['cc_exp']) : NULL; ?>" data-msg-required="<?php echo $front_sys['bf_cc_exp'];?>" />
									<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
								</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->
							</div><!-- /.form-group -->
							<div class="form-group vrBank" style="display: <?php echo isset($_POST['payment_method']) && $_POST['payment_method'] == 'bank' ? 'block' : 'none'; ?>">
								<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_booking_bank'); ?></label>

								<div class="col-lg-5 col-md-5 col-sm-5 col-xs-12">
									<label class="control-label"><?php echo stripslashes(nl2br($tpl['arr']['o_bank_account'])); ?></label>
								</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->
							</div><!-- /.form-group -->
							<?php
						} 
						?>

						<div class="form-group pjVrFormGroupCaptcha">
							<label for="" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 control-label"><?php __('front_booking_captcha'); ?></label>

							<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">
								<div class="row">
									<div class="col-lg-3 col-md-4 col-sm-4 col-xs-5">
										<input type="text" name="verification" id="verification" class="form-control required" maxlength="6" autocomplete="off" data-msg-required="<?php echo $front_sys['bf_verify'];?>" data-msg-remote="<?php __('front_booking_status_ARRAY_4')?>"/>
									</div><!-- /.col-lg-3 col-md-4 col-sm-4 col-xs-5 -->

									<div class="col-lg-3 col-md-3 col-sm-4 col-xs-5">
										<img id="pjVrCaptchaImage" class="property-captcha" src="<?php echo PJ_INSTALL_FOLDER; ?>index.php?controller=pjFront&amp;action=pjActionCaptcha&amp;rand=<?php echo rand(1, 999999); ?>" alt="CAPTCHA" style="vertical-align: middle; cursor: pointer;" />
									</div><!-- /.col-lg-3 col-md-3 col-sm-4 col-xs-5 -->
								</div><!-- /.row -->
								<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div><!-- /.col-lg-9 col-md-9 col-sm-9 col-xs-12 -->
						</div><!-- /.form-group pjVrFormGroupCaptcha -->

						<div class="form-group pjVrFormActions">
							<div class="col-lg-9 col-lg-offset-3 col-md-9 col-md-offset-3 col-sm-9 col-sm-offset-3 col-xs-12">
								<button type="submit" class="btn btn-default pjVrBtn pjVrBtnPrimary"><?php __('front_booking_submit'); ?></button>
							</div><!-- /.col-lg-9 col-lg-offset-3 col-md-9 col-md-offset-3 col-sm-9 col-sm-offset-3 col-xs-12 -->
						</div><!-- /.form-group pjVrFormActions -->
						<div class="form-group pjVrFormActions">
							<div class="col-lg-9 col-lg-offset-3 col-md-9 col-md-offset-3 col-sm-9 col-sm-offset-3 col-xs-12">
								<?php
								if (isset($tpl['status']))
								{
									$front_bs = __('front_booking_status', true);
									$status = __('status', true);
									$listing_b_dn = __('listing_b_dn', true);
									switch ($tpl['status'])
									{
										case 1:
											?><span class="text-success"><?php echo $front_bs[1]; ?></span><?php
											break;
										case 2:
											?><span class="text-danger"><?php echo $front_bs[2]; ?></span><?php
											break;
										case 3:
											?><span class="text-danger"><?php echo $front_bs[3]; ?></span><?php
											break;
										case 4:
											?><span class="text-danger"><?php echo $front_bs[4]; ?></span><?php
											break;
										case 5:
											?><span class="text-danger"><?php echo $front_bs[5]; ?></span><?php
											break;
										case 6:
											?><span class="text-danger"><?php echo $front_bs[6]; ?></span><?php
											break;
										case 8:
											?><span class="text-danger"><?php echo $front_bs[8]; ?></span><?php
											break;
										case 9:
											?><span class="text-danger"><?php printf($front_bs[9], $tpl['arr']['o_min_booking_lenght'], @$listing_b_dn[$tpl['arr']['o_price_based_on']]); ?></span><?php
											break;
										case 10:
											?><span class="text-danger"><?php printf($front_bs[10], $tpl['arr']['o_max_booking_lenght'], @$listing_b_dn[$tpl['arr']['o_price_based_on']]); ?></span><?php
											break;
										case 7:
											?><span class="text-danger"><?php echo $status[7]; ?></span><?php
											break;
									}
								}
								?>
							</div>
						</div>
					</form><!-- /.form-horizontal pjVrFormReservation -->
					
				</div><!-- /.col-lg-8 col-md-8 col-sm-8 col-xs-12 -->
				<?php
				if (!empty($tpl['arr']['listing_terms']))
				{ 
					?>
					<div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
						<div class="well well-sm">
							<h4><?php __('front_view_terms'); ?></h4>
							
							<div class="pre-scrollable pjVrBookingTerms">
								<?php echo stripslashes($tpl['arr']['listing_terms']); ?>
							</div><!-- /.pre-scrollable pjVrBookingTerms -->
						</div><!-- /.well well-sm -->
					</div><!-- /.col-lg-4 col-md-4 col-sm-4 col-xs-12 -->
					<?php
				} 
				?>
			</div><!-- /.row -->
		</div><!-- /.panel-body pjVrProductSectionBody -->
	</div><!-- /.panel panel-default pjVrProductSection -->
	<?php
}
?>