<?php
mt_srand();
$index = mt_rand(1, 9999);
include_once dirname(__FILE__) . '/elements/urlLanguage.php';

$floor = $tpl['option_arr']['o_floor'];
?>

<div id="pjWrapperVacationRental">
	<?php
	include_once dirname(__FILE__) . '/elements/menu.php';
	?>
	
	<div class="container-fluid pjVrContainer">
		<?php
		if (isset($tpl['arr']))
		{ 
			$main_image = 'https://placehold.it/600x600';
			if (count($tpl['gallery_arr']) > 0)
			{
				$main_image = PJ_INSTALL_URL . $tpl['gallery_arr'][0]['medium_path'];
			}
			$add_arr = array();
			if(!empty($tpl['arr']['address_content']))
			{
				$add_arr[] = $tpl['arr']['address_content'];
			}
			if(!empty($tpl['arr']['address_city']))
			{
				$add_arr[] = '<a href="'.$_SERVER['SCRIPT_NAME'].'?controller=pjListings&amp;action=pjActionListings'.$QS_LANG.(isset($_GET['iframe']) ? '&amp;iframe' : NULL).'&amp;listing_search=1&amp;location='.$tpl['arr']['address_city'].'">'.$tpl['arr']['address_city'].'</a>';
			}
			if(!empty($tpl['arr']['address_state']))
			{
				$add_arr[] = $tpl['arr']['address_state'];
			}
			if(!empty($tpl['arr']['address_postcode']))
			{
				$add_arr[] = $tpl['arr']['address_postcode'];
			}
			if(!empty($tpl['arr']['country_title']))
			{
				$add_arr[] = $tpl['arr']['country_title'];
			}
			?>
			<div class="row">
				<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
					<h1 class="pjVrProductTitleLarge"><?php echo pjSanitize::html(stripslashes($tpl['arr']['listing_title'])); ?></h1><!-- /.pjVrProductTitleLarge -->
					<?php
					if($tpl['arr']['address_map'] == 1)
					{ 
						?>
						<div class="pjVrProductAddress"><?php echo join(", ", $add_arr);?></div>
						<?php
					} 
					?>
				</div><!-- /.col-lg-12 col-md-12 col-sm-12 col-xs-12 -->
			</div><!-- /.row -->
			
			<div class="row">
				<div class="col-lg-7 col-md-7 col-sm-6 col-xs-12">
					<?php
					if (count($tpl['gallery_arr']) > 0)
					{
						?>
						<div class="pjVrProductImageCurrent">
							<a rel="pjVrGallery" class="pjVrFancybox" href="<?php echo PJ_INSTALL_URL . $tpl['gallery_arr'][0]['large_path']; ?>">
								<img id="pjVrMainImage_<?php echo $index;?>" src="<?php echo $main_image;?>" alt="" class="img-responsive" />
							</a>
						</div><!-- /.pjVrProductImageCurrent -->
						<?php
						unset($tpl['gallery_arr'][0]);
						if (count($tpl['gallery_arr']) > 0)
						{
							?>
							<div class="pjVrProductThumbs">
								<div class="row">
									<?php
									foreach($tpl['gallery_arr'] as $k => $thumb)
									{ 
										?>
										<a rel="pjVrGallery" href="<?php echo PJ_INSTALL_URL . $thumb['large_path']; ?>" class="thumbnail pjVrFancybox pjVrProductThumb<?php echo $k == 0 ? ' pjVrProductThumbCurrent' : null;?>" data-src="<?php echo PJ_INSTALL_URL . $thumb['medium_path'];?>">
											<img src="<?php echo PJ_INSTALL_URL . $thumb['small_path'];?>" alt="" class="img-responsive" />
										</a>
										<?php
									} 
									?>
								</div><!-- /.row -->
							</div><!-- /.pjVrProductThumbs -->
							<?php
						}
					} 
					?>
				</div><!-- /.col-lg-7 col-md-7 col-sm-6 col-xs-12 -->
				<?php
				$price_per = __('price_per', true); 
				?>
				<div class="col-lg-5 col-md-5 col-sm-6 col-xs-12">
					<p class="pjVrProductInnerPrice">
						<?php
						if($tpl['arr']['price'] != $tpl['arr']['max_price'])
						{ 
							?>
							<small><?php __('front_price_from');?> </small>
							<?php
						} 
						?>
						<strong><?php echo !empty($tpl['arr']['price']) ? pjUtil::formatCurrencySign(number_format($tpl['arr']['price'], 0), $tpl['option_arr']['o_currency']) : __('front_index_na', true); ?> </strong>
						<?php
						if(!empty($tpl['arr']['price']))
						{
							?><small><?php echo $price_per[$tpl['arr']['o_price_based_on']];?></small><?php
						} 
						?>
					</p><!-- /.pjVrProductInnerPrice -->
	
					<ul class="list-group pjVrProductInnerMeta">
						<li class="list-group-item">
							<dl class="dl-horizontal">
								<dt><?php __('front_view_refid'); ?>:</dt>
								<dd><?php echo pjSanitize::html($tpl['arr']['listing_refid']); ?></dd>
							</dl><!-- /.dl-horizontal -->
						</li><!-- /.list-group-item -->
	
						<li class="list-group-item">
							<dl class="dl-horizontal">
								<dt><?php __('front_view_type'); ?>:</dt>
								<dd><?php echo pjSanitize::html($tpl['arr']['type_title']); ?></dd>
							</dl><!-- /.dl-horizontal -->
						</li><!-- /.list-group-item -->
						<?php
						if (!empty($tpl['arr']['listing_bedrooms']))
						{ 
							?>
							<li class="list-group-item">
								<dl class="dl-horizontal">
									<dt><?php __('front_view_bedrooms'); ?>:</dt>
									<dd><?php echo $tpl['arr']['listing_bedrooms']; ?></dd>
								</dl><!-- /.dl-horizontal -->
							</li><!-- /.list-group-item -->
							<?php
						}
						if (!empty($tpl['arr']['listing_bathrooms']))
						{ 
							?>
							<li class="list-group-item">
								<dl class="dl-horizontal">
									<dt><?php __('front_view_bathrooms');?>:</dt>
									<dd><?php echo $tpl['arr']['listing_bathrooms'] - (int) $tpl['arr']['listing_bathrooms'] == 0 ? round($tpl['arr']['listing_bathrooms'], 0) : round($tpl['arr']['listing_bathrooms'], 1); ?></dd>
								</dl><!-- /.dl-horizontal -->
							</li><!-- /.list-group-item -->
							<?php
						} 
						if (!empty($tpl['arr']['listing_adults']))
						{
							?>
							<li class="list-group-item">
								<dl class="dl-horizontal">
									<dt><?php __('front_view_adults'); ?>:</dt>
									<dd><?php echo $tpl['arr']['listing_adults']; ?></dd>
								</dl><!-- /.dl-horizontal -->
							</li><!-- /.list-group-item -->
							<?php
						}
						if (!empty($tpl['arr']['listing_children']))
						{
							?>
							<li class="list-group-item">
								<dl class="dl-horizontal">
									<dt><?php __('front_view_children'); ?>:</dt>
									<dd><?php echo $tpl['arr']['listing_children']; ?></dd>
								</dl><!-- /.dl-horizontal -->
							</li><!-- /.list-group-item -->
							<?php
						}
						if (!empty($tpl['arr']['listing_floor_area']))
						{ 
							?>
							<li class="list-group-item">
								<dl class="dl-horizontal">
									<dt><?php __('front_view_floor_area'); ?>:</dt>
									<dd><?php echo pjUtil::showFloor($floor, $tpl['arr']['listing_floor_area'], __('front_view_floor_measure', true)); ?></dd>
								</dl><!-- /.dl-horizontal -->
							</li><!-- /.list-group-item -->
							<?php
						} 
						?>
					</ul><!-- /.list-group pjVrProductInnerMeta -->
				</div><!-- /.col-lg-5 col-md-5 col-sm-6 col-xs-12 -->
			</div><!-- /.row -->
			
			<div class="panel panel-default pjVrProductSection">
				<header class="panel-heading pjVrProductSectionHead">
					<strong><?php __('front_view_description'); ?></strong>
				</header><!-- /.panel-heading pjVrProductSectionHead -->
	
				<div class="panel-body pjVrProductSectionBody">
					<p><?php echo stripslashes(pjUtil::stripScripts($tpl['arr']['listing_description'])); ?></p>
				</div><!-- /.panel-body pjVrProductSectionBody -->
			</div><!-- /.panel panel-default pjVrProductInnerSection -->
			
			<div class="row">
				<?php
				$extra_arr = array('property' => array(), 'community' => array());
				foreach ($tpl['extra_arr'] as $extra)
				{
					if (in_array($extra['id'], $tpl['arr']['extras']))
					{
						switch ($extra['type'])
						{
							case 'property':
								$extra_arr['property'][] = sprintf('<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6"><p>%s</p></div>', stripslashes($extra['extra_title']));
								break;
							case 'community':
								$extra_arr['community'][] = sprintf('<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6"><p>%s</p></div>', stripslashes($extra['extra_title']));
								break;
						}
					}
				}
				$cnt_prop = count($extra_arr['property']);
				$cnt_comm = count($extra_arr['community']);
				if($cnt_prop > 0 || $cnt_comm > 0)
				{
					$vet = __('extra_type_arr', true);
					if($cnt_prop > 0)
					{
						?>
						<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
							<div class="panel panel-default pjVrProductSection">
								<header class="panel-heading pjVrProductSectionHead">
									<strong><?php echo $vet['property'];?></strong>
								</header><!-- /.panel-heading pjVrProductSectionHead -->
								<div class="panel-body pjVrProductSectionBody">
									<div class="row">
										<?php
										echo join("", $extra_arr['property']);
										?>
									</div><!-- /.row -->
								</div><!-- /.panel-body pjVrProductSectionBody -->
							</div><!-- /.panel panel-default pjVrProductSection -->
						</div><!-- /.col-lg-6 col-md-6 col-sm-12 col-xs-12 -->
						<?php
					}
					if($cnt_comm > 0)
					{
						?>
						<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
							<div class="panel panel-default pjVrProductSection">
								<header class="panel-heading pjVrProductSectionHead">
									<strong><?php echo $vet['community'];?></strong>
								</header><!-- /.panel-heading pjVrProductSectionHead -->
								<div class="panel-body pjVrProductSectionBody">
									<div class="row">
										<?php
										echo join("", $extra_arr['community']);
										?>
									</div><!-- /.row -->
								</div><!-- /.panel-body pjVrProductSectionBody -->
							</div><!-- /.panel panel-default pjVrProductSection -->
						</div><!-- /.col-lg-6 col-md-6 col-sm-12 col-xs-12 -->
						<?php
					} 
				} 
				?>
			</div><!-- /.row -->
			<?php
			$show_availability = true;
			
			if (isset($tpl['price_arr']) && count($tpl['price_arr']) > 0)
			{
			}else{
				$show_availability = false;
			}
			if ((int) $tpl['arr']['o_accept_bookings'] === 0){
				$show_availability = false;
			} 
			?>
			<div class="row">
				<?php
				if($show_availability == true)
				{ 
					?>
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
						<div class="panel panel-default pjVrProductSection pjVrCalendarInlineWrapper">
							<header class="panel-heading clearfix pjVrProductSectionHead">
								<strong><?php __('front_view_calendar'); ?></strong>
		
								<div class="btn-group btn-group-xs pull-right pjVrProductPanelActions">
									<button type="button" data-listing_id="<?php echo $tpl['arr']['id'];?>" data-get="prev" class="btn btn-default pjVrBtn pjVrBtnPrimary pjVrCalendarInlineAction pjVrCalendarInlineActionPrev">
										<i class="fa fa-chevron-left"></i>
									</button>
		
									<button type="button" data-listing_id="<?php echo $tpl['arr']['id'];?>" data-get="next" class="btn btn-default pjVrBtn pjVrBtnPrimary pjVrCalendarInlineAction pjVrCalendarInlineActionNext">
										<i class="fa fa-chevron-right"></i>
									</button>
								</div><!-- /.btn-group btn-group-xs pull-right pjVrProductPanelActions -->
								<span id="pjVrViewDate_<?php echo $index;?>" style="display: none"><?php echo date("Y-n-j", mktime(0,0,0,date("n"),1,date("Y"))); ?></span>
							</header><!-- /.panel-heading clearfix pjVrProductSectionHead -->
		
							<div class="panel-body pjVrProductSectionBody">
								<div id="pjVrCalendar_<?php echo $index;?>" class="pjVrCalendar pjVrCalendarInline"><?php include_once dirname(__FILE__) . '/elements/calendar.php'; ?></div><!-- /.pjVrCalendar pjVrCalendarInline -->
							</div><!-- /.panel-body pjVrProductSectionBody -->
						</div><!-- /.panel panel-default pjVrProductSection pjVrCalendarInlineWrapper -->
					</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
					<?php
				}
				if (isset($tpl['price_arr']) && count($tpl['price_arr']) > 0 && $show_availability == true)
				{ 
					?>
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
						<div class="panel panel-default pjVrProductSection">
							<header class="panel-heading pjVrProductSectionHead">
								<strong><?php __('front_view_price_quotes'); ?></strong>
							</header><!-- /.panel-heading pjVrProductSectionHead -->
		
							<div class="panel-body pjVrProductSectionBody">
								<div class="pjVrTablePrices">
									<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
										<tr>
											<th class="text-center text-capitalize"><strong><?php __('front_view_price_from'); ?></strong></th>
											<th class="text-center text-capitalize"><strong><?php __('front_view_price_to'); ?></strong></th>
											<th class="text-center text-capitalize"><strong><?php $tpl['arr']['o_price_based_on'] == 1 ? __('front_price_per_day') : __('front_price_per_night'); ?></strong></th>
										</tr>
										<?php
										foreach ($tpl['price_arr'] as $v)
										{
											?>
											<tr>
												<td class="text-center"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['date_from'])); ?></td>
												<td class="text-center"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['date_to'])); ?></td>
												<td class="text-center"><strong><?php echo pjUtil::formatCurrencySign(number_format($v['price'], 2), $tpl['option_arr']['o_currency']); ?></strong></td>
											</tr>
											<?php
										} 
										?>	
									</table><!-- /.table -->
								</div><!-- /.pjVrTablePrices -->
							</div><!-- /.panel-body pjVrProductSectionBody -->
						</div><!-- /.panel panel-default pjVrProductSection -->
					</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
					<?php
				} 
				?>
			</div><!-- /.row -->
			<div id="pjVrBookingForm_<?php echo $index;?>" class=""><?php include_once dirname(__FILE__) . '/elements/bookingform.php'; ?></div>
			<?php
			if ($tpl['arr']['address_map'] == 1 && !empty($tpl['arr']['lat']) && !empty($tpl['arr']['lng']))
			{ 
				?>
				<div class="panel panel-default pjVrProductSection">
					<header class="panel-heading pjVrProductSectionHead">
						<strong><?php __('front_view_map'); ?></strong>
					</header><!-- /.panel-heading pjVrProductSectionHead -->
		
					<div class="panel-body pjVrProductSectionBody">
						<div class="pjVrProductCustomMap">
							<?php include_once dirname(__FILE__) . '/elements/map.php'; ?>
						</div><!-- /.pjVrProductCustomMap -->
					</div><!-- /.panel-body pjVrProductSectionBody -->
				</div><!-- /.panel panel-default pjVrProductSection -->
				<?php
			}
			?>
			<div class="row">
				<?php
				ob_start();
				if(!empty($tpl['arr']['country_title']))
				{
					?>
					<dl class="dl-horizontal">
						<dt><?php __('front_view_country');?>: </dt>
						<dd><?php echo pjSanitize::html($tpl['arr']['country_title']);?></dd>
					</dl><!-- /.dl-horizontal -->
					<?php
				}
				if(!empty($tpl['arr']['address_state']))
				{
					?>
					<dl class="dl-horizontal">
						<dt><?php __('front_view_state');?>: </dt>
						<dd><?php echo pjSanitize::html($tpl['arr']['address_state']);?></dd>
					</dl><!-- /.dl-horizontal -->
					<?php
				}
				if(!empty($tpl['arr']['address_city']))
				{
					?>
					<dl class="dl-horizontal">
						<dt><?php __('front_view_city');?>: </dt>
						<dd><?php echo pjSanitize::html($tpl['arr']['address_city']);?></dd>
					</dl><!-- /.dl-horizontal -->
					<?php
				}
				if(!empty($tpl['arr']['address_content']))
				{
					?>
					<dl class="dl-horizontal">
						<dt><?php __('front_view_address');?>: </dt>
						<dd><?php echo pjSanitize::html($tpl['arr']['address_content']);?></dd>
					</dl><!-- /.dl-horizontal -->
					<?php
				}
				if(!empty($tpl['arr']['address_postcode']))
				{
					?>
					<dl class="dl-horizontal">
						<dt><?php __('front_view_postcode');?>: </dt>
						<dd><?php echo pjSanitize::html($tpl['arr']['address_postcode']);?></dd>
					</dl><!-- /.dl-horizontal -->
					<?php
				}
				$ob_address = ob_get_contents();
				ob_end_clean();
				if(!empty($ob_address) && $tpl['arr']['address_map'] == 1)
				{
					?>
					<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
						<div class="panel panel-default pjVrProductSection">
							<header class="panel-heading pjVrProductSectionHead">
								<strong><?php __('front_view_address');?></strong>
							</header><!-- /.panel-heading pjVrProductSectionHead -->
		
							<div class="panel-body pjVrProductSectionBody">
								<?php echo $ob_address;?>
							</div><!-- /.panel-body pjVrProductSectionBody -->
						</div><!-- /.panel panel-default pjVrProductSection -->
					</div><!-- /.col-lg-6 col-md-6 col-sm-12 col-xs-12 -->
					<?php
				}

				if ($tpl['arr']['contact_show'] == 1)
				{
					ob_start();
					if (!empty($tpl['arr']['personal_title']) || !empty($tpl['arr']['personal_fname']) || !empty($tpl['arr']['personal_lname']))
					{
						$pt = __('personal_titles', true);
						$name_arr = array();
						if(!empty($tpl['arr']['personal_fname']))
						{
							$name_arr[] = pjSanitize::html($tpl['arr']['personal_fname']);
						}
						if(!empty($tpl['arr']['personal_lname']))
						{
							$name_arr[] = pjSanitize::html($tpl['arr']['personal_lname']);
						}
						?>
						<dl class="dl-horizontal">
							<dt><?php __('front_view_name'); ?>: </dt>
							<dd><?php echo pjSanitize::html($pt[$tpl['arr']['personal_title']]) . join(" ", $name_arr); ?></dd>
						</dl><!-- /.dl-horizontal -->
						<?php
					}
					if (!empty($tpl['arr']['contact_phone']))
					{
						?>
						<dl class="dl-horizontal">
							<dt><?php __('front_view_phone');?>: </dt>
							<dd><?php echo pjSanitize::html($tpl['arr']['contact_phone']);?></dd>
						</dl><!-- /.dl-horizontal -->
						<?php
					}
					if (!empty($tpl['arr']['contact_mobile']))
					{
						?>
						<dl class="dl-horizontal">
							<dt><?php __('front_view_mobile');?>: </dt>
							<dd><?php echo pjSanitize::html($tpl['arr']['contact_mobile']);?></dd>
						</dl><!-- /.dl-horizontal -->
						<?php
					}
					if (!empty($tpl['arr']['contact_fax']))
					{
						?>
						<dl class="dl-horizontal">
							<dt><?php __('front_view_fax');?>: </dt>
							<dd><?php echo pjSanitize::html($tpl['arr']['contact_fax']);?></dd>
						</dl><!-- /.dl-horizontal -->
						<?php
					}
					if (!empty($tpl['arr']['contact_email']))
					{
						?>
						<dl class="dl-horizontal">
							<dt><?php __('front_view_email');?>: </dt>
							<dd><?php echo !preg_match('/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i', $tpl['arr']['contact_email']) ? $tpl['arr']['contact_email'] : '<a href="mailto:'.pjUtil::encodeEmail($tpl['arr']['contact_email']).'">'.pjUtil::encodeEmail($tpl['arr']['contact_email']).'</a>'; ?></dd>
						</dl><!-- /.dl-horizontal -->
						<?php
					}
					if (!empty($tpl['arr']['contact_url']))
					{
						$reg_exUrl = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";
						$text = $tpl['arr']['contact_url'];
						$hyper_link = $text;
						if(preg_match($reg_exUrl, $text, $url)) 
						{
							$hyper_link = preg_replace($reg_exUrl, '<a href="'.$url[0].'" rel="nofollow">'.$url[0].'</a>', $text);
						}
						?>
						<dl class="dl-horizontal">
							<dt><?php __('front_view_url');?>: </dt>
							<dd><?php echo $hyper_link;?></dd>
						</dl><!-- /.dl-horizontal -->
						<?php
					}
					$ob_contact = ob_get_contents();
					ob_end_clean();
					if(!empty($ob_contact))
					{
						?>
			
						<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
							<div class="panel panel-default pjVrProductSection">
								<header class="panel-heading pjVrProductSectionHead">
									<strong><?php __('front_view_contact'); ?></strong>
								</header><!-- /.panel-heading pjVrProductSectionHead -->
			
								<div class="panel-body pjVrProductSectionBody">
									<?php echo $ob_contact;?>
								</div><!-- /.panel-body pjVrProductSectionBody -->
							</div><!-- /.panel panel-default pjVrProductSection -->
						</div><!-- /.col-lg-6 col-md-6 col-sm-12 col-xs-12 -->
						<?php
					}
				} 
				?>
			</div><!-- /.row -->
			<?php			
		}else {
			__('front_view_na');
		} 
		?>
	</div><!-- /.container-fluid pjVrContainer -->
	
</div><!-- /#pjWrapper -->
	
<?php include_once dirname(__FILE__) . '/elements/loadjs.php';?>