<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{
	public $defaultCaptcha = 'StivaSoftCaptcha';
	
	public $defaultCommentCaptcha = 'StivaSoftCommentCaptcha';
	
	public $defaultMethod = 'front_integration_method';
	
	public $defaultView = 'front_view';
	
	public $defaultItemPerPage = 'front_item_per_page';
	
	public $defaultTheme = 'front_theme_id';
	
	public $defaultBackUrl = 'front_back_url';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
	}
	
	public function afterFilter()
	{
		$theme = $this->getTheme();
		if($theme == false)
		{
			$theme = $this->option_arr['o_theme'];
		}
		
		$this->appendCss('pj.bootstrap.min.css', PJ_FRAMEWORK_LIBS_PATH . 'pj/css/');
		$this->appendCss('jquery-ui.css', PJ_LIBS_PATH . 'pjQ/css/');
		$this->appendCss('font-awesome.min.css', PJ_TEMPLATE_PATH . PJ_TEMPLATE_SCRIPT_PATH . 'css/');
		if($_GET['action'] == 'pjActionView')
		{
			$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
			$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
			
			$this->appendCss('pjQuery.fancybox.css', PJ_INSTALL_URL . $dm->getPath('pj_fancybox'), true);
		}
		$this->appendCss('style.css', PJ_TEMPLATE_PATH . 'default/css/');
		$this->appendCss($theme . '.css', PJ_TEMPLATE_PATH . 'default/css/');
	}
	
	public function beforeFilter()
	{
		$locale_arr = pjLocaleModel::factory()
			->select('t1.*, t2.file, t2.title')
			->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left outer')
			->where('t2.file IS NOT NULL')
			->orderBy('t1.sort ASC')
			->findAll()
			->getDataPair('id');
		
		$this->set('locale_arr', $locale_arr);
		
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();
		
		if(isset($_GET['action']) && $_GET['action'] == 'pjActionPreview' )
		{
			unset($_SESSION[$this->defaultMethod]);
			unset($_SESSION[$this->defaultLocale]);
		}
		
		if (!isset($_SESSION[$this->defaultLocale]))
		{			
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		
		if(isset($_GET['view']))
		{
			$_SESSION[$this->defaultView] = $_GET['view'];
		}
		if(isset($_GET['item_per_page']))
		{
			$_SESSION[$this->defaultItemPerPage] = $_GET['item_per_page'];
		}
		if(isset($_GET['pjLang']))
		{
			$this->setLocaleId($_GET['pjLang']);
			$_SESSION[$this->defaultMethod] = 'each';
		}else{
			unset($_SESSION[$this->defaultMethod]);
		}
		if(isset($_GET['theme']))
		{
			$this->setTheme($_GET['theme']);
		}

		$this->loadSetFields();
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		if(!isset($_GET['comment']))
		{
			$Captcha = new pjCaptcha(PJ_WEB_PATH.'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		}else{
			$Captcha = new pjCaptcha(PJ_WEB_PATH.'obj/Anorexia.ttf', $this->defaultCommentCaptcha, 6);
		}
		$Captcha->setImage(PJ_IMG_PATH.'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if(!isset($_GET['comment']))
		{		
			if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
				echo 'false';
			}else{
				echo 'true';
			}
		}else{
			if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCommentCaptcha]){
				echo 'false';
			}else{
				echo 'true';
			}
		}
	}
	
	public function pjActionSetLocale()
	{
		$this->setLocaleId(@$_GET['locale']);
		$this->loadSetFields(true);
		if(strpos($_SERVER['HTTP_REFERER'], "pjActionPreview") !== false)
		{
			pjUtil::redirect(PJ_INSTALL_URL . 'index.php?controller=pjListings&action=pjActionIndex');
		}else{
			pjUtil::redirect($_SERVER['HTTP_REFERER']);
		}
	}
}
?>