<div id="tabs-8">
	<?php
	if (isset($_GET['err']))
	{
		$status = __('status', true);
		switch ($_GET['err'])
		{
			case 7:
				pjUtil::printNotice(NULL, $status[7]);
				break;
		}
	}
	pjUtil::printNotice(__('infoListingPricesTitle', true), __('infoListingPricesBody', true));
	
	$err = array();
	if (isset($tpl['price_arr']) && !empty($tpl['price_arr']))
	{
		foreach ($tpl['price_arr'] as $range)
		{
			$from = strtotime($range['date_from']);
			$to = strtotime($range['date_to']);
			
			foreach ($tpl['price_arr'] as $tmp)
			{
				if ($range['id'] == $tmp['id'])
				{
					continue;
				}
				if (strtotime($tmp['date_from']) <= $to && strtotime($tmp['date_to']) >= $from)
				{
					$err[] = array($range, $tmp);
				}
			}
		}
	}
	if (!empty($err))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice($titles['AL20'], $bodies['AL20']);
	}
	?>
	<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
	<div class="multilang b10"></div>
	<?php endif;?>
	<table class="pj-table" id="tblPrices" cellpadding="0" cellspacing="0" style="width: 100%">
		<thead>
			<tr>
				<th>#</th>
				<th><?php __('lblListingPriceTitle'); ?></th>
				<th><?php __('lblListingPriceFrom'); ?></th>
				<th><?php __('lblListingPriceTo'); ?></th>
				<th><?php __('lblListingPriceType'); ?></th>
				<th><?php __('lblListingPrice'); ?></th>
				<th style="width: 5%"></th>
			</tr>
		</thead>
		<tbody>
		<?php
		
		$price_types = __('price_types', true);
		if (isset($tpl['price_arr']) && count($tpl['price_arr']) > 0)
		{
			$i = 1;
			foreach ($tpl['price_arr'] as $v)
			{
				?>
				<tr>
					<td><?php echo $i++; ?></td>
					<td>
						<?php
						foreach ($tpl['lp_arr'] as $locale)
						{
							?>
							<span class="pj-multilang-wrap inline_block" data-index="<?php echo $locale['id']; ?>" style="display: <?php echo (int) $locale['is_default'] === 0 ? 'none' : NULL; ?>">
								<input type="text" name="i18n[<?php echo $locale['id']; ?>][price_title][]" value="<?php echo htmlspecialchars(stripslashes(@$v['i18n'][$locale['id']]['price_title'])); ?>" class="pj-form-field float_left r2 w100" lang="<?php echo $locale['id']; ?>"/>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input float_left r10"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $locale['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
							<?php
						} 
						?>
					</td>
					<td>
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="date_from[]" value="<?php echo pjUtil::formatDate($v['date_from'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" class="pj-form-field pointer w80 datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
					</td>
					<td>
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="date_to[]" value="<?php echo pjUtil::formatDate($v['date_to'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" class="pj-form-field pointer w80 datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
					</td>
					<td>
						<span class="inline-block">
							<select name="price_type[]" class="pj-form-field">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								foreach ($price_types as $key => $val)
								{
									?><option value="<?php echo $key; ?>" <?php echo $key == $v['price_type'] ? 'selected="selected"' : null;?> ><?php echo stripslashes($val); ?></option><?php
								}
								?>
							</select>
						</span>
					</td>
					<td>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" name="price[]" class="pj-form-field w70 align_right" value="<?php echo $v['price']; ?>" />
						</span>
					</td>
					<td><a class="pj-table-icon-delete btnDeletePrice" title="<?php __('lblDelete'); ?>" href="#" data-id="<?php echo $v['id']; ?>"></a></td>
				</tr>
				<?php
			}
		} else {
			?>
			<tr class="notFound">
				<td colspan="7"><?php __('lblListingPriceNotFound'); ?></td>
			</tr>
			<?php
		}
		?>
		</tbody>
	</table>
	<br />
	<p>
		<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
		<input type="button" value="<?php __('btnAdd'); ?>" class="pj-button" id="btnAddPrice" />
	</p>
	
	<div id="dialogDeletePrice" title="Delete confirmation" style="display: none"><?php __('lblSure'); ?></div>

</div>