<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	pjUtil::printNotice(__('infoPackagesTitle', true), __('infoPackagesDesc', true));
	?>
	<div class="b10">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
			<input type="hidden" name="controller" value="pjAdminListings" />
			<input type="hidden" name="action" value="pjActionCreate" />
			<input type="submit" class="pj-button" value="<?php __('btnAddPackage'); ?>" />
		</form>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>
		<?php
		$filter = __('filter', true);
		?>
		<div class="float_right t5">
			<a href="#" class="pj-button btn-all"><?php __('lblAll');?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="T"><?php echo $filter['active']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="F"><?php echo $filter['inactive']; ?></a>
			<a href="#" class="pj-button btn-filter btn-featured" data-column="is_featured" data-value="T"><?php echo $filter['featured']; ?></a>
		</div>
		<br class="clear_both" />
	</div>
	
	<div class="pj-form-filter-advanced" style="display: none">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			<div class="float_left w350">
				<p>
					<label class="title"><?php __('lblListingRefid'); ?></label>
					<input type="text" name="listing_refid" id="listing_refid" class="pj-form-field w150" />
				</p>
				
				<p>
					<label class="title"><?php __('lblKeyword'); ?></label>
					<input type="text" name="keyword" id="keyword" class="pj-form-field w150" />
				</p>
				<p>
					<label class="title"><?php __('lblType'); ?></label>
					<select name="type_id" id="type_id" class="pj-form-field w150">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['type_arr'] as $v)
						{
							?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['type_id']) && (int) $_GET['type_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
						}
						?>
					</select>
				</p>
			</div>
			<div class="float_right w350">
				<?php
				if ($controller->isAdmin())
				{
					?>
					<p style="overflow: visible;">
						<label class="title"><?php __('lblListingOwner'); ?></label>
						<select name="owner_id" id="owner_id" class="pj-form-field w150">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach ($tpl['user_arr'] as $v)
							{
								?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['user_id']) && (int) $_GET['user_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
							}
							?>
						</select>
					</p>
					<?php
				} 
				?>
				<p>
					<label class="title"><?php __('lblListingState'); ?></label>
					<input type="text" name="address_state" id="address_state" class="pj-form-field w150" />
				</p>
				<p>
					<label class="title"><?php __('lblListingCity'); ?></label>
					<input type="text" name="address_city" id="address_city" class="pj-form-field w150" />
				</p>
			</div>
			<br class="clear_both" />
			<p>
				<label class="title"><?php __('lblListingCountry'); ?></label>
				<select name="country_id" id="country_id" class="pj-form-field w350">
					<option value="">-- <?php __('lblChoose'); ?> --</option>
					<?php
					foreach ($tpl['country_arr'] as $v)
					{
						?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['country_id']) && (int) $_GET['country_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
					}
					?>
				</select>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSearch'); ?>" class="pj-button" />
				<input type="reset" value="<?php __('btnCancel'); ?>" class="pj-button" />
			</p>
		</form>
	</div>
	
	<div id="grid"></div>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.jqDateFormat = "<?php echo pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.queryString = "";
	pjGrid.isOwner = <?php echo $controller->isOwner() ? 'true' : 'false'; ?>;
	pjGrid.isEditor = <?php echo $controller->isEditor() ? 'true' : 'false'; ?>;
	<?php
	if (isset($_GET['user_id']) && (int) $_GET['user_id'] > 0)
	{
		?>pjGrid.queryString += "&user_id=<?php echo (int) $_GET['user_id']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.view_enquiries = "<?php __('vk_view_enquiries'); ?>";
	myLabel.image = "<?php __('vk_image'); ?>";
	myLabel.ref_id = "<?php __('vk_ref_id'); ?>";
	myLabel.type = "<?php __('lblType'); ?>";
	myLabel.publish = "<?php __('vk_publish'); ?>";
	myLabel.active = "<?php __('vk_active'); ?>";
	myLabel.inactive = "<?php __('vk_inactive'); ?>";
	myLabel.delete_selected = "<?php __('vk_delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('vk_delete_confirmation'); ?>";
	myLabel.published = "<?php __('vk_published'); ?>";
	myLabel.not_published = "<?php __('vk_not_published'); ?>";
	myLabel.extend_exp_date = "<?php __('vk_extend_exp_date'); ?>";
	myLabel.expire = "<?php __('vk_expire'); ?>";
	myLabel.exp_date = "<?php __('vk_exp_date'); ?>";
	myLabel.owner = "<?php __('vk_owner'); ?>";
	myLabel.exp_date_plus_30 = "<?php __('vk_exp_date_plus_30'); ?>";
	myLabel.view_enquiries = "<?php __('vk_view_enquiries'); ?>";
	myLabel.not_active = "<?php __('lblNotActive'); ?>";
	myLabel.unlimited = "<?php __('lblUnlimited');?>";
	</script>
	<?php
}
?>