<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	$months = __('months', true);
	$short_months = __('short_months', true);
	ksort($months);
	ksort($short_months);
	$days = __('days', true);
	$short_days = __('short_days', true);
			
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	
	$outbound_departs = !empty($tpl['arr']['outbound_departs']) ? pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['outbound_departs'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['outbound_departs'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : null;
	$outbound_arrives = !empty($tpl['arr']['outbound_departs']) ? pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['outbound_arrives'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['outbound_arrives'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : null; 
	$inbound_departs = !empty($tpl['arr']['inbound_departs']) ? pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['inbound_departs'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['inbound_departs'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : null;
	$inbound_arrives = !empty($tpl['arr']['inbound_departs']) ? pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['inbound_arrives'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['inbound_arrives'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : null;
	?>
	<style type="text/css">
	/*.ui-widget-content{
		border: medium none;
	}
	.ui-tabs .ui-tabs-nav li a {
		padding: 0.5em 0.8em;
	}*/
	.mceEditor > table{
		width: 570px !important;
	}
	.ui-menu{
		height: 230px;
		overflow-y: scroll;
	}
	.ui-tabs .ui-tabs-panel{
		overflow: visible;
	}
	</style>

	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionUpdate" method="post" id="frmUpdateListing" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="listing_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		<?php $locale = isset($_GET['locale']) && (int) $_GET['locale'] > 0 ? (int) $_GET['locale'] : $controller->getLocaleId(); ?>
		<input type="hidden" name="locale" value="<?php echo (int) $locale; ?>" />
		
		<div class="package-title">
			<?php
			$package_title =  $tpl['arr']['listing_refid'];
			if(!empty($tpl['arr']['i18n'][$locale]['title']))
			{
				$package_title .= ', ' . $tpl['arr']['i18n'][$locale]['title'];
			}
			echo $package_title;
			?>
		</div>

		<div id="tabs">
		
			<ul>
				<li><a href="#tabs-1"><?php __('lblListingSummary'); ?></a></li>
				<li><a href="#tabs-2"><?php __('lblListingDetails'); ?></a></li>
				<li><a href="#tabs-3"><?php __('lblListingFlight'); ?></a></li>
				<li><a href="#tabs-4"><?php __('lblListingFeatures'); ?></a></li>
				<li><a href="#tabs-5"><?php __('lblListingPhotos'); ?></a></li>
				<li><a href="#tabs-6"><?php __('lblListingOwner'); ?></a></li>
				<li><a href="#tabs-7"><?php __('lblListingAddress'); ?></a></li>
				<li><a href="#tabs-8"><?php __('lblListingPrices'); ?></a></li>
				<li><a href="#tabs-9"><?php __('lblListingTerms'); ?></a></li>
				<li><a href="#tabs-10"><?php __('lblListingSeo'); ?></a></li>
			</ul>
		
			<div id="tabs-1">
				<?php
				if($controller->isOwner())
				{
					pjUtil::printNotice(__('infoListingSummaryTitle', true), __('infoListingSummaryBody', true));
				}else{
					pjUtil::printNotice(__('infoSummaryTitle', true), __('infoSummaryDesc', true));
				} 
				?>	
				<p><label class="title"><?php __('lblAddedOn'); ?></label><span class="left"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['created'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['created'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></span></p>
				<p><label class="title"><?php __('lblLastUpdateOn'); ?></label><span class="left"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['modified'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['modified'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></span></p>
				<p><label class="title"><?php __('lblViews'); ?></label><span class="left"><?php echo $tpl['arr']['views']; ?></span></p>
				<p><label class="title"><?php __('lblEnquiries'); ?></label><span class="left"><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEnquiries&amp;action=pjActionIndex&amp;listing_id=<?php echo $tpl['arr']['id']; ?>"><?php echo (int) $tpl['arr']['enquiries']; ?></a></span></p>
				<p>
					<label class="title"><?php __('lblListingRefid'); ?></label>
					<span class="inline_block">
						<input type="text" name="listing_refid" id="listing_refid" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_refid'])); ?>" class="pj-form-field required" />
					</span>
				</p>
				
				<?php
				if (!$controller->isOwner())
				{
					?>
					<p><label class="title"><?php __('lblListingStatus'); ?></label>
						<span class="inline_block">
							<select name="status" id="status" class="pj-form-field required">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								foreach (__('publish_status', true) as $k => $v)
								{
									if ($tpl['arr']['status'] == $k)
									{
										?><option value="<?php echo $k; ?>" selected="selected"><?php echo stripslashes($v); ?></option><?php
									} else {
										?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
									}
								}
								?>
							</select>
							<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingStatusTip'); ?>"></a>
						</span>
					</p>
					<p id="expiration_container" style="display:<?php echo $tpl['arr']['status'] == 'E' ? 'block' : 'none'; ?>;">
						<label class="title"><?php __('lblListingExpire'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="expire" id="expire" class="pj-form-field pointer w100 datepick" value="<?php echo pjUtil::formatDate($tpl['arr']['expire'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo date($tpl['option_arr']['o_date_format']); ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>" />
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
						<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingExpireTip'); ?>"></a>
					</p>
					<?php
				} else {
					?>
					<p>
						<?php
						if($tpl['arr']['status'] == 'F')
						{
							?>
							<label class="title color-red"><?php __('lblListingExpire'); ?></label>
							<span class="left float_left"><?php __('lblNotActive'); ?></span>
							<a class="pj-button float_left l10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionPayment&amp;id=<?php echo $tpl['arr']['id']; ?>"><?php __('vk_publish'); ?></a>
							<?php
						}else if($tpl['arr']['status'] == 'T'){
							?>
							<label class="title"><?php __('lblListingExpire'); ?></label>
							<span class="left"><?php __('lblUnlimited'); ?></span>
							<?php
						}else{ 
							?>
							<label class="title"><?php __('lblListingExpire'); ?></label>
							<span class="left float_left"><?php echo pjUtil::formatDate($tpl['arr']['expire'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?></span>
							<a class="pj-button float_left l10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionPayment&amp;id=<?php echo $tpl['arr']['id']; ?>"><?php __('lblListingExtend'); ?></a>
							<?php
						}
						?>
					</p>
					<?php
				}
				if (!$controller->isOwner())
				{
					?>
					<p>
						<label class="title"><?php __('lblListingFeatured'); ?></label>
						<span class="left">
						<?php
						foreach (__('_yesno', true) as $k => $v)
						{
							?>
							<label class="r5"><input type="radio" name="is_featured" value="<?php echo $k; ?>"<?php echo $tpl['arr']['is_featured'] == $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
							<?php
						}
						?>
						<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php echo pjSanitize::clean(__('lblListingFeaturedTip', true)); ?>"></a>
						</span>
					</p>
					<?php
				}
				?>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
				</p>
			</div>
			
			<div id="tabs-2">
				<?php
				pjUtil::printNotice(__('infoListingDetailsTitle', true), __('infoListingDetailsDesc', true));
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10 first_multilang"></div>
				<?php endif;?>
				<div class="clear_both">
					<p>
						<label class="title"><?php __('lblType'); ?></label>
						<span class="inline_block" id="boxType">
							<select name="type_id" id="type_id" class="pj-form-field required">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								foreach ($tpl['type_arr'] as $v)
								{
									if ($tpl['arr']['type_id'] == $v['id'])
									{
										?><option value="<?php echo $v['id']; ?>" selected="selected"><?php echo stripslashes($v['name']); ?></option><?php
									} else {
										?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
									}
								}
								?>
							</select>
						</span>
					</p>
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblPackageTitle'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w500<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['title'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title"><?php __('lblRating'); ?></label>
						<span class="inline_block">
							<select name="listing_rating" id="listing_rating" class="pj-form-field w100">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								for ($i = 1; $i <= 5; $i++)
								{
									?><option value="<?php echo $i; ?>"  <?php echo $tpl['arr']['listing_rating'] == $i ? 'selected="selected"' : null;?>><?php echo $i; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<?php
					$season_arr = array();
					if(!empty($tpl['arr']['listing_season']))
					{
						$season_arr = explode("|", $tpl['arr']['listing_season']);
					}
					?>
					<p>
						<label class="title"><?php __('lblSeasonAvailability'); ?></label>
						<span class="inline_block t5">
							<?php
							foreach(__('filter_seasons', true) as $k => $v) 
							{
								?><input type="checkbox" id="<?php echo $k?>" name="listing_season[]" value="<?php echo $k?>" class="listing-season" <?php echo in_array($k, $season_arr) ? 'checked="checked"': null;?> />&nbsp;<label for="<?php echo $k?>"><?php echo $v?></label>&nbsp;&nbsp;<?php
							}
							?>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblNights'); ?></label>
						<span class="inline_block">
							<select name="listing_nights" id="listing_nights" class="pj-form-field w100">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								for ($i = 1; $i <= 30; $i++)
								{
									?><option value="<?php echo $i; ?>"  <?php echo $tpl['arr']['listing_nights'] == $i ? 'selected="selected"' : null;?>><?php echo $i; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblPackageDescription'); ?></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][description]" class="mceEditor<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" style="width: 570px; height: 400px"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['description']); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
					</p>
				</div>
			</div>
			<div id="tabs-3">
				<?php
				if($controller->isOwner())
				{
					pjUtil::printNotice(__('infoOwnerFlightTitle', true), __('infoOwnerFlightBody', true));
				}else{
					pjUtil::printNotice(__('infoFlightTitle', true), __('infoFlightBody', true)); 
				}
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10"></div>
				<?php endif;?>
				<div class="clear_both">
					<p>
						<label class="title"><?php __('lblFlightIncluded'); ?></label>
						<span class="inline_block">
							<select name="flight_included" id="flight_included" class="pj-form-field w100">
								<?php
								foreach (__('_yesno', true) as $k => $v)
								{
									?><option value="<?php echo $k; ?>" <?php echo $tpl['arr']['flight_included'] == $k ? 'selected="selected"' : null;?>><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p class="flight-detail">
						<label class="title"><?php __('lblListingOutboundFrom'); ?></label>
						<span class="inline_block">
							<input type="text" name="outbound_from" id="outbound_from" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['outbound_from'])); ?>" class="pj-form-field w200" />
						</span>
					</p>
					<p class="flight-detail">
						<label class="title"><?php __('lblListingOutboundTo'); ?></label>
						<span class="inline_block">
							<input type="text" name="outbound_to" id="outbound_to" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['outbound_to'])); ?>" class="pj-form-field w200" />
						</span>
					</p>
					<p class="flight-detail">
						<label class="title"><?php __('lblListingOutboundDeparts'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="outbound_departs" id="outbound_departs" class="pj-form-field pointer w120 datetimepick" value="<?php echo $outbound_departs; ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
					</p>
					<p class="flight-detail">
						<label class="title"><?php __('lblListingOutboundArrives'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="outbound_arrives" id="outbound_arrives" class="pj-form-field pointer w120 datetimepick" value="<?php echo $outbound_arrives; ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
					</p>
					
					<p class="flight-detail">
						<label class="title"><?php __('lblListingInboundFrom'); ?></label>
						<span class="inline_block">
							<input type="text" name="inbound_from" id="inbound_from" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['inbound_from'])); ?>" class="pj-form-field w200" />
						</span>
					</p>
					<p class="flight-detail">
						<label class="title"><?php __('lblListingInBoundTo'); ?></label>
						<span class="inline_block">
							<input type="text" name="inbound_to" id="inbound_to" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['inbound_to'])); ?>" class="pj-form-field w200" />
						</span>
					</p>
					<p class="flight-detail">
						<label class="title"><?php __('lblListingInBoundDeparts'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="inbound_departs" id="inbound_departs" class="pj-form-field pointer w120 datetimepick" value="<?php echo $inbound_departs; ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
					</p>
					<p class="flight-detail">
						<label class="title"><?php __('lblListingInBoundArrives'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="inbound_arrives" id="inbound_arrives" class="pj-form-field pointer w120 datetimepick" value="<?php echo $inbound_arrives; ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
					</p>
					<div class="flight-detail">
						<?php
						foreach ($tpl['lp_arr'] as $v)
						{
							?>
							<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
								<label class="title"><?php __('lblListingFlightNotes'); ?></label>
								<span class="inline_block">
									<textarea name="i18n[<?php echo $v['id']; ?>][flight_notes]" class="textarea h200 w500"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['flight_notes']); ?></textarea>
									<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
									<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
									<?php endif;?>
								</span>
							</p>
							<?php
						}
						?>
					</div>
				</div>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
				</p>
			</div>
			<div id="tabs-4">
				<?php
				if($controller->isOwner())
				{
					pjUtil::printNotice(__('infoOwnerFeatureTitle', true), __('infoOwnerFeatureBody', true));
				}else{
					pjUtil::printNotice(__('infoFeatureTitle', true), __('infoFeatureBody', true));
				} 
				
				$i = 1;
				foreach ($tpl['feature_arr'] as $v)
				{
					
					$is_open = true;
					?>
					<div class="float_left w200 b5 r25 pj-checkbox gradient<?php echo in_array($v['id'], $tpl['listing_feature_arr']) ? ' pj-checkbox-checked' : NULL; ?>">
						<input type="checkbox"  style="vertical-align: middle" name="feature[]" id="feature_<?php echo $v['id']; ?>" value="<?php echo $v['id']; ?>"<?php echo in_array($v['id'], $tpl['listing_feature_arr']) ? ' checked="checked"' : NULL; ?> />
						<label for="feature_<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></label>
					</div>
					<?php
					if ($i % 3 === 0)
					{
						$is_open = false;
						?><div class="clear_left"></div><?php
					}
					$i++;
					
				}
				if ($is_open) {
					?><div class="clear_left"></div><?php
				}
				?>
				
				<p>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
				</p>

			</div>
			
			<div id="tabs-5">
				<?php
				pjUtil::printNotice(@$titles['AL41'], @$bodies['AL41']);
				?>
				<div id="gallery"></div>
			</div>
			<div id="tabs-6">
				<?php
				if($controller->isOwner())
				{
					pjUtil::printNotice(__('infoOwnerContact2Title', true), __('infoOwnerContact2Body', true)); 
				}else{
					pjUtil::printNotice(__('infoOwnerContactTitle', true), __('infoOwnerContactBody', true)); 
				}
				
				if ($controller->isAdmin() || $controller->isEditor())
				{
					?>
					<p>
						<label class="title"><?php __('lblChooseOwner'); ?></label>
						<span class="inline_block">
							<select name="owner_id" id="owner_id" class="pj-form-field w200">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								foreach ($tpl['user_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id']; ?>" <?php echo $v['id'] == $tpl['arr']['owner_id'] ? 'selected="selected"' : null;?>><?php echo stripslashes($v['name']); ?></option><?php
								}
								?>
							</select>
						</span>
					</p>	
					<?php
				} 
				?>
				<p id="show_contact" style="display:<?php echo !empty($tpl['arr']['owner_id']) ? 'block' : 'none'; ?>">
					<label class="title"><?php __('lblOwnerShow'); ?></label>
					<span class="inline_block">
						<select name="owner_show" id="owner_show" class="pj-form-field w150">
							<?php
							if(empty($tpl['arr']['owner_show']))
							{
								$tpl['arr']['owner_show'] = 'T';
							}
							foreach (__('_yesno', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>" <?php echo $tpl['arr']['owner_show'] == $k ? 'selected="selected"' : null;?>><?php echo stripslashes($v); ?></option><?php
							}
							?>
						</select>
						<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingOwnerTip'); ?>"></a>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
				</p>
			</div>	
			<?php
			include PJ_VIEWS_PATH . 'pjAdminListings/elements/address.php';
			
			include PJ_VIEWS_PATH . 'pjAdminListings/elements/prices.php';
			
			?>
			<div id="tabs-9" style="padding: 10px 0">
				<?php pjUtil::printNotice(@$titles['AL91'], @$bodies['AL91']); ?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10"></div>
				<?php endif;?>
					<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblTerms'); ?></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][terms]" class="pj-form-field w500 h150"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['terms']); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingCheckin'); ?></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][checkin]" class="pj-form-field w500 h150"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['checkin'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingCheckout'); ?></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][checkout]" class="pj-form-field w500 h150"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['checkout'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingPets'); ?></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][pets]" class="pj-form-field w500 h150"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['pets'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingPolicies'); ?></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][policies]" class="pj-form-field w500 h150"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['policies']); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingFees'); ?></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][fees]" class="pj-form-field w500 h150"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['fees']); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					?>
				</div>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
				</p>
			</div><!-- tab-9 -->
			<div id="tabs-10">
				<?php
				pjUtil::printNotice(__('infoSEOTitle', true), __('infoSEOBody', true));  
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10"></div>
				<?php endif;?>
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title">
								<span class="title-tooltip"><?php __('lblListingMetaTitle'); ?></span>
								&nbsp;
								<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingMetaTitleTip'); ?>"></a>
							</label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][meta_title]" class="pj-form-field w500" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_title'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><span class="title-tooltip"><?php __('lblListingMetaKeywords'); ?></span>&nbsp;<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingMetaKeywordTip'); ?>"></a></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][meta_keywords]" class="pj-form-field w500" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_keywords'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><span class="title-tooltip"><?php __('lblListingMetaDesc'); ?></span>&nbsp;<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingMetaDescTip'); ?>"></a></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][meta_description]" class="pj-form-field w500" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_description'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
					</p>
				</div>
			</div><!-- tab-10 -->
		</div> <!-- #tabs -->
	</form>
	
	<table id="tblPricesClone" style="display: none">
		<tbody>
			<tr>
				<td>{INDEX}</td>
				<td>
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<span class="pj-multilang-wrap inline_block" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<input type="text" name="i18n[<?php echo $v['id']; ?>][price_title][]" class="pj-form-field float_left r2 w100" lang="<?php echo $v['id']; ?>"/>
							<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
							<span class="pj-multilang-input float_left r10"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
							<?php endif;?>
						</span>
						<?php
					} 
					?>
				</td>
				<td>
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" name="date_from[]" class="pj-form-field pointer w80 datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</td>
				<td>
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" name="date_to[]" class="pj-form-field pointer w80 datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>"/>
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</td>
				<td>
					<span class="inline-block">
						<select name="price_type[]" class="pj-form-field">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach ($price_types as $k => $v)
							{
								?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
							}
							?>
						</select>
					</span>
				</td>
				<td>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" name="price[]" class="pj-form-field w70 align_right" />
					</span>
				</td>
				<td><a class="pj-table-icon-delete btnRemovePrice" title="<?php __('lblDelete'); ?>" href="#"></a></td>
			</tr>
		</tbody>
	</table>
	
	<script type="text/javascript">
	var myGallery = myGallery || {};
	myGallery.foreign_id = "<?php echo $tpl['arr']['id']; ?>";
	myGallery.hash = "";
	var myLabel = myLabel || {};
	myLabel.address_not_found = "<?php __('vk_address_not_found'); ?>";
	myLabel.localeId = "<?php echo $controller->getLocaleId(); ?>";
	myLabel.timeTitle = <?php echo pjAppController::jsonEncode(__('picker_arr', true)); ?>;
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: <?php echo $tpl['locale_str']; ?>,
				flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
				select: function (event, ui) {
					$("input[name='locale']").val(ui.index);
					$.get("index.php?controller=pjAdminListings&action=pjActionGetLocale", {
						"locale" : ui.index
					}).done(function (data) {
						tid = $("#type_id").find("option:selected").val();
						$("#boxType").html(data.type);
						$("#type_id").find("option[value='"+tid+"']").prop("selected", true);
					});
				}
			});
			$(".first_multilang").find("a[data-index='<?php echo (int) $locale; ?>']").trigger("click");
			$(".multilang").find("a[data-index='<?php echo (int) $locale; ?>']").addClass("pj-form-langbar-item-active");
		});
	})(jQuery_1_8_2);
	</script>
	
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
		$tab_id = explode("-", $_GET['tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "active", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>