<ul class="list-group pjVpProducts">
	<?php
	foreach($tpl['arr'] as $v)
	{
		$title = stripslashes($v['listing_title']);
		
		if ($tpl['option_arr']['o_seo_url'] == 'No')
		{
			$detail_url = $_SERVER['SCRIPT_NAME'] . '?controller=pjListings&amp;action=pjActionView&amp;id=' . $v['id'] .(isset($_GET['iframe']) ? '&amp;iframe' : NULL);
		} else {
			$path = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
			$path = $path == '/' ? '' : $path;
			$detail_url = $path .'/'. $controller->friendlyURL($v['listing_title']) . "-". $v['id'] . ".html";
		}
		$_SESSION[$controller->defaultBackUrl] = pjUtil::getPageURL();
		$image = 'https://placehold.it/350x150';
		if(!empty($v['image']))
		{
			if(is_file(PJ_INSTALL_PATH . $v['image']))
			{
				$image = PJ_INSTALL_URL . $v['image'];
			}
		}
		$location_arr = array();
		if(!empty($v['address_city']))
		{
			$location_arr[] = stripslashes($v['address_city']);
		}
		if(!empty($v['country_title']))
		{
			$location_arr[] = stripslashes($v['country_title']);
		}
		
		$avail_arr = array();
		if(!empty($v['listing_season']))
		{
			$filter_seasons = __('filter_seasons', true);
			$season_arr = explode("|", $v['listing_season']);
			foreach($season_arr as $key => $val)
			{
				$avail_arr[] = $filter_seasons[$val];
			}
		}
		
		$price = 'n/a';
		if(!empty($v['max']) && !empty($v['min']))
		{
			if($v['max'] != $v['min'])
			{
				$price = pjUtil::formatCurrencySign(ceil($v['min']), $tpl['option_arr']['o_currency']) . ' - ' . pjUtil::formatCurrencySign(ceil($v['max']), $tpl['option_arr']['o_currency']);
			}else{
				$price = pjUtil::formatCurrencySign(ceil($v['min']), $tpl['option_arr']['o_currency']);
			}
		}
		?>
		<ul class="list-group pjVpProducts">
			<div class="list-group-item pjVpProduct">
				<a href="<?php echo $detail_url; ?>">
					<div class="row pjVpProductHead">
						<div class="col-md-9 col-sm-8 col-xs-12">
							<h4 class="pjVpProductTitle"><strong><?php echo $title;?></strong></h4><!-- /.pjVpProductTitle -->
						</div><!-- /.col-md-9 col-sm-8 col-xs-12 -->
									
						<div class="col-md-3 col-sm-4 col-xs-12">
							<ul class="list-inline pjVpProductRating">
								<?php
								for($i = 1; $i <= 5; $i++)
								{
									?><li><i class="fa fa-star<?php echo (int) $v['listing_rating'] < $i ? '-o' : NULL;?>"></i></li><?php
								} 
								?>
							</ul><!-- /.list-inline pjVpProductRating -->
						</div><!-- /.col-md-3 col-sm-4 col-xs-12 -->
					</div><!-- /.row pjVpProductHead -->
					
					<div class="row pjVpProductBody">
						<div class="col-md-5 col-sm-5 col-xs-12">
							<div class="row">
								<img src="<?php echo $image;?>" class="col-md-12 col-sm-12 col-xs-12 img-responsive" alt="Responsive image">
							</div><!-- /.row -->
						</div><!-- /.col-md-5 col-sm-5 col-xs-12 -->
									
						<div class="col-md-7 col-sm-7 col-xs-12">
							<div class="row pjVpProductInfo">
								<div class="col-md-4 col-sm-5 col-xs-12">
									<p>
										<i class="fa fa-university"></i>
										<strong><?php echo $price;?></strong>
									</p>
								</div><!-- /.col-md-4 col-sm-5 col-xs-12 -->
								<?php
								if(!empty($location_arr))
								{ 
									?>	
									<div class="col-md-8 col-sm-7 col-xs-12">
										<p class="text-right">
											<i class="fa fa-map-marker"></i>
											<strong><?php echo join(", ", $location_arr);?></strong>
										</p><!-- /.text-right -->
									</div><!-- /.col-md-7 col-sm-7 col-xs-12 -->
									<?php
								} 
								?>
							</div><!-- /.row pjVpProductInfo -->
					
							<ul class="list-inline pjVpProductMeta">
								<?php
								if(!empty($avail_arr))
								{ 
									?>
									<li>
										<i class="fa fa-calendar"></i>
										<span><?php __('front_label_available');?>: </span>
										<strong><?php echo implode(", ", $avail_arr);?></strong>
									</li>
									<?php
								}
								if(!empty($v['listing_nights']))
								{
									$nights = $v['listing_nights'];
									if($v['listing_nights'] > 1)
									{
										$nights .= ' ' . __('front_label_nights', true);
									}else{
										$nights .= ' ' . __('front_label_night', true);
									}
									?>
									<li>
										<i class="fa fa-cube"></i>
										<strong><?php echo mb_strtolower($nights, 'UTF-8');?></strong>
									</li>
									<?php
								}
								if($v['flight_included'] == 'T')
								{
									?>
									<li>
										<i class="fa fa-plane"></i>
										<strong><?php __('front_label_flight_included'); ?></strong>
									</li>
									<?php
								} 
								?>
							</ul><!-- /.list-inline pjVpProductMeta -->
							<?php
							if($v['number_of_comments'] > 0 && $tpl['option_arr']['o_comment_and_rating'] == 'Show')
							{
								?>
								<ul class="list-inline pjVpProductMeta">
									<li>
										<i class="fa fa-commenting"></i>
										<span><?php __('front_label_users_rating');?>: </span>
										<strong><?php echo number_format($v['avg_rating'],1) . ' / ' . $v['number_of_comments'] . ' ' . __('front_label_review', true);?></strong>
									</li>
								</ul>
								<?php
							} 
							?>
							
							<p><?php echo stripslashes(pjUtil::truncateDescription(pjUtil::html2txt($v['listing_description']), 350, ' ')); ?></p>
					
							<div class="row pjVpProductActions">
								<div class="col-md-9 col-sm-8 col-xs-6">
									<button class="btn btn-default pjVpBtn pjVpBtnPrimary"><?php echo mb_strtolower(__('front_label_details', true), 'UTF-8'); ?></button>
								</div><!-- /.col-md-9 col-sm-8 col-xs-6 -->
					
								<div class="col-md-3 col-sm-4 col-xs-6 text-right">
									<button class="btn btn-default pjVpBtn pjVpBtnSecondary pjVpBtnSendEnquiry" data-url="<?php echo $detail_url; ?>#pjVpEnquirySection"><?php echo mb_strtolower(__('front_label_send_enquiry', true), 'UTF-8'); ?></button>
								</div><!-- /.col-md-3 col-sm-4 col-xs-6 -->
							</div><!-- /.row pjVpProductActions -->
						</div><!-- /.col-md-7 col-sm-7 col-xs-12 -->
					</div><!-- /.row pjVpProductBody -->
				</a>
			</div><!-- /.list-group-item pjVpProduct -->
		<?php
	}
	?>
</ul>