<?php
mt_srand();
$index = mt_rand(1, 9999);
?>
<div id="pjWrapper">
	<div class="container-fluid pjVpContainer">
		<div class="pjVpBody">
			<div class="row pjVpProductsFeatured">
				<?php
				if(count($tpl['arr']) > 0)
				{
					foreach($tpl['arr'] as $v)
					{
						$title = stripslashes($v['listing_title']);
						
						if ($tpl['option_arr']['o_seo_url'] == 'No')
						{
							$detail_url = $_SERVER['SCRIPT_NAME'] . '?controller=pjListings&amp;action=pjActionView&amp;id=' . $v['id'] .(isset($_GET['iframe']) ? '&amp;iframe' : NULL);
							if(!empty($tpl['option_arr']['o_listing_page']))
							{
								$detail_url = $tpl['option_arr']['o_listing_page'] . '?controller=pjListings&amp;action=pjActionView&amp;id=' . $v['id'];
							}
						} else {
							$path = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
							$path = $path == '/' ? '' : $path;
							$detail_url = $path .'/'. $controller->friendlyURL($v['listing_title']) . "-". $v['id'] . ".html";
						}
						
						$image = 'https://placehold.it/360x260';
						if(!empty($v['image']))
						{
							if(is_file(PJ_INSTALL_PATH . $v['image']))
							{
								$image = PJ_INSTALL_URL . $v['image'];
							}
						}
						$price = 'n/a';
						if(!empty($v['max']) && !empty($v['min']))
						{
							if($v['max'] != $v['min'])
							{
								$price = pjUtil::formatCurrencySign(ceil($v['min']), $tpl['option_arr']['o_currency']) . ' - ' . pjUtil::formatCurrencySign(ceil($v['max']), $tpl['option_arr']['o_currency']);
							}else{
								$price = pjUtil::formatCurrencySign(ceil($v['min']), $tpl['option_arr']['o_currency']);
							}
						}
						$location_arr = array();
						if(!empty($v['address_city']))
						{
							$location_arr[] = stripslashes($v['address_city']);
						}
						if(!empty($v['country_title']))
						{
							$location_arr[] = stripslashes($v['country_title']);
						}
						
						$avail_arr = array();
						if(!empty($v['listing_season']))
						{
							$filter_seasons = __('filter_seasons', true);
							$season_arr = explode("|", $v['listing_season']);
							foreach($season_arr as $key => $val)
							{
								$avail_arr[] = $filter_seasons[$val];
							}
						}
						?>
						<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
							<a href="<?php echo $detail_url;?>" class="thumbnail">
								<div class="pjVpProductInner">
									<div class="pjVpProductHead">
										<h4 class="pjVpProductTitle">
											<strong><?php echo $title;?></strong>
										</h4><!-- /.pjVpProductTitle -->
										
										<ul class="list-inline pjVpProductRating">
											<?php
											for($i = 1; $i <= 5; $i++)
											{
												?><li><i class="fa fa-star<?php echo (int) $v['listing_rating'] < $i ? '-o' : NULL;?>"></i></li><?php
											} 
											?>
										</ul><!-- /.list-inline pjVpProductRating -->
									</div><!-- /.pjVpProductHead -->
									
									<div class="pjVpProductBody">
										<div class="pjVpProductImage">
											<img src="<?php echo $image;?>" class="img-responsive" alt="Responsive image">
										</div><!-- /.pjVpProductImage -->
													
										<div class="pjVpProductContent">
											<div class="pjVpProductInfo">
												<p class="pull-left">
													<i class="fa fa-university"></i>
													<?php echo $price;?>
												</p><!-- /.pull-left -->
												<?php
												if(!empty($location_arr))
												{ 
													?>
													<p class="pull-right">
														<i class="fa fa-map-marker"></i>
														<?php echo join(", ", $location_arr);?>
													</p><!-- /.pull-right -->	
													<?php
												} 
												?>	
											</div><!-- /.pjVpProductInfo -->
													
											<ul class="list-inline pjVpProductMeta">
												<?php
												if(!empty($avail_arr))
												{ 
													?>
													<li>
														<i class="fa fa-calendar"></i>
														<span><?php __('front_label_available');?>: </span>
														<span><?php echo implode(", ", $avail_arr);?></span>
													</li>
													<?php
												}
												if(!empty($v['listing_nights']))
												{
													$nights = $v['listing_nights'];
													if($v['listing_nights'] > 1)
													{
														$nights .= ' ' . __('front_label_nights', true);
													}else{
														$nights .= ' ' . __('front_label_night', true);
													}
													?>
													<li>
														<i class="fa fa-cube"></i>
														<span><?php echo mb_strtolower($nights, 'UTF-8');?></span>
													</li>													
													<?php
												}
												if($v['flight_included'] == 'T')
												{
													?>
													<li>
														<i class="fa fa-plane"></i>
														<span><?php __('front_label_flight_included'); ?></span>
													</li>
													<?php
												}  
												?>
											</ul><!-- /.list-inline pjVpProductMeta -->
													
											<p><?php echo stripslashes(pjUtil::truncateDescription(pjUtil::html2txt($v['listing_description']), 200, ' ')); ?></p>
											
										</div><!-- /.pjVpProductContent -->
									</div><!-- /.pjVpProductBody -->
									
									<div class="pjVpProductFoot">
										<div class="text-center pjVpProductActions">
											<button class="btn btn-default pjVpBtn pjVpBtnPrimary"><?php echo mb_strtolower(__('front_label_details', true), 'UTF-8'); ?></button>
										</div><!-- /.text-center pjVpProductActions -->
									</div><!-- /.pjVpProductFoot -->
								</div>
							</a>
						</div><!-- /.col-lg-4 col-md-4 col-sm-6 col-xs-12 -->
						<?php
					}
				}else{
					__('front_label_not_found');
				} 
				?>
			</div><!-- /.row pjVpProductsFeatured -->
		</div><!-- /.pjVpBody -->
	</div><!-- /.container-fluid pjVpContainer -->
</div><!-- /#pjWrapper -->