<?php
mt_srand();
$index = mt_rand(1, 9999);
?>
<div id="pjWrapper">
	<div class="container-fluid pjVpContainer">
		<?php 
		include_once ROOT_PATH . PJ_TEMPLATE_PATH . 'default/elements/header.php';
		?>
		
		<div class="pjVpBody">
			<?php
			if (isset($tpl['arr']))
			{
				$avail_arr = array();
				if(!empty($tpl['arr']['listing_season']))
				{
					$filter_seasons = __('filter_seasons', true);
					$season_arr = explode("|", $tpl['arr']['listing_season']);
					foreach($season_arr as $key => $val)
					{
						$avail_arr[] = $filter_seasons[$val];
					}
				}
					
				$price = null;
				if(!empty($tpl['arr']['max']) && !empty($tpl['arr']['min']))
				{
					if($tpl['arr']['max'] != $tpl['arr']['min'])
					{
						$price = pjUtil::formatCurrencySign(ceil($tpl['arr']['min']), $tpl['option_arr']['o_currency']) . ' - ' . pjUtil::formatCurrencySign(ceil($tpl['arr']['max']), $tpl['option_arr']['o_currency']);
					}else{
						$price = pjUtil::formatCurrencySign(ceil($tpl['arr']['min']), $tpl['option_arr']['o_currency']);
					}
				}
				?>
				<div class="pjVpProductInner">
					<div class="panel panel-default pjVpProductSection">
						<div class="panel-heading pjVpProductSectionHead">
							<div class="row">
								<div class="col-md-9 col-sm-8 col-xs-12">
									<h3 class="panel-title pjVpProductSectionTitle pjVpProductSectionTitleLg">
										<?php echo stripslashes($tpl['arr']['listing_title']);?>
										<small><?php echo __('front_label_id') . ': ' . stripslashes($tpl['arr']['listing_refid']); ?></small>
									</h3><!-- /.panel-title pjVpProductSectionTitle pjVpProductSectionTitleLg -->
								</div><!-- /.col-md-9 col-sm-8 col-xs-12 -->
									
								<div class="col-md-3 col-sm-4 col-xs-12">
									<ul class="list-inline pjVpProductRating">
										<?php
										for($i = 1; $i <= 5; $i++)
										{
											?><li><i class="fa fa-star<?php echo (int) $tpl['arr']['listing_rating'] < $i ? '-o' : NULL;?>"></i></li><?php
										} 
										?>
									</ul><!-- /.list-inline pjVpProductRating -->
								</div><!-- /.col-md-3 col-sm-4 col-xs-12 -->
							</div><!-- /.row -->
						</div><!-- /.panel-heading pjVpProductSectionHead -->
									
						<div class="panel-body pjVpProductSectionBody">
							<div class="row">
								<?php
								if (count($tpl['gallery_arr']) > 0)
								{ 
									?>
									<div id="pjVpGallery_<?php echo $index;?>" class="col-md-8 col-sm-9 col-xs-12 pjVpProductSectionImages">
										<div class="row pjVpProductMainImage">
											<img alt="Responsive image" class="col-md-12 col-sm-12 col-xs-12 img-responsive" src="<?php echo PJ_INSTALL_URL . $tpl['gallery_arr'][0]['medium_path']; ?>">
										</div><!-- /.row pjVpProductMainImage -->
										
										
									</div><!-- /.col-md-9 col-sm-9 col-xs-12 pjVpProductSectionImages -->
									<?php
								} 
								?>
								
								<div class="col-md-4 col-sm-3 col-xs-12">
									<ul class="list-unstyled pjVpProductSectionMeta">
										<?php
										if($price != null)
										{ 
											?>
											<li>
												<p class="text-muted pjVpProductSectionPrice">
													<i class="fa fa-university"></i>
													<strong><?php echo $price;?></strong>
												</p>
											</li>
											<?php
										}
										if(!empty($avail_arr))
										{ 
											?>
										
											<li>
												<i class="fa fa-calendar"></i>
												<span><?php __('front_label_available');?>: </span>
												<strong><?php echo implode(", ", $avail_arr);?></strong>
											</li>
											<?php
										}
										if(!empty($tpl['arr']['listing_nights']))
										{
											$nights = $tpl['arr']['listing_nights'];
											if($tpl['arr']['listing_nights'] > 1)
											{
												$nights .= ' ' . __('front_label_nights', true);
											}else{
												$nights .= ' ' . __('front_label_night', true);
											}
											?>
											<li>
												<i class="fa fa-cube"></i>
												<strong><?php echo strtolower($nights); ?></strong>
											</li>
											<?php
										} 
										if($tpl['arr']['flight_included'] == 'T')
										{
											?>
											<li>
												<i class="fa fa-plane"></i>
												<strong><?php __('front_label_flight_included');?></strong>
											</li>
											<?php
										} 
										$show = $tpl['option_arr']['o_comment_and_rating'];
										if($show == 'Show' && $tpl['arr']['number_of_comments'] > 0)
										{
											?>
											<li>
												<i class="fa fa-commenting"></i>
												<span><?php __('front_label_users_rating');?>: </span>
												<strong><?php echo number_format($tpl['arr']['avg_rating'],1) . ' / ' . $tpl['arr']['number_of_comments'] . ' ' . __('front_label_review', true);?></strong>
											</li>
											<?php
										}
										?>
									</ul><!-- /.list-unstyled pjVpProductSectionMeta -->

									<div class="row pjVpProductThumbImages">
										<?php
										foreach ($tpl['gallery_arr'] as $k => $v)
										{
											?>
											<div class="col-lg-4 col-md-4 col-sm-6 col-xs-4 pjVpProductThumbImage">
												<a rel="pjVpGallery" href="<?php echo PJ_INSTALL_URL . $v['large_path']; ?>" class="thumbnail pjVpProductThumbImageCurrent pjVpFancybox">
													<img alt="Responsive image" class="img-responsive" src="<?php echo PJ_INSTALL_URL . $v['small_path']; ?>">
												</a>
											</div><!-- /.col-lg-4 col-md-4 col-sm-6 col-xs-4 pjVpProductThumbImage -->
											<?php
										} 
										?>
									</div><!-- /.row pjVpProductThumbImages -->
								</div><!-- /.col-md-3 col-sm-3 col-xs-12 -->
							</div><!-- /.row -->
						</div><!-- /.panel-body pjVpProductSectionBody -->
					</div><!-- /.panel panel-default pjVpProductSection -->
					
					<div class="panel panel-default pjVpProductSection">
						<div class="panel-heading pjVpProductSectionHead">
							<h3 class="panel-title pjVpProductSectionTitle"><?php echo __('front_label_description'); ?></h3><!-- /.panel-title pjVpProductSectionTitle -->
						</div><!-- /.panel-heading pjVpProductSectionHead -->
									
						<div class="panel-body pjVpProductSectionBody">
							<?php echo stripslashes($tpl['arr']['listing_description']); ?>
						</div><!-- /.panel-body pjVpProductSectionBody -->
					</div><!-- /.panel panel-default pjVpProductSection -->
					<?php 
					include_once ROOT_PATH . PJ_TEMPLATE_PATH . 'default/elements/contact.php';
					if ($tpl['arr']['address_map'] == 1)
					{
						include_once ROOT_PATH . PJ_TEMPLATE_PATH . 'default/elements/viewmap.php';
					}
					if (count($tpl['feature_arr']) > 0)
					{
						?>
						<div class="panel panel-default pjVpProductSection">
							<div class="panel-heading pjVpProductSectionHead">
								<h3 class="panel-title pjVpProductSectionTitle"><?php echo __('front_label_features'); ?></h3><!-- /.panel-title -->
							</div><!-- /.panel-heading pjVpProductSectionHead -->
										
							<div class="panel-body pjVpProductSectionBody">
								<ul class="list-inline pjVpListTicks">
									<?php
									foreach ($tpl['feature_arr'] as $k => $v)
									{
										?>
										<li><i class="fa fa-check-circle"></i> <?php echo stripslashes($v['feature_title']);?></li>
										<?php
									} 
									?>
								</ul><!-- /.list-inline pjVpListTicks -->
							</div><!-- /.panel-body pjVpProductSectionBody -->
						</div><!-- /.panel panel-default pjVpProductSection -->
						<?php
					}
					include_once ROOT_PATH . PJ_TEMPLATE_PATH . 'default/elements/flight.php';
					
					if (count($tpl['price_arr']) > 0)
					{
						?>
						<div class="panel panel-default pjVpProductSection">
							<div class="panel-heading pjVpProductSectionHead">
								<h3 class="panel-title pjVpProductSectionTitle"><?php __('front_label_prices'); ?></h3><!-- /.panel-title -->
							</div><!-- /.panel-heading pjVpProductSectionHead -->
										
							<div class="panel-body pjVpProductSectionBody">
								<div class="table-responsive pjVpProductTablePackages">
									<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
										<thead>
											<tr>
												<th class="text-uppercase"><?php __('front_label_package'); ?></th><!-- /.text-uppercase -->
												<th class="text-uppercase"><?php __('front_label_from'); ?></th><!-- /.text-uppercase -->
												<th class="text-uppercase"><?php __('front_label_to'); ?></th><!-- /.text-uppercase -->
												<th class="text-uppercase"><?php __('front_label_price'); ?></th><!-- /.text-uppercase -->
											</tr>
										</thead>
										
										<tbody>
											<?php
											$price_types = __('price_types', true);
											foreach ($tpl['price_arr'] as $k => $v)
											{
												?>
												<tr>
													<td><?php echo $v['price_title'];?></td>
													<td><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($v['date_from'])), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?></td>
													<td><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($v['date_to'])), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?></td>
													<td><?php echo pjUtil::formatCurrencySign(ceil($v['price']), $tpl['option_arr']['o_currency'], ' '); ?> <?php echo $price_types[$v['price_type']];?></td>
												</tr>
												<?php
											} 
											?>
										</tbody>
									</table><!-- /.table -->
								</div><!-- /.table-responsive pjVpProductTablePackages -->
							</div><!-- /.panel-body pjVpProductSectionBody -->
						</div><!-- /.panel panel-default pjVpProductSection -->
						<?php
					}

					include_once ROOT_PATH . PJ_TEMPLATE_PATH . 'default/elements/policies.php';
					
					include_once ROOT_PATH . PJ_TEMPLATE_PATH . 'default/elements/enquiryform.php';
					
					include_once ROOT_PATH . PJ_TEMPLATE_PATH . 'default/elements/comments.php';
					?>
					<div class="pjVpScrollSection"><a id="pjVpScrollToTop_<?php echo $index;?>" class="btn btn-default pjVpScrollToTop" href="#"><i class="fa fa-chevron-up"></i>&nbsp;<span><?php __('front_label_top');?></span></a></div>
				</div><!-- /.pjVpProductInner -->
				<?php
			} 
			?>
		</div>
		
	</div><!--  /.container-fluid pjVpContainer  -->
</div>
<?php include_once ROOT_PATH . PJ_TEMPLATE_PATH . 'default/elements/loadjs.php';?>