<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjListingModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'listings';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'manufacturer_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'owner_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'feature_fuel_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'feature_engine_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'feature_hull_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'feature_yacht_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'created', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'modified', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'views', 'type' => 'int', 'default' => '0'),
		array('name' => 'for', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'is_featured', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'status', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'expire', 'type' => 'date', 'default' => ':NULL'),
		array('name' => 'last_extend', 'type' => 'enum', 'default' => 'free'),
		array('name' => 'added_by', 'type' => 'enum', 'default' => 'other'),
		array('name' => 'listing_refid', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'listing_model', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'listing_price', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'listing_year', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'listing_length', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'listing_loa', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'listing_beam', 'type' => 'decimal', 'default' => ':NULL'),
		array('name' => 'listing_engine_hours', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'listing_engine_model', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'listing_cruising_speed', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'listing_max_speed', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'listing_fuel_tank', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'listing_power', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'address_country', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'address_state', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'address_city', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'address_content', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'address_zip', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'owner_show', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'owner_name', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'owner_phone', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'owner_email', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'owner_fax', 'type' => 'varchar', 'default' => ':NULL')
	);
	
	public $i18n = array('title', 'discription', 'meta_title', 'meta_keywords', 'meta_description');
	
	public static function factory($attr=array())
	{
		return new pjListingModel($attr);
	}
	
	public function getLastID()
	{
		$id = 1;
		$arr = $this->orderBy("id DESC")->limit(1)->findAll()->getData();
		if(count($arr) > 0)
		{
			$id = $arr[0]['id'] + 1;
		}
		return $id;
	}
}
?>