<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjOptionModel extends pjAppModel
{
	protected $primaryKey = NULL;
	
	protected $table = 'options';
	
	public $defaultOpts = array(
		'o_currency',
		'o_length',
		'o_fuel',
		'o_speed',
		'o_power',
		'o_date_format',
		'o_time_format',
		'o_week_start',
		'o_timezone',
		'o_items_per_page',
		'o_layout',
		'o_send_email',
		'o_smtp_host',
		'o_smtp_pass',
		'o_smtp_port',
		'o_smtp_user',
		'o_allow_add_listing',
		'o_owner_is_active',
		'o_paypal_address',
		'o_email_registration',
		'o_email_registration_subject',
		'o_email_registration_message',
		'o_email_submission',
		'o_email_submission_subject',
		'o_email_submission_message',
		'o_email_forgot_subject',
		'o_email_forgot_message',
		'o_sms_registration',
		'o_sms_registration_message',
		'o_sms_submission',
		'o_sms_submission_message',
		'o_admin_email_registration',
		'o_admin_email_registration_subject',
		'o_admin_email_registration_message',
		'o_admin_email_submission',
		'o_admin_email_submission_subject',
		'o_admin_email_submission_message',
		'o_admin_sms_registration',
		'o_admin_sms_registration_message',
		'o_admin_sms_submission',
		'o_admin_sms_submission_message',
			
		'o_bf_include_title',
		'o_bf_include_name',
		'o_bf_include_email',
		'o_bf_include_phone',
		'o_bf_include_company',
		'o_bf_include_address',
		'o_bf_include_country',
		'o_bf_include_state',
		'o_bf_include_city',
		'o_bf_include_zip',
		'o_bf_include_notes',
		'o_bf_include_captcha',
			
		'o_featured_yachts',
		'o_listing_page',
		'o_seo_url',
		'o_website_seo',
		'o_theme',
		'o_multi_lang',
		'o_fields_index',
		'private_key'
	);
	
	protected $schema = array(
		array('name' => 'foreign_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'key', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'tab_id', 'type' => 'tinyint', 'default' => ':NULL'),
		array('name' => 'value', 'type' => 'text', 'default' => ':NULL'),
		array('name' => 'label', 'type' => 'text', 'default' => ':NULL'),
		array('name' => 'type', 'type' => 'varchar', 'default' => 'string'),
		array('name' => 'order', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'is_visible', 'type' => 'tinyint', 'default' => 1),
		array('name' => 'style', 'type' => 'varchar', 'default' => 'string')
	);
	
	public static function factory($attr=array())
	{
		return new pjOptionModel($attr);
	}
	
	public function getAllPairs($foreign_id)
	{
		if($foreign_id == 1)
		{
			return $this->where('t1.foreign_id', $foreign_id)->orWhere('`key`', 'private_key')->findAll()->getDataPair('key', 'value');
		}else{
			$arr = $this->where('t1.foreign_id', $foreign_id)->orWhere('`key`', 'private_key')->findAll()->getDataPair('key', 'value');
			$_arr = $this->reset()->where('t1.foreign_id', 1)->whereIn('`key`', $this->defaultOpts)->orWhere('`key`', 'private_key')->findAll()->getDataPair('key', 'value');
			return array_merge($arr, $_arr);
		}
	}
	
	public function getPairs($foreign_id)
	{
		$_arr = $this->where('t1.foreign_id', $foreign_id)->orWhere('`key`', 'private_key')->findAll()->getData();
		$arr = array();
		foreach ($_arr as $row)
		{
			switch ($row['type'])
			{
				case 'enum':
				case 'bool':
					list(, $arr[$row['key']]) = explode("::", $row['value']);
					break;
				default:
					$arr[$row['key']] = $row['value'];
					break;
			}
		}
		if($foreign_id > 1)
		{
			$_arr = $this->reset()->where('t1.foreign_id', 1)->whereIn('`key`', $this->defaultOpts)->orWhere('`key`', 'private_key')->findAll()->getData();
			foreach ($_arr as $row)
			{
				switch ($row['type'])
				{
					case 'enum':
					case 'bool':
						list(, $arr[$row['key']]) = explode("::", $row['value']);
						break;
					default:
						$arr[$row['key']] = $row['value'];
						break;
				}
			}
		}
		return $arr;
	}
	
	public function updateListingPage()
	{
		$this
			->reset()
			->where('foreign_id', 1)
			->where('`key`', 'o_listing_page')
			->limit(1)
			->modifyAll(array('value' => PJ_INSTALL_URL . 'preview.php'));
	}
	
	public function init($user_id)
	{
		$data = array(
			array($user_id, 'o_deposit_payment', 3, '10', NULL, 'int', 2, 1, NULL),
			array($user_id, 'o_tax_payment', 3, '0.00', NULL, 'int', 3, 1, NULL),
			array($user_id, 'o_booking_status', 3, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
			array($user_id, 'o_payment_status', 3, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
			array($user_id, 'o_thank_you_page', 3, 'https://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
			array($user_id, 'o_payment_disable', 3, 'Yes|No::No', 'Yes|No', 'enum', 9, 1, NULL),
			array($user_id, 'o_allow_paypal', 3, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
			array($user_id, 'o_owner_paypal_address', 3, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
			array($user_id, 'o_allow_authorize', 3, 'Yes|No::Yes', 'Yes|No', 'enum', 12, 1, NULL),
			array($user_id, 'o_authorize_transkey', 3, '', NULL, 'string', 13, 1, NULL),
			array($user_id, 'o_authorize_merchant_id', 3, '', NULL, 'string', 14, 1, NULL),
			array($user_id, 'o_authorize_timezone', 3, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
			array($user_id, 'o_authorize_md5_hash', 3, NULL, NULL, 'string', 16, 1, NULL),
			array($user_id, 'o_allow_cash', 3, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
			array($user_id, 'o_allow_creditcard', 3, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
			array($user_id, 'o_allow_bank', 3, 'Yes|No::Yes', NULL, 'enum', 19, 1, NULL),
			array($user_id, 'o_bank_account', 3, NULL, NULL, 'text', 20, 1, NULL),
				
			array($user_id, 'o_email_confirmation', 4, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
			array($user_id, 'o_email_confirmation_subject', 4, '', NULL, 'string', 2, 1, NULL),
			array($user_id, 'o_email_confirmation_message', 4, '', NULL, 'text', 3, 1, NULL),
			array($user_id, 'o_email_payment', 4, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
			array($user_id, 'o_email_payment_subject', 4, '', NULL, 'string', 5, 1, NULL),
			array($user_id, 'o_email_payment_message', 4, '', NULL, 'text', 6, 1, NULL),
			array($user_id, 'o_email_cancel', 4, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
			array($user_id, 'o_email_cancel_subject', 4, '', NULL, 'string', 8, 1, NULL),
			array($user_id, 'o_email_cancel_message', 4, '', NULL, 'text', 9, 1, NULL),
			array($user_id, 'o_sms_confirmation_message', 4, '', NULL, 'text', 10, 1, NULL),
				
			array($user_id, 'o_owner_email_confirmation', 5, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
			array($user_id, 'o_owner_email_confirmation_subject', 5, '', NULL, 'string', 8, 1, NULL),
			array($user_id, 'o_owner_email_confirmation_message', 5, '', NULL, 'text', 9, 1, NULL),
			array($user_id, 'o_owner_email_payment', 5, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
			array($user_id, 'o_owner_email_payment_subject', 5, '', NULL, 'string', 11, 1, NULL),
			array($user_id, 'o_owner_email_payment_message', 5, '', NULL, 'text', 12, 1, NULL),
			array($user_id, 'o_owner_email_cancel', 5, '0|1::1', 'No|Yes',  'enum', 13, 1, NULL),
			array($user_id, 'o_owner_email_cancel_subject', 5, '', NULL, 'string', 14, 1, NULL),
			array($user_id, 'o_owner_email_cancel_message', 5, '', NULL, 'text', 15, 1, NULL),
			array($user_id, 'o_owner_sms_confirmation_message', 5, '', NULL, 'text', 16, 1, NULL),
			array($user_id, 'o_owner_sms_payment_message', 5, '', NULL, 'text', 17, 1, NULL)
		);
	
		$this->setBatchFields(array('foreign_id', 'key', 'tab_id', 'value', 'label', 'type', 'order', 'is_visible', 'style'));
		$this->setBatchRows($data);
		$this->insertBatch();
	}
	
	public function initMultiLang($user_id, $role_id)
	{
		if($role_id == 1)
		{
			$data = array(
				array(NULL, $user_id, 'pjOption', 1, 'o_email_confirmation_subject', 'Your booking has been received', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_confirmation_subject', 'Your booking has been received', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_confirmation_subject', 'Your booking has been received', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_confirmation_message', "Your booking has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_confirmation_message', "Your booking has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_confirmation_message', "Your booking has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_payment_subject', 'We received your payment', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_payment_subject', 'We received your payment', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_payment_subject', 'We received your payment', 'data'),
	
				array(NULL, $user_id, 'pjOption', 1, 'o_email_payment_message', "Your payment has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_payment_message', "Your payment has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_payment_message', "Your payment has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_cancel_message', "You've just cancelled your booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_cancel_message', "You've just cancelled your booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_cancel_message', "You've just cancelled your booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_sms_confirmation_message', "Hi {Name},\r\n\r\nWe already received your booking.\r\n\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_sms_confirmation_message', "Hi {Name},\r\n\r\nWe already received your booking.\r\n\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_sms_confirmation_message', "Hi {Name},\r\n\r\nWe already received your booking.\r\n\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_confirmation_subject', 'New booking received', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_confirmation_subject', 'New booking received', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_confirmation_subject', 'New booking received', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_confirmation_message', "You've just received a booking. \r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_confirmation_message', "You've just received a booking. \r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_confirmation_message', "You've just received a booking. \r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_payment_subject', 'New payment received', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_payment_subject', 'New payment received', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_payment_subject', 'New payment received', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_payment_message', "You've just received payment for the booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_payment_message', "You've just received payment for the booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_payment_message', "You've just received payment for the booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_cancel_subject', 'Booking cancelled', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_cancel_subject', 'Booking cancelled', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_cancel_subject', 'Booking cancelled', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_cancel_message', "A booking has been cancelled.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_cancel_message', "A booking has been cancelled.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_cancel_message', "A booking has been cancelled.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_sms_confirmation_message', "New booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_sms_confirmation_message', "New booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_sms_confirmation_message', "New booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_sms_payment_message', "A payment for booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_sms_payment_message', "A payment for booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_sms_payment_message', "A payment for booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_registration_subject', 'Account created', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_registration_subject', 'Account created', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_registration_subject', 'Account created', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_registration_message', "Your account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPassword: {Password}\r\n\r\nRegards,\r\nThe Management", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_registration_message', "Your account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPassword: {Password}\r\n\r\nRegards,\r\nThe Management", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_registration_message', "Your account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPassword: {Password}\r\n\r\nRegards,\r\nThe Management", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_submission_subject', 'Yacht submitted', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_submission_subject', 'Yacht submitted', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_submission_subject', 'Yacht submitted', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_submission_message', "We've received your yacht submission.\r\n\r\nYacht ID: {RefID}\r\nType:{Type}\r\n\r\nRegards,\r\nThe Management", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_submission_message', "We've received your yacht submission.\r\n\r\nYacht ID: {RefID}\r\nType:{Type}\r\n\r\nRegards,\r\nThe Management", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_submission_message', "We've received your yacht submission.\r\n\r\nYacht ID: {RefID}\r\nType:{Type}\r\n\r\nRegards,\r\nThe Management", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_forgot_subject', 'Password recovery', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_forgot_subject', 'Password recovery', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_forgot_subject', 'Password recovery', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_forgot_message', "Dear {Name}.\r\n\r\nYour password is: {Password}\r\n\r\nRegards,\r\nThe Management", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_forgot_message', "Dear {Name}.\r\n\r\nYour password is: {Password}\r\n\r\nRegards,\r\nThe Management", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_forgot_message', "Dear {Name}.\r\n\r\nYour password is: {Password}\r\n\r\nRegards,\r\nThe Management", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_sms_registration_message', 'Your account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPassword: {Password}', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_sms_registration_message', 'Your account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPassword: {Password}', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_sms_registration_message', 'Your account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPassword: {Password}', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_sms_submission_message', "We've received your yacht submission.\r\n\r\nYacht ID: {RefID}\r\nType:{Type}", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_sms_submission_message', "We've received your yacht submission.\r\n\r\nYacht ID: {RefID}\r\nType:{Type}", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_sms_submission_message', "We've received your yacht submission.\r\n\r\nYacht ID: {RefID}\r\nType:{Type}", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_admin_email_registration_subject', 'New account created', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_admin_email_registration_subject', 'New account created', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_admin_email_registration_subject', 'New account created', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_admin_email_registration_message', "New account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPhone: {Phone}", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_admin_email_registration_message', "New account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPhone: {Phone}", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_admin_email_registration_message', "New account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPhone: {Phone}", 'data'),
				
				array(NULL, $user_id, 'pjOption', 1, 'o_admin_email_submission_subject', 'New Yacht Submitted', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_admin_email_submission_subject', 'New Yacht Submitted', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_admin_email_submission_subject', 'New Yacht Submitted', 'data'),
				
				array(NULL, $user_id, 'pjOption', 1, 'o_admin_email_submission_message', "Yacht ID: {RefID}\r\nType: {Type}", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_admin_email_submission_message', "Yacht ID: {RefID}\r\nType: {Type}", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_admin_email_submission_message', "Yacht ID: {RefID}\r\nType: {Type}", 'data'),
				
				array(NULL, $user_id, 'pjOption', 1, 'o_admin_sms_registration_message', "New account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPhone: {Phone}", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_admin_sms_registration_message', "New account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPhone: {Phone}", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_admin_sms_registration_message', "New account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPhone: {Phone}", 'data'),
				
				array(NULL, $user_id, 'pjOption', 1, 'o_admin_sms_submission_message', "New yacht submitted\r\n\r\nProperty ID: {RefID}\r\nType: {Type}", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_admin_sms_submission_message', "New yacht submitted\r\n\r\nProperty ID: {RefID}\r\nType: {Type}", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_admin_sms_submission_message', "New yacht submitted\r\n\r\nProperty ID: {RefID}\r\nType: {Type}", 'data')
			);
		}else{
			$data = array(
				array(NULL, $user_id, 'pjOption', 1, 'o_email_confirmation_subject', 'Your booking has been received', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_confirmation_subject', 'Your booking has been received', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_confirmation_subject', 'Your booking has been received', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_confirmation_message', "Your booking has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_confirmation_message', "Your booking has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_confirmation_message', "Your booking has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_payment_subject', 'We received your payment', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_payment_subject', 'We received your payment', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_payment_subject', 'We received your payment', 'data'),
	
				array(NULL, $user_id, 'pjOption', 1, 'o_email_payment_message', "Your payment has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_payment_message', "Your payment has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_payment_message', "Your payment has been received.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_email_cancel_message', "You've just cancelled your booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_email_cancel_message', "You've just cancelled your booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_email_cancel_message', "You've just cancelled your booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nThank you, we will contact you ASAP.", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_sms_confirmation_message', "Hi {Name},\r\n\r\nWe already received your booking.\r\n\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_sms_confirmation_message', "Hi {Name},\r\n\r\nWe already received your booking.\r\n\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_sms_confirmation_message', "Hi {Name},\r\n\r\nWe already received your booking.\r\n\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_confirmation_subject', 'New booking received', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_confirmation_subject', 'New booking received', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_confirmation_subject', 'New booking received', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_confirmation_message', "You've just received a booking. \r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_confirmation_message', "You've just received a booking. \r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_confirmation_message', "You've just received a booking. \r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_payment_subject', 'New payment received', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_payment_subject', 'New payment received', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_payment_subject', 'New payment received', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_payment_message', "You've just received payment for the booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_payment_message', "You've just received payment for the booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_payment_message', "You've just received payment for the booking.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_cancel_subject', 'Booking cancelled', 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_cancel_subject', 'Booking cancelled', 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_cancel_subject', 'Booking cancelled', 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_email_cancel_message', "A booking has been cancelled.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_email_cancel_message', "A booking has been cancelled.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_email_cancel_message', "A booking has been cancelled.\r\n\r\nPersonal details:\r\nName: {Name}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nCountry: {Country}\r\nCity: {City}\r\nAddress: {Address}\r\nNotes: {Notes}\r\n\r\nBooking details:\r\nBooking ID: {BookingID}\r\nBooking time: {BookingTime}\r\nYacht: {Yacht}\r\n\r\nPayment information:\r\nPayment method: {PaymentMethod}\r\nSub-total: {SubTotal}\r\nTax: {Tax}\r\nTotal: {Total}\r\nDeposit: {Deposit}\r\n\r\nThank you!", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_sms_confirmation_message', "New booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_sms_confirmation_message', "New booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_sms_confirmation_message', "New booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data'),
					
				array(NULL, $user_id, 'pjOption', 1, 'o_owner_sms_payment_message', "A payment for booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data'),
				array(NULL, $user_id, 'pjOption', 2, 'o_owner_sms_payment_message', "A payment for booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data'),
				array(NULL, $user_id, 'pjOption', 3, 'o_owner_sms_payment_message', "A payment for booking has been made\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nBooking ID: {BookingID}\r\nBookingTime: {BookingTime}\r\nSub-total: {SubTotal}", 'data')
			);
		}
		$pjMultiLangModel = pjMultiLangModel::factory();
		$pjMultiLangModel->setBatchFields(array('id', 'foreign_id', 'model', 'locale', 'field', 'content', 'source'));
		$pjMultiLangModel->setBatchRows($data);
		$pjMultiLangModel->insertBatch();
	}
	
	public function removeOptions($user_id)
	{
		$this->reset()->where('foreign_id', $user_id)->eraseAll();
	}
}
?>