<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	pjUtil::printNotice(__('infoListingsTitle', true), __('infoListingsDesc', true)); 
	?>	
	<div class="b10">
		<?php
		if($controller->isAdmin() || $controller->isEditor() || ($controller->isOwner() && $tpl['option_arr']['o_allow_add_listing'] == 'Yes'))
		{ 
			?>
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
				<input type="hidden" name="controller" value="pjAdminListings" />
				<input type="hidden" name="action" value="pjActionCreate" />
				<input type="submit" class="pj-button" value="<?php __('btnAddYacht'); ?>" />
			</form>
			<?php
		} 
		?>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>
		<?php
		$filter = __('filter', true);
		$publish_statuses = __('publish_statuses', true);
		?>
		<div class="float_right t5">
			<a href="#" class="pj-button btn-all pj-button-active"><?php __('lblAll');?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="T"><?php echo $publish_statuses['T']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="F"><?php echo $publish_statuses['F']; ?></a>
		</div>
		<br class="clear_both" />
	</div>
	
	<div class="pj-form-filter-advanced" style="display: none">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			<div class="float_left w350">
				<p>
					<label class="title"><?php __('lblRefId'); ?></label>
					<input type="text" name="listing_refid" id="listing_refid" class="pj-form-field w150" />
				</p>
				
				<p>
					<label class="title"><?php __('lblKeyword'); ?></label>
					<input type="text" name="keyword" id="keyword" class="pj-form-field w150" />
				</p>
				<p>
					<label class="title"><?php __('lblType'); ?></label>
					<select name="for" id="for" class="pj-form-field w180">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach (__('listing_for') as $k => $v)
						{
							?><option value="<?php echo $k; ?>"<?php echo isset($_GET['for']) && $_GET['for'] == $v['for'] ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</p>
			</div>
			<div class="float_right w350">
				<?php
				if ($controller->isAdmin())
				{
					?>
					<p style="overflow: visible;">
						<label class="title"><?php __('lblOwner'); ?></label>
						<select name="owner_id" id="owner_id" class="pj-form-field w150">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach ($tpl['user_arr'] as $v)
							{
								?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['user_id']) && (int) $_GET['user_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
							}
							?>
						</select>
					</p>
					<?php
				} 
				?>
				<p>
					<label class="title"><?php __('lblState'); ?></label>
					<input type="text" name="address_state" id="address_state" class="pj-form-field w150" />
				</p>
				<p>
					<label class="title"><?php __('lblCity'); ?></label>
					<input type="text" name="address_city" id="address_city" class="pj-form-field w150" />
				</p>
			</div>
			<br class="clear_both" />
			<p>
				<label class="title"><?php __('lblCountry'); ?></label>
				<select name="address_country" id="address_country" class="pj-form-field w350">
					<option value="">-- <?php __('lblChoose'); ?> --</option>
					<?php
					foreach ($tpl['country_arr'] as $v)
					{
						?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['address_country']) && (int) $_GET['address_country'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
					}
					?>
				</select>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSearch'); ?>" class="pj-button" />
				<input type="reset" value="<?php __('btnCancel'); ?>" class="pj-button" />
			</p>
		</form>
	</div>
	
	<div id="grid" class="pj-yachts"></div>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.jqDateFormat = "<?php echo pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.queryString = "";
	pjGrid.isOwner = <?php echo $controller->isOwner() ? 'true' : 'false'; ?>;
	pjGrid.isEditor = <?php echo $controller->isEditor() ? 'true' : 'false'; ?>;
	<?php
	if (isset($_GET['user_id']) && (int) $_GET['user_id'] > 0)
	{
		?>pjGrid.queryString += "&user_id=<?php echo (int) $_GET['user_id']; ?>";<?php
	}
	if (isset($_GET['for']) && in_array($_GET['for'], array('sale', 'rent')))
	{
		?>pjGrid.queryString += "&for=<?php echo $_GET['for']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.image = "<?php __('lblImage'); ?>";
	myLabel.listing_refid = "<?php __('lblRefId'); ?>";
	myLabel.type = "<?php __('lblType'); ?>";
	myLabel.publish = "<?php __('lblPublish'); ?>";
	myLabel.active = "<?php echo $publish_statuses['T']; ?>";
	myLabel.inactive = "<?php echo $publish_statuses['F']; ?>";
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	myLabel.published = "<?php __('lblPublished'); ?>";
	myLabel.not_published = "<?php __('lblNotPublished'); ?>";
	myLabel.extend_exp_date = "<?php __('lblExtendExpDate'); ?>";
	myLabel.price = "<?php __('lblPrice'); ?>";
	myLabel.expire = "<?php __('lblExpire'); ?>";
	myLabel.exp_date = "<?php __('lblExpDate'); ?>";
	myLabel.owner = "<?php __('lblOwner'); ?>";
	myLabel.exp_date_plus_30 = "<?php __('lblExpDatePlus30'); ?>";
	myLabel.unlimited = "<?php __('lblUnlimited');?>";
	</script>
	<?php
}
?>