var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var datagrid = ($.fn.datagrid !== undefined),
			datepicker = ($.fn.datepicker !== undefined),
			gallery = ($.fn.gallery !== undefined),
			chosen = ($.fn.chosen !== undefined),
			dialog = ($.fn.dialog !== undefined),
			validate = ($.fn.validate !== undefined),
			tipsy = ($.fn.tipsy !== undefined),
			$frmCreateListing = $("#frmCreateListing"),
			$frmUpdateListing = $("#frmUpdateListing"),
			$frmXMLFeed = $("#frmXMLFeed"),
			$dialogDeletePrice = $("#dialogDeletePrice"),
			$dialogDeleteFile = $("#dialogDeleteFile"),
			$gallery = $("#gallery"),
			$tabs = $("#tabs"),
			tOpt = {
				select: function (event, ui) {
					$(":input[name='tab_id']").val(ui.panel.id);
				}
			};
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 0
		});
		
		if ($frmXMLFeed.length > 0 && validate) {
			$frmXMLFeed.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				errorClass: "err",
				wrapper: "em",
				onkeyup: false,
				ignore: ""
			});
		}
		
		if ($frmCreateListing.length > 0 && validate) {
			$frmCreateListing.validate({
				rules: {
					"listing_refid": {
						required: true,
						remote: "index.php?controller=pjAdminListings&action=pjActionCheckRefId"
					},
					"expire": {
						required: function(e){
							if($('#status').val() == 'E'){
								return true;
							}else{
								return false;
							}
						}
		            }
				},
				messages: {
					"listing_refid": {
						required: myLabel.field_required
					},
					"for": {
						required: myLabel.field_required
					},
					"manufacturer_id": {
						required: myLabel.field_required
					},
					"status": {
						required: myLabel.field_required
					},
					"expire": {
						required: myLabel.field_required
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				errorClass: "err",
				wrapper: "em",
				onkeyup: false,
				ignore: ""
			});
		}
		
		if (chosen) {
			$("#user_id").chosen();
		}
		
		if($('.frm-filter-advanced').length > 0)
		{
			$("#address_country").chosen();
			$("#owner_id").chosen();
		}
		
		if ($dialogDeletePrice.length > 0 && dialog) {
			$dialogDeletePrice.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				buttons: {
					"Delete": function () {
						var $this = $(this),
							$link = $this.data("link"),
							$tr = $link.closest("tr");
						$.post("index.php?controller=pjAdminListings&action=pjActionDeletePrice", {
							id: $link.data("id")
						}).done(function () {
							$tr.css("backgroundColor", "#FFB4B4").fadeOut("slow", function () {
								$tr.remove();
								$this.dialog("close");
							});
						});
					},
					"Cancel": function () {
						$(this).dialog("close");
					}
				}
			});
		}
		
		if ($dialogDeleteFile.length > 0 && dialog) 
		{
			$dialogDeleteFile.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				width: 400,
				buttons: (function () {
					var buttons = {};
					buttons[ylApp.locale.button.delete] = function () {
						$.ajax({
							type: "GET",
							dataType: "json",
							url: $dialogDeleteFile.data('href'),
							success: function (res) {
								if(res.code == 200){
									$('#file_container').remove();
									$dialogDeleteFile.dialog('close');
								}
							}
						});
					};
					buttons[ylApp.locale.button.cancel] = function () {
						$dialogDeleteFile.dialog("close");
					};
					
					return buttons;
				})()
			});
		}
		
		$("#content").on("click", ".btnDeletePrice", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if ($dialogDeletePrice.length > 0 && dialog) {
				$dialogDeletePrice.data('link', $(this)).dialog("open");
			}
			return false;
		}).on("click", ".btnRemovePrice", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $tr = $(this).closest("tr");
			$tr.css("backgroundColor", "#FFB4B4").fadeOut("slow", function () {
				$tr.remove();
			});
			return false;
		}).on("click", "input[name='o_allow_paypal']", function (e) {
			if ($(this).is(":checked")) {
				$(".PayPal").show();
				$(".PayPal input").addClass('email required');
			} else {
				$(".PayPal").hide();
				$(".PayPal input").removeClass('email required');
			}
		}).on("click", "input[name='o_allow_authorize']", function (e) {
			if ($(this).is(":checked")) {
				$(".AuthorizeNet").show();
				$(".AuthorizeNet input").addClass('required');
			} else {
				$(".AuthorizeNet").hide();
				$(".AuthorizeNet input").removeClass('required');
			}
		}).on("click", "input[name='o_allow_bank']", function (e) {
			if ($(this).is(":checked")) {
				$(".BankAccount").show();
				$(".BankAccount textarea").addClass('required');
			} else {
				$(".BankAccount").hide();
				$(".BankAccount textarea").removeClass('required');
			}
		}).on("click", "#btnAddPrice", function (e) {
			var $tr,
				$tbody = $("#tblPrices tbody"),
				h = $tbody.find("tr:last").find("td:first").html(),
				i = (h === null) ? 0 : parseInt(h, 10);
			i = !isNaN(i) ? i : 0;
			$tr = $("#tblPricesClone").find("tbody").clone();
			$tbody.find(".notFound").remove();
			$tbody.append($tr.html().replace(/\{INDEX\}/g, i + 1));
		}).on("focusin", ".datepick", function (e) {
			var minDate, maxDate,
				$this = $(this),
				custom = {},
				o = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
			};
			switch ($this.attr("name")) {
			case "date_from[]":
				maxDate = $this.closest("tr").find(".datepick[name='date_to[]']").datepicker({
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
				}).datepicker("getDate");
				$this.closest("tr").find(".datepick[name='date_to[]']").datepicker("destroy").removeAttr("id");
				if (maxDate !== null) {
					custom.maxDate = maxDate;
				}
				break;
			case "date_to[]":
				minDate = $this.closest("tr").find(".datepick[name='date_from[]']").datepicker({
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
				}).datepicker("getDate");
				$this.closest("tr").find(".datepick[name='date_from[]']").datepicker("destroy").removeAttr("id");
				if (minDate !== null) {
					custom.minDate = minDate;
				}
				break;
			}
			$this.not('.hasDatepicker').datepicker($.extend(o, custom));
		}).on("click", ".pj-checkbox", function () {
			var $this = $(this);
			if ($this.find("input[type='checkbox']").is(":checked")) {
				$this.addClass("pj-checkbox-checked");
			} else {
				$this.removeClass("pj-checkbox-checked");
			}
		}).on("click", ".listing-tip", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			return false;
		});
		
		if ($frmUpdateListing.length > 0 && validate) {
			$frmUpdateListing.validate({
				messages:{
					"listing_year": {
		            	minlength: myLabel.min_length,
		                maxlength: myLabel.max_length,
		                digits: myLabel.digits
		            },
		            "listing_engine_hours": {
		                maxlength: myLabel.max_five_length,
		                digits: myLabel.digits
		            },
		            "listing_cruising_speed": {
		                maxlength: myLabel.max_five_length,
		                digits: myLabel.digits
		            },
		            "listing_max_speed": {
		                maxlength: myLabel.max_five_length,
		                digits: myLabel.digits
		            },
		            "listing_fuel_tank": {
		                maxlength: myLabel.max_five_length,
		                digits: myLabel.digits
		            }
				},
				rules: {
					"listing_refid": {
						required: true,
						remote: "index.php?controller=pjAdminListings&action=pjActionCheckRefId&id=" + $frmUpdateListing.find("input[name='id']").val()
					},
					"expire": {
						required: function(e){
							if($('#status').val() == 'E'){
								return true;
							}else{
								return false;
							}
						}
		            },
		            "listing_year": {
		            	minlength: 4,
		                maxlength:4,
		                digits: true
		            },
		            "listing_engine_hours": {
		                maxlength: 5,
		                digits: true
		            },
		            "listing_cruising_speed": {
		                maxlength: 5,
		                digits: true
		            },
		            "listing_max_speed": {
		                maxlength: 5,
		                digits: true
		            },
		            "listing_fuel_tank": {
		                maxlength: 5,
		                digits: true
		            }
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				errorClass: "err",
				wrapper: "em",
				onkeyup: false,
				ignore: "",
				invalidHandler: function (event, validator) {
				    if (validator.numberOfInvalids()) {
				    	var index = $(validator.errorList[0].element, this).closest("div[id^='tabs-']").index();
				    	if ($tabs.length > 0 && tabs && index !== -1) {
				    		$tabs.tabs(tOpt).tabs("option", "active", index-1);
				    	}
				    }
				    $(".pj-multilang-wrap").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).css('display','block');
						}else{
							$(this).css('display','none');
						}
					});
					$(".pj-form-langbar-item").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).addClass('pj-form-langbar-item-active');
						}else{
							$(this).removeClass('pj-form-langbar-item-active');
						}
					});
				}
				
			});

			if ($frmUpdateListing.length > 0 || $frmCreateListing.length > 0) 
			{
				tinymce.init({
				    selector: "textarea.mceEditor",
				    theme: "modern",
				    width: 570,
				    plugins: [
				         "advlist autolink link lists charmap",
				         "save directionality paste textcolor code"
				   ],
				   toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullpage | forecolor backcolor emoticons"
				 }); 
				
			}
	
			$("a.fancybox").fancybox();
			
			$(".field-int").spinner({
				min: 0
			});
			$('.pj-button-save').click(function() {
				tinyMCE.triggerSave();
			});
			if (chosen) {
				$("#owner_id").chosen();
				$("#address_country").chosen();
			}
		}
		
		if (tipsy) {
			$(".listing-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				gravity: "nw",
				className: "tipsy-listing"
			});
			$(".center-langbar-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				className: "tipsy-listing-center"
			});
		}
		
		if ($gallery.length > 0 && gallery) {
			$gallery.gallery({
				compressUrl: "index.php?controller=pjGallery&action=pjActionCompressGallery&foreign_id=" + myGallery.foreign_id,
				getUrl: "index.php?controller=pjGallery&action=pjActionGetGallery&foreign_id=" + myGallery.foreign_id,
				deleteUrl: "index.php?controller=pjGallery&action=pjActionDeleteGallery",
				emptyUrl: "index.php?controller=pjGallery&action=pjActionEmptyGallery&foreign_id=" + myGallery.foreign_id,
				rebuildUrl: "index.php?controller=pjGallery&action=pjActionRebuildGallery&foreign_id=" + myGallery.foreign_id,
				resizeUrl: "index.php?controller=pjGallery&action=pjActionResizeGallery&id={:id}&foreign_id=" + myGallery.foreign_id + "&hash=" + myGallery.hash + ($frmUpdateListing.length > 0 ? "&query_string=" + encodeURIComponent("controller=pjAdminListings&action=pjActionUpdate&id=" + myGallery.foreign_id + "&tab_id=tabs-5") : ""),
				rotateUrl: "index.php?controller=pjGallery&action=pjActionRotateGallery",
				sortUrl: "index.php?controller=pjGallery&action=pjActionSortGallery",
				updateUrl: "index.php?controller=pjGallery&action=pjActionUpdateGallery",
				uploadUrl: "index.php?controller=pjGallery&action=pjActionUploadGallery&foreign_id=" + myGallery.foreign_id,
				watermarkUrl: "index.php?controller=pjGallery&action=pjActionWatermarkGallery&foreign_id=" + myGallery.foreign_id
			});
		}
		
		$(".spin").spinner({
			min: 0
		});
		
		if ($("#grid").length > 0 && datagrid) {
			
			function formatImage(val, obj) {
				var src = val ? val : 'app/web/img/backend/no_img.png';
				return ['<a href="index.php?controller=pjAdminListings&action=pjActionUpdate&id=', obj.id ,'"><img src="', src, '" style="width: 100px" /></a>'].join("");
			}
			
			function formatOwner(val, obj) {
				return ['<a href="index.php?controller=pjAdminUsers&action=pjActionUpdate&id=', obj.owner_id, '">', $.datagrid.wordwrap(obj.owner_name, 20, '<br>', true), '</a>'].join("");
			}
			
			function formatRefid(val, obj) {
				return $.datagrid.wordwrap(val, 25, '<br>', true);
			}
			function _formatStatus(val, obj) 
			{
				if(obj.status == 'F')
				{
					return '<span class="pj-table-cell-label pj-status pj-status-F">'+myLabel.inactive+'</span>';
				}else if(obj.status == 'E'){
					if(obj.is_expired == 1)
					{
						return '<span class="pj-table-cell-label pj-status b5 pj-status-E">'+myLabel.exp_date+'</span><span class="color-red">'+obj.expire+'</span>';
					}else{
						return '<span class="pj-table-cell-label pj-status b5 pj-status-E">'+myLabel.exp_date+'</span><span>'+obj.expire+'</span>';
					}
				}else{
					return '<span class="pj-table-cell-label pj-status b10 pj-status-T">'+myLabel.active+'</span>' + myLabel.unlimited;
				}
			}
			function _formatDate(val, obj) {
				if(obj.added_by == 'owner')
				{
					if(obj.status == 'F')
					{
						return '';
					}else if(obj.status == 'E'){
						if(obj.is_expired == 1)
						{
							return '<span class="color-red">'+val+'</span>';
						}else{
							return val;
						}
					}else{
						return myLabel.unlimited;
					}
				}else{
					if(obj.status == 'E'){
						if(obj.is_expired == 1)
						{
							return '<span class="color-red">'+val+'</span>';
						}else{
							return val;
						}
					}
				}
			}
			var menuOpts = [  
			                  {text: myLabel.exp_date_plus_30, url: "index.php?controller=pjAdminListings&action=pjActionExpireListing&id={:id}", ajax: true, render: true},
				              {text: myLabel.view_enquiries, url: "index.php?controller=pjAdminEnquiries&action=pjActionIndex&listing_id={:id}"}
				           ];
			if (pjGrid.isEditor === true) {
				menuOpts = [  
				              {text: myLabel.view_enquiries, url: "index.php?controller=pjAdminEnquiries&action=pjActionIndex&listing_id={:id}"}
				           ];
			}
			var gridOpts = {
				buttons: [{type: "edit", url: "index.php?controller=pjAdminListings&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminListings&action=pjActionDeleteListing&id={:id}"},
				          {type: "menu", url: "#", text: myLabel.more, items:menuOpts}],
				columns: [{text: myLabel.image, type: "text", width: 110, sortable: false, editable: false, renderer: formatImage},
				          {text: myLabel.listing_refid, type: "text", sortable: true, width: 60, editable: true, renderer: formatRefid},
				          {text: myLabel.type, type: "text", sortable: true, editable: false, width: 80},
				          {text: myLabel.owner, type: "text", sortable: true, editable: false, renderer: formatOwner, width: 100},
				          {text: myLabel.price, type: "text", sortable: true, editable: false},
				          {text: myLabel.publish, type: "text", width: 90, sortable: true, editable: false, renderer: _formatStatus}
				          ],
				dataUrl: "index.php?controller=pjAdminListings&action=pjActionGetListing" + pjGrid.queryString,
				dataType: "json",
				fields: ['image', 'listing_refid', 'type', 'owner_name', 'price', 'status'],
				paginator: {
					actions: [
						{text: myLabel.delete_selected, url: "index.php?controller=pjAdminListings&action=pjActionDeleteListingBulk", render: true, confirmation: myLabel.delete_confirmation},
						{text: myLabel.published, url: "index.php?controller=pjAdminListings&action=pjActionStatusListing&status=T", render: true},
						{text: myLabel.not_published, url: "index.php?controller=pjAdminListings&action=pjActionStatusListing&status=F", render: true}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminListings&action=pjActionSaveListing&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			};
			if (pjGrid.isOwner === true) {
				function formatExtend(val, obj) {
					if(obj.status == 'F')
					{
						return '<span class="pj-table-cell-label pj-status b10 pj-status-F">'+myLabel.inactive+'</span>' + ['<a class="pj-button" href="index.php?controller=pjAdminProperties&action=pjActionPayment&id=', val, '">', myLabel.publish, '</a>'].join("");
					}if(obj.status == 'T'){
						return '<span class="pj-table-cell-label pj-status b5 pj-status-T">'+myLabel.active+'</span>' + myLabel.unlimited;
					}else{
						return '<span class="pj-table-cell-label pj-status b5 pj-status-E">'+myLabel.exp_date+'</span><span class="block b10">'+obj.expire+'</span>' + ['<a class="pj-button" href="index.php?controller=pjAdminProperties&action=pjActionPayment&id=', val, '">', myLabel.extend_exp_date, '</a>'].join("");
					}
				}
				function _formatDate(val, obj){
					if(obj.status == 'F')
					{
						return myLabel.inactive;
					}if(obj.status == 'T'){
						return myLabel.unlimited;
					}else{
						if(obj.is_expired == 1)
						{
							return '<span class="color-red">'+val+'</span>';
						}else{
							return val;
						}
					}
				}
				gridOpts.buttons = [
				    {type: "edit", url: "index.php?controller=pjAdminListings&action=pjActionUpdate&id={:id}"},
				    {type: "delete", url: "index.php?controller=pjAdminListings&action=pjActionDeleteListing&id={:id}"}
				];
				gridOpts.columns = [
				    {text: myLabel.image, type: "text", sortable: false, editable: false, renderer: formatImage, width: 100},
				    {text: myLabel.listing_refid, type: "text", sortable: true, editable: true, width: 80},
					{text: myLabel.price, type: "text", sortable: true, editable: false, width: 170},
					{text: myLabel.publish, type: "text", sortable: false, editable: false, renderer: formatExtend, width: 200}
				];
				gridOpts.fields = ['image', 'listing_refid', 'price', 'id'];
				gridOpts.paginator.actions = [{text: myLabel.delete_selected, url: "index.php?controller=pjAdminListings&action=pjActionDeleteListingBulk", render: true, confirmation: myLabel.delete_confirm}];
			}
			
			var $grid = $("#grid").datagrid(gridOpts);
			
			$(document).on("click", ".btn-all", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
				var content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					status: "",
					listing_refid: "",
					address_country: "",
					for: "",
					owner_id: "",
					keyword: "",
					address_state: "",
					address_city: ""
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminListings&action=pjActionGetListing", "id", "DESC", content.page, content.rowCount);
				return false;
			}).on("click", ".btn-filter", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = $(this),
					content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache"),
					obj = {};
				$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
				obj.status = "";
				obj.is_featured = "";
				obj[$this.data("column")] = $this.data("value");
				$.extend(cache, obj);
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminListings&action=pjActionGetListing", "id", "DESC", content.page, content.rowCount);
				return false;
			}).on("click", ".pj-button-detailed, .pj-button-detailed-arrow", function (e) {
				e.stopPropagation();
				$(".pj-form-filter-advanced").toggle();
			}).on("submit", ".frm-filter-advanced", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var obj = {},
					$this = $(this),
					arr = $this.serializeArray(),
					content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				for (var i = 0, iCnt = arr.length; i < iCnt; i++) {
					obj[arr[i].name] = arr[i].value;
				}
				$.extend(cache, obj);
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminListings&action=pjActionGetListing", "id", "ASC", content.page, content.rowCount);
				return false;
			}).on("reset", ".frm-filter-advanced", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				$(".pj-button-detailed").trigger("click");
				if (chosen) {
					$("#owner_id").val('').trigger("liszt:updated");
					$("#address_country").val('').trigger("liszt:updated");
				}
				$('#listing_refid').val('');
				$('#keyword').val('');
				$('#for').val('');
				$('#address_state').val('');
				$('#address_city').val('');
			}).on("submit", ".frm-filter", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = $(this),
					content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					q: $this.find("input[name='q']").val(),
					listing_refid: "",
					keyword: "",
					for: "",
					owner_id: "",
					address_country: "",
					address_state: "",
					address_city: ""
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminListings&action=pjActionGetListing", "id", "ASC", content.page, content.rowCount);
				return false;
			});
			
		}
		
		$(document).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
		}).on("change", "#status", function (e) {
			if($(this).val() == 'E')
			{
				$('#expiration_container').css('display', 'block');
			}else{
				$('#expiration_container').css('display', 'none');
			}
		}).on("change", "#for", function (e) {
			if($(this).val() == 'rent')
			{
				$('.priceBox').css('display', 'inline-block');
			}else{
				$('.priceBox').css('display', 'none');
			}
		}).on("click", ".resetContact", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var href = 'index.php?controller=pjAdminListings&action=pjActionResetContact',
				can_request = false;
			if($('#owner_id').length > 0)
			{
				if($('#owner_id').val() != '')
				{
					href += '&id=' + $('#owner_id').val();
					can_request = true;
				}
			}else{
				if(myLabel.isOwner == true)
				{
					can_request = true;
				}
			}
			if(can_request == true)
			{
				$.get(href).done(function (data) {
					if(data.hasOwnProperty('name')){
						$('#owner_name').val(data.name);
					}
					if(data.hasOwnProperty('email')){
						$('#owner_email').val(data.email);
					}
					if(data.hasOwnProperty('phone')){
						$('#owner_phone').val(data.phone);
					}
					if(data.hasOwnProperty('fax')){
						$('#owner_fax').val(data.fax);
					}
				});
			}
		}).on("focus", "#properties_feed", function (e) {
			$(this).select();
		}).on("change", "#year_price", function (e) {
			$('.pj-loader').show();
			$.get('index.php?controller=pjAdminListings&action=pjActionGetPrices&id=' + $frmUpdateListing.find("input[name='id']").val() + '&year=' + $(this).val()).done(function (data) {
				$('#ylPriceContainer').html(data);
				$('.pj-loader').hide();
			});
		});
	});
})(jQuery_1_8_2);