<?php
$listing_for = __('listing_for', true); 
?>
<div class="yacht-details">
	<div class="container">
		<?php
		if($tpl['status'] == '200')
		{
			$back = !empty($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : $_SERVER['PHP_SELF'] .'?controller=pjWebsite&amp;action=pjActionYachts&amp;listing_search=1&amp;for=' . $tpl['arr']['for']. (isset($_GET['iframe']) ? '&amp;iframe' : NULL);
			if(strpos($back, 'pjActionReserve') > 0)
			{
				$back = $_SERVER['PHP_SELF'] .'?controller=pjWebsite&amp;action=pjActionYachts&amp;listing_search=1&amp;for=' . $tpl['arr']['for'] . (isset($_GET['iframe']) ? '&amp;iframe' : NULL);
			}
			$listing_title = pjSanitize::html(stripslashes($tpl['arr']['title']));
			?>
			<div class="buttons">
				<a href="<?php echo $back;?>" class="btn btn-primary"><span class="glyphicon glyphicon-menu-left"></span> <?php __('ws_btn_back');?></a>
			</div><!-- /.buttons -->
	
			<div class="row yacht-details-row">
				<?php
				if(!empty($tpl['gallery_arr']))
				{ 
					?>
					<div class="col-lg-8">
						<div class="flexslider yacht-details-slider">
							<ul class="slides">
								<?php
								foreach ($tpl['gallery_arr'] as $k => $v)
								{ 
									?>
									<li data-thumb="<?php echo PJ_INSTALL_URL . $v['small_path'];?>"><img src="<?php echo PJ_INSTALL_URL . $v['medium_path'];?>" alt=""></li>
									<?php
								} 
								?>
							</ul>
						</div><!-- /.yacht-details-slider -->
					</div>
					<?php
				} 
				?>
	
				<div class="col-lg-4">
					<div class="yacht-details-info">
						<h2><?php echo $listing_title;?></h2>
						<?php
						if($tpl['arr']['for'] == 'sale' && !empty($tpl['arr']['listing_price']))
						{ 
							?>
							<p class="price"><?php echo pjUtil::formatCurrencySign($tpl['arr']['listing_price'], $tpl['option_arr']['o_currency']);?></p>
							<?php
						} 
						?>
	
						<ul>
							<li><?php __('ws_reference_id');?> <strong><?php echo pjSanitize::html($tpl['arr']['listing_refid']);?></strong></li>
							<li><?php __('ws_search_manufacturer');?> <strong><?php echo pjSanitize::html($tpl['arr']['manufacturer']);?></strong></li>
							<li><?php __('ws_search_model');?> <strong><?php echo pjSanitize::html($tpl['arr']['listing_model']);?></strong></li>
							<?php
							$enum_arr = __('enum_arr', true);
							$opt_speed = $tpl['option_arr']['o_speed'];
							if(!empty($tpl['arr']['listing_year']))
							{
								?><li><?php __('ws_registration_year');?> <strong><?php echo pjSanitize::html($tpl['arr']['listing_year']);?></strong></li><?php
							}
							$feature_types = __('feature_types', true);
							foreach($feature_types as $k => $v)
							{
								if(!empty($tpl['arr']['feature_' . $k]))
								{
									?>
									<li><?php echo $v;?> <strong><?php echo pjSanitize::html($tpl['arr']['feature_' . $k]);?></strong></li>
									<?php
								}
							} 
							if(!empty($tpl['arr']['listing_length']))
							{
								?>
								<li>
									<?php __('ws_listing_length');?>  <strong><?php echo pjSanitize::html($tpl['arr']['listing_length']);?> <?php echo $enum_arr[$tpl['option_arr']['o_length']];?></strong>
								</li>
								<?php
							}
							if(!empty($tpl['arr']['listing_loa']))
							{
								?>
								<li>
									<?php __('ws_listing_loa');?> <strong><?php echo pjSanitize::html($tpl['arr']['listing_loa']);?></strong>
								</li>
								<?php
							}
							if(!empty($tpl['arr']['listing_beam']))
							{
								?>
								<li>
									<?php __('ws_listing_beam');?> <strong><?php echo pjSanitize::html($tpl['arr']['listing_beam']);?> <?php echo $enum_arr[$tpl['option_arr']['o_length']];?></strong>
								</li>
								<?php
							}
							if(!empty($tpl['arr']['listing_power']))
							{
								?>
								<li>
									<?php __('ws_listing_power');?> <strong><?php echo pjSanitize::html($tpl['arr']['listing_power']);?> <?php echo $enum_arr[$tpl['option_arr']['o_power']];?></strong>
								</li>
								<?php
							}
							if(!empty($tpl['arr']['listing_engine_model']))
							{
								?>
								<li>
									<?php __('ws_engine_model');?> 
									<strong><?php echo pjSanitize::html($tpl['arr']['listing_engine_model']);?></strong>
								</li>
								<?php
							}
							if(!empty($tpl['arr']['listing_engine_hours']))
							{
								?>
								<li>
									<?php __('ws_engine_hours');?>
									<strong><?php echo pjSanitize::html($tpl['arr']['listing_engine_hours']);?> <?php __('front_hours');?></strong>
								</li>
								<?php
							}
							if(!empty($tpl['arr']['listing_cruising_speed']))
							{
								?>
								<li>
									<?php __('ws_cruising_speed');?> 
									<strong><?php echo pjSanitize::html($tpl['arr']['listing_cruising_speed']);?> <?php echo $enum_arr[$opt_speed];?></strong>
								</li>
								<?php
							}
							if(!empty($tpl['arr']['listing_max_speed']))
							{
								?>
								<li>
									<?php __('ws_max_speed');?> 
									<strong><?php echo pjSanitize::html($tpl['arr']['listing_max_speed']);?> <?php echo $enum_arr[$opt_speed];?></strong>
								</li>
								<?php
							}
							if(!empty($tpl['arr']['listing_fuel_tank']))
							{
								?>
								<li>
									<?php __('ws_fuel_tank');?> 
									<strong><?php echo pjSanitize::html($tpl['arr']['listing_fuel_tank']);?> <?php echo $enum_arr[$tpl['option_arr']['o_fuel']];?></strong>
								</li>
								<?php
							}
							?>
						</ul>
					</div><!-- /.yacht-details-info -->
				</div>
			</div><!-- /.row -->
	
			<div class="row">
				<?php
				if(!empty($tpl['listing_extra_arr']))
				{ 
					?>
					<div class="col-sm-6">
						<div class="entry">
							<h3><?php __('ws_feature_set');?></h3>
		
							<p><?php echo join(', ', $tpl['listing_extra_arr']);?></p>
						</div><!-- /.entry -->
					</div><!-- /.col-sm-6 -->
					<?php
				} 
				?>
	
				<div class="col-sm-6">
					<div class="entry">
						<h3><?php __('ws_yacht_description');?></h3>
	
						<p><?php echo stripslashes($tpl['arr']['description']);?></p>
					</div><!-- /.entry -->
				</div><!-- /.col-sm-6 -->
			</div><!-- /.row -->
	
			<?php
			if(isset($tpl['price_arr']))
			{ 
				$selected_week = isset($_SESSION[$controller->defaultStore]['week']) ? $_SESSION[$controller->defaultStore]['week'] : null;
				if($selected_week != null)
				{
					$week_arr = pjUtil::getWeeksOfMonth(date('Y', $selected_week), date('n', $selected_week), $tpl['option_arr']['o_week_start']);
				}else{
					$week_arr = pjUtil::getWeeksOfMonth(date('Y'), date('n'), $tpl['option_arr']['o_week_start']);
				}
				$months = __('months', true);
				?>
				<div class="entry">
					<h3><?php __('ws_yacht_reservation');?></h3>
					<?php 
					if ($tpl['option_arr']['o_website_seo'] == 'Yes')
					{
						?>
						<form id="frmYlBooking" action="<?php echo PJ_INSTALL_URL . 'reservation.html'; ?>" name="frmYlBooking" method="get">
							<input type="hidden" value="<?php echo $tpl['arr']['id'];?>" name="id">
							<input type="hidden" value="" name="week">
						</form>
						<?php
					} else {
						?>
						<form id="frmYlBooking" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" name="frmYlBooking" method="get">
							<input type="hidden" value="pjWebsite" name="controller">
							<input type="hidden" value="pjActionReserve" name="action">
							<input type="hidden" value="<?php echo $tpl['arr']['id'];?>" name="id">
							<input type="hidden" value="" name="week">
						</form>
						<?php
					}
					?>
					<div id="pjYlReservationTable" class="entry-table">
						<div class="entry-table-head">
							<div class="pull-right text-right">
								<h5>
									<?php
									if($selected_week != null)
									{
										echo $months[date('n', $selected_week)] . ' ' . date('Y', $selected_week);
									}else{
										echo $months[date('n')] . ' ' . date('Y');
									}
									?>
								</h5>
							</div><!-- /.pull-right -->
							
							<div class="pull-left">
								<a href="#" class="btn btn-primary ylNavMonth" data-id="<?php echo $tpl['arr']['id']?>" data-month="<?php echo $week_arr['prev'] ?>"><span class="glyphicon glyphicon-menu-left"></span> <?php __('ws_prev');?></a>
								<a href="#" class="btn btn-primary ylNavMonth" data-id="<?php echo $tpl['arr']['id']?>" data-month="<?php echo $week_arr['next'] ?>"><?php __('ws_next');?> <span class="glyphicon glyphicon-menu-right"></span></a>
							</div><!-- /.pull-left -->
						</div><!-- /.entry-table-head -->
		
						<div class="entry-table-body">
							<table width="100%" border="0" cellspacing="0" cellpadding="0">
								<?php
								foreach($week_arr as $k => $v)
								{
									if($k == 'next' || $k == 'prev')
									{
										continue;
									}
									$iso_date = date('Y-m-d', $v['monday']);
									$is_reserved = false;
									$is_avaialble = false;
									if(in_array($iso_date, $tpl['booking_arr']))
									{
										$is_reserved = true;
									}else{
										if(isset($tpl['price_arr'][$iso_date]))
										{
											if($iso_date >= date('Y-m-d'))
											{
												$is_avaialble = true;
											}
										}
									}
									?>
									<tr class="<?php echo $is_reserved == true ? 'ylReserved' : ($is_avaialble == true ? 'ylAvailable' : 'ylUnavailable');?>">
										<td><?php __('ws_week')?> <?php echo $k;?></td>
										<td><?php echo date($tpl['option_arr']['o_date_format'], $v['monday'])?> - <?php echo date($tpl['option_arr']['o_date_format'], $v['sunday'])?></td>
										
										<td>
											<strong><?php echo $is_avaialble == true ? pjUtil::formatCurrencySign($tpl['price_arr'][$iso_date], $tpl['option_arr']['o_currency'])  : '&nbsp;'?></strong>
										</td>
										<td>
											<?php
											if($is_reserved == false)
											{ 
												if($is_avaialble == true)
												{
													?>
													<strong class="free"><?php __('ws_free');?></strong>
													<?php
												}else{
													?><strong class="not-available"><?php __('ws_not_avaialble');?></strong><?php
												}
											}else{
												?><strong class="reserved"><?php __('ws_reserved');?></strong><?php
											} 
											?>
										</td>
										<td>
											<?php
											if($is_reserved == false)
											{ 
												if($is_avaialble == true)
												{
													if ($tpl['option_arr']['o_website_seo'] == 'Yes')
													{
														$r_url = sprintf("%sreservation.html?id=%u", PJ_INSTALL_URL, $tpl['arr']['id']);
													} else {
														$r_url = sprintf("%s?controller=pjListings&amp;action=pjActionReserve&amp;id=%u", $_SERVER['PHP_SELF'], $tpl['arr']['id']);
													}
													?>
													<a href="<?php echo $r_url; ?>" data-week="<?php echo $v['monday'];?>" class="btn btn-primary btn-sm ylBtnReserve"><?php __('ws_make_a_reservation');?></a>
													<?php
												}else{
													?>&nbsp;<?php
												}
											}else{
												?>&nbsp;<?php
											} 
											?>
										</td>
									</tr>
			
									<?php
								} 
								?>
							</table>
						</div><!-- /.entry-table-body -->
					</div><!-- /.table -->
				</div><!-- /.entry -->
				<?php
			} 
			
			ob_start();
			$owner_name = !empty($tpl['arr']['owner_name']) ? $tpl['arr']['owner_name'] : (!empty($tpl['arr']['name']) ? $tpl['arr']['name'] : null);
			if(!empty($owner_name))
			{ 
				?>
				<li class="col-sm-3"><?php __('ws_name');?> <strong><?php echo pjSanitize::html($owner_name);?></strong></li>
				<?php
			}
			$owner_email = !empty($tpl['arr']['owner_email']) ? $tpl['arr']['owner_email'] : (!empty($tpl['arr']['email']) ? $tpl['arr']['email'] : null);
			if(!empty($owner_email))
			{
				?><li class="col-sm-3"><?php __('ws_email');?> <?php echo !preg_match('/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i', $owner_email) ? $owner_email : '<a href="mailto:'.$owner_email.'">'.$owner_email.'</a>'; ?></li><?php 
			}
			$owner_phone = !empty($tpl['arr']['owner_phone']) ? $tpl['arr']['owner_phone'] : (!empty($tpl['arr']['phone']) ? $tpl['arr']['phone'] : null);
			if(!empty($owner_phone))
			{
				?>
				<li class="col-sm-3"><?php __('ws_phone');?> <strong><?php echo pjSanitize::html($owner_phone);?></strong></li>
				<?php
			}
			$owner_fax = !empty($tpl['arr']['owner_fax']) ? $tpl['arr']['owner_fax'] : (!empty($tpl['arr']['fax']) ? $tpl['arr']['fax'] : null);
			if(!empty($owner_fax))
			{ 
				?>
				<li class="col-sm-3"><?php __('ws_fax');?> <strong><?php echo pjSanitize::html($owner_fax);?></strong></li>
				<?php
			}
			$ob_contact = ob_get_contents();
			ob_end_clean();
			
			if($tpl['arr']['owner_show'] == 'T' && !empty($ob_contact))
			{
				?>
				<div class="entry">
					<h3><?php __('ws_contact_details');?></h3>
	
					<ul class="entry-details row">
						<?php echo $ob_contact;?>
					</ul><!-- /.entry-details -->
				</div><!-- /.entry -->
				<?php
			}
		}else{
			$listing_statuses = __('listing_statuses', true);
			echo $listing_statuses[$tpl['status']];
		} 
		?>
	</div><!-- /.container -->
</div><!-- /.yacht-details -->
<?php
if(!empty($tpl['sale_feature_arr']))
{ 
	?>
	<div class="section">
		<div class="container">
			<h2><?php __('ws_featured_yachts_for_sale');?></h2>
	
			<div class="yachts">
				<div class="row">
					<?php
					foreach($tpl['sale_feature_arr'] as $v)
					{ 
						$image = NULL;
						if(!empty($v['image']))
						{
							if(is_file(PJ_INSTALL_PATH . $v['medium_image']))
							{
								$image = PJ_INSTALL_URL . $v['medium_image'];
							}
						}
						$price = pjUtil::formatCurrencySign(number_format($v['listing_price'], 0, '.', ','), $tpl['option_arr']['o_currency']);
						
						$listing_title = pjSanitize::html(stripslashes($v['title']));
						if ($tpl['option_arr']['o_website_seo'] == 'No')
						{
							$url = $_SERVER['SCRIPT_NAME'] . '?controller=pjWebsite&amp;action=pjActionView&amp;id=' . $v['id'] .(isset($_GET['iframe']) ? '&amp;iframe' : NULL);
						} else {
							$path = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
							$path = $path == '/' ? '' : $path;
							$url = $path .'/'. $controller->friendlyURL($v['title']) . "-". $v['id'] . ".html";
						}
						?>
						<div class="col-sm-4">
							<a href="<?php echo $url;?>" class="yacht">
								<div class="yacht-head">
									<div class="yacht-title"><?php echo $listing_title;?></div><!-- /.yacht-title -->
		
									<div class="yacht-price"><?php echo $price;?></div><!-- /.yacht-price -->
								</div><!-- /.yacht-head -->
		
								<div class="yacht-body">
									<img src="<?php echo $image;?>" alt="">
		
									<div class="yacht-body-overlay">
										<ul>
											<?php
											if(!empty($v['listing_year']))
											{ 
												?><li><span><?php __('ws_listing_year');?>:</span> <?php echo $v['listing_year'];?></li><?php
											}
											if(!empty($v['listing_loa']))
											{
												?><li><span><?php __('ws_listing_loa');?>:</span> <?php echo $v['listing_loa'];?></li><?php
											}
											if(!empty($v['listing_beam']))
											{
												?><li><span><?php __('ws_listing_beam');?>:</span> <?php echo $v['listing_beam'];?></li><?php
											}
											if(!empty($v['listing_length']))
											{
												?><li><span><?php __('ws_listing_length');?>:</span> <?php echo pjSanitize::html($v['listing_length']);?> <?php echo $enum_arr[$tpl['option_arr']['o_length']];?></li><?php
											}
											if(!empty($v['listing_power']))
											{
												?><li><span><?php __('ws_listing_power');?>:</span> <?php echo pjSanitize::html($v['listing_power']);?> <?php echo $enum_arr[$tpl['option_arr']['o_power']];?></li><?php
											} 
											?>
										</ul>
									</div><!-- /.yacht-body-overlay -->
								</div><!-- /.yacht-body -->
							</a><!-- /.yacht -->
						</div><!-- /.col-sm-4 -->
						<?php
					} 
					?>
				</div><!-- /.row -->
			</div><!-- /.yachts -->
		</div><!-- /.container -->
	</div><!-- /.section -->
	<?php
}
if(!empty($tpl['rent_feature_arr']))
{ 
	?>
	<div class="section">
		<div class="container">
			<h2><?php __('ws_featured_yachts_for_rent');?></h2>
	
			<div class="yachts">
				<div class="row">
					<?php
					foreach($tpl['rent_feature_arr'] as $v)
					{ 
						$image = NULL;
						if(!empty($v['image']))
						{
							if(is_file(PJ_INSTALL_PATH . $v['medium_image']))
							{
								$image = PJ_INSTALL_URL . $v['medium_image'];
							}
						}
						$price = '';
						if($v['min_price'] != '' || $v['max_price'] != '')
						{
							if($v['min_price'] == $v['max_price'])
							{
								$price = pjUtil::formatCurrencySign(number_format($v['min_price'], 0, '.', ','), $tpl['option_arr']['o_currency']) . ' ' . __('front_per_week', true);
							}else{
								$price = pjUtil::formatCurrencySign(number_format($v['min_price'], 0, '.', ','), $tpl['option_arr']['o_currency']) . ' - ' . $price = pjUtil::formatCurrencySign(number_format($v['max_price'], 0, '.', ','), $tpl['option_arr']['o_currency']) . ' ' . __('front_per_week', true);
							}
						}
						$listing_title = pjSanitize::html(stripslashes($v['title']));
						if ($tpl['option_arr']['o_website_seo'] == 'No')
						{
							$url = $_SERVER['SCRIPT_NAME'] . '?controller=pjWebsite&amp;action=pjActionView&amp;id=' . $v['id'] .(isset($_GET['iframe']) ? '&amp;iframe' : NULL);
						} else {
							$path = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
							$path = $path == '/' ? '' : $path;
							$url = $path .'/'. $controller->friendlyURL($v['title']) . "-". $v['id'] . ".html";
						}
						?>
						<div class="col-sm-4">
							<a href="<?php echo $url;?>" class="yacht">
								<div class="yacht-head">
									<div class="yacht-title"><?php echo $listing_title;?></div><!-- /.yacht-title -->
		
									<div class="yacht-price"><?php echo $price;?></div><!-- /.yacht-price -->
								</div><!-- /.yacht-head -->
		
								<div class="yacht-body">
									<img src="<?php echo $image;?>" alt="">
		
									<div class="yacht-body-overlay">
										<ul>
											<?php
											if(!empty($v['listing_year']))
											{ 
												?><li><span><?php __('ws_listing_year');?>:</span> <?php echo $v['listing_year'];?></li><?php
											}
											if(!empty($v['listing_loa']))
											{
												?><li><span><?php __('ws_listing_loa');?>:</span> <?php echo $v['listing_loa'];?></li><?php
											}
											if(!empty($v['listing_beam']))
											{
												?><li><span><?php __('ws_listing_beam');?>:</span> <?php echo $v['listing_beam'];?></li><?php
											}
											if(!empty($v['listing_length']))
											{
												?><li><span><?php __('ws_listing_length');?>:</span> <?php echo pjSanitize::html($v['listing_length']);?> <?php echo $enum_arr[$tpl['option_arr']['o_length']];?></li><?php
											}
											if(!empty($v['listing_power']))
											{
												?><li><span><?php __('ws_listing_power');?>:</span> <?php echo pjSanitize::html($v['listing_power']);?> <?php echo $enum_arr[$tpl['option_arr']['o_power']];?></li><?php
											} 
											?>
										</ul>
									</div><!-- /.yacht-body-overlay -->
								</div><!-- /.yacht-body -->
							</a><!-- /.yacht -->
						</div><!-- /.col-sm-4 -->
						<?php
					} 
					?>
				</div><!-- /.row -->
			</div><!-- /.yachts -->
		</div><!-- /.container -->
	</div><!-- /.section -->
	<?php
} 
?>