<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjListingModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'listings';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'owner_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'country_id', 'type' => 'int', 'default' => ':NULL'),
		
		array('name' => 'listing_refid', 'type' => 'varchar', 'default' => ':NULL'),
		
		array('name' => 'lat', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'lng', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'address_map', 'type' => 'tinyint', 'default' => '0'),
		array('name' => 'address_postcode', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'address_content', 'type' => 'text', 'default' => ':NULL'),
		array('name' => 'address_city', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'address_state', 'type' => 'varchar', 'default' => ':NULL'),
		
		array('name' => 'phone', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'fax', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'url', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'email', 'type' => 'varchar', 'default' => ':NULL'),
		
		array('name' => 'views', 'type' => 'int', 'default' => ':NULL'),
		
		array('name' => 'created', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'modified', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'expire', 'type' => 'date', 'default' => ':NULL'),
		
		array('name' => 'last_extend', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'owner_show', 'type' => 'enum', 'default' => 'T'),
		
		array('name' => 'status', 'type' => 'enum', 'default' => ':NULL')
	);
	
	public $i18n = array('title', 'description', 'meta_title', 'meta_keywords', 'meta_description');
	
	public static function factory($attr=array())
	{
		return new pjListingModel($attr);
	}
}
?>