<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{
	public $defaultCaptcha = 'StivaSoftCaptcha';
	
	public $defaultCandidate = 'front_candidate';
	
	public $defaultError = 'pjJobListing_Error';
	
	public $defaultMessage = 'pjJobListing_Message';
	
	public $defaultTheme = 'front_theme_id';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
	}

	public function afterFilter()
	{
		$theme = $this->option_arr['o_theme'];
		if(isset($_SESSION[$this->defaultTheme]))
		{
			$theme = $_SESSION[$this->defaultTheme];
		}
		$this->appendCss('pj.bootstrap.min.css', PJ_FRAMEWORK_LIBS_PATH . 'pj/css/');
		$this->appendCss('font-awesome.min.css', PJ_TEMPLATE_PATH . PJ_TEMPLATE_SCRIPT_PATH . 'css/');
		$this->appendCss('style.css', PJ_TEMPLATE_PATH . PJ_TEMPLATE_SCRIPT_PATH . 'css/');
		$this->appendCss($theme . '.css', PJ_TEMPLATE_PATH . PJ_TEMPLATE_SCRIPT_PATH . 'css/');
	}
	
	public function beforeFilter()
	{
		$locale_arr = pjLocaleModel::factory()
			->select('t1.*, t2.file, t2.title')
			->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left outer')
			->where('t2.file IS NOT NULL')
			->orderBy('t1.sort ASC')
			->findAll()
			->getDataPair('id');
		
		$this->set('locale_arr', $locale_arr);
		
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		if(isset($_GET['theme']))
		{
			$theme = $OptionModel->escapeStr($_GET['theme']);
			if(!empty($theme))
			{
				$_SESSION[$this->defaultTheme] = $theme;
			}
		}
		$this->loadSetFields();
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$type = null;
		if(isset($_GET['pjType']))
		{
			$type = $_GET['pjType'];
		}
		$Captcha = new pjCaptcha(PJ_WEB_PATH . 'obj/Anorexia.ttf', $this->defaultCaptcha . $type, 6);
		$Captcha->setImage(PJ_IMG_PATH . 'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		$type = null;
		if(isset($_GET['pjType']))
		{
			$type = $_GET['pjType'];
		}
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha . $type]){
			echo 'false';
		}else{
			echo 'true';
		}
	}
	
	public function pjActionSetLocale()
	{
		if((int) $_GET['locale'] > 0)
		{
			$this->setLocaleId(@$_GET['locale']);
			$this->loadSetFields(true);
		}
		if(isset($_SERVER['HTTP_REFERER']))
		{
			pjUtil::redirect($_SERVER['HTTP_REFERER']);
		}
	}
	
	public function checkLogin()
	{
		if (isset($_SESSION[$this->defaultCandidate]) && count($_SESSION[$this->defaultCandidate]) > 0)
        {
            return true;
	    }
	    return false;
	}
}
?>