<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	?>
	<div class="dashboard">
		<div class="dashboard_header">
			<div class="left"></div>
			<div class="middle">
				<div class="jobs"><div class="header-content"><span><?php echo intval($tpl['cnt_jobs']); ?></span><label><?php echo intval($tpl['cnt_jobs']) != 1 ? __('lblJobs', true) : __('lblJob', true); ?></label></div></div>
				<?php
				if($controller->isEmployer())
				{
					?><div class="views"><div class="header-content"><span><?php echo intval($tpl['cnt_views']); ?></span><label><?php echo intval($tpl['cnt_views']) != 1 ? __('lblViews', true) : __('lblView', true); ?></label></div></div><?php
				} else{
					?><div class="employers"><div class="header-content"><span><?php echo intval($tpl['cnt_employers']); ?></span><label><?php echo intval($tpl['cnt_employers']) != 1 ? __('lblEmployers', true) : __('lblEmployer', true); ?></label></div></div><?php
				}
				?>
				<div class="applications"><div class="header-content"><span><?php echo intval($tpl['cnt_applications']); ?></span><label><?php echo intval($tpl['cnt_applications']) != 1 ? __('lblApplications', true) : __('lblApplication', true); ?></label></div></div>
			</div>
			<div class="right"></div>
		</div>
		<div class="dashboard_box job_box">
			<div class="header">
				<div class="left"></div>
				<div class="middle"><span><?php __('lblLatestJobs');?></span></div>
				<div class="right"></div>
			</div>
			<div class="content">
				<div class="dashboard_list">
					<?php
					if(!empty($tpl['job_arr']))
					{
						$row_count = count($tpl['job_arr']);
						foreach($tpl['job_arr'] as $k => $v)
						{
							?>
							<div class="dashboard_row job_row <?php echo $k + 1 == $row_count ? 'dashboard_last_row' : null; ?>">
								<div class="job_title">
									<a class="block" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminJobs&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>"><?php echo pjSanitize::html(stripslashes($v['job_title']));?></a>
								</div>
								<div class="job_applications">
									<abbr><?php echo $v['cnt_applications'];?></abbr><label><?php echo $v['cnt_applications'] != 1 ? strtolower(__('lblApplications', true)) : strtolower(__('lblApplication', true)); ?></label>
								</div>
							</div>
							<?php
						}
					} else {
						?>
						<div class="dashboard_row"><div class="job_title"><?php __('lblNoJobFound');?></div></div>
						<?php
					}
					?>
				</div>
			</div>
			<div class="footer">
				<div class="left"></div>
				<div class="middle"></div>
				<div class="right"></div>
			</div>
		</div>
		<?php
		if($controller->isAdmin())
		{ 
			?>
			<div class="dashboard_box employer_box">
				<div class="header">
					<div class="left"></div>
					<div class="middle"><span><?php __('lblLatestEmployers');?></span></div>
					<div class="right"></div>
				</div>
				<div class="content">
					<div class="dashboard_list">
						<?php
						if(!empty($tpl['employer_arr']))
						{
							$row_count = count($tpl['employer_arr']);
							foreach($tpl['employer_arr'] as $k => $v)
							{
								$logo_url = PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/no-logo.png';
								if(!empty($v['thumb']))
								{
									if(file_exists(PJ_INSTALL_PATH . $v['thumb'])){
										$logo_url = PJ_INSTALL_URL . $v['thumb'];
									}
								}
								?>
								<div class="dashboard_row employer_row <?php echo $k + 1 == $row_count ? 'dashboard_last_row' : null; ?>">
									<div class="employer_detail">
										<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEmployers&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>"><img src="<?php echo $logo_url; ?>"/></a>
										<a class="block" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEmployers&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>"><?php echo pjSanitize::html(stripslashes($v['company_name']));?></a>
									</div>
									<div class="employer_jobs">
										<abbr><?php echo $v['cnt_jobs'];?></abbr><label><?php echo $v['cnt_jobs'] != 1 ? strtolower(__('lblJobs', true)) : strtolower(__('lblJob', true)); ?></label>
									</div>
								</div>
								<?php
							}
						} else {
							?>
							<div class="dashboard_row"><div class="job_title"><?php __('lblNoEmployerFound');?></div></div>
							<?php
						}
						?>
					</div>
				</div>
				<div class="footer">
					<div class="left"></div>
					<div class="middle"></div>
					<div class="right"></div>
				</div>
			</div>
			<?php
		}else{
			?>
			<div class="dashboard_box job_box">
				<div class="header">
					<div class="left"></div>
					<div class="middle"><span><?php __('lblMostPopularJobs');?></span></div>
					<div class="right"></div>
				</div>
				<div class="content">
					<div class="dashboard_list">
						<?php
						if(!empty($tpl['popular_arr']))
						{
							$row_count = count($tpl['popular_arr']);
							foreach($tpl['popular_arr'] as $k => $v)
							{
								?>
								<div class="dashboard_row job_row <?php echo $k + 1 == $row_count ? 'dashboard_last_row' : null; ?>">
									<div class="job_title">
										<a class="block" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminJobs&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>"><?php echo pjSanitize::html(stripslashes($v['job_title']));?></a>
									</div>
									<div class="job_applications">
										<abbr><?php echo $v['views'];?></abbr><label><?php echo $v['views'] != 1 ? strtolower(__('lblViews', true)) : strtolower(__('lblView', true)); ?></label>
									</div>
								</div>
								<?php
							}
						} else {
							?>
							<div class="dashboard_row"><div class="job_title"><?php __('lblNoJobFound');?></div></div>
							<?php
						}
						?>
					</div>
				</div>
				<div class="footer">
					<div class="left"></div>
					<div class="middle"></div>
					<div class="right"></div>
				</div>
			</div>
			<?php
		} 
		?>
		<div class="dashboard_box application_box">
			<div class="header">
				<div class="left"></div>
				<div class="middle"><span><?php __('lblLatestApplications');?></span></div>
				<div class="right"></div>
			</div>
			<div class="content">
				<div class="dashboard_list">
					<?php
					if(!empty($tpl['application_arr']))
					{
						$row_count = count($tpl['application_arr']);
						foreach($tpl['application_arr'] as $k => $v)
						{
							?>
							<div class="dashboard_row application_row <?php echo $k + 1 == $row_count ? 'dashboard_last_row' : null; ?>">
								<label><?php echo $v['fname'] . ' ' . $v['lname'];?></label>
								<a class="block" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminApplications&amp;action=pjActionView&id=<?php echo $v['id'];?>"><?php echo pjSanitize::html(stripslashes($v['email']));?></a>
							</div>
							<?php
						}
					} else {
						?>
						<div class="dashboard_row"><div class="topic_title"><?php __('lblNoApplicationFound');?></div></div>
						<?php
					}
					?>
				</div>
			</div>
			<div class="footer">
				<div class="left"></div>
				<div class="middle"></div>
				<div class="right"></div>
			</div>
		</div>
	</div>
	<?php
	$dayname_arr = __('days', true);
	?>
	<div class="clear_left t20 overflow">
		<div class="float_left black t30"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
			<div class="dashboard_date">
				<abbr><?php echo $dayname_arr[date("N")]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']) ; ?>
			</div>
			<div class="dashboard_hour"><?php echo pjUtil::formatTime(date('H:i:s'), 'H:i:s', $tpl['option_arr']['o_time_format']) ; ?></div>
		</div>
	</div>
	<?php
}
?>