<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$cv_path = '';
	$cv_url = '';
	$cv_name = '';
	$cv_id = '';
	$cv_hash = '';
	if(!empty($tpl['arr']['filename1']))
	{
		$cv_path = PJ_INSTALL_PATH . $tpl['arr']['filepath1'];
		$cv_url = PJ_INSTALL_URL . $tpl['arr']['filepath1'];
		$cv_name = $tpl['arr']['filename1'];
		$cv_id = $tpl['arr']['fileid1'];
		$cv_hash = $tpl['arr']['hash1'];
	}elseif(!empty($tpl['arr']['filename2'])){
		$cv_path = PJ_INSTALL_PATH . $tpl['arr']['filepath2'];
		$cv_url = PJ_INSTALL_URL . $tpl['arr']['filepath2'];
		$cv_name = $tpl['arr']['filename2'];
		$cv_id = $tpl['arr']['fileid2'];
		$cv_hash = $tpl['arr']['hash2'];
	}
		
	pjUtil::printNotice(__('infoViewApplicationTitle', true), __('infoViewApplicationDesc', true));
	?>
	<div class="form pj-form">
		<p>
			<label class="title"><?php __('lblAppliedJob'); ?></label>
			<span class="inline_block t4">
				<a class="no-decor" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminJobs&amp;action=pjActionUpdate&id=<?php echo $tpl['arr']['job_id'];?>">
					<?php echo stripslashes($tpl['arr']['job_title'] . ' / ' . $tpl['arr']['job_refid']); ?>
				</a>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblEmployer'); ?></label>
			<span class="inline_block t4">
				<a class="no-decor" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEmployers&amp;action=pjActionUpdate&id=<?php echo $tpl['arr']['employer_id'];?>">
					<?php echo stripslashes($tpl['arr']['company_name']); ?>
				</a>
			</span>
		</p>
		<p>
			<label class="title"><?php __('email'); ?></label>
			<span class="inline_block t4">
				<?php echo !preg_match('/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i', $tpl['arr']['email']) ? $tpl['arr']['email'] : '<a class="no-decor" href="maito:'.$tpl['arr']['email'].'">'.$tpl['arr']['email'].'</a>'; ?>
			</span>
		</p>
		<?php 
		$name_arr = array();
		if(!empty($tpl['arr']['fname']))
		{
			$name_arr[] = pjSanitize::clean($tpl['arr']['fname']);
		}
		if(!empty($tpl['arr']['lname']))
		{
			$name_arr[] = pjSanitize::clean($tpl['arr']['lname']);
		}
		if(!empty($name_arr))
		{
			?>
			<p>
				<label class="title"><?php __('lblName'); ?></label>
				<span class="inline_block t4">
					<?php
					if(!$controller->isEmployer() && !empty($tpl['arr']['employee_id']))
					{
						?>
						<a class="no-decor" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEmployees&amp;action=pjActionUpdate&id=<?php echo $tpl['arr']['employee_id'];?>">
							<?php echo stripslashes(join(" ", $name_arr)); ?>
						</a>
						<?php
					}else{
						echo stripslashes(join(" ", $name_arr));
					} 
					?>
				</span>
			</p>
			<?php
		} 
		?>
		<p>
			<label class="title"><?php __('lblPhone'); ?></label>
			<span class="inline_block t4">
				<?php echo pjSanitize::clean($tpl['arr']['phone']); ?>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblLinkedin'); ?></label>
			<span class="inline_block t4">
				<a class="no-decor" href="<?php echo $tpl['arr']['linkedin'];?>" target="_blank">
					<?php echo pjSanitize::clean($tpl['arr']['linkedin']); ?>
				</a>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblNotes'); ?></label>
			<span class="block t4 overflow">
				<?php echo nl2br(stripslashes($tpl['arr']['notes'])); ?>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblCreated'); ?></label>
			<span class="inline_block t4">
				<?php echo pjToolkit::formatDate(date('Y-m-d', strtotime($tpl['arr']['created'])), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</span>
		</p>
		<?php
		if($cv_path != '')
		{ 
			?>
			<p>
				<label class="title"><?php __('lblCV'); ?></label>
				<span class="inline_block t4">
					<label class="block float_left r10"><?php echo $cv_name;?></label>
					<a target="_blank" class="icon download-file r10" href="<?php echo PJ_INSTALL_URL;?>index.php?controller=pjAdminEmployees&action=pjActionDownloadFile&id=<?php echo $cv_id; ?>&hash=<?php echo $cv_hash;?>"><?php echo strtolower(__('lnkDownload', true));?></a>
				</span>
			</p>
			<?php
		} 
		?>
		<p>
			<label class="title">&nbsp;</label>
			<input type="button" value="<?php __('lblBack'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminApplications&action=pjActionIndex';" />
		</p>
	</div>
	<?php
}
?>