<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	pjUtil::printNotice(__('infoAddEmployerTitle', true), __('infoAddEmployerDesc', true));
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEmployers&amp;action=pjActionCreate" method="post" id="frmCreateEmployer" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="employer_create" value="1" />
		<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
		<div class="multilang b10"></div>
		<?php endif;?>
		<div class="clear_both">
			
			<p>
				<label class="title"><?php __('lblCompanyName'); ?></label>
				<span class="inline_block">
					<input type="text" name="company_name" id="company_name" class="pj-form-field w300 required" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblContactName'); ?></label>
				<span class="inline_block">
					<input type="text" name="contact_name" id="contact_name" class="pj-form-field w300" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblWebsite'); ?></label>
				<span class="inline_block">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-url"></abbr></span>
				<input type="text" name="url" id="url" class="pj-form-field w300 url" placeholder="http://www.domain.com" value="" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblPhone'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
					<input type="text" name="phone" id="phone" class="pj-form-field w150" placeholder="(123) 456-7890" value="" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('email'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
					<input type="text" name="email" id="email" class="pj-form-field required email w200" placeholder="info@domain.com"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('pass'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-password"></abbr></span>
					<input type="text" name="password" id="password" class="pj-form-field required w200" />
				</span>
			</p>
			<?php
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblDescription'); ?></label>
					<textarea name="i18n[<?php echo $v['id']; ?>][description]" class="pj-form-field w500 h200<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>"></textarea>
					<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
					<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
					<?php endif;?>
				</p>
				<?php
			} 
			?>
			<p>
				<label class="title"><?php __('lblLogo'); ?></label>
				<span class="inline_block">
					<input type="file" name="company_logo" id="company_logo" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field required">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach (__('employer_statarr', true) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEmployers&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<script type="text/javascript">
		var myLabel = myLabel || {};
		myLabel.field_required = "<?php __('jl_field_required'); ?>";
		myLabel.email_invalid = "<?php __('jl_email_invalid'); ?>";
		myLabel.email_taken = "<?php __('jl_email_taken'); ?>";
		myLabel.file_allowed = "<?php __('jl_file_allowed'); ?>";
		
		(function ($) {
			$(function() {
				$(".multilang").multilang({
					langs: <?php echo $tpl['locale_str']; ?>,
					flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
					tooltip: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris sit amet faucibus enim."
				});
			});
		})(jQuery_1_8_2);
	</script>
	<?php
}
?>