<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	
	pjUtil::printNotice(__('infoUpdateEmployerTitle', true), __('infoUpdateEmployerDesc', true));
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEmployers&amp;action=pjActionUpdate" method="post" id="frmUpdateEmployer" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="employer_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
		<div class="multilang"></div>
		<?php endif;?>
		<div class="clear_both">
			<p>
				<label class="title"><?php __('lblRegisteredOn'); ?></label>
				<span class="inline_block">
					<label class="block float_left t5 r30"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['created'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['created'])), 'H:i:s', $tpl['option_arr']['o_time_format']);?></label>
					<label class="block float_left t5"><?php echo $tpl['arr']['ip_registered'];?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblLastLogin'); ?></label>
				<span class="inline_block">
					<label class="block float_left t5 r30"><?php echo !empty($tpl['arr']['last_login']) ? ( pjUtil::isValidDateTime($tpl['arr']['last_login']) ? pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : __('lblNotYet', true) ) : __('lblNotYet', true);?></label>
					<label class="block float_left t5"><?php echo $tpl['arr']['ip_last_login'];?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('menuJobs'); ?></label>
				<span class="inline_block">
					<label class="block float_left t5"><?php echo $tpl['arr']['cnt_jobs'] > 0 ? '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminJobs&amp;action=pjActionIndex&employer_id='.$tpl['arr']['id'].'">'.$tpl['arr']['cnt_jobs'].'</a>' : $tpl['arr']['cnt_jobs'];?> <?php echo mb_strtolower(__('lblTotal', true), 'UTF-8');?>,&nbsp;&nbsp;</label>
					<label class="block float_left t5"><?php echo $tpl['arr']['cnt_active_jobs'] > 0 ? '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminJobs&amp;action=pjActionIndex&employer_id='.$tpl['arr']['id'].'&status=T">'.$tpl['arr']['cnt_active_jobs'].'</a>' : $tpl['arr']['cnt_active_jobs'];?> <?php echo mb_strtolower(__('lblActive', true), 'UTF-8');?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblCompanyName'); ?></label>
				<span class="inline_block">
					<input type="text" name="company_name" id="company_name" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['company_name'])); ?>" class="pj-form-field w300 required" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblContactName'); ?></label>
				<span class="inline_block">
					<input type="text" name="contact_name" id="contact_name" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['contact_name'])); ?>" class="pj-form-field w300" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblWebsite'); ?></label>
				<span class="inline_block">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-url"></abbr></span>
				<input type="text" name="url" id="url" class="pj-form-field w300 url" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['url'])); ?>" placeholder="http://www.domain.com" value="" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblPhone'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
					<input type="text" name="phone" id="phone" class="pj-form-field w150" placeholder="(123) 456-7890" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['phone'])); ?>" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('email'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
					<input type="text" name="email" id="email" class="pj-form-field required email w200" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['email'])); ?>" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('pass'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-password"></abbr></span>
					<input type="text" name="password" id="password" class="pj-form-field required w200" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['password'])); ?>" />
				</span>
			</p>
			<?php
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblDescription'); ?></label>
					<textarea name="i18n[<?php echo $v['id']; ?>][description]" class="pj-form-field w500 h200<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['description']); ?></textarea>
					<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
					<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
					<?php endif;?>
				</p>
				<?php
			} 
			?>
			<p>
				<label class="title"><?php __('lblLogo'); ?></label>
				<span class="inline_block">
					<input type="file" name="company_logo" id="company_logo" class="pj-form-field" />
				</span>
			</p>
			<?php
			
			if(!empty($tpl['arr']['thumb']))
			{
				$thumb_path = PJ_INSTALL_PATH . $tpl['arr']['thumb'];
				$thumb_url = PJ_INSTALL_URL . $tpl['arr']['thumb'];
				if(file_exists($thumb_path))
				{
					?>
					<p id="logo_container">
						<label class="title">&nbsp;</label>
						<span class="inline_block">
							<img class="company-logo" src="<?php echo $thumb_url; ?>" />
							<a href="javascript:void(0);" class="icon delete-logo" rev="<?php echo $tpl['arr']['id']?>"><?php echo strtolower(__('lnkDelete', true));?></a>
						</span>
					</p>
					<?php
				}
			}
			 
			?>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field required">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach (__('employer_statarr', true) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEmployers&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	<div id="dialogDeleteLogo" title="<?php __('lblDeleteLogoTitle'); ?>" style="display:none">
		<p><?php __('lblDeleteLogoBody'); ?></p>
	</div>
	<script type="text/javascript">
		var myLabel = myLabel || {};
		myLabel.field_required = "<?php __('jl_field_required'); ?>";
		myLabel.email_invalid = "<?php __('jl_email_invalid'); ?>";
		myLabel.email_taken = "<?php __('jl_email_taken'); ?>";
		myLabel.file_allowed = "<?php __('jl_file_allowed'); ?>";
		
		(function ($) {
			$(function() {
				$(".multilang").multilang({
					langs: <?php echo $tpl['locale_str']; ?>,
					flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
					tooltip: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris sit amet faucibus enim."
				});
			});
		})(jQuery_1_8_2);
	</script>
	<?php
}
?>