<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$yesno_arr = __('_yesno', true);
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	if($controller->isAdmin())
	{
		include_once PJ_VIEWS_PATH . 'pjAdminJobs/elements/menu.php';
	}
	pjUtil::printNotice(__('lblJobAddTitle', true), __('lblJobAddDesc', true));
	?>	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminJobs&amp;action=pjActionCreate" method="post" id="frmCreateJob" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="job_create" value="1" />
		<?php $locale = isset($_GET['locale']) && (int) $_GET['locale'] > 0 ? (int) $_GET['locale'] : $controller->getLocaleId(); ?>
		<input type="hidden" name="locale" value="<?php echo $locale; ?>" />
		
		<div class="clear_both">
			<p>
				<label class="title"><?php __('lblReferenceID'); ?></label>
				<span class="inline_block">
					<input type="text" name="job_refid" id="job_refid" value="<?php echo pjUtil::uuid(); ?>" class="pj-form-field w250 required" />
				</span>
			</p>
			<?php
			if (!$controller->isEmployer())
			{ 
				?>
				<p>
					<label class="title"><?php __('lblIsPublished'); ?></label>
					<span class="inline_block">
						<select name="status" id="status" class="pj-form-field w200 required">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach (__('publish_status', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
							}
							?>
						</select>
						<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblStatusTip'); ?>"></a>
					</span>
				</p>
				<p class="expiredWrapper" style="display: none;">
					<label class="title"><?php __('lblExpiredOn'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" name="expired" id="expired" class="pj-form-field pointer w80 required datepick" value="<?php echo date($tpl['option_arr']['o_date_format']); ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblExpireOnTip'); ?>"></a>
					</span>
				</p>
				<p class="expiredWrapper" style="display: none;">
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<input type="checkbox" id="expired_show" name="expired_show" checked="checked" value="T"/>
						<label for="expired_show"><?php __('lblShowOn');?></label>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblMakeFeatured'); ?></label>
					<span class="left">
						<?php
						foreach (__('_yesno', true) as $k => $v)
						{
							?>
							<label class="r5"><input type="radio" name="is_featured" value="<?php echo $k; ?>"<?php echo 'F' == $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
							<?php
						}
						?>
						<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php echo pjSanitize::clean(__('lblFeaturedTip', true)); ?>"></a>
						<?php 
						?>
					</span>
				</p>
				<?php 
			}	
			?>
			<p>
				<label class="title"><?php __('lblType'); ?></label>
				<span class="inline_block" id="boxType">
					<select name="type_id" id="type_id" class="pj-form-field w200 required">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['type_arr'] as $v)
						{
							?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p style="overflow: visible">
				<label class="title"><?php __('lblCategory'); ?></label>
				<span class="inline_block" id="boxCategory">
					<select name="category_id" id="category_id" class="pj-form-field w400 required">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['category_arr'] as $v)
						{
							?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminJobs&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.field_required = "<?php __('jl_field_required'); ?>";
	myLabel.same_refid = "<?php __('jl_same_refid'); ?>";
	</script>
	<?php
}
?>