<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$yesno_arr = __('_yesno', true);
	
	if($controller->isAdmin())
	{
		include_once PJ_VIEWS_PATH . 'pjAdminJobs/elements/menu.php';
	}
	pjUtil::printNotice(__('infoJobsListTitle', true), __('infoJobsListDesc', true));
	?>
	<div class="b10">
		<?php
		if($controller->isAdmin() || ($controller->isEmployer() && $tpl['option_arr']['o_is_adding_job_allowed'] == 'Yes'))
		{ 
			?>
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
				<input type="hidden" name="controller" value="pjAdminJobs" />
				<input type="hidden" name="action" value="pjActionCreate" />
				<input type="submit" class="pj-button" value="+ <?php __('lblAddJob'); ?>" />
			</form>
			<?php
		} 
		?>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>
		<?php
		$filter_published = __('filter_published', true);
		?>
		<div class="float_right t5">
			<a href="#" class="pj-button btn-all">All</a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="T"><?php echo $filter_published['T']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="F"><?php echo $filter_published['F']; ?></a>
		</div>
		<br class="clear_both" />
	</div>

	<div class="pj-form-filter-advanced" style="display: none">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			<div class="overflow">
				<p class="float_left w340">
					<label class="title"><?php __('lblReferenceID'); ?></label>
					<input type="text" name="refid" id="refid" class="pj-form-field w150" />
				</p>
				<?php
				if(!$controller->isEmployer())
				{ 
					?>
					<p class="w340" >
						<label class="title t5"><?php __('lblEmployer'); ?></label>
						<span class="inline_block">
							<select name="employer_id" id="employer_id" class="pj-form-field w152">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ($tpl['employer_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id']; ?>"<?php echo (isset($_GET['employer_id']) && (int) $_GET['employer_id']) ? ($_GET['employer_id'] == $v['id'] ? ' selected="selected"' : NULL) : NULL;?>><?php echo $v['company_name']; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<?php
				}else{
					?>
					<p class="w340" >
						<label class="title t5"><?php __('lblEmployer'); ?></label>
						<span class="inline_block">
							<label class="content t10"><?php echo $tpl['employer_arr']['company_name'];?></label>
						</span>
					</p>
					<?php
				} 
				?>
			</div>
			<div class="overflow">
				<p class="float_left w340">
					<label class="title"><?php __('lblKeyword'); ?></label>
					<input type="text" name="keyword" id="keyword" class="pj-form-field w150" />
				</p>
				<p class="w340">
					<label class="title t5"><?php __('lblType'); ?></label>
					<span class="inline_block">
						<select name="type_id" id="type_id" class="pj-form-field w162">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['type_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
			</div>
			<p style="overflow: visible">
				<label class="title"><?php __('lblCategory'); ?></label>
				<select name="category_id" id="category_id" class="pj-form-field w500">
					<option value="">-- <?php __('lblChoose'); ?> --</option>
					<?php
					foreach ($tpl['category_arr'] as $v)
					{
						?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
					}
					?>
				</select>
			</p>
			<p style="overflow: visible">
				<label class="title"><?php __('lblCountry'); ?></label>
				<select name="country_id" id="country_id" class="pj-form-field w500">
					<option value="">-- <?php __('lblChoose'); ?> --</option>
					<?php
					foreach ($tpl['country_arr'] as $v)
					{
						?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
					}
					?>
				</select>
			</p>
			<p class="float_left w340">
				<label class="title t5"><?php __('lblState'); ?></label>
				<input type="text" name="address_state" id="address_state" value="" class="pj-form-field w150" />
			</p>
			<p class="w340">
				<label class="title"><?php __('lblCity'); ?></label>
				<input type="text" name="address_city" id="address_city" value="" class="pj-form-field w150" />
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSearch'); ?>" class="pj-button" />
				<input type="reset" value="<?php __('btnCancel'); ?>" class="pj-button" />
			</p>
			
		</form>
	</div>

	<div id="grid"></div>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.jqDateFormat = "<?php echo pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.isEmployer = <?php echo $controller->isEmployer() ? 'true' : 'false'; ?>;
	pjGrid.queryString = "";
	<?php
	if (isset($_GET['employer_id']) && (int) $_GET['employer_id'] > 0 && !$controller->isEmployer())
	{
		?>pjGrid.queryString += "&employer_id=<?php echo (int) $_GET['employer_id']; ?>";<?php
	}
	?>
	<?php
	if (isset($_GET['status']) && in_array($_GET['status'] , array('T', 'F')))
	{
		?>pjGrid.queryString += "&status=<?php echo $_GET['status']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.refid = "<?php __('lblReferenceID'); ?>";
	myLabel.type = "<?php __('lblType'); ?>";
	myLabel.category = "<?php __('lblCategory'); ?>";
	myLabel.country = "<?php __('lblCountry'); ?>";
	myLabel.applications = "<?php __('menuApplications'); ?>";
	myLabel.revert_status = "<?php __('revert_status'); ?>";
	myLabel.exported = "<?php __('lblExport'); ?>";
	myLabel.yes = "<?php echo $yesno_arr['T']; ?>";
	myLabel.no = "<?php echo $yesno_arr['F']; ?>";
	myLabel.exp_date = "<?php __('jl_exp_date'); ?>";
	myLabel.extend_exp_date = "<?php __('btnExtendExpDate'); ?>";
	myLabel.delete_confirmation = "<?php __('lblDeleteConfirmation'); ?>";
	myLabel.delete_selected = "<?php __('lblDeleteSelected'); ?>";
	myLabel.is_published = "<?php __('lblIsPublished'); ?>";
	</script>
	<?php
}
?>