<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/optmenu.php';
	?>
	<form id="frmNotifications" action="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminOptions&amp;action=pjActionNotifications" method="post" class="pj-form form">
		<input type="hidden" name="notification_update" value="1" />
		<input type="hidden" name="next_action" value="pjActionNotifications" />
		<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
		<div class="multilang"></div>
		<?php endif;?>
		<div class="clear_both">
			<?php
			$notifications = __('notifications', true);
			$tokens = __('notify_tokens', true);
			$notify_titles = __('notify_titles', true);
			$notify_bodies = __('notify_bodies', true);
			foreach($tpl['arr'] as $notify)
			{
				pjUtil::printNotice(@$notify_titles[$notify['id']], @$notify_bodies[$notify['id']]);
				?>
				
				<fieldset class="fieldset white">
					<legend><?php echo $notifications[$notify['id']]; ?></legend>
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('opt_notify_subject'); ?>:</label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][subject<?php echo $notify['id'];?>]" class="pj-form-field w300" value="<?php echo htmlspecialchars(stripslashes(@$notify['i18n'][$v['id']]['subject'.$notify['id']])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
					<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						$message = $notify['i18n'][$v['id']]['message'.$notify['id']]; 
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title">
								<?php __('opt_notify_message'); ?>:
								<br/><br/>
								<?php echo $tokens[$notify['id']];?>
							</label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][message<?php echo $notify['id'];?>]" class="pj-form-field w500 h150 mceEditor"><?php echo htmlspecialchars(stripslashes($message)); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					?>	
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					</p>
				</fieldset>
				<?php
			} 
			?>	
		</div>
	</form>
	<script type="text/javascript">
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: <?php echo $tpl['locale_str']; ?>,
				flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
				tooltip: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris sit amet faucibus enim.",
				select: function (event, ui) {
					// Callback, e.g. ajax requests or whatever
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
}
?>