var jQuery_1_8_2 = $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateEmployee = $("#frmCreateEmployee"),
			$frmUpdateEmployee = $("#frmUpdateEmployee"),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		if ($frmCreateEmployee.length > 0 && validate) {
			$.validator.addMethod(
			    "fileAccept",
			    function(value, element) {
			    	if(value != '')
			    	{
			    		var ext = value.split('.').pop().toLowerCase();
				    	if($.inArray(ext, ['docx','pdf','doc']) == -1) {
				    	    return false;
				    	}else{
				    		return true;
				    	}
			    	}else{
			    		return true;
			    	}
			    }, myLabel.file_allowed
			);
			$frmCreateEmployee.validate({
				rules: {
					"email": {
						required: true,
						email: true,
						remote: "index.php?controller=pjAdminEmployees&action=pjActionCheckEmail"
					},
					"cv":{
						fileAccept: function(element){
							return $("#cv").val();
		            	}
					}
				},
				messages: {
					"email": {
						required: myLabel.field_required,
						email: myLabel.email_invalid,
						remote: myLabel.email_taken
					},
					"password": {
						required: myLabel.field_required
					},
					"fname": {
						required: myLabel.field_required
					},
					"lname": {
						required: myLabel.field_required
					},
					"status": {
						required: myLabel.field_required
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if ($frmUpdateEmployee.length > 0 && validate) {
			$.validator.addMethod(
			    "fileAccept",
			    function(value, element) {
			    	if(value != '')
			    	{
				    	var ext = value.split('.').pop().toLowerCase();
				    	if($.inArray(ext, ['docx','pdf','doc']) == -1) {
				    	    return false;
				    	}else{
				    		return true;
				    	}
			    	}else{
			    		return true;
			    	}
			    	
			    }, myLabel.file_allowed
			);
			$frmUpdateEmployee.validate({
				rules: {
					"email": {
						required: true,
						email: true,
						remote: "index.php?controller=pjAdminEmployees&action=pjActionCheckEmail&id=" + $frmUpdateEmployee.find("input[name='id']").val()
					},
					"cv":{
						fileAccept: function(element){
							return $("#cv").val();
		            	}
					}
				},
				messages: {
					"email": {
						required: myLabel.field_required,
						email: myLabel.email_invalid,
						remote: myLabel.email_taken
					},
					"password": {
						required: myLabel.field_required
					},
					"fname": {
						required: myLabel.field_required
					},
					"lname": {
						required: myLabel.field_required
					},
					"status": {
						required: myLabel.field_required
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
			
			$('.delete-file').on('click', function(e){
				e.preventDefault();
				var file_id = $(this).attr('rev');
				$("#dialogDeleteCV").dialog({
					autoOpen: false,
					resizable: false,
					draggable: false,
					height:150,
					modal: true,
					
					buttons: {
						'Delete': function() {
							$.ajax({
								type: "POST",
								data: {
									id: file_id
								},
								dataType: 'json',
								url: "index.php?controller=pjAdminEmployees&action=pjActionDeleteCV",
								success: function (res) {
									if(res.status == 1){
										$("#cv_container").remove();
									}
								}
							});
							$(this).dialog('close');			
						},
						'Cancel': function() {
							$(this).dialog('close');
						}
					}
				});
				$("#dialogDeleteCV").dialog('open');
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			function formatDefault (str, obj) {
				if (obj.role_id == 3) {
					return '<a href="#" class="pj-status-icon pj-status-' + (str == 'F' ? '0' : '1') + '" style="cursor: ' +  (str == 'F' ? 'pointer' : 'default') + '"></a>';
				} else {
					return '<a href="#" class="pj-status-icon pj-status-1" style="cursor: default"></a>';
				}
			}
			function onBeforeShowView()
			{
				return true;
			}
			if (pjGrid.isEmployer == 'true') {
				var $grid = $("#grid").datagrid({
					buttons: [{type: "view", url: "index.php?controller=pjAdminEmployees&action=pjActionView&id={:id}", title: 'View', beforeShow: onBeforeShowView}	
					          ],
					columns: [{text: myLabel.fname, type: "text", sortable: true, editable: false, width: 150},
					          {text: myLabel.lname, type: "text", sortable: true, editable: false, width: 150},
					          {text: myLabel.email, type: "text", sortable: true, editable: false, width: 200},
					          {text: myLabel.status, type: "select", sortable: true, editable: false, options: [
					                                                                                     {label: myLabel.active, value: "T"}, 
					                                                                                     {label: myLabel.inactive, value: "F"}
					                                                                                     ], applyClass: "pj-status"}],
					dataUrl: "index.php?controller=pjAdminEmployees&action=pjActionGetEmployee",
					dataType: "json",
					fields: ['fname', 'lname', 'email', 'status'],
					paginator: {
						actions: [
						   {text: myLabel.exported, url: "index.php?controller=pjAdminEmployees&action=pjActionExportEmployee", ajax: false}
						],
						gotoPage: true,
						paginate: true,
						total: true,
						rowCount: true
					},
					saveUrl: "index.php?controller=pjAdminEmployees&action=pjActionSaveEmployee&id={:id}",
					select: {
						field: "id",
						name: "record[]"
					}
				});
			}else{
				var $grid = $("#grid").datagrid({
					buttons: [{type: "edit", url: "index.php?controller=pjAdminEmployees&action=pjActionUpdate&id={:id}"},
					          {type: "delete", url: "index.php?controller=pjAdminEmployees&action=pjActionDeleteEmployee&id={:id}"}
					          ],
					columns: [{text: myLabel.fname, type: "text", sortable: true, editable: true, width: 150},
					          {text: myLabel.lname, type: "text", sortable: true, editable: true, width: 150},
					          {text: myLabel.email, type: "text", sortable: true, editable: true, width: 200},
					          {text: myLabel.status, type: "select", sortable: true, editable: true, options: [
					                                                                                     {label: myLabel.active, value: "T"}, 
					                                                                                     {label: myLabel.inactive, value: "F"}
					                                                                                     ], applyClass: "pj-status"}],
					dataUrl: "index.php?controller=pjAdminEmployees&action=pjActionGetEmployee",
					dataType: "json",
					fields: ['fname', 'lname', 'email', 'status'],
					paginator: {
						actions: [
						   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminEmployees&action=pjActionDeleteEmployeeBulk", render: true, confirmation: myLabel.delete_confirmation},
						   {text: myLabel.revert_status, url: "index.php?controller=pjAdminEmployees&action=pjActionStatusEmployee", render: true},
						   {text: myLabel.exported, url: "index.php?controller=pjAdminEmployees&action=pjActionExportEmployee", ajax: false}
						],
						gotoPage: true,
						paginate: true,
						total: true,
						rowCount: true
					},
					saveUrl: "index.php?controller=pjAdminEmployees&action=pjActionSaveEmployee&id={:id}",
					select: {
						field: "id",
						name: "record[]"
					}
				});
			}
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminEmployees&action=pjActionGetEmployee", "fname", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminEmployees&action=pjActionGetEmployee", "fname", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-status-1", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			return false;
		}).on("click", ".pj-status-0", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$.post("index.php?controller=pjAdminEmployees&action=pjActionSetActive", {
				id: $(this).closest("tr").data("object")['id']
			}).done(function (data) {
				$grid.datagrid("load", "index.php?controller=pjAdminEmployees&action=pjActionGetEmployee");
			});
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminEmployees&action=pjActionGetEmployee", "id", "ASC", content.page, content.rowCount);
			return false;
		});
	});
})(jQuery_1_8_2);