var JL = JL || {};
JL.Utils = {
	getExt: function(filename){
		var dot_pos = filename.lastIndexOf(".");
		
		if(dot_pos == -1){
			return "";
		}
		return filename.substr(dot_pos+1).toLowerCase();
	},
	validateExt: function(cv_name){
		
		var ext = this.getExt(cv_name);
		if(ext == "docx" || ext == "doc" || ext == "pdf")
		{
			return true;
		}
		return false;
	},
	
	checkEmail: function(email, frm, err_container, type, id)
	{
		var email_used = JL.Msg.email_used;
		var install_folder = document.getElementById('jl_install_folder').value;
		var str_type = '', str_id = '';
		if(type != null)
		{
			var str_type = '&type=' + type;
		}
		if(id != null)
		{
			var str_id = '&id=' + id;
		}
		JABB.Ajax.sendRequest(install_folder + 'index.php?controller=pjLoad&action=pjActionCheckEmail&email=' + email + str_id + str_type, function (resp) {
			var code = resp.responseText;
			if(code == 'true'){
				frm.submit();
			}else{
				var msg = '<li>' + email_used + '</li>';
				err_container.innerHTML = msg;
				err_container.style.display = "block";
			}
		});
	},
	
	validateEmployerRegister: function(frm)
	{
		var re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
			msg = '',
			email = document.forms[frm].email,
			password = document.forms[frm].password,
			cpassword = document.forms[frm].cpassword,
			company_name = document.forms[frm].company_name,
			captcha = document.forms[frm].captcha,
			install_folder = document.getElementById('jl_install_folder').value;
		
		var err_container = document.getElementById('jl_employer_error_container');
		if (email) {
			if (email.value == '') {
				msg += '<li>' + JL.Msg.email + '</li>';
			}
			if (email.value != '' && email.value.match(re) == null) {
				msg += '<li>' + JL.Msg.email_inv + '</li>';
			}
		}
		if (password) {
			if (password.value == '') {
				msg += '<li>' + JL.Msg.password + '</li>';
			}
		}
		if (cpassword) {
			if (cpassword.value == '') {
				msg += '<li>' + JL.Msg.cpassword + '</li>';
			}
		}
		if (password && cpassword) {
			if (password.value != '' && cpassword.value != '') {
				if(password.value != cpassword.value)
				msg += '<li>' + JL.Msg.password_match + '</li>';
			}
		}
		if (company_name) {
			if (company_name.value == '') {
				msg += '<li>' + JL.Msg.company_name + '</li>';
			}
		}
		if (captcha && captcha.value == '') {
			msg += '<li>' + JL.Msg.captcha + '</li>';
		}
		if (msg != '') {
			err_container.innerHTML = msg;
			err_container.style.display = "block";
		}else{
			if(captcha)
			{
				var captcha_inc = JL.Msg.captcha_inc;
				var $this = this;
				JABB.Ajax.sendRequest(install_folder + 'index.php?controller=pjFront&action=pjActionCheckCaptcha&verification=' + captcha.value + '&pjType=Employer', function (resp) {
					var code = resp.responseText;
					if(code == 100){
						if (email) {
							$this.checkEmail(email.value, document.forms[frm], err_container, 'Employer', null);
						}else{
							document.forms[frm].submit();
						}
					}else{
						msg = '<li>' + captcha_inc + '</li>';
						err_container.innerHTML = msg;
						err_container.style.display = "block";
					}
				});
			}else{
				document.forms[frm].submit();
			}
		}
	},
	validateCandidateRegister: function(frm)
	{
		var re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
			msg = '',
			email = document.forms[frm].email,
			password = document.forms[frm].password,
			cpassword = document.forms[frm].cpassword,
			fname = document.forms[frm].fname,
			lname = document.forms[frm].lname,
			captcha = document.forms[frm].captcha,
			cv = document.forms[frm].cv,
			install_folder = document.getElementById('jl_install_folder').value;
		
		var err_container = document.getElementById('jl_candidate_error_container');
		if (email) {
			if (email.value == '') {
				msg += '<li>' + JL.Msg.email + '</li>';
			}
			if (email.value != '' && email.value.match(re) == null) {
				msg += '<li>' + JL.Msg.email_inv + '</li>';
			}
		}
		if (password) {
			if (password.value == '') {
				msg += '<li>' + JL.Msg.password + '</li>';
			}
		}
		if (cpassword) {
			if (cpassword.value == '') {
				msg += '<li>' + JL.Msg.cpassword + '</li>';
			}
		}
		if (password && cpassword) {
			if (password.value != '' && cpassword.value != '') {
				if(password.value != cpassword.value)
				msg += '<li>' + JL.Msg.password_match + '</li>';
			}
		}
		if (fname) {
			if (fname.value == '') {
				msg += '<li>' + JL.Msg.fname + '</li>';
			}
		}
		if (lname) {
			if (lname.value == '') {
				msg += '<li>' + JL.Msg.lname + '</li>';
			}
		}
		if (captcha && captcha.value == '') {
			msg += '<li>' + JL.Msg.captcha + '</li>';
		}
		if(cv.value != ""){
			if(this.validateExt(cv.value) == false){
				msg += '<li>' + JL.Msg.cv_ext + '</li>';
			}
		}
		if (msg != '') {
			err_container.innerHTML = msg;
			err_container.style.display = "block";
		}else{
			if(captcha)
			{
				var captcha_inc = JL.Msg.captcha_inc;
				var $this = this;
				JABB.Ajax.sendRequest(install_folder + 'index.php?controller=pjFront&action=pjActionCheckCaptcha&verification=' + captcha.value + '&pjType=Candidate', function (resp) {
					var code = resp.responseText;
					if(code == 100){
						if (email) {
							$this.checkEmail(email.value, document.forms[frm], err_container, 'Candidate', null);
						}else{
							document.forms[frm].submit();
						}
					}else{
						msg = '<li>' + captcha_inc + '</li>';
						err_container.innerHTML = msg;
						err_container.style.display = "block";
					}
				});
			}else{
				document.forms[frm].submit();
			}
		}
	},
	validateLogin: function(frm, container_id)
	{
		var re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
		msg = '',
		email = document.forms[frm].email,
		password = document.forms[frm].password;
		
		var err_container = document.getElementById(container_id);
		if (email) {
			if (email.value == '') {
				msg += '<li>' + JL.Msg.email + '</li>';
			}
			if (email.value != '' && email.value.match(re) == null) {
				msg += '<li>' + JL.Msg.email_inv + '</li>';
			}
		}
		if (password) {
			if (password.value == '') {
				msg += '<li>' + JL.Msg.password + '</li>';
			}
		}
		if (msg != '') {
			err_container.innerHTML = msg;
			err_container.style.display = "block";
		}else{
			document.forms[frm].submit();
		}
	},
	validateProfile: function(frm)
	{
		var re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
			msg = '',
			email = document.forms[frm].email,
			password = document.forms[frm].password,
			cpassword = document.forms[frm].cpassword,
			fname = document.forms[frm].fname,
			lname = document.forms[frm].lname,
			captcha = document.forms[frm].captcha,
			cv = document.forms[frm].cv,
			id = document.forms[frm].id.value;
		
		var err_container = document.getElementById('jl_profile_error_container');
		if (email) {
			if (email.value == '') {
				msg += '<li>' + JL.Msg.email + '</li>';
			}
			if (email.value != '' && email.value.match(re) == null) {
				msg += '<li>' + JL.Msg.email_inv + '</li>';
			}
		}
		if (password) {
			if (password.value == '') {
				msg += '<li>' + JL.Msg.password + '</li>';
			}
		}
		if (cpassword) {
			if (cpassword.value == '') {
				msg += '<li>' + JL.Msg.cpassword + '</li>';
			}
		}
		if (password && cpassword) {
			if (password.value != '' && cpassword.value != '') {
				if(password.value != cpassword.value)
				msg += '<li>' + JL.Msg.password_match + '</li>';
			}
		}
		if (fname) {
			if (fname.value == '') {
				msg += '<li>' + JL.Msg.fname + '</li>';
			}
		}
		if (lname) {
			if (lname.value == '') {
				msg += '<li>' + JL.Msg.lname + '</li>';
			}
		}
		if (captcha && captcha.value == '') {
			msg += '<li>' + JL.Msg.captcha + '</li>';
		}
		if(cv.value != ""){
			if(this.validateExt(cv.value) == false){
				msg += '<li>' + JL.Msg.cv_ext + '</li>';
			}
		}
		if (msg != '') {
			err_container.innerHTML = msg;
			err_container.style.display = "block";
		}else{
			document.forms[frm].submit();
		}
	},
	validateApplyForm: function(frm)
	{
		var re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
			msg = '',
			email = document.forms[frm].email,
			fname = document.forms[frm].fname,
			lname = document.forms[frm].lname,
			captcha = document.forms[frm].captcha,
			cv = document.forms[frm].cv,
			install_folder = document.getElementById('jl_install_folder').value;
		
		var err_container = document.getElementById('jl_apply_error_container');
		if (email) {
			if (email.value == '') {
				msg += '<li>' + JL.Msg.email + '</li>';
			}
			if (email.value != '' && email.value.match(re) == null) {
				msg += '<li>' + JL.Msg.email_inv + '</li>';
			}
		}
		if (fname) {
			if (fname.value == '') {
				msg += '<li>' + JL.Msg.fname + '</li>';
			}
		}
		if (lname) {
			if (lname.value == '') {
				msg += '<li>' + JL.Msg.lname + '</li>';
			}
		}
		if (captcha && captcha.value == '') {
			msg += '<li>' + JL.Msg.captcha + '</li>';
		}
		if(cv.value != ""){
			if(this.validateExt(cv.value) == false){
				msg += '<li>' + JL.Msg.cv_ext + '</li>';
			}
		}
		if (msg != '') {
			err_container.innerHTML = msg;
			err_container.style.display = "block";
		}else{
			if(captcha)
			{
				var captcha_inc = JL.Msg.captcha_inc;
				var $this = this;
				JABB.Ajax.sendRequest(install_folder + 'index.php?controller=pjFront&action=pjActionCheckCaptcha&verification=' + captcha.value , function (resp) {
					var code = resp.responseText;
					if(code == 100){
						
						document.forms[frm].submit();
						
					}else{
						msg = '<li>' + captcha_inc + '</li>';
						err_container.innerHTML = msg;
						err_container.style.display = "block";
					}
				});
			}else{
				document.forms[frm].submit();
			}
		}
	},
	validateForgotPassword: function(frm)
	{
		var re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
			msg = '',
			email = document.forms[frm].email;
		
		var err_container = document.getElementById('jl_forgot_error_container');
		if (email) {
			if (email.value == '') {
				msg += '<li>' + JL.Msg.email + '</li>';
			}
			if (email.value != '' && email.value.match(re) == null) {
				msg += '<li>' + JL.Msg.email_inv + '</li>';
			}
		}
		
		if (msg != '') {
			err_container.innerHTML = msg;
			err_container.style.display = "block";
		}else{
			document.forms[frm].submit();
		}
	},
	removeCV: function(url, cv_container, error_message)
	{
		JABB.Ajax.sendRequest(url, function (resp) {
			var code = resp.responseText;
			if(code == 100){
				document.getElementById(cv_container).style.display = "none";
			}else{
				alert(error_message);
			}
		});
	},
	
	bindJobType: function(){
		var self = this;
		var arrTypeNode = JABB.Utils.getElementsByClass("type-node", document.getElementById("jl_type_list"), "LI");
		for (i = 0, len = arrTypeNode.length; i < len; i++) {
			JABB.Utils.addEvent(arrTypeNode[i], "click", function (e) {
				var type_id = this.getAttribute("lang");
				var frmQuickSearch = document.getElementById("frmQuickSearch");
				var type_id_ele = frmQuickSearch.type_id;
				type_id_ele.value = type_id;
				frmQuickSearch.submit();
			});
		}
		if ('ontouchstart' || 'onmsgesturechange')
		{ 
			_touch_focus = document.querySelectorAll('div[tabindex]');
			 document.body.addEventListener('touchstart', function(){
				for ( var i = 0; i < _touch_focus.length; i++ ) {
					_touch_focus[i].blur();
					_touch_focus[i].focused = false;
				}
			}, false);
			for ( var i = 0; i < _touch_focus.length; i++ ) {
				_touch_focus[i].addEventListener('touchstart', function(event){
					this.focus();
					this.focused = true;
					event.stopPropagation();
				}, false);
			}
		}
	},
	
	init: function(){
		var job_type_list = document.getElementById("jl_type_list");
		if(typeof(job_type_list) != 'undefined' && job_type_list != null)
		{	
			this.bindJobType();
		}
	},
	loadDelayedCSS: function()
	{
		var cssId = 'pjJLTransitions'; 
		if (!document.getElementById(cssId))
		{
			var head  = document.getElementsByTagName('head')[0];
		    var link  = document.createElement('link');
		    link.id   = cssId;
		    link.rel  = 'stylesheet';
		    link.type = 'text/css';
		    link.href = JL.opts.server + 'templates/default/css/transitions.css';
		    link.media = 'all';
		    head.appendChild(link);
		}
	}
};
window.onload = function()
{
	JL.Utils.init();
	JL.Utils.loadDelayedCSS();
}
