/*!
 * Job Listing Script v3.0
 * 
 * http://www.phpjabbers.com/job-listing-script/
 * 
 * Copyright 2015, StivaSoft Ltd.
 * 
 */
(function (window, undefined){
	"use strict";
	

	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined);
    
	function loadDelayedCSS(opts) {
		pjQ.$(window).load(function() {
			pjQ.$('body').append(pjQ.$('<link rel="stylesheet" type="text/css" />').attr('href', opts.server+'templates/default/css/transitions.css'));
		});
	}
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnYacht(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function JobListing(opts) {
		if (!(this instanceof JobListing)) {
			return new JobListing(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	JobListing.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnYacht(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	JobListing.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnYacht(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	JobListing.prototype = {
		reset: function () {
			this.$container = null;
			this.container = null;			
			this.opts = {};
			
			return this;
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjWrapper");
			this.$container = pjQ.$(this.container);
			
			loadDelayedCSS(opts);
			self.bindQuickSearch();
			self.bindAdvancedSearch();
			self.bindRegisterForm();
			self.bindLoginForm();
			self.bindProfileForm();
			self.bindForgotForm();
			self.bindApplyForm();
			
			this.$container.on('change', 'input[name=cv_option]', function(e){
				if(pjQ.$(this).val() == 'current')
				{
					pjQ.$('#pjCurrentRow').show();
					pjQ.$('#pjUploadRow').hide();
					pjQ.$('#pjUploadCV').val();
				}else{
					pjQ.$('#pjCurrentRow').hide();
					pjQ.$('#pjUploadRow').show();
				}
			}).on('click', '#pjJlCaptchaImage_' + self.opts.index, function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $captchaImg = pjQ.$(this);
				if($captchaImg.length > 0){
					var rand = Math.floor((Math.random()*999999)+1); 
					
					$captchaImg.attr("src", self.opts.folder + 'index.php?controller=pjFront&action=pjActionCaptcha&rand=' + rand);
					
					pjQ.$('#pjJlCaptchaField_' + self.opts.index).val("").removeData("previousValue");
				}
				return false;
			}).on('click', '#pjJlCandidateCaptchaImage_' + self.opts.index, function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $captchaImg = pjQ.$(this);
				if($captchaImg.length > 0){
					var rand = Math.floor((Math.random()*999999)+1); 
					
					$captchaImg.attr("src", self.opts.folder + 'index.php?controller=pjFront&action=pjActionCaptcha&rand=' + rand + "&pjType=Candidate");
					
					pjQ.$('#pjJlCandidateCaptchaField_' + self.opts.index).val("").removeData("previousValue");
				}
				return false;
			}).on('click', '#pjJlEmployerCaptchaImage_' + self.opts.index, function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $captchaImg = pjQ.$(this);
				if($captchaImg.length > 0){
					var rand = Math.floor((Math.random()*999999)+1); 
					
					$captchaImg.attr("src", self.opts.folder + 'index.php?controller=pjFront&action=pjActionCaptcha&rand=' + rand + "&pjType=Employer");
					
					pjQ.$('#pjJlEmployerCaptchaField_' + self.opts.index).val("").removeData("previousValue");
				}
				return false;
			}).on('click', '.pjJlBtnViewDetails', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				window.location = pjQ.$(this).closest('a').attr('href');
				return false;
			}).on('click', '#tab_employer_radio_1', function(e){
				pjQ.$('#tab_candidate_radio_1').prop('checked', true);
				pjQ.$('#tab_candidate_radio_2').prop('checked', false);
				pjQ.$('#pjJLEmployerTab').removeClass("active");
				pjQ.$('#pjJLCandidateTab').addClass("active");
			}).on('click', '#tab_employer_radio_2', function(e){
				pjQ.$('#tab_candidate_radio_1').prop('checked', false);
				pjQ.$('#tab_candidate_radio_2').prop('checked', true);
				pjQ.$('#pjJLEmployerTab').addClass("active");
				pjQ.$('#pjJLCandidateTab').removeClass("active");
			}).on('click', '#tab_candidate_radio_1', function(e){
				pjQ.$('#tab_employer_radio_1').prop('checked', true);
				pjQ.$('#tab_employer_radio_2').prop('checked', false);
				pjQ.$('#pjJLEmployerTab').removeClass("active");
				pjQ.$('#pjJLCandidateTab').addClass("active");
			}).on('click', '#tab_candidate_radio_2', function(e){
				pjQ.$('#tab_employer_radio_1').prop('checked', false);
				pjQ.$('#tab_employer_radio_2').prop('checked', true);
				pjQ.$('#pjJLEmployerTab').addClass("active");
				pjQ.$('#pjJLCandidateTab').removeClass("active");
			}).on('click', '.pjJlBtnApplyJob', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $applyWrapper = pjQ.$('#frmJobApply').parent();
				if($applyWrapper.css('display') == 'none')
				{
					$applyWrapper.css('display', 'block');
				}else{
					$applyWrapper.css('display', 'none');
				}
			}).on('click', '.pjJlPagingItem', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $frmQuickSearch = pjQ.$('#pjJLQuickSearch_' + self.opts.index);
				var page = pjQ.$(this).attr('data-page');
				if($frmQuickSearch.find('input[name="pjPage"]').length > 0)
				{
					$frmQuickSearch.find('input[name="pjPage"]').val(page);
				}
				$frmQuickSearch.submit();
				return false;
			});
		},
		bindQuickSearch: function()
		{
			var self = this;
			var $frmQuickSearch = pjQ.$('#pjJLQuickSearch_' + self.opts.index);
			var $sortBy = pjQ.$('#pjJLSortBy_' + self.opts.index);
			
			if($frmQuickSearch.length > 0)
			{
				if (pjQ.$('.pjJlCustomRadio, .pjJlCustomCheckbox').length) 
				{
					var checkedClass = 'pjJlCustomInputChecked';
					var disabledClass = 'pjJlCustomInputDisabled';
					var inputSelector = '.pjJlCustomCheckbox input, .pjJlCustomRadio input';

					pjQ.$(inputSelector).each(function() {
						var input = this;

						pjQ.$(input).parent().toggleClass(checkedClass, input.checked);
					}).on('change', function() {
						var input = this;

						if(input.type === 'radio') {
							var name = input.name;
							pjQ.$(input.ownerDocument).find('[name=' + name + ']').each(function() {
								var radioInput = this;
								pjQ.$(radioInput).parent().toggleClass(checkedClass, radioInput.checked);
							});
						} else {
							pjQ.$(input).parent().toggleClass(checkedClass, input.checked);
						};
						$frmQuickSearch.submit();
					}).on('disable', function() {
						var input = this;

						input.disabled = true;
						pjQ.$(input).parent().addClass(disabledClass);
					}).on('enable', function() {
						var input = this;

						input.disabled = false;
						pjQ.$(input).parent().removeClass(disabledClass);
					});			
				};
				
				if (pjQ.$('.pjJlSortItems').length) {
					pjQ.$('.pjJlSortItem').each(function() {
						if (pjQ.$(this).index() > 4) 
						{
							pjQ.$(this).hide().addClass('pjJlSortItemHidden');
						};
					});

					pjQ.$('.pjJlSortItemsTrigger').on('click', function(e) {
						var $clickedLink = pjQ.$(this);
						var openClass = 'pjJlSortItemsOpen';
						$clickedLink.parents('.pjJlSortSection').find('.pjJlSortItemHidden').stop(true, true).slideToggle('slow');
						$clickedLink.toggleClass(openClass);
						
						if ($clickedLink.hasClass(openClass)) {
							$clickedLink.text($clickedLink.attr('data-less'));
						} else {
							$clickedLink.text($clickedLink.attr('data-more'));
						};

						e.preventDefault();
					});
				};
				if($sortBy.length > 0)
				{
					$sortBy.on('change', function(e){
						$frmQuickSearch.submit();
					});
				}
			}
		},
		bindAdvancedSearch: function()
		{
			var self = this;
			var $frmAdvancedSearch = pjQ.$('#pjJLAdvancedSearch_' + self.opts.index);
			
			if($frmAdvancedSearch.length > 0)
			{
				if (pjQ.$('.pjJlCustomRadio, .pjJlCustomCheckbox').length) 
				{
					var checkedClass = 'pjJlCustomInputChecked';
					var disabledClass = 'pjJlCustomInputDisabled';
					var inputSelector = '.pjJlCustomCheckbox input, .pjJlCustomRadio input';

					pjQ.$(inputSelector).each(function() {
						var input = this;

						pjQ.$(input).parent().toggleClass(checkedClass, input.checked);
					}).on('change', function() {
						var input = this;

						if(input.type === 'radio') {
							var name = input.name;
							pjQ.$(input.ownerDocument).find('[name=' + name + ']').each(function() {
								var radioInput = this;
								pjQ.$(radioInput).parent().toggleClass(checkedClass, radioInput.checked);
							});
						} else {
							pjQ.$(input).parent().toggleClass(checkedClass, input.checked);
						};
					}).on('disable', function() {
						var input = this;

						input.disabled = true;
						pjQ.$(input).parent().addClass(disabledClass);
					}).on('enable', function() {
						var input = this;

						input.disabled = false;
						pjQ.$(input).parent().removeClass(disabledClass);
					});			
				};
			}
		},
		bindRegisterForm: function()
		{
			var self = this;
			var $frmEmployerRegister = pjQ.$('#frmEmployerRegister');
			var $frmCandidateRegister = pjQ.$('#frmCandidateRegister');
			
			if($frmEmployerRegister.length > 0)
			{
				$frmEmployerRegister.validate({
					rules: {
						"email": {
							remote: self.opts.folder + "index.php?controller=pjLoad&action=pjActionCheckEmail&pjType=Employer"
						},
						"captcha": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha&pjType=Employer"
						},
						"cpassword":{
							equalTo: "#pjJLEmployerPassword"
						}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form)
		            {
		            	var $fileField = pjQ.$('#pjJlLogo_' + self.opts.index);
		            	var file = $fileField[0].files[0];
		            	var allowed_ext = $fileField.attr('data-extension');
		            	var valid = false;
		            	if (file){
		            		var file_name = file.name,
								file_extension = file_name.substr( (file_name.lastIndexOf('.') + 1) );
		            		if(allowed_ext != '')
							{
								var allowed_arr = allowed_ext.split("|");
								if(pjQ.$.inArray(file_extension, allowed_arr) > -1)
								{
									valid = true;
								}
							}
	            		}else{
	            			valid = true;
	            		}
		            	if(valid == false)
		            	{
		            		pjQ.$('#pjJlLogoErrorWrapper').show();
		            		pjQ.$('#pjJlLogoErrorWrapper').parent().addClass('has-error');
		            	}else{
		            		pjQ.$('#pjJlLogoErrorWrapper').hide();
		            		pjQ.$('#pjJlLogoErrorWrapper').parent().removeClass('has-error');
		            		form.submit();
		            	}
		            	return false;
		            }
				});
			}
			if($frmCandidateRegister.length > 0)
			{
				$frmCandidateRegister.validate({
					rules: {
						"email": {
							remote: self.opts.folder + "index.php?controller=pjLoad&action=pjActionCheckEmail&pjType=Candidate"
						},
						"captcha": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha&pjType=Candidate"
						},
						"cpassword":{
							equalTo: "#pjJLCandidatePassword"
						}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form)
		            {
		            	var $fileField = pjQ.$('#pjJlCV_' + self.opts.index);
		            	var file = $fileField[0].files[0];
		            	var allowed_ext = $fileField.attr('data-extension');
		            	var valid = false;
		            	if (file){
		            		var file_name = file.name,
								file_extension = file_name.substr( (file_name.lastIndexOf('.') + 1) );
		            		if(allowed_ext != '')
							{
								var allowed_arr = allowed_ext.split("|");
								if(pjQ.$.inArray(file_extension, allowed_arr) > -1)
								{
									valid = true;
								}
							}
	            		}else{
	            			valid = true;
	            		}
		            	if(valid == false)
		            	{
		            		pjQ.$('#pjJlFileErrorWrapper').show();
		            		pjQ.$('#pjJlFileErrorWrapper').parent().addClass('has-error');
		            	}else{
		            		pjQ.$('#pjJlFileErrorWrapper').hide();
		            		pjQ.$('#pjJlFileErrorWrapper').parent().removeClass('has-error');
		            		form.submit();
		            	}
		            	return false;
		            }
				});
			}
			
			if (pjQ.$('.pjJlAddFile').length) 
			{
				var hasSelectedClass = 'pjJlAddFileAdded';
				var holderSelector = '.pjJlAddFile';
				var namesSelector = '.pjJlUploadedFiles';
				var inputSelector = '.pjJlFileUploadField';
				var multipleNamesDivider = ', ';

				pjQ.$(inputSelector).on('change', function() {
					var input = this;
					var files = input.files,
						allowed_ext = pjQ.$(input).attr('data-extension'),
						valid = false;

					if(!('files' in input)) {
						files = [];
						files.push({
							name: input.value.replace('C:\\fakepath\\', '')
						});
					};

					pjQ.$.map(files, function(file) {
						var file_name = file.name,
							file_extension = file_name.substr( (file_name.lastIndexOf('.') + 1) );
						if(allowed_ext != '')
						{
							var allowed_arr = allowed_ext.split("|");
							if(pjQ.$.inArray(file_extension, allowed_arr) > -1)
							{
								valid = true;
							}
						}
					});
					
					pjQ.$(input).closest(holderSelector).toggleClass(hasSelectedClass, input.value !== '').find(namesSelector).val(pjQ.$.map(files, function(file) {
						pjQ.$(input).parent().next().show();
						return file.name;
					}).join(multipleNamesDivider));
					
					if(valid == true)
	            	{
						var $closestForm = pjQ.$(input).closest('form');
						if($closestForm.attr('name') == 'frmEmployerRegister')
						{
							pjQ.$('#pjJlLogoErrorWrapper').hide();
		            		pjQ.$('#pjJlLogoErrorWrapper').parent().removeClass('has-error');
						}
						if($closestForm.attr('name') == 'frmCandidateRegister')
						{
							pjQ.$('#pjJlFileErrorWrapper').hide();
		            		pjQ.$('#pjJlFileErrorWrapper').parent().removeClass('has-error');
						}
	            	}
				});

				pjQ.$('.pjJlBtnRemoveFile').on('click', function(e) {
					pjQ.$(holderSelector).removeClass(hasSelectedClass);
					pjQ.$(inputSelector).val('');
					pjQ.$(namesSelector).val('');
					pjQ.$(this).hide();
					
					var $closestForm = pjQ.$(this).closest('form');
					if($closestForm.attr('name') == 'frmEmployerRegister')
					{
						pjQ.$('#pjJlLogoErrorWrapper').hide();
	            		pjQ.$('#pjJlLogoErrorWrapper').parent().removeClass('has-error');
					}
					if($closestForm.attr('name') == 'frmCandidateRegister')
					{
						pjQ.$('#pjJlFileErrorWrapper').hide();
	            		pjQ.$('#pjJlFileErrorWrapper').parent().removeClass('has-error');
					}
            		
					e.preventDefault();
				});
			};
		},
		bindLoginForm: function()
		{
			var self = this;
			var $frmEmployerLogin = pjQ.$('#frmEmployerLogin');
			var $frmCandidateLogin = pjQ.$('#frmCandidateLogin');
			
			if($frmEmployerLogin.length > 0)
			{
				$frmEmployerLogin.validate({
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
			if($frmCandidateLogin.length > 0)
			{
				$frmCandidateLogin.validate({
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
		},
		bindProfileForm: function()
		{
			var self = this;
			var $frmProfile = pjQ.$('#frmProfile');
			
			if($frmProfile.length > 0)
			{
				$frmProfile.validate({
					rules: {
						"email": {
							remote: self.opts.folder + "index.php?controller=pjLoad&action=pjActionCheckEmail&pjType=Candidate&id=" + $frmProfile.find("input[name='id']").val()
						},
						"cpassword":{
							equalTo: "#pjJLProfilePassword"
						}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
				
				pjQ.$('.modal-dialog').css("z-index", "9999");
				
				pjQ.$('.pjULOpenDeleteModal').on('click', function(e){
					e.preventDefault();
					pjQ.$('#pjJLDeleteCVModal').modal('show');
				});
				pjQ.$('#pjJLDeleteButton_' + self.opts.index).on('click', function(e){
					e.preventDefault();
					var id = pjQ.$(this).attr('data-id'),
						hash = pjQ.$(this).attr('data-hash');
					var member_id = pjQ.$(this).attr('data-id');
					pjQ.$.get(self.opts.folder + "index.php?controller=pjLoad&action=pjActionDeleteCV&id=" + id + "&hash=" + hash).done(function (data) {
						if(data == '100')
						{
							pjQ.$('#pjJLCVContainer_' + self.opts.index).remove();
							pjQ.$('#pjJLDeleteCVModal').modal('hide');
						}
					});
				});
			}
		},
		bindForgotForm: function()
		{
			var self = this;
			var $frmForgotPassword = pjQ.$('#frmForgotPassword');
			
			if($frmForgotPassword.length > 0)
			{
				$frmForgotPassword.validate({
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
		},
		bindApplyForm: function()
		{
			var self = this;
			var $frmJobApply = pjQ.$('#frmJobApply');
			if($frmJobApply.length > 0)
			{
				$frmJobApply.validate({
					rules: {
						"captcha": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha"
						}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form)
		            {
		            	var $fileField = pjQ.$('#pjJlCV_' + self.opts.index);
		            	var file = $fileField[0].files[0];
		            	var allowed_ext = $fileField.attr('data-extension');
		            	var valid = false;
		            	if (file){
		            		var file_name = file.name,
								file_extension = file_name.substr( (file_name.lastIndexOf('.') + 1) );
		            		if(allowed_ext != '')
							{
								var allowed_arr = allowed_ext.split("|");
								if(pjQ.$.inArray(file_extension, allowed_arr) > -1)
								{
									valid = true;
								}
							}
	            		}else{
	            			valid = true;
	            		}
		            	if(valid == false)
		            	{
		            		pjQ.$('#pjJlFileErrorWrapper').show();
		            		pjQ.$('#pjJlFileErrorWrapper').parent().addClass('has-error');
		            	}else{
		            		pjQ.$('#pjJlFileErrorWrapper').hide();
		            		pjQ.$('#pjJlFileErrorWrapper').parent().removeClass('has-error');
		            		form.submit();
		            	}
		            	return false;
		            }
				});
				if (pjQ.$('.pjJlAddFile').length) 
				{
					var hasSelectedClass = 'pjJlAddFileAdded';
					var holderSelector = '.pjJlAddFile';
					var namesSelector = '.pjJlUploadedFiles';
					var inputSelector = '.pjJlFileUploadField';
					var multipleNamesDivider = ', ';

					pjQ.$(inputSelector).on('change', function() {
						var input = this;
						var files = input.files,
							allowed_ext = pjQ.$(input).attr('data-extension'),
							valid = false;

						if(!('files' in input)) {
							files = [];
							files.push({
								name: input.value.replace('C:\\fakepath\\', '')
							});
						};
						
						pjQ.$.map(files, function(file) {
							var file_name = file.name,
								file_extension = file_name.substr( (file_name.lastIndexOf('.') + 1) );
							if(allowed_ext != '')
							{
								var allowed_arr = allowed_ext.split("|");
								if(pjQ.$.inArray(file_extension, allowed_arr) > -1)
								{
									valid = true;
								}
							}
						});
						
						pjQ.$(input).closest(holderSelector).toggleClass(hasSelectedClass, input.value !== '').find(namesSelector).val(pjQ.$.map(files, function(file) {
							return file.name;
						}).join(multipleNamesDivider));
						
						if(valid == true)
		            	{
							pjQ.$('#pjJlFileErrorWrapper').hide();
		            		pjQ.$('#pjJlFileErrorWrapper').parent().removeClass('has-error');
		            	}
					});

					pjQ.$('.pjJlBtnRemoveFile').on('click', function(e) {
						pjQ.$(holderSelector).removeClass(hasSelectedClass);
						pjQ.$(inputSelector).val('');
						pjQ.$(namesSelector).val('');

						pjQ.$('#pjJlFileErrorWrapper').hide();
	            		pjQ.$('#pjJlFileErrorWrapper').parent().removeClass('has-error');
	            		
						e.preventDefault();
					});
				};
			}
			if(pjQ.$('#pjJlJobApplyAlert').length > 0)
			{
				pjQ.$('html, body').animate({
			        scrollTop: pjQ.$('#pjJlJobApplyAlert').offset().top
			    }, 500);
			}
		}
	};
	
	window.JobListing = JobListing;	
})(window);