<?php
mt_srand();
$index = mt_rand(1, 9999);
$front_err = __('front_error', true);
?>
<div id="pjWrapper">
	<div class="container-fluid pjJlContainer">
		<?php include_once dirname(__FILE__) . '/elements/header.php';?>
		
		<div class="pjJlBody">
			<div class="pjJlJob">
				<?php
				if(isset($tpl['status']))
				{
					$job_statuses = __('job_statuses', true);
					echo $job_statuses[$tpl['status']];
				}else{
					if (isset($tpl['arr']))
					{ 
						$job_title = stripslashes($tpl['arr']['job_title']);
						$logo_url = '';
						if(!empty($tpl['arr']['logo']))
						{
							if(file_exists(PJ_INSTALL_PATH . $tpl['arr']['logo']))
							{
								$logo_url = PJ_INSTALL_URL . $tpl['arr']['logo'];
							}
						}
						$back = !empty($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : $_SERVER['PHP_SELF'] .'?controller=pjLoad&amp;action=pjActionJobs';
						if(strpos("pjActionView", $back) >= 0)
						{
							if ($tpl['option_arr']['o_seo_url'] == 'No')
							{
								$back = $_SERVER['PHP_SELF'] .'?controller=pjLoad&amp;action=pjActionJobs';
							}else{
								if(empty($tpl['option_arr']['o_job_page']))
								{
									$path = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
									$path = $path == '/' ? '' : $path;
									$back = $path .'/job-home.html';
								}else{
									$back = $tpl['option_arr']['o_job_page'];
								}
							}
						}
						$map = array(
							1 => 'pjJlResultTypeLightGreen',
							2 => 'pjJlResultTypeRed',
							3 => 'pjJlResultTypeBlue',
							4 => 'pjJlResultTypeOrange',
							5 => 'pjJlResultTypePurple',
							6 => 'pjJlResultTypeGreen'
						);
						?>
						<header class="pjJlJobHead">
							<div class="pjJlJobActions">
								<a href="<?php echo $back;?>" class="btn btn-default pjJlBtn pjJlBtnBack">
									<i class="fa fa-angle-left"></i> 
									<?php __('front_menu_back');?>
								</a>
							</div><!-- /.pjJlJobActions -->
		
							<div class="clearfix">
								<?php
								if($logo_url != '')
								{ 
									?>
									<div class="pull-right pjJlJobLogo">
										<img src="<?php echo $logo_url;?>" alt="" />
									</div><!-- /.pull-right pjJlJobLogo -->
									<?php
								} 
								?>
		
								<p class="pjJlJobTitle"><?php echo html_entity_decode(stripslashes($job_title)); ?></p><!-- /.pjJlJobTitle -->
								<p class="pjJlJobSubtitle"><?php echo stripslashes($tpl['arr']['category']); ?></p><!-- /.pjJlJobSubtitle -->
							</div><!-- /.clearfix -->
						</header><!-- /.pjJlJobHead -->
						
						<div class="row pjJlJobBody">
							<aside class="col-lg-3 col-md-3 col-sm-4 col-xs-12 pjJlJobAside">
								<div class="thumbnail pjJlJobBox">
									<p class="clearfix pjJlJobBoxTitle">
										<span class="pull-right label label-default pjJlResultType <?php echo $map[$tpl['arr']['type_id']];?>"><?php echo stripslashes($tpl['arr']['type_title']);?></span>
										<strong><?php __('front_job_summary');?></strong>
									</p><!-- /.clearfix pjJlJobBoxTitle -->
																
									<dl>
										<dt><?php __('front_posted_on');?></dt>
										<dd><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created']));?></dd>
									</dl>
									<?php
									if(!empty($v['company_name']))
									{ 
										?>							
										<dl>
											<dt><?php __('front_label_company_name');?>: </dt>
											<dd><?php echo pjSanitize::html($tpl['arr']['company_name']);?></dd>
										</dl>
										<?php
									} 
									if(!empty($v['lang_city']))
									{
										?>
										<dl>
											<dt><?php __('front_location');?>: </dt>
											<dd><?php echo pjSanitize::html($tpl['arr']['lang_city']);?></dd>
										</dl>
										<?php
									}else{
										if(!empty($v['address_city']))
										{
											?>
											<dl>
												<dt><?php __('front_location');?>: </dt>
												<dd><?php echo pjSanitize::html($tpl['arr']['address_city']);?></dd>
											</dl>
											<?php
										}
									}
									if(!empty($tpl['filter_arr']))
									{
										foreach(__('filter_types', true) as $key => $val)
										{
											if(isset($tpl['filter_arr'][$key]))
											{
												ob_start();
												foreach($tpl['filter_arr'][$key] as $k => $v)
												{ 
													if(in_array($v['id'], $tpl['filter_id_arr']))
													{
														?>
														<dd><?php echo stripslashes($v['name']);?></dd>
														<?php
													}
												} 
												$ob_filter = ob_get_contents();
												ob_end_clean();
												if (!empty($ob_filter))
												{
													?>
													<dl>
														<dt><?php echo $val;?></dt>
														<?php echo $ob_filter;?>
													</dl>
													<?php
												}
											}
										}
									}
									if (!empty($tpl['arr']['job_salary']))
									{ 
										?>							
										<dl>
											<dt><?php __('front_label_salary'); ?></dt>
											<dd><?php echo pjSanitize::html($tpl['arr']['job_salary']);?></dd>
										</dl>
										<?php
									}
									if ($tpl['arr']['expired_show'] == 'T')
									{
										?>
										<dl>
											<dt class="light"><?php __('front_expiration_date'); ?></dt>
						                  	<dd><?php echo pjToolkit::formatDate($tpl['arr']['expired'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?></dd>
						                </dl>
										<?php
									} 
									?>
								</div><!-- /.thumbnail pjJlJobBox -->
								<?php
								if(!empty($tpl['arr']['company_name']) && $tpl['arr']['employer_show'] == 'T')
								{ 
									?>
									<div class="thumbnail pjJlJobBox">
										<p class="pjJlJobBoxTitle"><?php __('front_about');?> <?php echo pjSanitize::html($tpl['arr']['company_name']);?></p><!-- /.pjJlJobBoxTitle -->
																	
										<p class="pjJlHasMoreText"><?php echo nl2br(stripslashes($tpl['arr']['about_company']));?></p>
										<br/>
										<?php include_once dirname(__FILE__) . '/elements/contact.php';?>
									</div><!-- /.thumbnail pjJlJobBox -->
									<?php
								} 
								?>
							</aside><!-- /.col-lg-3 col-md-3 col-sm-4 col-xs-12 pjJlJobAside -->
							
							<div class="col-lg-9 col-md-9 col-sm-8 col-xs-12 pjJlJobContent">
								<p class="pjJlJobTitleSmall"><?php __('front_label_job_description');?></p><!-- /.pjJlJobTitleSmall -->
								<div><?php echo html_entity_decode(htmlspecialchars(stripslashes($tpl['arr']['job_description']))); ?></div>
								<?php
								$title = pjSanitize::html($job_title);
								$minus_name = $controller->friendlyURL($title, '-');
								$plus_name = str_replace('-', "+", $minus_name);
								$url = str_replace("&", "%26", pjUtil::getPageURL());
								?>
								<div class="pjJlSocials">
									<p class="pjJlSocialsTitle"><?php __('front_share');?></p><!-- /.pjJlSocialsTitle -->

									<ul class="list-inline">
										<li>
											<a href="https://www.facebook.com/sharer.php?u=<?php echo $url;?>&t=<?php echo $plus_name;?>" class="pjJlLinkFacebook" target="_blank">
												<i class="fa fa-facebook"></i>
											</a>
										</li>

										<li>
											<a href="https://twitter.com/intent/tweet?source=webclient&text=<?php echo $plus_name; ?>&url=<?php echo $url?>" class="pjJlLinkTwitter" target="_blank">
												<i class="fa fa-twitter"></i>
											</a>
										</li>

										<li>
											<a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo $url?>&title=<?php echo $plus_name; ?>&source=<?php echo $url?>" class="pjJlLinkLinkedIn" target="_blank">
												<i class="fa fa-linkedin"></i>
											</a>
										</li>
									</ul><!-- /.list-inline -->
									<?php
									if($tpl['option_arr']['o_is_applying_job_allowed'] == 'Yes')
									{
										if(!isset($tpl['err']) || (isset($tpl['err']) && in_array($tpl['err'], array('0', '2', '3','4','data_inv'))) )
										{ 
											if(isset($tpl['is_applied']) && $tpl['is_applied'] == true)
											{
												?>
												<div class="pjJlFormActions pull-right">
													<label class="text-success"><?php __('front_job_applied')?></label>
												</div>
												<?php
											}else{
												?>
												<div class="pjJlFormActions pull-right">
													<button type="button" class="btn btn-default pjJlBtn pjJlBtnPrimary pjJlBtnApplyJob"><?php __('front_btn_apply_for_this_job');?></button>
												</div>
												<?php
											}
										}
									} 
									?>
								</div><!-- /.pjJlSocials -->
								<?php
								if($tpl['option_arr']['o_is_applying_job_allowed'] == 'Yes')
								{ 
									if(isset($tpl['err']))
									{
										$error_code = $tpl['err'];
										$reg_message = __('front_apply', true);
										$class = in_array($error_code, array('0', '2', '3','4','data_inv')) ? ' alert-danger' : ' alert-success';
										?>
										<div id="pjJlJobApplyAlert" class="alert<?php echo $class;?>"><?php echo $reg_message[$error_code]; ?></div>
										<?php
									} 
									?>
									<div class="pjJlForm pjJlFormApply" style="display: none;">
										<form action="<?php echo $_SERVER['PHP_SELF'];?>?controller=pjLoad&amp;action=pjActionApply" method="post" id="frmJobApply" name="frmJobApply" autocomplete="off" class="form-dyna xs-4 form-apply" enctype="multipart/form-data" >
											<input type="hidden" name="job_id"  value="<?php echo $tpl['arr']['id'];?>" />
											
											<p class="pjJlFormTitle"><?php __('front_label_job_apply');?></p><!-- /.pjJlFormTitle -->
											<?php
											
											if ($controller->checkLogin())
											{
												$employee = $_SESSION[$controller->defaultCandidate];
												?>
												<div class="row">
													<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
														<div class="form-group">
															<label for=""><?php __('front_label_email');?>: </label>
															<input type="text" name="email" class="form-control" disabled="disabled" value="<?php echo pjSanitize::html($employee['email']); ?>"/>
														</div><!-- /.form-group -->
													</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
												</div><!-- /.row -->
												<div class="row">
													<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
														<div class="form-group">
															<label for=""><?php __('front_label_fname'); ?>: </label>
															<input type="text" name="fname" class="form-control" disabled="disabled" value="<?php echo pjSanitize::html($employee['fname']); ?>"/>
														</div><!-- /.form-group -->
													</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
													<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
														<div class="form-group">
															<label for=""><?php __('front_label_lname'); ?>: </label>
															<input type="text" name="lname" class="form-control" disabled="disabled" value="<?php echo pjSanitize::html($employee['lname']); ?>"/>
														</div><!-- /.form-group -->
													</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
												</div>
												<input type="hidden" name="employee_id"  value="<?php echo $employee['id'];?>"/>
												<?php
											}else{
												?>
												<div class="row">
													<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
														<div class="form-group">
															<label for=""><?php __('front_label_email');?>: </label>
															<input type="text" name="email" class="form-control required email" data-msg-required="<?php echo $front_err['email']?>" data-msg-email="<?php echo $front_err['email_inv']?>"/>
															<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
														</div><!-- /.form-group -->
													</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
												</div><!-- /.row -->
												<div class="row">
													<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
														<div class="form-group">
															<label for=""><?php __('front_label_fname'); ?>: </label>
															<input type="text" name="fname" class="form-control required" data-msg-required="<?php echo $front_err['fname']?>"/>
															<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
														</div><!-- /.form-group -->
													</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
													<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
														<div class="form-group">
															<label for=""><?php __('front_label_lname'); ?>: </label>
															<input type="text" name="lname" class="form-control required" data-msg-required="<?php echo $front_err['lname']?>"/>
															<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
														</div><!-- /.form-group -->
													</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
												</div>
												<?php
											}
											if(isset($tpl['cv_arr']))
											{
												$file = $tpl['cv_arr'];
												if(!empty($file['file_path']) && file_exists(PJ_INSTALL_PATH . $file['file_path']))
												{
													$file_path = PJ_INSTALL_PATH . $file['file_path'];
													$file_url = PJ_INSTALL_URL . $file['file_path'];
													?>
													<div class="row">
														<div class="col-sm-12">
															<div class="form-group">
																<label class="radio-inline"><input id="current_cv" checked="checked" type="radio" value="current" name="cv_option"> <?php __('front_current_cv');?></label>
																<label class="radio-inline"><input id="upload_new" type="radio" value="new" name="cv_option"> <?php __('front_upload_new');?></label>
															</div>
														</div>
													</div>
													<div id="pjCurrentRow" class="row">
														<div class="col-sm-12">
															<div class="form-group">
																<label><?php __('front_label_your_cv'); ?></label>
																<div>
																	<label class="content"><a target="_blank" href="<?php echo PJ_INSTALL_FOLDER;?>index.php?controller=pjLoad&action=pjActionDownloadFile&id=<?php echo $file['id']; ?>&hash=<?php echo $file['hash'];?>"><?php echo stripslashes($file['file_name']); ?></a></label>
																</div>
															</div>
														</div>
													</div>
													<div id="pjUploadRow" class="row" style="display: none;">
														<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
															<div class="form-group">
																<label><?php __('front_label_send_latest_cv'); ?></label>
																<div class="row pjJlAddFile">
																	<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
																		<input type="text" class="form-control pjJlUploadedFiles" placeholder="Choose file" />
																	</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
															
																	<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
																		<div class="btn btn-default pjJlBtn pjJlBtnSecondary pjJlBtnUpload">
																			<?php __('front_btn_browse');?>
																														
																			<input type="file" id="pjJlCV_<?php echo $index;?>" name="cv" class="pjJlFileUploadField" data-extension="doc|docx|pdf"/>
																		</div>
																														
																		<a href="#" class="btn btn-default pjJlBtn pjJlBtnBordered pjJlBtnRemoveFile" style="display: none;"><?php __('front_btn_delete');?></a>
																	</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
																</div><!-- /.row pjJlAddFile -->
																<div id="pjJlFileErrorWrapper" class="help-block with-errors" style="display: none;"><ul class="list-unstyled"><li><?php __('front_cv_file_not_in_format');?></li></ul></div>
															</div>
														</div>
													</div>	
													<?php
												}else{
													?>
													<div class="row">
														<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
															<div class="form-group">
																<label><?php __('front_upload_cv'); ?></label>
																<div class="row pjJlAddFile">
																	<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
																		<input type="text" class="form-control pjJlUploadedFiles" placeholder="Choose file" />
																	</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
															
																	<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
																		<div class="btn btn-default pjJlBtn pjJlBtnSecondary pjJlBtnUpload">
																			<?php __('front_btn_browse');?>
																														
																			<input type="file" id="pjJlCV_<?php echo $index;?>" name="cv" class="pjJlFileUploadField" data-extension="doc|docx|pdf"/>
																		</div>
																														
																		<a href="#" class="btn btn-default pjJlBtn pjJlBtnBordered pjJlBtnRemoveFile" style="display: none;"><?php __('front_btn_delete');?></a>
																	</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
																</div><!-- /.row pjJlAddFile -->
																<div id="pjJlFileErrorWrapper" class="help-block with-errors" style="display: none;"><ul class="list-unstyled"><li><?php __('front_cv_file_not_in_format');?></li></ul></div>
															</div>
														</div>
													</div>
													<?php
												}
											}else{ 
												?>
												<div class="row">
													<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
														<div class="form-group">
															<label><?php __('front_upload_cv'); ?></label>
															<div class="row pjJlAddFile">
																<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
																	<input type="text" class="form-control pjJlUploadedFiles" placeholder="Choose file" />
																</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
														
																<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
																	<div class="btn btn-default pjJlBtn pjJlBtnSecondary pjJlBtnUpload">
																		<?php __('front_btn_browse');?>
																													
																		<input type="file" id="pjJlCV_<?php echo $index;?>" name="cv" class="pjJlFileUploadField" data-extension="doc|docx|pdf"/>
																	</div>
																													
																	<a href="#" class="btn btn-default pjJlBtn pjJlBtnBordered pjJlBtnRemoveFile" style="display: none;"><?php __('front_btn_delete');?></a>
																</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 -->
															</div><!-- /.row pjJlAddFile -->
															<div id="pjJlFileErrorWrapper" class="help-block with-errors" style="display: none;"><ul class="list-unstyled"><li><?php __('front_cv_file_not_in_format');?></li></ul></div>
														</div>
													</div>
												</div>
												<?php
											} 
											?>
											<div class="form-group">
												<label for=""><?php __('front_label_notes'); ?>: </label>
											
												<textarea name="i18n[<?php echo $controller->getLocaleId(); ?>][notes]" rows="10" class="form-control"></textarea>
											</div><!-- /.form-group -->
											
											<div class="form-group pjJlFormGroupCaptcha">
												<div class="pjJlCaptchaImage">
													<img id="pjJlCaptchaImage_<?php echo $index;?>" src="<?php echo PJ_INSTALL_FOLDER; ?>index.php?controller=pjFront&amp;action=pjActionCaptcha&amp;rand=<?php echo rand(1, 999999); ?>" alt="" style="cursor: pointer;"/>
												</div><!-- /.pjJlCaptchaImage -->
											
												<input type="text" id="pjJlCaptchaField_<?php echo $index;?>" name="captcha" class="form-control pjJlCaptchaField required" data-msg-required="<?php echo $front_err['captcha']?>" data-msg-remote="<?php echo $front_err['captcha_inc']?>" />
												<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
											</div><!-- /.form-group pjJlFormGroupCaptcha -->
											
											<div class="pjJlFormActions">
												<button type="submit" class="btn btn-default pjJlBtn pjJlBtnPrimary"><?php __('front_button_apply');?></button>
											</div><!-- /.pjJlFormActions -->
										</form>
									</div><!-- /.pjJlForm pjJlFormApply -->
									<?php
								} 
								?>
							</div><!-- /.col-lg-9 col-md-9 col-sm-8 col-xs-12 pjJlJobContent -->
						</div><!-- /.row pjJlJobBody -->
						<?php
					}
				} 
				?>
			</div><!-- /.pjJlJob -->
		</div><!-- /.pjJlBody -->
	</div><!-- /.container-fluid pjJlContainer -->
</div><!-- /.pjWrapper -->

<?php include_once dirname(__FILE__) . '/elements/loadjs.php';?>