BEGIN;

DROP TABLE IF EXISTS `mds_members`;
CREATE TABLE IF NOT EXISTS `mds_members` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `email` varchar(255) default NULL,
  `password` blob,
  `name` varchar(255) default NULL,
  `phone` varchar(255) DEFAULT NULL,
  `age` int(3) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `country_id` varchar(255) DEFAULT NULL,
  `avatar_path` varchar(255) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `avatar_hash` varchar(255) DEFAULT NULL,
  `ip` varchar(15) default NULL,
  `facebook` varchar(255) DEFAULT NULL,
  `google` varchar(255) DEFAULT NULL,
  `linkedin` varchar(255) DEFAULT NULL,
  `twitter` varchar(255) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime default NULL,
  `status` enum('T','F') NOT NULL default 'T',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mds_members_skills`;
CREATE TABLE IF NOT EXISTS `mds_members_skills` (
  `member_id` int(10) unsigned NOT NULL,
  `skill_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`member_id`,`skill_id`),
  KEY `member_id` (`member_id`),
  KEY `skill_id` (`skill_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mds_skills`;
CREATE TABLE IF NOT EXISTS `mds_skills` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL default 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mds_passwords`;
CREATE TABLE IF NOT EXISTS `mds_passwords` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mds_fields`;
CREATE TABLE IF NOT EXISTS `mds_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mds_multi_lang`;
CREATE TABLE IF NOT EXISTS `mds_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mds_options`;
CREATE TABLE IF NOT EXISTS `mds_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mds_roles`;
CREATE TABLE IF NOT EXISTS `mds_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mds_users`;
CREATE TABLE IF NOT EXISTS `mds_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) default NULL,
  `password` blob,
  `name` varchar(255) default NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime default NULL,
  `status` enum('T','F') NOT NULL default 'T',
  `is_active` enum('T','F') NOT NULL default 'F',
  `ip` varchar(15) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `mds_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'btnAddMember', 'backend', 'Button / + Add member', 'script', NULL),
(5, 'btnAddSkill', 'backend', 'Button / + Add skill', 'script', NULL),
(6, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(7, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(8, 'btnLogin', 'backend', 'Login', 'script', NULL),
(9, 'btnSave', 'backend', 'Save', 'script', NULL),
(10, 'btnSearch', 'backend', 'Search', 'script', NULL),
(11, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(12, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(13, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(14, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(15, 'email', 'backend', 'E-Mail', 'script', NULL),
(16, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(17, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(18, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(19, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(20, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(21, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(22, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(23, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(24, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(25, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(26, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(27, 'gridEmptyBody', 'backend', 'Grid / You need to select at least a single record.', 'script', NULL),
(28, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(29, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoAddMemberDesc', 'backend', 'Infobox / Add new member', 'script', NULL),
(38, 'infoAddMemberTitle', 'backend', 'Infobox / Add new member', 'script', NULL),
(39, 'infoAddSkillDesc', 'backend', 'Infobox / Add skill description', 'script', NULL),
(40, 'infoAddSkillTitle', 'backend', 'Infobox / Add skill', 'script', NULL),
(41, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(42, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(43, 'infoAdministratorsEmailDesc', 'backend', 'Infobox / Notifications sent to administrators', 'script', NULL),
(44, 'infoAdministratorsEmailTitle', 'backend', 'Infobox / Notifications sent to administrators', 'script', NULL),
(45, 'infoAdministratorsSMSDesc', 'backend', 'Infobox / SMS sent to administrators', 'script', NULL),
(46, 'infoAdministratorsSMSTitle', 'backend', 'Infobox / SMS sent to administrators', 'script', NULL),
(47, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(48, 'infoGeneralOptionDesc', 'backend', 'Infobox / General options', 'script', NULL),
(49, 'infoGeneralOptionTitle', 'backend', 'Infobox / General options', 'script', NULL),
(50, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(51, 'infoInstallDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(52, 'infoInstallSEODESC', 'backend', 'Infobox / Install SEO description', 'script', NULL),
(53, 'infoInstallTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(54, 'infoMembersDesc', 'backend', 'Infobox / List of members', 'script', NULL),
(55, 'infoMembersEmailDesc', 'backend', 'Infobox / Email confirmation', 'script', NULL),
(56, 'infoMembersEmailTitle', 'backend', 'Infobox / Email confirmation', 'script', NULL),
(57, 'infoMembersSMSDesc', 'backend', 'Infobox / SMS confirmation', 'script', NULL),
(58, 'infoMembersSMSTitle', 'backend', 'Infobox / SMS confirmation', 'script', NULL),
(59, 'infoMembersTitle', 'backend', 'Infobox / List of members', 'script', NULL),
(60, 'infoPhotosDesc', 'backend', 'Infobox / Photos', 'script', NULL),
(61, 'infoPhotosTitle', 'backend', 'Infobox / Photos', 'script', NULL),
(62, 'infoPreviewDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(63, 'infoPreviewTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(64, 'infoSkillsDesc', 'backend', 'Infobox / List of skills', 'script', NULL),
(65, 'infoSkillsTitle', 'backend', 'Infobox / List of skills', 'script', NULL),
(66, 'infoUpdateMemberDesc', 'backend', 'Infobox / Update member', 'script', NULL),
(67, 'infoUpdateMemberTitle', 'backend', 'Infobox / Update member', 'script', NULL),
(68, 'infoUpdateSkillDesc', 'backend', 'Infobox / Update skill', 'script', NULL),
(69, 'infoUpdateSkillTitle', 'backend', 'Infobox / Update skill', 'script', NULL),
(70, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(71, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(72, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(73, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(74, 'lblAddASkill', 'backend', 'Label / Add a skill', 'script', NULL),
(75, 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
(76, 'lblAge', 'backend', 'Label / Age', 'script', NULL),
(77, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(78, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(79, 'lblAvatar', 'backend', 'Label / Avatar', 'script', NULL),
(80, 'lblBiography', 'backend', 'Label / Biography', 'script', NULL),
(81, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(82, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(83, 'lblCity', 'backend', 'Label / City', 'script', NULL),
(84, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(85, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(86, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(87, 'lblDeleteAvatar', 'backend', 'Label / Delete avatar', 'script', NULL),
(88, 'lblDeleteAvatarDesc', 'backend', 'Label / Delete avatar', 'script', NULL),
(89, 'lblEmail', 'backend', 'Label / Email', 'script', NULL),
(90, 'lblEmailInvalid', 'backend', 'Label / Email is invalid.', 'script', NULL),
(91, 'lblExport', 'backend', 'Export', 'script', NULL),
(92, 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', NULL),
(93, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(94, 'lblInstallPhp1_1', 'backend', 'Infobox / Step 1', 'script', NULL),
(95, 'lblInstallPhp1_2', 'backend', 'Infobox / Step 2', 'script', NULL),
(96, 'lblInstallPhp1_2a', 'backend', 'Install / Step 2a', 'script', NULL),
(97, 'lblInstallPhp1_3', 'backend', 'Infobox / Step 3', 'script', NULL),
(98, 'lblInstallPhpHtaccess', 'backend', 'Install / htaccess step', 'script', NULL),
(99, 'lblInstallPhpHtaccess2', 'backend', 'Install / htaccess step optional', 'script', NULL),
(100, 'lblIp', 'backend', 'IP address', 'script', NULL),
(101, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(102, 'lblMessage', 'backend', 'Label / Message', 'script', NULL),
(103, 'lblName', 'backend', 'Name', 'script', NULL),
(104, 'lblNo', 'backend', 'No', 'script', NULL),
(105, 'lblNoSkillsFound', 'backend', 'Label / There is no skills found.', 'script', NULL),
(106, 'lblOption', 'backend', 'Option', 'script', NULL),
(107, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(108, 'lblPleaseEnterDigits', 'backend', 'Label / Please enter only digits.', 'script', NULL),
(109, 'lblRole', 'backend', 'Role', 'script', NULL),
(110, 'lblSameSkillName', 'backend', 'Label / Skill name is already used.', 'script', NULL),
(111, 'lblSkill', 'backend', 'Label / Skill', 'script', NULL),
(112, 'lblState', 'backend', 'Label / State', 'script', NULL),
(113, 'lblStatus', 'backend', 'Status', 'script', NULL),
(114, 'lblSubject', 'backend', 'Label / Subject', 'script', NULL),
(115, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(116, 'lblValue', 'backend', 'Value', 'script', NULL),
(117, 'lblZip', 'backend', 'Label / Zip', 'script', NULL),
(118, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(119, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(120, 'menuCountries', 'backend', 'Menu / Countries', 'script', NULL),
(121, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(122, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(123, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(124, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(125, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(126, 'menuMembers', 'backend', 'Menu / Members', 'script', NULL),
(127, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(128, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(129, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(130, 'menuSkills', 'backend', 'Menu / Skills', 'script', NULL),
(131, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(132, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(133, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(134, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(135, 'opt_o_items_per_page', 'backend', 'Options / Members per page', 'script', NULL),
(136, 'opt_o_listing_page', 'backend', 'Options / Listing page', 'script', NULL),
(137, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(138, 'opt_o_seo_url', 'backend', 'Options / Use SEO Friendly URLs', 'script', NULL),
(139, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(140, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(141, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(142, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(143, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(144, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(145, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(146, 'pass', 'backend', 'Password', 'script', NULL),
(147, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(148, 'tabAdministrators', 'backend', 'Tab / Administrators', 'script', NULL),
(149, 'tabDetails', 'backend', 'Tab / Details', 'script', NULL),
(150, 'tabInstallListing', 'backend', 'Tab / Listing', 'script', NULL),
(151, 'tabInstallSEO', 'backend', 'Tab / SEO', 'script', NULL),
(152, 'tabMembers', 'backend', 'Tab / Members', 'script', NULL),
(153, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(154, 'tabPhotos', 'backend', 'Tab / Photos', 'script', NULL),
(155, 'front_age', 'frontend', 'Label / Age', 'script', NULL),
(156, 'front_menu_members', 'frontend', 'Label / Members', 'script', NULL),
(157, 'front_menu_register', 'frontend', 'Label / Register', 'script', NULL),
(158, 'front_menu_search_page', 'frontend', 'Label / Search page', 'script', NULL),
(159, 'front_no_members_found', 'frontend', 'Label / No members found.', 'script', NULL),
(160, 'front_paging_next', 'frontend', 'Label / Next', 'script', NULL),
(161, 'front_paging_previous', 'frontend', 'Label / Prev', 'script', NULL),
(162, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(163, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(164, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(165, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(166, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(167, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(168, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(169, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(170, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(171, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(172, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(173, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(174, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(175, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(176, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(177, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(178, 'enum_arr_ARRAY_1', 'arrays', 'enum_arr_ARRAY_1', 'script', NULL),
(179, 'enum_arr_ARRAY_2', 'arrays', 'enum_arr_ARRAY_2', 'script', NULL),
(180, 'enum_arr_ARRAY_3', 'arrays', 'enum_arr_ARRAY_3', 'script', NULL),
(181, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(182, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(183, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(184, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(185, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(186, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(187, 'error_bodies_ARRAY_AM01', 'arrays', 'error_bodies_ARRAY_AM01', 'script', NULL),
(188, 'error_bodies_ARRAY_AM03', 'arrays', 'error_bodies_ARRAY_AM03', 'script', NULL),
(189, 'error_bodies_ARRAY_AM04', 'arrays', 'error_bodies_ARRAY_AM04', 'script', NULL),
(190, 'error_bodies_ARRAY_AM05', 'arrays', 'error_bodies_ARRAY_AM05', 'script', NULL),
(191, 'error_bodies_ARRAY_AM06', 'arrays', 'error_bodies_ARRAY_AM06', 'script', NULL),
(192, 'error_bodies_ARRAY_AM08', 'arrays', 'error_bodies_ARRAY_AM08', 'script', NULL),
(193, 'error_bodies_ARRAY_AM09', 'arrays', 'error_bodies_ARRAY_AM09', 'script', NULL),
(194, 'error_bodies_ARRAY_AM10', 'arrays', 'error_bodies_ARRAY_AM10', 'script', NULL),
(195, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(196, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(197, 'error_bodies_ARRAY_AS01', 'arrays', 'error_bodies_ARRAY_AS01', 'script', NULL),
(198, 'error_bodies_ARRAY_AS03', 'arrays', 'error_bodies_ARRAY_AS03', 'script', NULL),
(199, 'error_bodies_ARRAY_AS04', 'arrays', 'error_bodies_ARRAY_AS04', 'script', NULL),
(200, 'error_bodies_ARRAY_AS08', 'arrays', 'error_bodies_ARRAY_AS08', 'script', NULL),
(201, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(202, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(203, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(204, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(205, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(206, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(207, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(208, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(209, 'error_titles_ARRAY_AM01', 'arrays', 'error_titles_ARRAY_AM01', 'script', NULL),
(210, 'error_titles_ARRAY_AM03', 'arrays', 'error_titles_ARRAY_AM03', 'script', NULL),
(211, 'error_titles_ARRAY_AM04', 'arrays', 'error_titles_ARRAY_AM04', 'script', NULL),
(212, 'error_titles_ARRAY_AM05', 'arrays', 'error_titles_ARRAY_AM05', 'script', NULL),
(213, 'error_titles_ARRAY_AM06', 'arrays', 'error_titles_ARRAY_AM06', 'script', NULL),
(214, 'error_titles_ARRAY_AM08', 'arrays', 'error_titles_ARRAY_AM08', 'script', NULL),
(215, 'error_titles_ARRAY_AM09', 'arrays', 'error_titles_ARRAY_AM09', 'script', NULL),
(216, 'error_titles_ARRAY_AM10', 'arrays', 'error_titles_ARRAY_AM10', 'script', NULL),
(217, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(218, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(219, 'error_titles_ARRAY_AS01', 'arrays', 'error_titles_ARRAY_AS01', 'script', NULL),
(220, 'error_titles_ARRAY_AS03', 'arrays', 'error_titles_ARRAY_AS03', 'script', NULL),
(221, 'error_titles_ARRAY_AS04', 'arrays', 'error_titles_ARRAY_AS04', 'script', NULL),
(222, 'error_titles_ARRAY_AS08', 'arrays', 'error_titles_ARRAY_AS08', 'script', NULL),
(223, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(224, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(225, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(226, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(227, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(228, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(229, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(230, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(231, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(232, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(233, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(234, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(235, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(236, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(237, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(238, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(239, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(240, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(241, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(242, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(243, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(244, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(245, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(246, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(247, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(248, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(249, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(250, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(251, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(252, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(253, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(254, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(255, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(256, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(257, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(258, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(259, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(260, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(261, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(262, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(263, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(264, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(265, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(266, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(267, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(268, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(269, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(270, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(271, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(272, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(273, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(274, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(275, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(276, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(277, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(278, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(279, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(280, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(281, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(282, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(283, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(284, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(285, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(286, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(287, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(288, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(289, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(290, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(291, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(292, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(293, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(294, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(295, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(296, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(297, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(298, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(299, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(300, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(301, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(302, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(303, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(304, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(305, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(306, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(307, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(308, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(309, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(310, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(311, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(312, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(313, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(314, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(315, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(489, 'lblFacebook', 'backend', 'Label / Facebook', 'script', NULL),
(490, 'lblGooglePlus', 'backend', 'Label / Google plus', 'script', NULL),
(491, 'lblLinkedin', 'backend', 'Label / Linkedin', 'script', NULL),
(492, 'lblTwitter', 'backend', 'Label / Twitter', 'script', NULL),
(493, 'lblNoAccessToFeed', 'backend', 'Label / No access to feed.', 'script', NULL),
(494, 'infoExportMembersTitle', 'backend', 'Infobox / Export members', 'script', NULL),
(495, 'infoExportMembersDesc', 'backend', 'Infobox / Export members', 'script', NULL),
(496, 'lblType', 'backend', 'Label / Type', 'script', NULL),
(497, 'lblMemberCreated', 'backend', 'Label / Member created', 'script', NULL),
(498, 'btnGetFeedURL', 'backend', 'Label / Get Feed URL', 'script', NULL),
(499, 'infoMembersFeedTitle', 'backend', 'Infobox / Members Feed URL', 'script', NULL),
(500, 'infoMembersFeedDesc', 'backend', 'Infobox / Members Feed URL', 'script', NULL),
(501, 'export_formats_ARRAY_xml', 'arrays', 'export_formats_ARRAY_xml', 'script', NULL),
(502, 'export_formats_ARRAY_csv', 'arrays', 'export_formats_ARRAY_csv', 'script', NULL),
(503, 'export_types_ARRAY_file', 'arrays', 'export_types_ARRAY_file', 'script', NULL),
(504, 'export_types_ARRAY_feed', 'arrays', 'export_types_ARRAY_feed', 'script', NULL),
(505, 'lblFormat', 'backend', 'Label / Format', 'script', NULL),
(506, 'lblEnterPassword', 'backend', 'Label / Enter password', 'script', NULL),
(507, 'made_arr_ARRAY_1', 'arrays', 'made_arr_ARRAY_1', 'script', NULL),
(508, 'made_arr_ARRAY_2', 'arrays', 'made_arr_ARRAY_2', 'script', NULL),
(509, 'made_arr_ARRAY_3', 'arrays', 'made_arr_ARRAY_3', 'script', NULL),
(510, 'made_arr_ARRAY_4', 'arrays', 'made_arr_ARRAY_4', 'script', NULL),
(511, 'made_arr_ARRAY_5', 'arrays', 'made_arr_ARRAY_5', 'script', NULL),
(512, 'made_arr_ARRAY_6', 'arrays', 'made_arr_ARRAY_6', 'script', NULL),
(513, 'lblImport', 'backend', 'Label / Import', 'script', NULL),
(514, 'error_bodies_ARRAY_AM21', 'arrays', 'error_bodies_ARRAY_AM21', 'script', NULL),
(515, 'error_titles_ARRAY_AM11', 'arrays', 'error_titles_ARRAY_AM11', 'script', NULL),
(516, 'error_titles_ARRAY_AM22', 'arrays', 'error_titles_ARRAY_AM22', 'script', NULL),
(517, 'error_bodies_ARRAY_AM22', 'arrays', 'error_bodies_ARRAY_AM22', 'script', NULL),
(518, 'error_titles_ARRAY_AM20', 'arrays', 'error_titles_ARRAY_AM20', 'script', NULL),
(519, 'error_bodies_ARRAY_AM20', 'arrays', 'error_bodies_ARRAY_AM20', 'script', NULL),
(520, 'error_titles_ARRAY_AM23', 'arrays', 'error_titles_ARRAY_AM23', 'script', NULL),
(521, 'error_bodies_ARRAY_AM23', 'arrays', 'error_bodies_ARRAY_AM23', 'script', NULL),
(522, 'error_titles_ARRAY_AM21', 'arrays', 'error_titles_ARRAY_AM21', 'script', NULL),
(523, 'error_bodies_ARRAY_AM11', 'arrays', 'error_bodies_ARRAY_AM11', 'script', NULL),
(524, 'error_titles_ARRAY_AM12', 'arrays', 'error_titles_ARRAY_AM12', 'script', NULL),
(525, 'error_bodies_ARRAY_AM12', 'arrays', 'error_bodies_ARRAY_AM12', 'script', NULL),
(526, 'import_sources_ARRAY_csv', 'arrays', 'import_sources_ARRAY_csv', 'script', NULL),
(527, 'import_sources_ARRAY_excel', 'arrays', 'import_sources_ARRAY_excel', 'script', NULL),
(528, 'infoImportTitle', 'backend', 'Infobox / Import title', 'script', NULL),
(529, 'infoImportBody', 'backend', 'Infobox / Import body', 'script', NULL),
(530, 'lblSource', 'backend', 'Label / Source', 'script', NULL),
(531, 'lblCSVFile', 'backend', 'Label / CSV File', 'script', NULL),
(532, 'lblMembers', 'backend', 'Label / Members', 'script', NULL),
(533, 'lblUpdateMembers', 'backend', 'Label / Update members', 'script', NULL),
(534, 'btnImport', 'backend', 'Button / Import', 'script', NULL),
(535, 'lblCSVAllowed', 'backend', 'Label / Only csv files are allowed.', 'script', NULL),
(536, 'front_skills', 'frontend', 'Label / Skills', 'script', NULL),
(537, 'front_bio', 'frontend', 'Label / Bio', 'script', NULL),
(538, 'front_photos', 'frontend', 'Label / Photos', 'script', NULL),
(539, 'lblRegistrationEmail', 'backend', 'Label / Registration email', 'script', NULL),
(540, 'lblPasswordRecoveryEmail', 'backend', 'Label / Password recovery email', 'script', NULL),
(541, 'front_err_ARRAY_REG14', 'arrays', 'front_err_ARRAY_REG14', 'script', NULL),
(542, 'front_email_in_used', 'frontend', 'Label / Email is already used.', 'script', NULL),
(543, 'front_err_ARRAY_FOR01', 'arrays', 'front_err_ARRAY_FOR01', 'script', NULL),
(544, 'front_err_ARRAY_FOR02', 'arrays', 'front_err_ARRAY_FOR02', 'script', NULL),
(545, 'front_err_ARRAY_FOR03', 'arrays', 'front_err_ARRAY_FOR03', 'script', NULL),
(546, 'front_err_ARRAY_FOR04', 'arrays', 'front_err_ARRAY_FOR04', 'script', NULL),
(547, 'front_msg_ARRAY_FOR01', 'arrays', 'front_msg_ARRAY_FOR01', 'script', NULL),
(548, 'front_forgot_password_notes', 'frontend', 'Label / Forgot password notes', 'script', NULL),
(549, 'front_btn_send', 'frontend', 'Button / Send', 'script', NULL),
(550, 'front_login', 'frontend', 'Label / Login', 'script', NULL),
(551, 'front_err_ARRAY_LOG01', 'arrays', 'front_err_ARRAY_LOG01', 'script', NULL),
(552, 'front_err_ARRAY_LOG02', 'arrays', 'front_err_ARRAY_LOG02', 'script', NULL),
(553, 'front_err_ARRAY_LOG03', 'arrays', 'front_err_ARRAY_LOG03', 'script', NULL),
(554, 'front_err_ARRAY_LOG04', 'arrays', 'front_err_ARRAY_LOG04', 'script', NULL),
(555, 'front_err_ARRAY_LOG05', 'arrays', 'front_err_ARRAY_LOG05', 'script', NULL),
(556, 'front_err_ARRAY_LOG06', 'arrays', 'front_err_ARRAY_LOG06', 'script', NULL),
(557, 'front_err_ARRAY_LOG07', 'arrays', 'front_err_ARRAY_LOG07', 'script', NULL),
(558, 'front_menu_profile', 'frontend', 'Menu / Profile', 'script', NULL),
(559, 'front_menu_logout', 'frontend', 'Menu / Logout', 'script', NULL),
(560, 'front_your_profile', 'frontend', 'Label / Your profile', 'script', NULL),
(561, 'front_btn_save', 'frontend', 'Button / Save', 'script', NULL),
(562, 'front_tab_details', 'frontend', 'Tab / Details', 'script', NULL),
(563, 'front_tab_photos', 'frontend', 'Tab / Photos', 'script', NULL),
(564, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(565, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(566, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(567, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(568, 'front_biography', 'frontend', 'Label / Biography', 'script', NULL),
(569, 'front_facebook', 'frontend', 'Label / Facebook', 'script', NULL),
(570, 'front_google_plus', 'frontend', 'Label / Google plus', 'script', NULL),
(571, 'front_linkedin', 'frontend', 'Label / Linkedin', 'script', NULL),
(572, 'front_twitter', 'frontend', 'Label / Twitter', 'script', NULL),
(573, 'front_avatar', 'frontend', 'Label / Avatar', 'script', NULL),
(574, 'front_delete', 'frontend', 'Label / delete', 'script', NULL),
(575, 'front_delete_avatar_confirm', 'frontend', 'Label / delete avatar confirm', 'script', NULL),
(576, 'front_btn_close', 'frontend', 'Button / Close', 'script', NULL),
(577, 'front_btn_delete', 'frontend', 'Button / Delete', 'script', NULL),
(578, 'front_err_ARRAY_PRO01', 'arrays', 'front_err_ARRAY_PRO01', 'script', NULL),
(579, 'front_err_ARRAY_PRO02', 'arrays', 'front_err_ARRAY_PRO02', 'script', NULL),
(580, 'front_msg_ARRAY_PRO01', 'arrays', 'front_msg_ARRAY_PRO01', 'script', NULL),
(581, 'front_btn_upload', 'frontend', 'Button / Upload', 'script', NULL),
(582, 'front_photo', 'frontend', 'Label / Photo', 'script', NULL),
(583, 'front_upload_processing', 'frontend', 'Label / Photo upload processing', 'script', NULL),
(584, 'front_upload_err_ARRAY_100', 'arrays', 'front_upload_err_ARRAY_100', 'script', NULL),
(585, 'front_upload_err_ARRAY_101', 'arrays', 'front_upload_err_ARRAY_101', 'script', NULL),
(586, 'front_upload_err_ARRAY_102', 'arrays', 'front_upload_err_ARRAY_102', 'script', NULL),
(587, 'front_upload_err_ARRAY_103', 'arrays', 'front_upload_err_ARRAY_103', 'script', NULL),
(588, 'front_upload_err_ARRAY_104', 'arrays', 'front_upload_err_ARRAY_104', 'script', NULL),
(589, 'front_upload_err_ARRAY_200', 'arrays', 'front_upload_err_ARRAY_200', 'script', NULL),
(590, 'front_delete_photo_confirm', 'frontend', 'Label / Delete photo confirmation', 'script', NULL),
(591, 'front_menu_back', 'frontend', 'Label / Back', 'script', NULL),
(592, 'front_search_members', 'frontend', 'Label / Search members', 'script', NULL),
(593, 'front_member_name', 'frontend', 'Label / Member name', 'script', NULL),
(594, 'front_select', 'frontend', 'Label / Select', 'script', NULL),
(595, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(596, 'front_email_address', 'frontend', 'Label / Email address', 'script', NULL),
(597, 'front_btn_search', 'frontend', 'Button / Search', 'script', NULL),
(598, 'front_login_to_your_account', 'frontend', 'Label / Login to your account', 'script', NULL),
(599, 'front_login_notes', 'frontend', 'Label / Login notes', 'script', NULL),
(600, 'front_field_required', 'frontend', 'Label / This field is required.', 'script', NULL),
(601, 'front_email_invalid', 'frontend', 'Label / Email is invalid.', 'script', NULL),
(602, 'front_password', 'frontend', 'Label / Password', 'script', NULL),
(603, 'front_btn_login', 'frontend', 'Button / Login', 'script', NULL),
(604, 'front_forgot_password', 'frontend', 'Label / Forgot password?', 'script', NULL),
(605, 'front_create_an_account', 'frontend', 'Label / Create an Account', 'script', NULL),
(606, 'front_create_an_account_notes', 'frontend', 'Label / Create an account notes', 'script', NULL),
(607, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(608, 'front_reenter_password', 'frontend', 'Label / Re-enter password', 'script', NULL),
(609, 'front_password_not_match', 'frontend', 'Label / Password does not match.', 'script', NULL),
(610, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(611, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(612, 'front_captcha_incorrect', 'frontend', 'Label / Captcha is incorrect.', 'script', NULL),
(613, 'front_btn_register', 'frontend', 'Button / Register', 'script', NULL),
(614, 'front_err_ARRAY_REG01', 'arrays', 'front_err_ARRAY_REG01', 'script', NULL),
(615, 'front_err_ARRAY_REG02', 'arrays', 'front_err_ARRAY_REG02', 'script', NULL),
(616, 'front_err_ARRAY_REG03', 'arrays', 'front_err_ARRAY_REG03', 'script', NULL),
(617, 'front_err_ARRAY_REG04', 'arrays', 'front_err_ARRAY_REG04', 'script', NULL),
(618, 'front_err_ARRAY_REG05', 'arrays', 'front_err_ARRAY_REG05', 'script', NULL),
(619, 'front_err_ARRAY_REG06', 'arrays', 'front_err_ARRAY_REG06', 'script', NULL),
(620, 'front_err_ARRAY_REG07', 'arrays', 'front_err_ARRAY_REG07', 'script', NULL),
(621, 'front_err_ARRAY_REG08', 'arrays', 'front_err_ARRAY_REG08', 'script', NULL),
(622, 'front_err_ARRAY_REG09', 'arrays', 'front_err_ARRAY_REG09', 'script', NULL),
(623, 'front_err_ARRAY_REG10', 'arrays', 'front_err_ARRAY_REG10', 'script', NULL),
(624, 'front_err_ARRAY_REG11', 'arrays', 'front_err_ARRAY_REG11', 'script', NULL),
(625, 'front_err_ARRAY_REG12', 'arrays', 'front_err_ARRAY_REG12', 'script', NULL),
(626, 'front_err_ARRAY_REG13', 'arrays', 'front_err_ARRAY_REG13', 'script', NULL),
(627, 'front_msg_ARRAY_REG01', 'arrays', 'front_msg_ARRAY_REG01', 'script', NULL),
(628, 'front_err_ARRAY_FOR05', 'arrays', 'front_err_ARRAY_FOR05', 'script', NULL);

INSERT INTO `mds_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', '+ Add member', 'script'),
(NULL, 4, 'pjField', 2, 'title', '+ Add member', 'script'),
(NULL, 4, 'pjField', 3, 'title', '+ Add member', 'script'),
(NULL, 5, 'pjField', 1, 'title', '+ Add skill', 'script'),
(NULL, 5, 'pjField', 2, 'title', '+ Add skill', 'script'),
(NULL, 5, 'pjField', 3, 'title', '+ Add skill', 'script'),
(NULL, 6, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 6, 'pjField', 2, 'title', '+ Add user', 'script'),
(NULL, 6, 'pjField', 3, 'title', '+ Add user', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Use this theme', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Use this theme', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Member with such email address exists.', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Member with such email address exists.', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Member with such email address exists.', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records selected', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records selected', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next ', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next ', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next ', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', 'Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', 'Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Fill in the form below and click on "Save" button to add new member. Once added you can upload photos too.', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'Fill in the form below and click on "Save" button to add new member. Once added you can upload photos too.', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'Fill in the form below and click on "Save" button to add new member. Once added you can upload photos too.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Add new member', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Add new member', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Add new member', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Fill in the skill name and click "Save" button to add new skill.', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Fill in the skill name and click "Save" button to add new skill.', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Fill in the skill name and click "Save" button to add new skill.', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Add skill', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Add skill', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Add skill', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'You can add a new administrator who has full access to the backend system and can add other users; or an editor.', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'You can add a new administrator who has full access to the backend system and can add other users; or an editor.', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'You can add a new administrator who has full access to the backend system and can add other users; or an editor.', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Send an email notifications to the administrator when new registration is made. You can use the available tokens to personalize the messages.', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Send an email notifications to the administrator when new registration is made. You can use the available tokens to personalize the messages.', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Send an email notifications to the administrator when new registration is made. You can use the available tokens to personalize the messages.', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Notifications sent to administrators', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Notifications sent to administrators', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Notifications sent to administrators', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Here you can set SMS sent to administrators after new registration made. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Here you can set SMS sent to administrators after new registration made. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Here you can set SMS sent to administrators after new registration made. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'SMS sent to administrators', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'SMS sent to administrators', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'SMS sent to administrators', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Here you can set the General options for the Menu Builder.', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Here you can set the General options for the Menu Builder.', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Here you can set the General options for the Menu Builder.', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Set general settings for the Member Directory script.', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Set general settings for the Member Directory script.', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Set general settings for the Member Directory script.', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'General options', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'General options', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'General options', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'General options', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Follow these steps to put member directory on your .php web page using PHP include code:', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Follow these steps to put member directory on your .php web page using PHP include code:', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Follow these steps to put member directory on your .php web page using PHP include code:', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your members.', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your members.', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your members.', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Install code', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Install code', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Below you can find list with all members. If you want to add new member, click on the button "+ Add member". You can also view more information about specific member or delete it.', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Below you can find list with all members. If you want to add new member, click on the button "+ Add member". You can also view more information about specific member or delete it.', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Below you can find list with all members. If you want to add new member, click on the button "+ Add member". You can also view more information about specific member or delete it.', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Set an auto responder message which will be sent to the member once a new registration is made. You can use the available tokens to personalize the messages.', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Set an auto responder message which will be sent to the member once a new registration is made. You can use the available tokens to personalize the messages.', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Set an auto responder message which will be sent to the member once a new registration is made. You can use the available tokens to personalize the messages.', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Email confirmation', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Email confirmation', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Email confirmation', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Set an SMS auto responder message which will be sent to the member once a new registration is made. You can use the available tokens to personalize the messages.', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Set an SMS auto responder message which will be sent to the member once a new registration is made. You can use the available tokens to personalize the messages.', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Set an SMS auto responder message which will be sent to the member once a new registration is made. You can use the available tokens to personalize the messages.', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'SMS confirmation', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'SMS confirmation', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'SMS confirmation', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'List of members', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'List of members', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'List of members', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Upload as many images as you want for this member. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Upload as many images as you want for this member. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Upload as many images as you want for this member. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Photos', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Photos', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use. ', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use. ', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use. ', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Preview front end', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Preview front end', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Below you can find the list of defined skills. If you want to add new skill, click on the button "+ Add skill". You also click on the pencil icon on the corresponding entry to edit a skill.', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'Below you can find the list of defined skills. If you want to add new skill, click on the button "+ Add skill". You also click on the pencil icon on the corresponding entry to edit a skill.', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'Below you can find the list of defined skills. If you want to add new skill, click on the button "+ Add skill". You also click on the pencil icon on the corresponding entry to edit a skill.', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'List of skills', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'List of skills', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'List of skills', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'You can make changes on the form below and click "Save" button to update member information.', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'You can make changes on the form below and click "Save" button to update member information.', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'You can make changes on the form below and click "Save" button to update member information.', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Update member', 'script'),
(NULL, 67, 'pjField', 2, 'title', 'Update member', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'Update member', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Make changes on the skill name and click "Save" button to update the skill.', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Make changes on the skill name and click "Save" button to update the skill.', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Make changes on the skill name and click "Save" button to update the skill.', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Update skill', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Update skill', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Update skill', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'You can make any change to the form below. Just click "Save" to update the user information.', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'You can make any change to the form below. Just click "Save" to update the user information.', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'You can make any change to the form below. Just click "Save" to update the user information.', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Below you can see all users who have access to the Member Directory admin panel. There are two types of users - Administrators and Editors. Click on "+ Add user" to add a new user.', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Below you can see all users who have access to the Member Directory admin panel. There are two types of users - Administrators and Editors. Click on "+ Add user" to add a new user.', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Below you can see all users who have access to the Member Directory admin panel. There are two types of users - Administrators and Editors. Click on "+ Add user" to add a new user.', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Add a skill', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Add a skill', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Add a skill', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Age', 'script'),
(NULL, 76, 'pjField', 2, 'title', 'Age', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Age', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'All', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'All', 'script'),
(NULL, 78, 'pjField', 1, 'title', '<div class="float_left w350">\r\n{Name} - Member name;<br/>\r\n{Email} - Member e-mail address;<br/>\r\n{Password} - Member password;<br/>\r\n{Phone} - Phone number;<br/>\r\n</div>\r\n<div class="float_left w350">\r\n{Address} - Member address;<br/>\r\n{City} - City;<br/>\r\n{State} - State;<br/>\r\n{Zip} - Zip;<br/>\r\n{Country} - Country\r\n</div>', 'script'),
(NULL, 78, 'pjField', 2, 'title', '<div class="float_left w350">\r\n{Name} - Member name;<br/>\r\n{Email} - Member e-mail address;<br/>\r\n{Password} - Member password;<br/>\r\n{Phone} - Phone number;<br/>\r\n</div>\r\n<div class="float_left w350">\r\n{Address} - Member address;<br/>\r\n{City} - City;<br/>\r\n{State} - State;<br/>\r\n{Zip} - Zip;<br/>\r\n{Country} - Country\r\n</div>', 'script'),
(NULL, 78, 'pjField', 3, 'title', '<div class="float_left w350">\r\n{Name} - Member name;<br/>\r\n{Email} - Member e-mail address;<br/>\r\n{Password} - Member password;<br/>\r\n{Phone} - Phone number;<br/>\r\n</div>\r\n<div class="float_left w350">\r\n{Address} - Member address;<br/>\r\n{City} - City;<br/>\r\n{State} - State;<br/>\r\n{Zip} - Zip;<br/>\r\n{Country} - Country\r\n</div>', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Avatar', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Avatar', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Avatar', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Biography', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Biography', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Biography', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Choose theme', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Choose theme', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Choose theme', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Currently in use', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Currently in use', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Last login', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Last login', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Delete avatar', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Delete avatar', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Delete avatar', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Are you sure that you want to delete the avatar?', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Are you sure that you want to delete the avatar?', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Are you sure that you want to delete the avatar?', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Email is invalid.', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Email is invalid.', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Step 2. Copy and paste the code below into your html code, where the listing will be displayed.', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Step 2. Copy and paste the code below into your html code, where the listing will be displayed.', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Step 2. Copy and paste the code below into your html code, where the listing will be displayed.', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Create a file named ".htaccess" in the same directory where your .php page with listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'Create a file named ".htaccess" in the same directory where your .php page with listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'Create a file named ".htaccess" in the same directory where your .php page with listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 99, 'pjField', 1, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 99, 'pjField', 2, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 99, 'pjField', 3, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Is confirmed', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Is confirmed', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'Message', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'Message', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 104, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 104, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'There is no skills found.', 'script'),
(NULL, 105, 'pjField', 2, 'title', 'There is no skills found.', 'script'),
(NULL, 105, 'pjField', 3, 'title', 'There is no skills found.', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 106, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 106, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 107, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 107, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Please enter only digits.', 'script'),
(NULL, 108, 'pjField', 2, 'title', 'Please enter only digits.', 'script'),
(NULL, 108, 'pjField', 3, 'title', 'Please enter only digits.', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 109, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 109, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Skill name is already used.', 'script'),
(NULL, 110, 'pjField', 2, 'title', 'Skill name is already used.', 'script'),
(NULL, 110, 'pjField', 3, 'title', 'Skill name is already used.', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Skill', 'script'),
(NULL, 111, 'pjField', 2, 'title', 'Skill', 'script'),
(NULL, 111, 'pjField', 3, 'title', 'Skill', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 112, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 112, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 113, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 113, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 114, 'pjField', 2, 'title', 'Subject', 'script'),
(NULL, 114, 'pjField', 3, 'title', 'Subject', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 115, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 115, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 116, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 116, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 117, 'pjField', 2, 'title', 'Zip', 'script'),
(NULL, 117, 'pjField', 3, 'title', 'Zip', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 118, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 118, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 119, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 119, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Countries', 'script'),
(NULL, 120, 'pjField', 2, 'title', 'Countries', 'script'),
(NULL, 120, 'pjField', 3, 'title', 'Countries', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 121, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 121, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 122, 'pjField', 2, 'title', 'General', 'script'),
(NULL, 122, 'pjField', 3, 'title', 'General', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 123, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 123, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 124, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 124, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Members', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'Members', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'Members', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Skills', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Skills', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Skills', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Members per page', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Members per page', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Members per page', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Enter web address for the web page where listing is put', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'Enter web address for the web page where listing is put', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'Enter web address for the web page where listing is put', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'Time format', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'Time format', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Administrators', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'Administrators', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'Administrators', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'Details', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'Details', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Listing', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'Listing', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'Listing', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'SEO', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'SEO', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'SEO', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Members', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'Members', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'Members', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'Notifications', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'Notifications', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 154, 'pjField', 2, 'title', 'Photos', 'script'),
(NULL, 154, 'pjField', 3, 'title', 'Photos', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Age', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'Age', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'Age', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Members', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'Members', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'Members', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Login / Register', 'script'),
(NULL, 157, 'pjField', 2, 'title', 'Login / Register', 'script'),
(NULL, 157, 'pjField', 3, 'title', 'Login / Register', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 158, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 158, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'No members found.', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'No members found.', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'No members found.', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Next', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Next', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Next', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Prev', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Prev', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 172, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 172, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 173, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 173, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Yes (required)', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'Yes (required)', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'Yes (required)', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'PHP mail()', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'PHP mail()', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'SMTP', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'SMTP', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Changes made on the member have been saved.', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'Changes made on the member have been saved.', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'Changes made on the member have been saved.', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Member has been added into the system.', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'Member has been added into the system.', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'Member has been added into the system.', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Member could not be added. Please try again.', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'Member could not be added. Please try again.', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'Member could not be added. Please try again.', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Member could not be added because the post content is greater than {MAXSIZE}.', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'Member could not be added because the post content is greater than {MAXSIZE}.', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'Member could not be added because the post content is greater than {MAXSIZE}.', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Member has been added, but the avatar could not be uploaded correctly. Please check the file again.', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'Member has been added, but the avatar could not be uploaded correctly. Please check the file again.', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'Member has been added, but the avatar could not be uploaded correctly. Please check the file again.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Member you are looking for is missing. Please try again.', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'Member you are looking for is missing. Please try again.', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'Member you are looking for is missing. Please try again.', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Member could not be updated because the post content is greater than {MAXSIZE}. Please try again.', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'Member could not be updated because the post content is greater than {MAXSIZE}. Please try again.', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'Member could not be updated because the post content is greater than {MAXSIZE}. Please try again.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Changes made on the member have been saved, but the avatar could not be uploaded. Please try again.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Changes made on the member have been saved, but the avatar could not be uploaded. Please try again.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Changes made on the member have been saved, but the avatar could not be uploaded. Please try again.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Changes made to notifications email have been saved.', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'Changes made to notifications email have been saved.', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'Changes made to notifications email have been saved.', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Changes made on the selected skills have been saved.', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'Changes made on the selected skills have been saved.', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'Changes made on the selected skills have been saved.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Skill has been added into the system.', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Skill has been added into the system.', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Skill has been added into the system.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Skill could not be added. Please try again.', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Skill could not be added. Please try again.', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Skill could not be added. Please try again.', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Skill you are looking for is missing. Please try again.', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Skill you are looking for is missing. Please try again.', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Skill you are looking for is missing. Please try again.', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Member updated!', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'Member updated!', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'Member updated!', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Member added!', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'Member added!', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'Member added!', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Member not added!', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'Member not added!', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'Member not added!', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Member not added!', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'Member not added!', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'Member not added!', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Member added!', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Member added!', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Member added!', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Member not found!', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Member not found!', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Member not found!', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Member not updated!', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'Member not updated!', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'Member not updated!', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Member updated!', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'Member updated!', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'Member updated!', 'script');
INSERT INTO `mds_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 217, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'Notifications updated!', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'Notifications updated!', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Skill updated!', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'Skill updated!', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'Skill updated!', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Skill added!', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'Skill added!', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'Skill added!', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Skill not added!', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'Skill not added!', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'Skill not added!', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Skill not found!', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'Skill not found!', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'Skill not found!', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'Theme 1', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'Theme 1', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'Theme 10', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'Theme 10', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'Theme 2', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'Theme 2', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'Theme 3', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'Theme 3', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'Theme 4', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'Theme 4', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'Theme 5', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'Theme 5', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 250, 'pjField', 2, 'title', 'Theme 6', 'script'),
(NULL, 250, 'pjField', 3, 'title', 'Theme 6', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'Theme 7', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'Theme 7', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'Theme 8', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'Theme 8', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 253, 'pjField', 2, 'title', 'Theme 9', 'script'),
(NULL, 253, 'pjField', 3, 'title', 'Theme 9', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 254, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 254, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 255, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 255, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 256, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 256, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 257, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 257, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 258, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 258, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 259, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 259, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 260, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 260, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 261, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 261, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 262, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 262, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 263, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 263, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 264, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 264, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 265, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 265, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 266, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 266, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 267, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 267, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 268, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 268, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 269, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 269, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 270, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 270, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 271, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 271, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 272, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 272, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 273, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 273, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 274, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 274, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 275, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 275, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 276, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 276, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 277, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 277, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 278, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 278, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 279, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 279, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 280, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 280, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 281, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 281, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 282, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 282, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 283, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 283, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 284, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 284, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 285, 'pjField', 2, 'title', 'Your registration was successfull.', 'script'),
(NULL, 285, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 286, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 286, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 287, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 287, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 288, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 288, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 289, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 289, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 290, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 290, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 291, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 291, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 292, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 292, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 293, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 293, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 294, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 294, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 295, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 295, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 296, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 296, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 297, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 297, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 298, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 298, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 299, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 299, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 300, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 300, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 301, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 301, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 302, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 302, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 303, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 303, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 304, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 304, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 305, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 305, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 306, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 306, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 307, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 307, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 308, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 308, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 309, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 309, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 310, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 310, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 311, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 311, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 312, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 312, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 313, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 313, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 314, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 314, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 315, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 315, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Facebook', 'script'),
(NULL, 489, 'pjField', 2, 'title', 'Facebook', 'script'),
(NULL, 489, 'pjField', 3, 'title', 'Facebook', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Google plus', 'script'),
(NULL, 490, 'pjField', 2, 'title', 'Google plus', 'script'),
(NULL, 490, 'pjField', 3, 'title', 'Google plus', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Linkedin', 'script'),
(NULL, 491, 'pjField', 2, 'title', 'Linkedin', 'script'),
(NULL, 491, 'pjField', 3, 'title', 'Linkedin', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Twitter', 'script'),
(NULL, 492, 'pjField', 2, 'title', 'Twitter', 'script'),
(NULL, 492, 'pjField', 3, 'title', 'Twitter', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'No access to feed.', 'script'),
(NULL, 493, 'pjField', 2, 'title', 'No access to feed.', 'script'),
(NULL, 493, 'pjField', 3, 'title', 'No access to feed.', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Export members'' profiles', 'script'),
(NULL, 494, 'pjField', 2, 'title', 'Export members'' profiles', 'script'),
(NULL, 494, 'pjField', 3, 'title', 'Export members'' profiles', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'You can export members'' details in different formats. You can either download a file with members'' details or use a link for a feed which load all the members'' profiles.', 'script'),
(NULL, 495, 'pjField', 2, 'title', 'You can export members'' details in different formats. You can either download a file with members'' details or use a link for a feed which load all the members'' profiles.', 'script'),
(NULL, 495, 'pjField', 3, 'title', 'You can export members'' details in different formats. You can either download a file with members'' details or use a link for a feed which load all the members'' profiles.', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 496, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 496, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Member created', 'script'),
(NULL, 497, 'pjField', 2, 'title', 'Member created', 'script'),
(NULL, 497, 'pjField', 3, 'title', 'Member created', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Get Feed URL', 'script'),
(NULL, 498, 'pjField', 2, 'title', 'Get Feed URL', 'script'),
(NULL, 498, 'pjField', 3, 'title', 'Get Feed URL', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Members Feed URL', 'script'),
(NULL, 499, 'pjField', 2, 'title', 'Members Feed URL', 'script'),
(NULL, 499, 'pjField', 3, 'title', 'Members Feed URL', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Use the URL below to have access to all members. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 500, 'pjField', 2, 'title', 'Use the URL below to have access to all members. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 500, 'pjField', 3, 'title', 'Use the URL below to have access to all members. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'XML', 'script'),
(NULL, 501, 'pjField', 2, 'title', 'XML', 'script'),
(NULL, 501, 'pjField', 3, 'title', 'XML', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'CSV', 'script'),
(NULL, 502, 'pjField', 2, 'title', 'CSV', 'script'),
(NULL, 502, 'pjField', 3, 'title', 'CSV', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'File', 'script'),
(NULL, 503, 'pjField', 2, 'title', 'File', 'script'),
(NULL, 503, 'pjField', 3, 'title', 'File', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Feed', 'script'),
(NULL, 504, 'pjField', 2, 'title', 'Feed', 'script'),
(NULL, 504, 'pjField', 3, 'title', 'Feed', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Format', 'script'),
(NULL, 505, 'pjField', 2, 'title', 'Format', 'script'),
(NULL, 505, 'pjField', 3, 'title', 'Format', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Enter password', 'script'),
(NULL, 506, 'pjField', 2, 'title', 'Enter password', 'script'),
(NULL, 506, 'pjField', 3, 'title', 'Enter password', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 507, 'pjField', 2, 'title', 'Today', 'script'),
(NULL, 507, 'pjField', 3, 'title', 'Today', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Yesterday', 'script'),
(NULL, 508, 'pjField', 2, 'title', 'Yesterday', 'script'),
(NULL, 508, 'pjField', 3, 'title', 'Yesterday', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'This week', 'script'),
(NULL, 509, 'pjField', 2, 'title', 'This week', 'script'),
(NULL, 509, 'pjField', 3, 'title', 'This week', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Last week', 'script'),
(NULL, 510, 'pjField', 2, 'title', 'Last week', 'script'),
(NULL, 510, 'pjField', 3, 'title', 'Last week', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'This month', 'script'),
(NULL, 511, 'pjField', 2, 'title', 'This month', 'script'),
(NULL, 511, 'pjField', 3, 'title', 'This month', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Last month', 'script'),
(NULL, 512, 'pjField', 2, 'title', 'Last month', 'script'),
(NULL, 512, 'pjField', 3, 'title', 'Last month', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Import', 'script'),
(NULL, 513, 'pjField', 2, 'title', 'Import', 'script'),
(NULL, 513, 'pjField', 3, 'title', 'Import', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Importing cannot be processed because of invalid data. ', 'script'),
(NULL, 514, 'pjField', 2, 'title', 'Importing cannot be processed because of invalid data. ', 'script'),
(NULL, 514, 'pjField', 3, 'title', 'Importing cannot be processed because of invalid data. ', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'CSV file missing', 'script'),
(NULL, 515, 'pjField', 2, 'title', 'CSV file missing', 'script'),
(NULL, 515, 'pjField', 3, 'title', 'CSV file missing', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'File type error', 'script'),
(NULL, 516, 'pjField', 2, 'title', 'File type error', 'script'),
(NULL, 516, 'pjField', 3, 'title', 'File type error', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 517, 'pjField', 2, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 517, 'pjField', 3, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Members updated', 'script'),
(NULL, 518, 'pjField', 2, 'title', 'Members updated', 'script'),
(NULL, 518, 'pjField', 3, 'title', 'Members updated', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Members pasted from Excel have been updated.', 'script'),
(NULL, 519, 'pjField', 2, 'title', 'Members pasted from Excel have been updated.', 'script'),
(NULL, 519, 'pjField', 3, 'title', 'Members pasted from Excel have been updated.', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Member imported', 'script'),
(NULL, 520, 'pjField', 2, 'title', 'Member imported', 'script'),
(NULL, 520, 'pjField', 3, 'title', 'Member imported', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'Member list has been imported successfully.', 'script'),
(NULL, 521, 'pjField', 2, 'title', 'Member list has been imported successfully.', 'script'),
(NULL, 521, 'pjField', 3, 'title', 'Member list has been imported successfully.', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Members data invalid', 'script'),
(NULL, 522, 'pjField', 2, 'title', 'Members data invalid', 'script'),
(NULL, 522, 'pjField', 3, 'title', 'Members data invalid', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'Importing members could not be process because of missing of CSV file.', 'script'),
(NULL, 523, 'pjField', 2, 'title', 'Importing members could not be process because of missing of CSV file.', 'script'),
(NULL, 523, 'pjField', 3, 'title', 'Importing members could not be process because of missing of CSV file.', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Members updated', 'script'),
(NULL, 524, 'pjField', 2, 'title', 'Members updated', 'script'),
(NULL, 524, 'pjField', 3, 'title', 'Members updated', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'Members in CSV file have been updated.', 'script'),
(NULL, 525, 'pjField', 2, 'title', 'Members in CSV file have been updated.', 'script'),
(NULL, 525, 'pjField', 3, 'title', 'Members in CSV file have been updated.', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'upload CSV file', 'script'),
(NULL, 526, 'pjField', 2, 'title', 'upload CSV file', 'script'),
(NULL, 526, 'pjField', 3, 'title', 'upload CSV file', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'copy/paste from Excel', 'script'),
(NULL, 527, 'pjField', 2, 'title', 'copy/paste from Excel', 'script'),
(NULL, 527, 'pjField', 3, 'title', 'copy/paste from Excel', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Import members', 'script'),
(NULL, 528, 'pjField', 2, 'title', 'Import members', 'script'),
(NULL, 528, 'pjField', 3, 'title', 'Import members', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'You can either upload a CSV file with your members or copy/paste from Excel. If you check "Update members" then members who are already in your list will be updated with the new data provided. Otherwise each new member will be added to the list and duplicates may be possible. Sample CSV file can be found <a href="import-sample.csv">here</a>.', 'script'),
(NULL, 529, 'pjField', 2, 'title', 'You can either upload a CSV file with your members or copy/paste from Excel. If you check "Update members" then members who are already in your list will be updated with the new data provided. Otherwise each new member will be added to the list and duplicates may be possible. Sample CSV file can be found <a href="import-sample.csv">here</a>.', 'script'),
(NULL, 529, 'pjField', 3, 'title', 'You can either upload a CSV file with your members or copy/paste from Excel. If you check "Update members" then members who are already in your list will be updated with the new data provided. Otherwise each new member will be added to the list and duplicates may be possible. Sample CSV file can be found <a href="import-sample.csv">here</a>.', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Source', 'script'),
(NULL, 530, 'pjField', 2, 'title', 'Source', 'script'),
(NULL, 530, 'pjField', 3, 'title', 'Source', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'CSV File', 'script'),
(NULL, 531, 'pjField', 2, 'title', 'CSV File', 'script'),
(NULL, 531, 'pjField', 3, 'title', 'CSV File', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Members', 'script'),
(NULL, 532, 'pjField', 2, 'title', 'Members', 'script'),
(NULL, 532, 'pjField', 3, 'title', 'Members', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Update members', 'script'),
(NULL, 533, 'pjField', 2, 'title', 'Update members', 'script'),
(NULL, 533, 'pjField', 3, 'title', 'Update members', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Import', 'script'),
(NULL, 534, 'pjField', 2, 'title', 'Import', 'script'),
(NULL, 534, 'pjField', 3, 'title', 'Import', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 535, 'pjField', 2, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 535, 'pjField', 3, 'title', 'Only csv files are allowed.', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Skills', 'script'),
(NULL, 536, 'pjField', 2, 'title', 'Skills', 'script'),
(NULL, 536, 'pjField', 3, 'title', 'Skills', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Bio', 'script'),
(NULL, 537, 'pjField', 2, 'title', 'Bio', 'script'),
(NULL, 537, 'pjField', 3, 'title', 'Bio', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 538, 'pjField', 2, 'title', 'Photos', 'script'),
(NULL, 538, 'pjField', 3, 'title', 'Photos', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Registration email', 'script'),
(NULL, 539, 'pjField', 2, 'title', 'Registration email', 'script'),
(NULL, 539, 'pjField', 3, 'title', 'Registration email', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Password recovery email', 'script'),
(NULL, 540, 'pjField', 2, 'title', 'Password recovery email', 'script'),
(NULL, 540, 'pjField', 3, 'title', 'Password recovery email', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Your account could not be created. Please try again.', 'script'),
(NULL, 541, 'pjField', 2, 'title', 'Your account could not be created. Please try again.', 'script'),
(NULL, 541, 'pjField', 3, 'title', 'Your account could not be created. Please try again.', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Email is already used.', 'script'),
(NULL, 542, 'pjField', 2, 'title', 'Email is already used.', 'script'),
(NULL, 542, 'pjField', 3, 'title', 'Email is already used.', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 543, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 543, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 544, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 544, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 545, 'pjField', 2, 'title', 'Email is invalid.', 'script'),
(NULL, 545, 'pjField', 3, 'title', 'Email is invalid.', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Your account is inactive.', 'script'),
(NULL, 546, 'pjField', 2, 'title', 'Your account is inactive.', 'script'),
(NULL, 546, 'pjField', 3, 'title', 'Your account is inactive.', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Password was sent to your mail box.', 'script'),
(NULL, 547, 'pjField', 2, 'title', 'Password was sent to your mail box.', 'script'),
(NULL, 547, 'pjField', 3, 'title', 'Password was sent to your mail box.', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 548, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 548, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 549, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 549, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 550, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 550, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 551, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 551, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 552, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 552, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 553, 'pjField', 2, 'title', 'Email is invalid.', 'script'),
(NULL, 553, 'pjField', 3, 'title', 'Email is invalid.', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 554, 'pjField', 2, 'title', 'Password is missing.', 'script'),
(NULL, 554, 'pjField', 3, 'title', 'Password is missing.', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 555, 'pjField', 2, 'title', 'Password cannot be empty.', 'script'),
(NULL, 555, 'pjField', 3, 'title', 'Password cannot be empty.', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Email or password is incorrect.', 'script'),
(NULL, 556, 'pjField', 2, 'title', 'Email or password is incorrect.', 'script'),
(NULL, 556, 'pjField', 3, 'title', 'Email or password is incorrect.', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Your account is inactive.', 'script'),
(NULL, 557, 'pjField', 2, 'title', 'Your account is inactive.', 'script'),
(NULL, 557, 'pjField', 3, 'title', 'Your account is inactive.', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 558, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 558, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 559, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 559, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Your profile', 'script'),
(NULL, 560, 'pjField', 2, 'title', 'Your profile', 'script'),
(NULL, 560, 'pjField', 3, 'title', 'Your profile', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 561, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 561, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 562, 'pjField', 2, 'title', 'Details', 'script'),
(NULL, 562, 'pjField', 3, 'title', 'Details', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 563, 'pjField', 2, 'title', 'Photos', 'script'),
(NULL, 563, 'pjField', 3, 'title', 'Photos', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 564, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 564, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 565, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 565, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 566, 'pjField', 2, 'title', 'Zip', 'script'),
(NULL, 566, 'pjField', 3, 'title', 'Zip', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 567, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 567, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Biography', 'script'),
(NULL, 568, 'pjField', 2, 'title', 'Biography', 'script'),
(NULL, 568, 'pjField', 3, 'title', 'Biography', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Facebook', 'script'),
(NULL, 569, 'pjField', 2, 'title', 'Facebook', 'script'),
(NULL, 569, 'pjField', 3, 'title', 'Facebook', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Google plus', 'script'),
(NULL, 570, 'pjField', 2, 'title', 'Google plus', 'script'),
(NULL, 570, 'pjField', 3, 'title', 'Google plus', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Linkedin', 'script'),
(NULL, 571, 'pjField', 2, 'title', 'Linkedin', 'script'),
(NULL, 571, 'pjField', 3, 'title', 'Linkedin', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Twitter', 'script'),
(NULL, 572, 'pjField', 2, 'title', 'Twitter', 'script'),
(NULL, 572, 'pjField', 3, 'title', 'Twitter', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Avatar', 'script'),
(NULL, 573, 'pjField', 2, 'title', 'Avatar', 'script'),
(NULL, 573, 'pjField', 3, 'title', 'Avatar', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'delete', 'script'),
(NULL, 574, 'pjField', 2, 'title', 'delete', 'script'),
(NULL, 574, 'pjField', 3, 'title', 'delete', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Are you sure that you want to delete the avatar?', 'script'),
(NULL, 575, 'pjField', 2, 'title', 'Are you sure that you want to delete the avatar?', 'script'),
(NULL, 575, 'pjField', 3, 'title', 'Are you sure that you want to delete the avatar?', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 576, 'pjField', 2, 'title', 'Close', 'script'),
(NULL, 576, 'pjField', 3, 'title', 'Close', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 577, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 577, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Profile could not be saved because the post content size is greater than {MAXSIZE}.', 'script'),
(NULL, 578, 'pjField', 2, 'title', 'Profile could not be saved because the post content size is greater than {MAXSIZE}.', 'script'),
(NULL, 578, 'pjField', 3, 'title', 'Profile could not be saved because the post content size is greater than {MAXSIZE}.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Your profile has been updated, but the avatar couldn''t be uploaded.', 'script'),
(NULL, 579, 'pjField', 2, 'title', 'Your profile has been updated, but the avatar couldn''t be uploaded.', 'script'),
(NULL, 579, 'pjField', 3, 'title', 'Your profile has been updated, but the avatar couldn''t be uploaded.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Your profile has been saved successfully.', 'script'),
(NULL, 580, 'pjField', 2, 'title', 'Your profile has been saved successfully.', 'script'),
(NULL, 580, 'pjField', 3, 'title', 'Your profile has been saved successfully.', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Upload', 'script'),
(NULL, 581, 'pjField', 2, 'title', 'Upload', 'script'),
(NULL, 581, 'pjField', 3, 'title', 'Upload', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Photo', 'script'),
(NULL, 582, 'pjField', 2, 'title', 'Photo', 'script'),
(NULL, 582, 'pjField', 3, 'title', 'Photo', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Photos is uploading. Please wait...', 'script'),
(NULL, 583, 'pjField', 2, 'title', 'Photos is uploading. Please wait...', 'script'),
(NULL, 583, 'pjField', 3, 'title', 'Photos is uploading. Please wait...', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'File could not be uploaded, because the post content is greater than {MAXSIZE}.', 'script'),
(NULL, 584, 'pjField', 2, 'title', 'File could not be uploaded, because the post content is greater than {MAXSIZE}.', 'script'),
(NULL, 584, 'pjField', 3, 'title', 'File could not be uploaded, because the post content is greater than {MAXSIZE}.', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'GD extension is not loaded.', 'script'),
(NULL, 585, 'pjField', 2, 'title', 'GD extension is not loaded.', 'script'),
(NULL, 585, 'pjField', 3, 'title', 'GD extension is not loaded.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Photo could not be loaded.', 'script'),
(NULL, 586, 'pjField', 2, 'title', 'Photo could not be loaded.', 'script'),
(NULL, 586, 'pjField', 3, 'title', 'Photo could not be loaded.', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Allowed memory size of %u bytes exhausted (tried to allocate %u bytes)', 'script'),
(NULL, 587, 'pjField', 2, 'title', 'Allowed memory size of %u bytes exhausted (tried to allocate %u bytes)', 'script'),
(NULL, 587, 'pjField', 3, 'title', 'Allowed memory size of %u bytes exhausted (tried to allocate %u bytes)', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Photo could not be saved.', 'script'),
(NULL, 588, 'pjField', 2, 'title', 'Photo could not be saved.', 'script'),
(NULL, 588, 'pjField', 3, 'title', 'Photo could not be saved.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Photo has been uploaded.', 'script'),
(NULL, 589, 'pjField', 2, 'title', 'Photo has been uploaded.', 'script'),
(NULL, 589, 'pjField', 3, 'title', 'Photo has been uploaded.', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Are you sure that you want to delete this photo?', 'script'),
(NULL, 590, 'pjField', 2, 'title', 'Are you sure that you want to delete this photo?', 'script'),
(NULL, 590, 'pjField', 3, 'title', 'Are you sure that you want to delete this photo?', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 591, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 591, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Search members', 'script'),
(NULL, 592, 'pjField', 2, 'title', 'Search members', 'script'),
(NULL, 592, 'pjField', 3, 'title', 'Search members', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Member name', 'script'),
(NULL, 593, 'pjField', 2, 'title', 'Member name', 'script'),
(NULL, 593, 'pjField', 3, 'title', 'Member name', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Select', 'script'),
(NULL, 594, 'pjField', 2, 'title', 'Select', 'script'),
(NULL, 594, 'pjField', 3, 'title', 'Select', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 595, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 595, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Email address', 'script'),
(NULL, 596, 'pjField', 2, 'title', 'Email address', 'script'),
(NULL, 596, 'pjField', 3, 'title', 'Email address', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 597, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 597, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Login to your account', 'script'),
(NULL, 598, 'pjField', 2, 'title', 'Login to your account', 'script'),
(NULL, 598, 'pjField', 3, 'title', 'Login to your account', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 599, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 599, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 600, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 600, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 601, 'pjField', 2, 'title', 'Email is invalid.', 'script'),
(NULL, 601, 'pjField', 3, 'title', 'Email is invalid.', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 602, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 602, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 603, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 603, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 604, 'pjField', 2, 'title', 'Forgot password?', 'script'),
(NULL, 604, 'pjField', 3, 'title', 'Forgot password?', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Create an Account', 'script'),
(NULL, 605, 'pjField', 2, 'title', 'Create an Account', 'script'),
(NULL, 605, 'pjField', 3, 'title', 'Create an Account', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 606, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 606, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 607, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 607, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Re-enter password', 'script'),
(NULL, 608, 'pjField', 2, 'title', 'Re-enter password', 'script'),
(NULL, 608, 'pjField', 3, 'title', 'Re-enter password', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Password does not match.', 'script'),
(NULL, 609, 'pjField', 2, 'title', 'Password does not match.', 'script'),
(NULL, 609, 'pjField', 3, 'title', 'Password does not match.', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 610, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 610, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 611, 'pjField', 2, 'title', 'Captcha', 'script'),
(NULL, 611, 'pjField', 3, 'title', 'Captcha', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 612, 'pjField', 2, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 612, 'pjField', 3, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 613, 'pjField', 2, 'title', 'Register', 'script'),
(NULL, 613, 'pjField', 3, 'title', 'Register', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Name is missing.', 'script'),
(NULL, 614, 'pjField', 2, 'title', 'Name is missing.', 'script'),
(NULL, 614, 'pjField', 3, 'title', 'Name is missing.', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Name cannot be empty.', 'script'),
(NULL, 615, 'pjField', 2, 'title', 'Name cannot be empty.', 'script'),
(NULL, 615, 'pjField', 3, 'title', 'Name cannot be empty.', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 616, 'pjField', 2, 'title', 'Email is missing.', 'script'),
(NULL, 616, 'pjField', 3, 'title', 'Email is missing.', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 617, 'pjField', 2, 'title', 'Email cannot be empty.', 'script'),
(NULL, 617, 'pjField', 3, 'title', 'Email cannot be empty.', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 618, 'pjField', 2, 'title', 'Email is invalid.', 'script'),
(NULL, 618, 'pjField', 3, 'title', 'Email is invalid.', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 619, 'pjField', 2, 'title', 'Password is missing.', 'script'),
(NULL, 619, 'pjField', 3, 'title', 'Password is missing.', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 620, 'pjField', 2, 'title', 'Password cannot be empty.', 'script'),
(NULL, 620, 'pjField', 3, 'title', 'Password cannot be empty.', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Re-enter password is missing.', 'script'),
(NULL, 621, 'pjField', 2, 'title', 'Re-enter password is missing.', 'script'),
(NULL, 621, 'pjField', 3, 'title', 'Re-enter password is missing.', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Re-enter cannot be empty.', 'script'),
(NULL, 622, 'pjField', 2, 'title', 'Re-enter cannot be empty.', 'script'),
(NULL, 622, 'pjField', 3, 'title', 'Re-enter cannot be empty.', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Password does not match.', 'script'),
(NULL, 623, 'pjField', 2, 'title', 'Password does not match.', 'script'),
(NULL, 623, 'pjField', 3, 'title', 'Password does not match.', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Captcha is missing.', 'script'),
(NULL, 624, 'pjField', 2, 'title', 'Captcha is missing.', 'script'),
(NULL, 624, 'pjField', 3, 'title', 'Captcha is missing.', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 625, 'pjField', 2, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 625, 'pjField', 3, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 626, 'pjField', 2, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 626, 'pjField', 3, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Your account has been created. Please login to update your profile.', 'script'),
(NULL, 627, 'pjField', 2, 'title', 'Your account has been created. Please login to update your profile.', 'script'),
(NULL, 627, 'pjField', 3, 'title', 'Your account has been created. Please login to update your profile.', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Email address not found.', 'script'),
(NULL, 628, 'pjField', 2, 'title', 'Email address not found.', 'script'),
(NULL, 628, 'pjField', 3, 'title', 'Email address not found.', 'script');

INSERT INTO `mds_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 4, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 5, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 6, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 7, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 8, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 10, 0, NULL),
(1, 'o_items_per_page', 1, '10', NULL, 'int', 11, 1, NULL),

(1, 'o_email_register_subject', 2, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_register_message', 2, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_forgot_subject', 2, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_forgot_message', 2, '', NULL, 'text', 3, 1, NULL),
(1, 'o_sms_register_message', 2, '', NULL, 'text', 3, 1, NULL),
(1, 'o_admin_email_register_subject', 3, '', NULL, 'string', 4, 1, NULL),
(1, 'o_admin_email_register_message', 3, '', NULL, 'text', 5, 1, NULL),
(1, 'o_admin_sms_register_message', 3, '', NULL, 'text', 5, 1, NULL),

(1, 'o_listing_page', 99, '', NULL, 'string', NULL, 0, NULL),
(1, 'o_seo_url', 99, 'Yes|No::No', NULL, 'enum', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::1', 'Yes|No', 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `mds_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

COMMIT;