<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{MAXSIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	include_once PJ_VIEWS_PATH . 'pjAdminMembers/elements/menu.php';
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminMembers&amp;action=pjActionUpdate" method="post" id="frmUpdateMember" class="pj-form form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="member_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		<?php $locale = isset($_GET['locale']) && (int) $_GET['locale'] > 0 ? (int) $_GET['locale'] : $controller->getLocaleId(); ?>
		<input type="hidden" name="locale" value="<?php echo $locale; ?>" />
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabDetails'); ?></a></li>
				<li><a href="#tabs-2"><?php __('tabPhotos'); ?></a></li>
			</ul>
			<div id="tabs-1">
				<?php
				pjUtil::printNotice(__('infoUpdateMemberTitle', true), __('infoUpdateMemberDesc', true));
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang"></div>
				<?php endif; ?>
				
				<div class="clear_both">
					<p>
						<label class="title"><?php __('lblSkill'); ?></label>
						<span id="pjMLSkillContainer" class="inline_block">
							<select id="skill_id" name="skill_id[]" class="pj-form-field w300" data-msg-required="<?php __('lblFieldRequired');?>" data-placeholder="--<?php __('lblChoose'); ?>--" multiple="multiple">
								<?php
								foreach ($tpl['skill_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id']; ?>"<?php echo in_array($v['id'], $tpl['skill_id_arr']) ? ' selected="selected"' : NULL;?>><?php echo $v['name']; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p>
						<label class="title"><?php __('email'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
							<input type="text" name="email" id="email" value="<?php echo pjSanitize::html($tpl['arr']['email']);?>" class="pj-form-field required email w200" data-msg-required="<?php __('lblFieldRequired');?>" data-msg-email="<?php __('lblEmailInvalid');?>" data-msg-remote="<?php __('email_taken');?>"/>
						</span>
					</p>
					<p>
						<label class="title"><?php __('pass'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-password"></abbr></span>
							<input type="text" name="password" id="password" value="<?php echo pjSanitize::html($tpl['arr']['password']);?>" class="pj-form-field required w200" data-msg-required="<?php __('lblFieldRequired');?>"/>
						</span>
					</p>
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblName'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][name]" value="<?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['name']); ?>" class="pj-form-field w250<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>"/>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					} 
					?>
					<p>
						<label class="title"><?php __('lblPhone'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
							<input type="text" name="phone" id="phone" value="<?php echo pjSanitize::html($tpl['arr']['phone']);?>" class="pj-form-field w200"/>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblAge'); ?></label>
						<span class="inline_block">
							<input type="text" name="age" id="age" value="<?php echo pjSanitize::html($tpl['arr']['age']);?>" class="pj-form-field field-int digits w60" data-msg-digits="<?php __('lblPleaseEnterDigits');?>"/>
						</span>
					</p>
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblAddress'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][address]" value="<?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['address']); ?>" class="pj-form-field w250"/>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblCity'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][city]" value="<?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['city']); ?>" class="pj-form-field w250"/>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblState'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][state]" value="<?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['state']); ?>" class="pj-form-field w250"/>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					} 
					?>
					<p>
						<label class="title"><?php __('lblZip'); ?></label>
						<span class="inline_block">
							<input type="text" name="zip" id="zip" value="<?php echo pjSanitize::html($tpl['arr']['zip']);?>" class="pj-form-field w250"/>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblCountry'); ?></label>
						<span class="inline_block">
							<select id="country_id" name="country_id" class="pj-form-field 250">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ($tpl['country_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id']; ?>"<?php echo $tpl['arr']['country_id'] == $v['id'] ? ' selected="selected"' : NULL;?>><?php echo $v['country_title']; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblAvatar'); ?></label>
						<span class="inline_block">
							<input type="file" name="avatar" id="avatar" class="pj-form-field w250"/>
						</span>
					</p>
					<?php
					if(!empty($tpl['arr']['avatar_path']) && is_file(PJ_INSTALL_PATH . $tpl['arr']['avatar_path']))
					{
						?>
						<p>
							<label class="title">&nbsp;</label>
							<span class="inline_block">
								<img class="block float_left r5" src="<?php echo PJ_INSTALL_URL . $tpl['arr']['avatar_path']?>"/>
								<a href="#" class="pj-delete pjMLDeleteAvatar" data-id="<?php echo $tpl['arr']['id'];?>"></a>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblBiography'); ?></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][biography]" class="pj-form-field w500 h100"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['biography']); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					} 
					?>
					<p>
						<label class="title"><?php __('lblFacebook'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-url"></abbr></span>
							<input type="text" name="facebook" id="facebook" value="<?php echo pjSanitize::html($tpl['arr']['facebook']);?>" class="pj-form-field w400"/>
						</span>
					</p>
					<?php /*
					<p>
						<label class="title"><?php __('lblGooglePlus'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-url"></abbr></span>
							<input type="text" name="google" id="google" value="<?php echo pjSanitize::html($tpl['arr']['google']);?>" class="pj-form-field w400"/>
						</span>
					</p> */ ?>
					<p>
						<label class="title"><?php __('lblLinkedin'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-url"></abbr></span>
							<input type="text" name="linkedin" id="linkedin" value="<?php echo pjSanitize::html($tpl['arr']['linkedin']);?>" class="pj-form-field w400"/>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblTwitter'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-url"></abbr></span>
							<input type="text" name="twitter" id="twitter" value="<?php echo pjSanitize::html($tpl['arr']['twitter']);?>" class="pj-form-field w400"/>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblStatus'); ?></label>
						<span class="inline_block">
							<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('lblFieldRequired');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach (__('u_statarr', true) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"<?php echo $k == 'T' ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminMembers&action=pjActionIndex';" />
					</p>
				</div>
			</div><!-- Tab-1 -->
			<div id="tabs-2">
				<?php
				pjUtil::printNotice(__('infoPhotosTitle', true), __('infoPhotosDesc', true));
				?>
				<div id="gallery"></div>
			</div>
		</div>
	</form>
	
	<div id="dialogDelete" title="<?php __('lblDeleteAvatar'); ?>" style="display: none">
		<?php __('lblDeleteAvatarDesc'); ?>
	</div>
	
	<script type="text/javascript">
	var myGallery = myGallery || {};
	myGallery.foreign_id = "<?php echo $tpl['arr']['id']; ?>";
	myGallery.hash = "";
	var locale_array = new Array(); 
	var myLabel = myLabel || {};
	myLabel.field_required = "<?php __('lblFieldRequired'); ?>";
	<?php
	foreach ($tpl['lp_arr'] as $v)
	{
		?>locale_array.push(<?php echo $v['id'];?>);<?php
	} 
	?>
	myLabel.locale_array = locale_array;
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: <?php echo $tpl['locale_str']; ?>,
				flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
				tooltip: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris sit amet faucibus enim.",
				select: function (event, ui) {
					$("input[name='locale']").val(ui.index);
					$.get("index.php?controller=pjAdminMembers&action=pjActionGetLocale", {
						"locale" : ui.index
					}).done(function (data) {
						var values = $("#skill_id").chosen().val();
						$('#pjMLSkillContainer').html(data.skill);
						if(values != null)
						{
							$.each(values.toString().split(","), function(index, value){
								$("#skill_id").find("option[value='"+value+"']").prop("selected", true);
							});
						}
						$("#skill_id").chosen();
					});
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
	$tab_id = explode("-", $_GET['tab_id']);
	$tab_id = (int) $tab_id[1] - 1;
	$tab_id = $tab_id < 0 ? 0 : $tab_id;
	?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "selected", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>