/*!
 * Member Directory Script v1.0
 * 
 * https://www.phpjabbers.com/member-directory-script/
 * 
 * Copyright 2015, StivaSoft Ltd.
 * 
 */
(function (window, undefined){
	"use strict";
	

	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined);
    
	function loadDelayedCSS(opts) {
		pjQ.$(window).load(function() {
			pjQ.$('body').append(pjQ.$('<link rel="stylesheet" type="text/css" />').attr('href', opts.server+'app/web/css/transitions.css'));
		});
	}
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnYacht(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function MemberDir(opts) {
		if (!(this instanceof MemberDir)) {
			return new MemberDir(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	MemberDir.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnYacht(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	MemberDir.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnYacht(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	MemberDir.prototype = {
		reset: function () {
			this.$container = null;
			this.container = null;			
			this.opts = {};
			
			return this;
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjWrapper");
			this.$container = pjQ.$(this.container);
			
			loadDelayedCSS(opts);
			
			if(pjQ.$('#pjMlThumbsPopup').length > 0)
			{
				pjQ.$('.modal-dialog').css("z-index", "9999");
			}
			
			self.bindSearchForm();
			self.bindRegisterForm();
			self.bindLoginForm();
			self.bindForgotForm();
			self.bindProfileForm();
			
			this.$container.on('click.ml', '.pjMLOpenAvatarModal', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				pjQ.$('#pjMLDeleteAvatarModal').modal('show');
				return false;
			}).on('click.ml', '.pjMLDeleteAvatar', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var member_id = pjQ.$(this).attr('data-id');
				pjQ.$.get(self.opts.folder + "index.php?controller=pjLoad&action=pjActionDeleteAvatar&id=" + member_id).done(function (data) {
					pjQ.$('#pjMLAvatarContainer').remove();
					pjQ.$('#pjMLDeleteAvatarModal').modal('hide');
				});
				return false;
			}).on('click.ml', '.pjMLOpenPhotoModal', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				pjQ.$('#pjMLDeleteButton_' + self.opts.index).attr('data-id', pjQ.$(this).attr('data-id'));
				pjQ.$('#pjMLDeletePhotoModal').modal('show');
				return false;
			}).on('click.ml', '.pjMLDeletePhoto', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var id = pjQ.$(this).attr('data-id'),
					member_id = pjQ.$(this).attr('data-member_id');
				pjQ.$.get(self.opts.folder + "index.php?controller=pjLoad&action=pjActionDeleteGallery&id=" + id).done(function (data) {
					pjQ.$('#pjMLThumb_' + id).remove();
					pjQ.$('#pjMLDeletePhotoModal').modal('hide');
				});
				return false;
			});
		},
		bindSearchForm: function()
		{
			var self = this;
			var $frmSearch = pjQ.$('#pjMlFormSearch_' + self.opts.index);
			var $frmProfile = pjQ.$('#pjMLProfileForm_' + self.opts.index);
			
			if($frmSearch.length > 0 || $frmProfile.length > 0)
			{
				var checkedClass = 'pjMlCustomInputChecked';
				var disabledClass = 'pjMlCustomInputDisabled';
				var inputSelector = '.pjMlCustomCheckbox input';

				pjQ.$(inputSelector).each(function() {
					var input = this;

					pjQ.$(input).parent().toggleClass(checkedClass, input.checked);
				}).on('change', function() {
					var input = this;

					if(input.type === 'radio') {
						var name = input.name;
						pjQ.$(input.ownerDocument).find('[name=' + name + ']').each(function() {
							var radioInput = this;
							pjQ.$(radioInput).parent().toggleClass(checkedClass, radioInput.checked);
						});
					} else {
						pjQ.$(input).parent().toggleClass(checkedClass, input.checked);
					};
				}).on('disable', function() {
					var input = this;

					input.disabled = true;
					pjQ.$(input).parent().addClass(disabledClass);
				}).on('enable', function() {
					var input = this;

					input.disabled = false;
					pjQ.$(input).parent().removeClass(disabledClass);
				});	
			}
		},
		bindLoginForm: function()
		{
			var self = this;
			var $frmLogin = pjQ.$('#pjMLFormLogIn_' + self.opts.index);
			
			if($frmLogin.length > 0)
			{
				$frmLogin.validate({
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
		},
		bindProfileForm: function()
		{
			var self = this;
			var $frmProfile = pjQ.$('#pjMLProfileForm_' + self.opts.index),
				$frmUpload = pjQ.$('#pjMLUploadForm_' + self.opts.index),
				$inputPhoto = pjQ.$('#pjMLPhoto_' + self.opts.index),
				$uploadMessage = pjQ.$('#pjMLUploadMessage_' + self.opts.index);
			
			if($frmProfile.length > 0)
			{
				pjQ.$('.modal-dialog').css("z-index", "9999");
				
				$frmProfile.validate({
					rules: {
						"email": {
							remote: self.opts.folder + "index.php?controller=pjLoad&action=pjActionCheckEmail&id=" + $frmProfile.find("input[name='id']").val()
						}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
			if($frmUpload.length > 0)
			{
				$frmUpload.validate({
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function (form) {
		            	var info = $uploadMessage.attr('data-info');
		            	$uploadMessage.addClass('alert-info').html(info).show();
		            	$frmUpload.ajaxSubmit({
							success: function(data) {
								$inputPhoto.val('');
								$uploadMessage.removeClass('alert-info');
								if(data.code == '200')
								{
									$uploadMessage.addClass('alert-success').html(data.text);
									pjQ.$.get(self.opts.folder + "index.php?controller=pjLoad&action=pjActionGallery&id=" + data.id).done(function (data) {
										pjQ.$('#pjMLGallery_' + self.opts.index).html(data);
										$uploadMessage.removeClass('alert-success').hide();
									});
								}else{
									$uploadMessage.addClass('alert-danger').html(data.text);
								}
							}
						});
		            	return false;
		            }
				});
			}
		},
		bindRegisterForm: function()
		{
			var self = this;
			var $frmRegister = pjQ.$('#pjMLFormRegister_' + self.opts.index);
			
			if($frmRegister.length > 0)
			{
				$frmRegister.validate({
					rules: {
						"email": {
							remote: self.opts.folder + "index.php?controller=pjLoad&action=pjActionCheckEmail"
						},
						"captcha": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha"
						},
						"reenter_password":{
							equalTo: "#pjMLPassword"
						}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
		},
		bindForgotForm: function()
		{
			var self = this;
			var $frmForgot = pjQ.$('#pjMLForgotForm_' + self.opts.index);
			
			if($frmForgot.length > 0)
			{
				$frmForgot.validate({
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            }
				});
			}
		}
	};
	
	window.MemberDir = MemberDir;	
})(window);