DROP TABLE IF EXISTS `property_listing_properties`;
CREATE TABLE `property_listing_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type_id` int(11) NULL DEFAULT NULL,
  `owner_id` int(11) NULL DEFAULT NULL,
  `created` datetime NULL DEFAULT NULL,
  `modified` datetime NULL DEFAULT NULL,
  `views` int(11) NOT NULL DEFAULT '0',
  `prints` int(11) NOT NULL DEFAULT '0',
  `sents` int(11) NOT NULL DEFAULT '0',
  `for` enum('rent','sale') DEFAULT NULL,
  `is_featured` enum('T','F') DEFAULT 'F',
  `status` enum('T','F','E') NOT NULL DEFAULT 'F',
  `ref_id` varchar(250) DEFAULT NULL,
  `special` enum('none','premium','sold','underoffer') DEFAULT NULL,
  `expire` date DEFAULT NULL,
  `last_extend` enum('free','paid') DEFAULT 'free',
  `added_by` enum('other','owner') NOT NULL DEFAULT 'other',
  `bedrooms` varchar(10) DEFAULT NULL,
  `bathrooms` varchar(10) DEFAULT NULL,
  `year_built` varchar(250) DEFAULT NULL,
  `lot` varchar(250) DEFAULT NULL,
  `price` varchar(250) DEFAULT NULL,
  `price_per` enum('day','week','month ','year') DEFAULT NULL,
  `floor_area` varchar(250) DEFAULT NULL,
  `floor_plan_filename` varchar(250) DEFAULT NULL,
  `floor_plan_filepath` varchar(250) DEFAULT NULL,
  `floor_plan_mime` varchar(250) DEFAULT NULL,
  `floor_plan_hash` varchar(250) DEFAULT NULL,
  `show_googlemap` enum('T','F') DEFAULT NULL,
  `address_country` int(11) DEFAULT NULL,
  `address_state` varchar(250) DEFAULT NULL,
  `address_city` varchar(250) DEFAULT NULL,
  `address_1` varchar(250) DEFAULT NULL,
  `address_2` varchar(250) DEFAULT NULL,
  `address_zip` varchar(250) DEFAULT NULL,
  `lat` varchar(100) DEFAULT NULL,
  `lng` varchar(100) DEFAULT NULL,
  `owner_show` enum('T','F') DEFAULT NULL,
  `owner_name` varchar(250) DEFAULT NULL,
  `owner_phone` varchar(250) DEFAULT NULL,
  `owner_email` varchar(250) DEFAULT NULL,
  `owner_fax` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type_id` (`type_id`),
  KEY `owner_id` (`owner_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `property_listing_payments`;
CREATE TABLE IF NOT EXISTS `property_listing_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `property_id` int(10) unsigned DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `property_id` (`property_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `property_listing_properties_features`;
CREATE TABLE `property_listing_properties_features` (
  `property_id` int(11) NOT NULL,
  `feature_id` int(11) NOT NULL,
  PRIMARY KEY (`property_id`, `feature_id`),
  KEY `property_id` (`property_id`),
  KEY `feature_id` (`feature_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `property_listing_features`;
CREATE TABLE IF NOT EXISTS `property_listing_features` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` tinyint(3) unsigned DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `property_listing_types`;
CREATE TABLE IF NOT EXISTS `property_listing_types` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `property_listing_periods`;
CREATE TABLE IF NOT EXISTS `property_listing_periods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `days` smallint(5) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `property_listing_fields`;
CREATE TABLE IF NOT EXISTS `property_listing_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `property_listing_multi_lang`;
CREATE TABLE IF NOT EXISTS `property_listing_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `property_listing_options`;
CREATE TABLE IF NOT EXISTS `property_listing_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `property_listing_passwords`;
CREATE TABLE IF NOT EXISTS `property_listing_passwords` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `property_listing_roles`;
CREATE TABLE IF NOT EXISTS `property_listing_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `property_listing_users`;
CREATE TABLE IF NOT EXISTS `property_listing_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `property_listing_periods` (`id`, `days`, `price`) VALUES
(1, 10, 49.00),
(2, 20, 79.00),
(3, 30, 99.00),
(4, 40, 109.00),
(5, 50, 119.00);

INSERT INTO `property_listing_features` (`id`, `category_id`, `status`) VALUES
(1, 2, 'T'),
(2, 2, 'T'),
(3, 2, 'T'),
(4, 2, 'T'),
(5, 2, 'T'),
(6, 2, 'T'),
(7, 1, 'T'),
(8, 2, 'T'),
(9, 2, 'T'),
(10, 1, 'T'),
(11, 1, 'T'),
(12, 2, 'T'),
(13, 2, 'T'),
(14, 2, 'T'),
(15, 1, 'T'),
(16, 2, 'T'),
(17, 2, 'T'),
(18, 1, 'T'),
(19, 1, 'T'),
(20, 1, 'T'),
(21, 1, 'T'),
(22, 2, 'T'),
(23, 1, 'T'),
(24, 2, 'T'),
(25, 2, 'T'),
(26, 2, 'T'),
(27, 2, 'T'),
(28, 1, 'T'),
(29, 2, 'T'),
(30, 2, 'T'),
(31, 1, 'T'),
(32, 2, 'T'),
(33, 2, 'T'),
(34, 2, 'T'),
(35, 1, 'T'),
(36, 2, 'T'),
(37, 1, 'T'),
(38, 2, 'T'),
(39, 2, 'T'),
(40, 1, 'T'),
(41, 1, 'T'),
(42, 1, 'T'),
(43, 2, 'T'),
(44, 1, 'T'),
(45, 2, 'T'),
(46, 2, 'T'),
(47, 1, 'T'),
(48, 1, 'T'),
(49, 2, 'T'),
(50, 1, 'T'),
(51, 2, 'T'),
(52, 2, 'T'),
(53, 1, 'T'),
(54, 2, 'T');

INSERT INTO `property_listing_types` (`id`, `status`) VALUES
(1, 'T'),
(2, 'T'),
(3, 'T'),
(4, 'T'),
(5, 'T');

INSERT INTO `property_listing_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(360, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(361, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(529, 'menuProperties', 'backend', 'Menu / Properties', 'script', NULL),
(530, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(531, 'menuNotifications', 'backend', 'Menu / Notifications', 'script', NULL),
(532, 'menuTypes', 'backend', 'Menu / Types', 'script', NULL),
(533, 'menuFeatures', 'backend', 'Menu / Features', 'script', NULL),
(534, 'opt_o_floor_metric', 'backend', 'Options / Floor metrics', 'script', NULL),
(535, 'opt_o_price_format', 'backend', 'Options / Price format', 'script', NULL),
(536, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(537, 'opt_o_items_per_page', 'backend', 'Options / Number of properties per page', 'script', NULL),
(538, 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
(539, 'opt_o_show_contact', 'backend', 'Options / Show contact form', 'script', NULL),
(540, 'opt_o_email_request', 'backend', 'Options / New request email', 'script', NULL),
(541, 'opt_o_email_request_text', 'backend', 'Options / New request email', 'script', NULL),
(542, 'opt_o_email_request_subject', 'backend', 'Options / New request email subject', 'script', NULL),
(543, 'opt_o_email_request_message', 'backend', 'Options / New request email message', 'script', NULL),
(544, 'opt_o_email_request_message_text', 'backend', 'Options / New request email message', 'script', NULL),
(545, 'opt_o_email_registration', 'backend', 'Options / Registration email', 'script', NULL),
(546, 'opt_o_email_registration_text', 'backend', 'Options / Registration email', 'script', NULL),
(547, 'opt_o_email_registration_subject', 'backend', 'Options / Registration email subject', 'script', NULL),
(548, 'opt_o_email_registration_message', 'backend', 'Options / Registration email message', 'script', NULL),
(549, 'opt_o_email_registration_message_text', 'backend', 'Options / Registration email message', 'script', NULL),
(550, 'opt_o_email_submission', 'backend', 'Options / New property submitted email', 'script', NULL),
(551, 'opt_o_email_submission_text', 'backend', 'Options / New property submitted email', 'script', NULL),
(552, 'opt_o_email_submission_subject', 'backend', 'Options / New property submitted email subject', 'script', NULL),
(553, 'opt_o_email_submission_message', 'backend', 'Options / New property submitted email message', 'script', NULL),
(554, 'opt_o_email_submission_message_text', 'backend', 'Options / New property submitted email message', 'script', NULL),
(555, 'opt_o_email_forgot', 'backend', 'Options / Password recovery email', 'script', NULL),
(556, 'opt_o_email_forgot_subject', 'backend', 'Options / Password recovery email subject', 'script', NULL),
(557, 'opt_o_email_forgot_message', 'backend', 'Options / Password recovery email message', 'script', NULL),
(558, 'opt_o_email_forgot_message_text', 'backend', 'Options / Password recovery email message', 'script', NULL),
(559, 'opt_o_sms_request', 'backend', 'Options / New request SMS', 'script', NULL),
(560, 'opt_o_sms_request_text', 'backend', 'Options / New request SMS', 'script', NULL),
(561, 'opt_o_sms_request_message', 'backend', 'Options / New request SMS', 'script', NULL),
(562, 'opt_o_sms_request_message_text', 'backend', 'Options / New request SMS', 'script', NULL),
(563, 'opt_o_sms_registration', 'backend', 'Options / Registration SMS', 'script', NULL),
(564, 'opt_o_sms_registration_text', 'backend', 'Options / Registration SMS', 'script', NULL),
(565, 'opt_o_sms_registration_message', 'backend', 'Options / Registration SMS', 'script', NULL),
(566, 'opt_o_sms_registration_message_text', 'backend', 'Options / Registration SMS', 'script', NULL),
(567, 'opt_o_sms_submission', 'backend', 'Options / New property submitted SMS', 'script', NULL),
(568, 'opt_o_sms_submission_text', 'backend', 'Options / New property submitted SMS', 'script', NULL),
(569, 'opt_o_sms_submission_message', 'backend', 'Options / New property submitted SMS content', 'script', NULL),
(570, 'opt_o_sms_submission_message_text', 'backend', 'Options / New property submitted SMS content', 'script', NULL),
(571, 'opt_o_admin_send_to_email', 'backend', 'Options / Send to email', 'script', NULL),
(572, 'opt_o_send_to_email', 'backend', 'Options / Send to email', 'script', NULL),
(573, 'opt_o_admin_email_request_text', 'backend', 'Options / Send to email', 'script', NULL),
(576, 'opt_o_admin_email_registration_text', 'backend', 'Options / Send to email', 'script', NULL),
(577, 'opt_o_admin_email_submission_text', 'backend', 'Options / Send to email', 'script', NULL),
(578, 'opt_o_admin_sms_registration_text', 'backend', 'Options / Send to email', 'script', NULL),
(579, 'opt_o_admin_sms_submission_text', 'backend', 'Options / Send to email', 'script', NULL),
(580, 'lblOptionOwner', 'backend', 'Label / Owner', 'script', NULL),
(581, 'lblOptionAdministrator', 'backend', 'Label / Administrator', 'script', NULL),
(582, 'infoOwnerNotificaionsTitle', 'backend', 'Infobox / Notifications to owners', 'script', NULL),
(583, 'infoOwnerNotificaionsDesc', 'backend', 'Infobox / Notifications to owners', 'script', NULL),
(584, 'infoAdminNotificaionsTitle', 'backend', 'Infobox / Notifications to system admin', 'script', NULL),
(585, 'infoAdminNotificationsDesc', 'backend', 'Infobox / Notifications to system admin', 'script', NULL),
(586, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(587, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(588, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(589, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(590, 'infoTypesTitle', 'backend', 'Infobox / Property Types', 'script', NULL),
(591, 'infoTypesDesc', 'backend', 'Infobox / Property Types', 'script', NULL),
(593, 'lblActive', 'backend', 'Label / Active', 'script', NULL),
(594, 'lblInactive', 'backend', 'Label / Inactive', 'script', NULL),
(595, 'same_type', 'backend', 'Label / Same type', 'script', NULL),
(596, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(597, 'infoTypeCreateTitle', 'backend', 'Infobox / Add type', 'script', NULL),
(598, 'infoTypeCreateDesc', 'backend', 'Infobox / Add type', 'script', NULL),
(599, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(600, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(601, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(602, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(603, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(604, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(605, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(606, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(607, 'infoTypeUpdateTitle', 'backend', 'Infobox / Update type', 'script', NULL),
(608, 'infoTypeUpdateDesc', 'backend', 'Infobox / Update type', 'script', NULL),
(609, 'feature_categories_ARRAY_1', 'arrays', 'feature_categories_ARRAY_1', 'script', NULL),
(610, 'feature_categories_ARRAY_2', 'arrays', 'feature_categories_ARRAY_2', 'script', NULL),
(611, 'opt_o_email_send_subject', 'backend', 'Options / Send to email subject', 'script', NULL),
(612, 'opt_o_email_send_message', 'backend', 'Options / Send to email', 'script', NULL),
(613, 'infoAdminNotificationsTitle', 'backend', 'Infobox / Notifications to administrators', 'script', NULL),
(614, 'opt_o_email_send_message_text', 'backend', 'Options / Send to email', 'script', NULL),
(615, 'lblFeatureName', 'backend', 'Label / Feature name', 'script', NULL),
(616, 'lblFeatureCategory', 'backend', 'Label / Feature category', 'script', NULL),
(617, 'infoFeaturesTitle', 'backend', 'Infobox / Feature list', 'script', NULL),
(618, 'infoFeaturesDesc', 'backend', 'Infobox / List of features', 'script', NULL),
(619, 'infoFeatureCreateTitle', 'backend', 'Infobox / Add new feature', 'script', NULL),
(620, 'infoFeatureCreateDesc', 'backend', 'Infobox / Add new feature', 'script', NULL),
(621, 'infoFeatureUpdateTitle', 'backend', 'Infobox / Update feature', 'script', NULL),
(622, 'infoFeatureUpdateDesc', 'backend', 'Infobox / Update feature', 'script', NULL),
(623, 'error_titles_ARRAY_AF01', 'arrays', 'error_titles_ARRAY_AF01', 'script', NULL),
(624, 'error_bodies_ARRAY_AF01', 'arrays', 'error_bodies_ARRAY_AF01', 'script', NULL),
(625, 'error_titles_ARRAY_AF03', 'arrays', 'error_titles_ARRAY_AF03', 'script', NULL),
(626, 'error_bodies_ARRAY_AF03', 'arrays', 'error_bodies_ARRAY_AF03', 'script', NULL),
(627, 'error_titles_ARRAY_AF04', 'arrays', 'error_titles_ARRAY_AF04', 'script', NULL),
(628, 'error_bodies_ARRAY_AF04', 'arrays', 'error_bodies_ARRAY_AF04', 'script', NULL),
(629, 'error_titles_ARRAY_AF08', 'arrays', 'error_titles_ARRAY_AF08', 'script', NULL),
(630, 'error_bodies_ARRAY_AF08', 'arrays', 'error_bodies_ARRAY_AF08', 'script', NULL),
(631, 'opt_o_featured_items_per_page', 'backend', 'Label / Features items per page', 'script', NULL),
(632, 'lblNumberOfFeaturedTip', 'backend', 'Label  Featured item tip', 'script', NULL),
(633, 'opt_o_allow_add_property', 'backend', 'Option / Allow users to submit properties', 'script', NULL),
(634, 'opt_o_owner_is_active', 'backend', 'Options / Automatically activate new owner accounts', 'script', NULL),
(635, 'lblOwnerActiveTip', 'backend', 'Tooltip / Owner active', 'script', NULL),
(636, 'menuSubmissions', 'backend', 'Menu / Submissions', 'script', NULL),
(637, 'infoSubmissionsTitle', 'backend', 'Infobox / Property Submissions by Users', 'script', NULL),
(638, 'infoSubmissionsDesc', 'backend', 'Infobox / Property Submissions by Users', 'script', NULL),
(639, 'opt_period_note', 'backend', 'Options / Period notes', 'script', NULL),
(640, 'payment_period', 'backend', 'Label / Period', 'script', NULL),
(641, 'payment_price', 'backend', 'Label / Price', 'script', NULL),
(642, 'btnAddPeriod', 'backend', 'Buttons / + Add period / price', 'script', NULL),
(643, 'opt_o_paypal_address', 'backend', 'Options / Set your PayPal address', 'script', NULL),
(644, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(645, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(648, 'delete_price_confirmation', 'backend', 'Label / Delete price confirmation', 'script', NULL),
(649, 'filter_ARRAY_featured', 'arrays', 'filter_ARRAY_featured', 'script', NULL),
(650, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(651, 'lblRefId', 'backend', 'Label / Reference ID', 'script', NULL),
(652, 'lblPublish', 'backend', 'Label / Publish', 'script', NULL),
(653, 'lblPublished', 'backend', 'Label / Published', 'script', NULL),
(654, 'lblNotPublished', 'backend', 'Label / Not published', 'script', NULL),
(655, 'lblExtendExpDate', 'backend', 'Label / Extend exp. date', 'script', NULL),
(656, 'lblExpire', 'backend', 'Label / Expire', 'script', NULL),
(657, 'lblExpDate', 'backend', 'Label / Exp. date', 'script', NULL),
(658, 'lblExpDatePlus30', 'backend', 'Label / Expiration date + 30 days', 'script', NULL),
(659, 'lblUnlimited', 'backend', 'Label / Unlimited', 'script', NULL),
(660, 'menuAddProperty', 'backend', 'Menu / Add property', 'script', NULL),
(661, 'lblOwner', 'backend', 'Label / Owner', 'script', NULL),
(662, 'lblKeyword', 'backend', 'Label / Keyword', 'script', NULL),
(663, 'lblState', 'backend', 'Label / State', 'script', NULL),
(664, 'lblCity', 'backend', 'Label / City', 'script', NULL),
(665, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(666, 'infoPropertyAddTitle', 'backend', 'Infobox / Add new property', 'script', NULL),
(667, 'infoPropertyAddDesc', 'backend', 'Infobox / Add new property', 'script', NULL),
(668, 'lblFeatured', 'backend', 'Label / Make featured', 'script', NULL),
(669, 'lblRefIdTip', 'backend', 'Tips / Reference ID', 'script', NULL),
(670, 'lblStatusTip', 'backend', 'Tips / Status', 'script', NULL),
(671, 'lblFeaturedTip', 'backend', 'Tips / Featured', 'script', NULL),
(672, 'publish_statuses_ARRAY_T', 'arrays', 'publish_statuses_ARRAY_T', 'script', NULL),
(673, 'publish_statuses_ARRAY_F', 'arrays', 'publish_statuses_ARRAY_F', 'script', NULL),
(674, 'publish_statuses_ARRAY_E', 'arrays', 'publish_statuses_ARRAY_E', 'script', NULL),
(675, 'lblExpireTip', 'backend', 'Tips / Expire', 'script', NULL),
(676, 'lblSummary', 'backend', 'Label / Summary', 'script', NULL),
(677, 'lblDetails', 'backend', 'Label / Details', 'script', NULL),
(678, 'lblFeatures', 'backend', 'Label / Features', 'script', NULL),
(679, 'lblPhotos', 'backend', 'Label / Photos', 'script', NULL),
(680, 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
(681, 'lblSeo', 'backend', 'Label / SEO', 'script', NULL),
(682, 'lblAddressNotFound', 'backend', 'Label / Address not found', 'script', NULL),
(683, 'lblNotActive', 'backend', 'Label / Not active', 'script', NULL),
(684, 'lblExtend', 'backend', 'Label / Extend', 'script', NULL),
(685, 'infoPropertySummaryTitle', 'backend', 'Infobox / Property summary', 'script', NULL),
(686, 'infoPropertySummaryDesc', 'backend', 'Infobox / Property summary', 'script', NULL),
(687, 'lblAddedOn', 'backend', 'Label / Added on', 'script', NULL),
(688, 'lblLastUpdateOn', 'backend', 'Label / Last updated on', 'script', NULL),
(689, 'lblViews', 'backend', 'Label / Views', 'script', NULL),
(690, 'lblFloorPlan', 'backend', 'Label / Floor plan', 'script', NULL),
(691, 'lblAddTypeMessage', 'backend', 'Label / Add type message', 'script', NULL),
(692, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(693, 'special_items_ARRAY_none', 'arrays', 'special_items_ARRAY_none', 'script', NULL),
(694, 'special_items_ARRAY_premium', 'arrays', 'special_items_ARRAY_premium', 'script', NULL),
(695, 'special_items_ARRAY_sold', 'arrays', 'special_items_ARRAY_sold', 'script', NULL),
(696, 'special_items_ARRAY_underoffer', 'arrays', 'special_items_ARRAY_underoffer', 'script', NULL),
(697, 'lblSpecial', 'backend', 'Label / Special', 'script', NULL),
(698, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(699, 'price_per_ARRAY_day', 'arrays', 'price_per_ARRAY_day', 'script', NULL),
(700, 'price_per_ARRAY_week', 'arrays', 'price_per_ARRAY_week', 'script', NULL),
(701, 'price_per_ARRAY_month', 'arrays', 'price_per_ARRAY_month', 'script', NULL),
(702, 'price_per_ARRAY_year', 'arrays', 'price_per_ARRAY_year', 'script', NULL),
(703, 'lblYearBuilt', 'backend', 'Label / Year built', 'script', NULL),
(704, 'lblLotDimensions', 'backend', 'Label / Lot dimensions', 'script', NULL),
(705, 'lblFloorArea', 'backend', 'Label / Floor area', 'script', NULL),
(706, 'lblBedrooms', 'backend', 'Label / Bedrooms', 'script', NULL),
(707, 'lblBathrooms', 'backend', 'Label / Bathrooms', 'script', NULL),
(708, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(709, 'infoGalleryTitle', 'backend', 'Infobox / Photos', 'script', NULL),
(710, 'infoGalleryDesc', 'backend', 'Infobox / Photos', 'script', NULL),
(711, 'infoFeatureTitle', 'backend', 'Infobox / Features', 'script', NULL),
(712, 'infoFeatureDesc', 'backend', 'Infobox / Features', 'script', NULL),
(713, 'infoOwnerFeatureTitle', 'backend', 'Infobox / Features', 'script', NULL),
(714, 'infoOwnerFeatureDesc', 'backend', 'Infobox / Features', 'script', NULL),
(715, 'infoSEOTitle', 'backend', 'Infobox / SEO settings', 'script', NULL),
(716, 'infoSEODesc', 'backend', 'Infobox / SEO settings', 'script', NULL),
(717, 'lblMetaTitle', 'backend', 'Label / Meta title', 'script', NULL),
(718, 'lblMetaTitleTip', 'backend', 'Label / Meta title', 'script', NULL),
(719, 'lblMetaKeywords', 'backend', 'Label / Meta keywords', 'script', NULL),
(720, 'lblMetaKeywordTip', 'backend', 'Label / Meta keywords', 'script', NULL),
(721, 'lblMetaDesc', 'backend', 'Label / Meta description', 'script', NULL),
(722, 'lblMetaDescTip', 'backend', 'Label / Meta description', 'script', NULL),
(723, 'infoAddressTitle', 'backend', 'Infobox / Address', 'script', NULL),
(724, 'infoAddressDesc', 'backend', 'Infobox / Address', 'script', NULL),
(725, 'lblShowOnMap', 'backend', 'Label / Show google map', 'script', NULL),
(728, 'lblZip', 'backend', 'Label / Zip / post code', 'script', NULL),
(729, 'lblGMapNote', 'backend', 'Label / Zip / post code', 'script', NULL),
(730, 'btnGoogleMapsApi', 'backend', 'Label / Zip / post code', 'script', NULL),
(731, 'lblLatitude', 'backend', 'Label / Latitude', 'script', NULL),
(732, 'lblLongitude', 'backend', 'Label / Longitude', 'script', NULL),
(734, 'lblSendToEmail', 'backend', 'Label / Send to email', 'script', NULL),
(735, 'lblPrinted', 'backend', 'Label / Printed', 'script', NULL),
(736, 'infoContactTitle', 'backend', 'Infobox / Owner contact', 'script', NULL),
(737, 'infoContactDesc', 'backend', 'Infobox / Owner contact', 'script', NULL),
(738, 'infoOwnerContactTitle', 'backend', 'Infobox / Owner contact', 'script', NULL),
(739, 'infoOwnerContactDesc', 'backend', 'Infobox / Owner contact', 'script', NULL),
(740, 'lblChooseOwner', 'backend', 'Label / Choose owner', 'script', NULL),
(741, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(742, 'lblOwnerShow', 'backend', 'Label / Show owner contact', 'script', NULL),
(743, 'lblOwnerTip', 'backend', 'Label / Owner tip', 'script', NULL),
(744, 'lblResetContactDetails', 'backend', 'Label / Load owner contact details', 'script', NULL),
(745, 'lblFax', 'backend', 'Label / Fax', 'script', NULL),
(746, 'infoFloorPlanTitle', 'backend', 'Infobox / Floor plan file', 'script', NULL),
(747, 'infoFloorPlanDesc', 'backend', 'Infobox / Floor plan file', 'script', NULL),
(748, 'lblDeleteFileConfirmation', 'backend', 'Label / Delete file confirmation', 'script', NULL),
(749, 'lblFile', 'backend', 'Label / File', 'script', NULL),
(750, 'error_titles_ARRAY_AP01', 'arrays', 'error_titles_ARRAY_AP01', 'script', NULL),
(751, 'error_bodies_ARRAY_AP01', 'arrays', 'error_bodies_ARRAY_AP01', 'script', NULL),
(752, 'error_titles_ARRAY_AP03', 'arrays', 'error_titles_ARRAY_AP03', 'script', NULL),
(753, 'error_bodies_ARRAY_AP03', 'arrays', 'error_bodies_ARRAY_AP03', 'script', NULL),
(754, 'error_titles_ARRAY_AP04', 'arrays', 'error_titles_ARRAY_AP04', 'script', NULL),
(755, 'error_bodies_ARRAY_AP04', 'arrays', 'error_bodies_ARRAY_AP04', 'script', NULL),
(756, 'error_titles_ARRAY_AP08', 'arrays', 'error_titles_ARRAY_AP08', 'script', NULL),
(757, 'error_bodies_ARRAY_AP08', 'arrays', 'error_bodies_ARRAY_AP08', 'script', NULL),
(758, 'front_file_not_found', 'frontend', 'Label / File not found', 'script', NULL),
(759, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(760, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(761, 'error_titles_ARRAY_AP09', 'arrays', 'error_titles_ARRAY_AP09', 'script', NULL),
(762, 'error_bodies_ARRAY_AP09', 'arrays', 'error_bodies_ARRAY_AP09', 'script', NULL),
(763, 'lblExtendExpireDate', 'backend', 'Label / Extend expire date', 'script', NULL),
(764, 'infoExtendTitle', 'backend', 'Infobox / Extend expiration date', 'script', NULL),
(765, 'infoExtendDesc', 'backend', 'Infobox / Extend expiration date', 'script', NULL),
(766, 'lblProperty', 'backend', 'Label / Property', 'script', NULL),
(767, 'payment_renew_paypal', 'backend', 'Label / Buy now', 'script', NULL),
(768, 'infoDescriptionTitle', 'backend', 'Infobox / Property description', 'script', NULL),
(769, 'infoDescriptionDesc', 'backend', 'Infobox / Property description', 'script', NULL),
(770, 'types_ARRAY_rent', 'arrays', 'types_ARRAY_rent', 'script', NULL),
(771, 'types_ARRAY_sale', 'arrays', 'types_ARRAY_sale', 'script', NULL),
(939, 'infoSummaryTitle', 'backend', 'Infobox / Property summary', 'script', NULL),
(940, 'infoSummaryDesc', 'backend', 'Infobox / Property summary', 'script', NULL),
(941, 'infoDetailsTitle', 'backend', 'Infobox / Details information', 'script', NULL),
(942, 'infoDetailsDesc', 'backend', 'Infobox / Details information', 'script', NULL),
(943, 'menuXMLFeed', 'backend', 'Menu / XML Feed', 'script', NULL),
(944, 'order_by_ARRAY_added', 'arrays', 'order_by_ARRAY_added', 'script', NULL),
(945, 'order_by_ARRAY_updated', 'arrays', 'order_by_ARRAY_updated', 'script', NULL),
(946, 'order_by_ARRAY_expired', 'arrays', 'order_by_ARRAY_expired', 'script', NULL),
(947, 'direction_ARRAY_ASC', 'arrays', 'direction_ARRAY_ASC', 'script', NULL),
(948, 'direction_ARRAY_DESC', 'arrays', 'direction_ARRAY_DESC', 'script', NULL),
(949, 'btnGetFeedURL', 'backend', 'Buttons / Get Feed URL', 'script', NULL),
(950, 'infoXMLFeedTitle', 'backend', 'Infobox / XML Feed', 'script', NULL),
(951, 'infoXMLFeedDesc', 'backend', 'Infobox / XML Feed', 'script', NULL),
(952, 'infoPropertiesFeedTitle', 'backend', 'Infobox / Properties feed URL', 'script', NULL),
(953, 'infoPropertiesFeedDesc', 'backend', 'Infobox / Properties feed URL', 'script', NULL),
(954, 'lblEnterPassword', 'backend', 'Label / Enter password', 'script', NULL),
(955, 'lblOrderBy', 'backend', 'Label / Order by', 'script', NULL),
(956, 'lblNoAccessToFeed', 'backend', 'Label / No access to XML feed', 'script', NULL),
(957, 'lblTotalProperties', 'backend', 'Label / total properties', 'script', NULL),
(959, 'lblActiveForRent', 'backend', 'Label / active for rent', 'script', NULL),
(960, 'lblActiveForSale', 'backend', 'Label / active for sale', 'script', NULL),
(961, 'lblLatestAdded', 'backend', 'Label / Latest added', 'script', NULL),
(962, 'lblLatestUpdated', 'backend', 'Label / Latest updated', 'script', NULL),
(963, 'lblNextExpiring', 'backend', 'Label / Next expiring', 'script', NULL),
(964, 'lblNoPropertiesFound', 'backend', 'Label / No properties found', 'script', NULL),
(965, 'lblID', 'backend', 'Label / ID', 'script', NULL),
(966, 'lblExpireOn', 'backend', 'Label / Expire on', 'script', NULL),
(967, 'lblOptional', 'backend', 'Label / Optional', 'script', NULL),
(968, 'lblInstallPhp1Title', 'backend', 'Label / Install description', 'script', NULL),
(969, 'opt_o_property_page', 'backend', 'Options / page title', 'script', NULL),
(970, 'lblInstallPhp1_1', 'backend', 'Label / Install PHP Step 1', 'script', NULL),
(971, 'lblInstallPhp1_2', 'backend', 'Label / Install PHP Step 2', 'script', NULL),
(972, 'lblInstallPhp1_2a', 'backend', 'Label / Install PHP Step 2a', 'script', NULL),
(973, 'lblInstallPhp1_3', 'backend', 'Label / Install PHP Step 3', 'script', NULL),
(974, 'lblInstallPhp2Title', 'backend', 'Label / Install SEO', 'script', NULL),
(975, 'opt_o_seo_url', 'backend', 'Options / Use SEO Friendly URLs', 'script', NULL),
(976, 'lblInstallPhp2_1', 'backend', 'Label / Install step 2_1', 'script', NULL),
(977, 'lblInstallPhp2_2', 'backend', 'Label / Install step 2_2', 'script', NULL),
(978, 'infoInstallSEODesc', 'backend', 'Infobox / Install SEO description', 'script', NULL),
(979, 'lblHomePage', 'backend', 'Label / Home page', 'script', NULL),
(980, 'lblMapPage', 'backend', 'Label / Map page', 'script', NULL),
(981, 'lblAccountPage', 'backend', 'Label / Account page', 'script', NULL),
(982, 'lblListingMetaTitle', 'backend', 'Label / Meta title', 'script', NULL),
(983, 'lblListingMetaKeywords', 'backend', 'Label / Meta keywords', 'script', NULL),
(984, 'lblListingMetaDesc', 'backend', 'Label / Meta description', 'script', NULL),
(985, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(986, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(987, 'menu_login', 'frontend', 'Login / Sign up', 'script', NULL),
(988, 'menu_map', 'frontend', 'Menu / Map', 'script', NULL),
(989, 'menu_all', 'frontend', 'Menu / All', 'script', NULL),
(990, 'front_types_ARRAY_sale', 'arrays', 'front_types_ARRAY_sale', 'script', NULL),
(991, 'front_types_ARRAY_rent', 'arrays', 'front_types_ARRAY_rent', 'script', NULL),
(992, 'front_location', 'frontend', 'Label / Location', 'script', NULL),
(993, 'front_type', 'frontend', 'Label / Type', 'script', NULL),
(994, 'front_choose', 'frontend', 'Label / Choose', 'script', NULL),
(995, 'front_all', 'frontend', 'Label / All', 'script', NULL),
(996, 'front_specials', 'frontend', 'Label / Specials', 'script', NULL),
(997, 'front_bedrooms', 'frontend', 'Label / Bedrooms', 'script', NULL),
(998, 'front_bathrooms', 'frontend', 'Label / Bathrooms', 'script', NULL),
(999, 'front_min', 'frontend', 'Label / Min', 'script', NULL),
(1000, 'front_max', 'frontend', 'Label / Max', 'script', NULL),
(1001, 'front_floor_area', 'frontend', 'Label / Floor area', 'script', NULL),
(1002, 'front_more_filters', 'frontend', 'Label / more filters', 'script', NULL),
(1003, 'front_button_search', 'frontend', 'Label / Search', 'script', NULL),
(1004, 'front_view_details', 'frontend', 'Label / View details', 'script', NULL),
(1005, 'front_area', 'frontend', 'Label / Area', 'script', NULL),
(1006, 'front_beds', 'frontend', 'Label / Beds', 'script', NULL),
(1007, 'front_baths', 'frontend', 'Label / Baths', 'script', NULL),
(1008, 'menu_account', 'frontend', 'Menu / My Account', 'script', NULL),
(1009, 'menu_sign_out', 'frontend', 'Menu / Sign out', 'script', NULL),
(1010, 'property_statuses_ARRAY_100', 'arrays', 'property_statuses_ARRAY_100', 'script', NULL),
(1011, 'property_statuses_ARRAY_101', 'arrays', 'property_statuses_ARRAY_101', 'script', NULL),
(1012, 'front_back', 'frontend', 'Labl / Back', 'script', NULL),
(1013, 'front_request_details', 'frontend', 'Labl / Request Details', 'script', NULL),
(1014, 'front_print', 'frontend', 'Labl / Print', 'script', NULL),
(1015, 'front_send_to_email', 'frontend', 'Labl / Send to email', 'script', NULL),
(1016, 'front_for_ARRAY_rent', 'arrays', 'front_for_ARRAY_rent', 'script', NULL),
(1017, 'front_for_ARRAY_sale', 'arrays', 'front_for_ARRAY_sale', 'script', NULL),
(1018, 'front_reference_id', 'frontend', 'Label / Reference ID', 'script', NULL),
(1019, 'front_price', 'frontend', 'Label / Price', 'script', NULL),
(1021, 'front_bedroom', 'frontend', 'Label / Bedroom', 'script', NULL),
(1022, 'front_bathroom', 'frontend', 'Label / Bathroom', 'script', NULL),
(1023, 'front_year_built', 'frontend', 'Label / Year built', 'script', NULL),
(1024, 'front_lot_dimensions', 'frontend', 'Label / Lot dimensions', 'script', NULL),
(1025, 'front_floor_plan', 'frontend', 'Label / Floor plan', 'script', NULL),
(1026, 'front_description', 'frontend', 'Label / Description', 'script', NULL),
(1027, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(1028, 'front_map', 'frontend', 'Label / Map', 'script', NULL),
(1029, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(1030, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(1031, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(1032, 'front_address_1', 'frontend', 'Label / Address 1', 'script', NULL),
(1033, 'front_address_2', 'frontend', 'Label / Address 2', 'script', NULL),
(1034, 'front_zip', 'frontend', 'Label / Address 2', 'script', NULL),
(1035, 'front_more_for_rent', 'frontend', 'Label / More properties for rent', 'script', NULL),
(1036, 'front_more_for_sale', 'frontend', 'Label / More properties for sale', 'script', NULL),
(1037, 'front_send_email', 'frontend', 'Label / Send email', 'script', NULL),
(1038, 'front_send_to', 'frontend', 'Label / Send to', 'script', NULL),
(1039, 'front_subject', 'frontend', 'Label / Subject', 'script', NULL),
(1040, 'front_message', 'frontend', 'Label / Message', 'script', NULL),
(1041, 'front_cancel', 'frontend', 'Label / Cancel', 'script', NULL),
(1042, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(1043, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(1044, 'front_fax', 'frontend', 'Label / Fax', 'script', NULL),
(1045, 'front_email', 'frontend', 'Label / Email', 'script', NULL),
(1046, 'front_send_to_required', 'frontend', 'Label / Send to is required.', 'script', NULL),
(1047, 'front_email_invalid', 'frontend', 'Label / Email is invalid.', 'script', NULL),
(1048, 'front_subject_required', 'frontend', 'Label / Subject is required.', 'script', NULL),
(1049, 'front_message_required', 'frontend', 'Label / Message is required.', 'script', NULL),
(1050, 'front_send', 'frontend', 'Labl / Send', 'script', NULL),
(1051, 'front_message_sending', 'frontend', 'Label / Message is sending...', 'script', NULL),
(1052, 'front_message_sent', 'frontend', 'Label / Message sent', 'script', NULL),
(1053, 'front_request_sending', 'frontend', 'Label / Your request is sending...', 'script', NULL),
(1054, 'front_request_sent', 'frontend', 'Label / Your request has been sent successfully to property''s owner.', 'script', NULL),
(1055, 'front_login_to_your_account', 'frontend', 'Label / Login to your Account', 'script', NULL),
(1056, 'front_login_text', 'frontend', 'Label / Login text', 'script', NULL),
(1057, 'front_password', 'frontend', 'Label / Password', 'script', NULL),
(1058, 'front_forgot_password', 'frontend', 'Label / Forgot password?', 'script', NULL),
(1059, 'front_create_an_account', 'frontend', 'Label / Create an Account', 'script', NULL),
(1060, 'front_create_an_account_text', 'frontend', 'Label / Create an Account', 'script', NULL),
(1061, 'front_reenter_password', 'frontend', 'Label / Re-enter password', 'script', NULL),
(1062, 'front_submit', 'frontend', 'Label / Submit', 'script', NULL),
(1063, 'front_password_required', 'frontend', 'Label / Password is required.', 'script', NULL),
(1064, 'front_name_required', 'frontend', 'Label / Name is required.', 'script', NULL),
(1065, 'front_reenter_password_required', 'frontend', 'Label / Re-enter password is required.', 'script', NULL),
(1066, 'front_password_match', 'frontend', 'Label / Password does not match.', 'script', NULL),
(1067, 'front_login', 'frontend', 'Label / Login', 'script', NULL),
(1068, 'front_email_required', 'frontend', 'Label / Email is required.', 'script', NULL),
(1069, 'register_err_ARRAY_101', 'arrays', 'register_err_ARRAY_101', 'script', NULL),
(1070, 'register_err_ARRAY_102', 'arrays', 'register_err_ARRAY_102', 'script', NULL),
(1071, 'register_err_ARRAY_103', 'arrays', 'register_err_ARRAY_103', 'script', NULL),
(1072, 'register_err_ARRAY_104', 'arrays', 'register_err_ARRAY_104', 'script', NULL),
(1073, 'register_err_ARRAY_105', 'arrays', 'register_err_ARRAY_105', 'script', NULL),
(1074, 'register_err_ARRAY_106', 'arrays', 'register_err_ARRAY_106', 'script', NULL),
(1075, 'register_err_ARRAY_107', 'arrays', 'register_err_ARRAY_107', 'script', NULL),
(1076, 'register_err_ARRAY_108', 'arrays', 'register_err_ARRAY_108', 'script', NULL),
(1077, 'register_err_ARRAY_109', 'arrays', 'register_err_ARRAY_109', 'script', NULL),
(1078, 'register_err_ARRAY_110', 'arrays', 'register_err_ARRAY_110', 'script', NULL),
(1079, 'register_statuses_ARRAY_200', 'arrays', 'register_statuses_ARRAY_200', 'script', NULL),
(1080, 'register_statuses_ARRAY_201', 'arrays', 'register_statuses_ARRAY_201', 'script', NULL),
(1081, 'forgot_statuses_ARRAY_200', 'arrays', 'forgot_statuses_ARRAY_200', 'script', NULL),
(1082, 'front_forgot_password_text', 'frontend', 'Label / Forgot password text', 'script', NULL),
(1083, 'front_err_ARRAY_101', 'arrays', 'front_err_ARRAY_101', 'script', NULL),
(1084, 'front_err_ARRAY_102', 'arrays', 'front_err_ARRAY_102', 'script', NULL),
(1085, 'front_err_ARRAY_103', 'arrays', 'front_err_ARRAY_103', 'script', NULL),
(1086, 'front_err_ARRAY_104', 'arrays', 'front_err_ARRAY_104', 'script', NULL),
(1087, 'front_err_ARRAY_105', 'arrays', 'front_err_ARRAY_105', 'script', NULL),
(1088, 'front_home', 'frontend', 'Label / Home', 'script', NULL),
(1089, 'front_view_all', 'frontend', 'Label / View all', 'script', NULL),
(1090, 'front_label_for', 'frontend', 'Label / for', 'script', NULL),
(1091, 'front_for_arr_ARRAY_rent', 'arrays', 'front_for_arr_ARRAY_rent', 'script', NULL),
(1092, 'front_for_arr_ARRAY_sale', 'arrays', 'front_for_arr_ARRAY_sale', 'script', NULL),
(1093, 'front_property_details', 'frontend', 'Label / Property Details', 'script', NULL),
(1094, 'front_contact_details', 'frontend', 'Label / Contact Details', 'script', NULL),
(1095, 'front_request_information', 'frontend', 'Label / Request Information', 'script', NULL),
(1274, 'property_statuses_ARRAY_102', 'arrays', 'property_statuses_ARRAY_102', 'script', NULL),
(1275, 'property_statuses_ARRAY_103', 'arrays', 'property_statuses_ARRAY_103', 'script', NULL),
(1276, 'front_no_properties_found', 'frontend', 'Label / No properties found.', 'script', NULL),
(1277, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(1278, 'front_captcha_required', 'frontend', 'Label / Captcha is required.', 'script', NULL),
(1279, 'front_captcha_incorrect', 'frontend', 'Label / Captcha is incorrect.', 'script', NULL),
(1280, 'register_err_ARRAY_111', 'arrays', 'register_err_ARRAY_111', 'script', NULL),
(1281, 'register_err_ARRAY_112', 'arrays', 'register_err_ARRAY_112', 'script', NULL),
(1282, 'register_err_ARRAY_113', 'arrays', 'register_err_ARRAY_113', 'script', NULL),
(1283, 'lblInstallPhp3Title', 'backend', 'Label / Install featured properties', 'script', NULL),
(1284, 'lblInstallFeatured', 'backend', 'Label / Featured properties', 'script', NULL),
(1285, 'front_owner_contact', 'frontend', 'Label / Contact Details', 'script', NULL),
(1286, 'lblFeedURLInvalid', 'backend', 'Label / Feed URL invalid.', 'script', NULL),
(1287, 'pj_digits_only', 'backend', 'Label / Please enter digits only.', 'script', NULL),
(1288, 'pj_positive_number', 'backend', 'Label / Please enter positive number.', 'script', NULL),
(1289, 'front_layout1_all', 'frontend', 'Label / All', 'script', NULL);
INSERT INTO `property_listing_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1290, 'front_layout1_map', 'frontend', 'Label / Map', 'script', NULL),
(1291, 'front_layout1_menu_login', 'frontend', 'Label / Login / Signup', 'script', NULL),
(1292, 'front_layout1_location', 'frontend', 'Label / Location', 'script', NULL),
(1293, 'front_layout1_type', 'frontend', 'Label / Type', 'script', NULL),
(1294, 'front_layout1_choose', 'frontend', 'Label / Choose', 'script', NULL),
(1295, 'front_layout1_specials', 'frontend', 'Label / Specials', 'script', NULL),
(1296, 'front_layout1_bedrooms', 'frontend', 'Label / Bedrooms', 'script', NULL),
(1297, 'front_layout1_min', 'frontend', 'Label / Min', 'script', NULL),
(1298, 'front_layout1_max', 'frontend', 'Label / Max', 'script', NULL),
(1299, 'front_layout1_bathrooms', 'frontend', 'Label / Bathrooms', 'script', NULL),
(1300, 'front_layout1_floor_area', 'frontend', 'Label / Floor area', 'script', NULL),
(1301, 'front_layout1_button_search', 'frontend', 'Button / Search', 'script', NULL),
(1302, 'front_layout1_area', 'frontend', 'Button / Area', 'script', NULL),
(1303, 'front_layout1_beds', 'frontend', 'Button / Beds', 'script', NULL),
(1304, 'front_layout1_baths', 'frontend', 'Button / Baths', 'script', NULL),
(1305, 'front_layout1_special_items_ARRAY_none', 'arrays', 'front_layout1_special_items_ARRAY_none', 'script', NULL),
(1306, 'front_layout1_special_items_ARRAY_premium', 'arrays', 'front_layout1_special_items_ARRAY_premium', 'script', NULL),
(1307, 'front_layout1_special_items_ARRAY_sold', 'arrays', 'front_layout1_special_items_ARRAY_sold', 'script', NULL),
(1308, 'front_layout1_special_items_ARRAY_underoffer', 'arrays', 'front_layout1_special_items_ARRAY_underoffer', 'script', NULL),
(1309, 'front_layout1_label_for', 'frontend', 'Label / For', 'script', NULL),
(1310, 'front_layout1_for_ARRAY_rent', 'arrays', 'front_layout1_for_ARRAY_rent', 'script', NULL),
(1311, 'front_layout1_for_ARRAY_sale', 'arrays', 'front_layout1_for_ARRAY_sale', 'script', NULL),
(1312, 'front_layout1_full_details', 'frontend', 'Label / Full Details', 'script', NULL),
(1313, 'front_layout1_next', 'frontend', 'Label / Next', 'script', NULL),
(1314, 'front_layout1_prev', 'frontend', 'Label / Prev', 'script', NULL),
(1315, 'front_layout1_reference_id', 'frontend', 'Label / Reference ID', 'script', NULL),
(1316, 'front_layout1_bedroom', 'frontend', 'Label / Bedroom', 'script', NULL),
(1317, 'front_layout1_bathroom', 'frontend', 'Label / Bathroom', 'script', NULL),
(1318, 'front_layout1_year_built', 'frontend', 'Label / Year built', 'script', NULL),
(1319, 'front_layout1_lot_dimensions', 'frontend', 'Label / Lot dimensions', 'script', NULL),
(1320, 'front_layout1_floor_plan', 'frontend', 'Label / Floor plan', 'script', NULL),
(1321, 'front_layout1_description', 'frontend', 'Label / Description', 'script', NULL),
(1322, 'front_layout1_address', 'frontend', 'Label / Address', 'script', NULL),
(1323, 'front_layout1_country', 'frontend', 'Label / Country', 'script', NULL),
(1324, 'front_layout1_state', 'frontend', 'Label / State', 'script', NULL),
(1325, 'front_layout1_city', 'frontend', 'Label / City', 'script', NULL),
(1326, 'front_layout1_address_1', 'frontend', 'Label / Address 1', 'script', NULL),
(1327, 'front_layout1_address_2', 'frontend', 'Label / Address 2', 'script', NULL),
(1328, 'front_layout1_zip', 'frontend', 'Label / Zip code', 'script', NULL),
(1329, 'front_layout1_contact_details', 'frontend', 'Label / Contact Details', 'script', NULL),
(1330, 'front_layout1_name', 'frontend', 'Label / Name', 'script', NULL),
(1331, 'front_layout1_email', 'frontend', 'Label / Email', 'script', NULL),
(1332, 'front_layout1_phone', 'frontend', 'Label / Phone', 'script', NULL),
(1333, 'front_layout1_fax', 'frontend', 'Label / Fax', 'script', NULL),
(1334, 'front_layout1_login_to_account', 'backend', 'Label / Login to your Account', 'script', NULL),
(1335, 'front_layout1_login_text', 'backend', 'Label / Login text', 'script', NULL),
(1336, 'front_layout1_email_required', 'backend', 'Label / Email is required.', 'script', NULL),
(1337, 'front_layout1_email_invalid', 'backend', 'Label / Email is invalid.', 'script', NULL),
(1338, 'front_layout1_password', 'backend', 'Label / Password', 'script', NULL),
(1339, 'front_layout1_password_required', 'backend', 'Label / Password is required.', 'script', NULL),
(1340, 'front_layout1_login', 'backend', 'Label / Login', 'script', NULL),
(1341, 'front_layout1_forgot_password', 'backend', 'Label / Forgot password?', 'script', NULL),
(1342, 'front_layout1_create_account', 'backend', 'Label / Create an Account', 'script', NULL),
(1343, 'front_layout1_account_text', 'backend', 'Label / Create an Account', 'script', NULL),
(1344, 'front_layout1_name_required', 'backend', 'Label / Name is required.', 'script', NULL),
(1345, 'front_layout1_reenter_password', 'backend', 'Label / Re-enter password', 'script', NULL),
(1346, 'front_layout1_reenter_password_required', 'backend', 'Label / Re-enter password is required.', 'script', NULL),
(1347, 'front_layout1_password_match', 'backend', 'Label / Password does not match.', 'script', NULL),
(1348, 'front_layout1_captcha', 'backend', 'Label / Captcha', 'script', NULL),
(1349, 'front_layout1_captcha_required', 'backend', 'Label / Captcha is required.', 'script', NULL),
(1350, 'front_layout1_captcha_incorrect', 'backend', 'Label / Captcha is incorrect.', 'script', NULL),
(1351, 'front_layout1_send', 'backend', 'Label / Send', 'script', NULL),
(1352, 'front_layout1_forgot_text', 'backend', 'Label / Forgot password text', 'script', NULL),
(1353, 'front_layout1_contact', 'backend', 'Label / Contact', 'script', NULL),
(1354, 'front_layout1_message', 'backend', 'Label / Message', 'script', NULL),
(1355, 'front_layout1_message_required', 'backend', 'Label / Message is required.', 'script', NULL),
(1356, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(1357, 'gridEmptyBody', 'backend', 'Grid / You need to select at least a single record.', 'script', NULL),
(1358, 'lblNA', 'backend', 'Label / Not available', 'script', NULL),
(1359, 'error_titles_ARRAY_AP10', 'arrays', 'error_titles_ARRAY_AP10', 'script', NULL),
(1360, 'error_bodies_ARRAY_AP10', 'arrays', 'error_bodies_ARRAY_AP10', 'script', NULL),
(1361, 'front_layout1_close', 'frontend', 'Label / Close', 'script', NULL),
(1362, 'front_email_exists', 'frontend', 'Label / Email was already used.', 'script', NULL),
(1363, 'register_err_ARRAY_114', 'arrays', 'register_err_ARRAY_114', 'script', NULL),
(1364, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(1365, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(1366, 'infoPropertiesTitle', 'backend', 'Infobox / List of properties', 'script', NULL),
(1367, 'infoPropertiesDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(1368, 'infoPreviewTitle', 'backend', 'Infobox / Preview', 'script', NULL),
(1369, 'infoPreviewDesc', 'backend', 'Infobox / Preview', 'script', NULL),
(1370, 'btnPreviewFrontEnd', 'backend', 'Button / Preview Front End', 'script', NULL),
(1371, 'btnPreviewFeatured', 'backend', 'Button / Preview Featured Properties', 'script', NULL);

INSERT INTO `property_listing_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjFeature', 1, 'name', 'Air conditioning', 'data'),
(NULL, 2, 'pjFeature', 1, 'name', 'Attic', 'data'),
(NULL, 3, 'pjFeature', 1, 'name', 'Balcony, Deck or Patio', 'data'),
(NULL, 4, 'pjFeature', 1, 'name', 'Basement', 'data'),
(NULL, 5, 'pjFeature', 1, 'name', 'Bonus / Rec room', 'data'),
(NULL, 6, 'pjFeature', 1, 'name', 'Breakfast nook', 'data'),
(NULL, 7, 'pjFeature', 1, 'name', 'Business center', 'data'),
(NULL, 8, 'pjFeature', 1, 'name', 'Cable- ready', 'data'),
(NULL, 9, 'pjFeature', 1, 'name', 'Central heat', 'data'),
(NULL, 10, 'pjFeature', 1, 'name', 'Clubhouse', 'data'),
(NULL, 11, 'pjFeature', 1, 'name', 'Covered parking', 'data'),
(NULL, 12, 'pjFeature', 1, 'name', 'Dining room', 'data'),
(NULL, 13, 'pjFeature', 1, 'name', 'Dishwasher', 'data'),
(NULL, 14, 'pjFeature', 1, 'name', 'Dryer', 'data'),
(NULL, 15, 'pjFeature', 1, 'name', 'Elevator', 'data'),
(NULL, 16, 'pjFeature', 1, 'name', 'Family room', 'data'),
(NULL, 17, 'pjFeature', 1, 'name', 'Fireplace', 'data'),
(NULL, 18, 'pjFeature', 1, 'name', 'Fitness center', 'data'),
(NULL, 19, 'pjFeature', 1, 'name', 'Garage parking', 'data'),
(NULL, 20, 'pjFeature', 1, 'name', 'Gated property', 'data'),
(NULL, 21, 'pjFeature', 1, 'name', 'Golf course', 'data'),
(NULL, 22, 'pjFeature', 1, 'name', 'Granite countertop', 'data'),
(NULL, 23, 'pjFeature', 1, 'name', 'Guest parking', 'data'),
(NULL, 24, 'pjFeature', 1, 'name', 'Hardwood floor', 'data'),
(NULL, 25, 'pjFeature', 1, 'name', 'High / Vaulted ceiling', 'data'),
(NULL, 26, 'pjFeature', 1, 'name', 'High- speed internet', 'data'),
(NULL, 27, 'pjFeature', 1, 'name', 'Jacuzzi / Whirlpool', 'data'),
(NULL, 28, 'pjFeature', 1, 'name', 'Lake', 'data'),
(NULL, 29, 'pjFeature', 1, 'name', 'Laundry area - garage', 'data'),
(NULL, 30, 'pjFeature', 1, 'name', 'Laundry area - inside', 'data'),
(NULL, 31, 'pjFeature', 1, 'name', 'Laundry on-site', 'data'),
(NULL, 32, 'pjFeature', 1, 'name', 'Living Room', 'data'),
(NULL, 33, 'pjFeature', 1, 'name', 'Loft layout', 'data'),
(NULL, 34, 'pjFeature', 1, 'name', 'Microwave', 'data'),
(NULL, 35, 'pjFeature', 1, 'name', 'New property (<5 years)', 'data'),
(NULL, 36, 'pjFeature', 1, 'name', 'Office / Den', 'data'),
(NULL, 37, 'pjFeature', 1, 'name', 'Playground', 'data'),
(NULL, 38, 'pjFeature', 1, 'name', 'Refrigerator', 'data'),
(NULL, 39, 'pjFeature', 1, 'name', 'Sauna', 'data'),
(NULL, 40, 'pjFeature', 1, 'name', 'Sauna / Spa', 'data'),
(NULL, 41, 'pjFeature', 1, 'name', 'Secured entry', 'data'),
(NULL, 42, 'pjFeature', 1, 'name', 'Small building', 'data'),
(NULL, 43, 'pjFeature', 1, 'name', 'Stainless steel appliances', 'data'),
(NULL, 44, 'pjFeature', 1, 'name', 'Storage space(s)', 'data'),
(NULL, 45, 'pjFeature', 1, 'name', 'Stove / Oven', 'data'),
(NULL, 46, 'pjFeature', 1, 'name', 'Swimming pool', 'data'),
(NULL, 47, 'pjFeature', 1, 'name', 'Swimming pool(s)', 'data'),
(NULL, 48, 'pjFeature', 1, 'name', 'Tennis court(s)', 'data'),
(NULL, 49, 'pjFeature', 1, 'name', 'Tile floor', 'data'),
(NULL, 50, 'pjFeature', 1, 'name', 'Vintage building', 'data'),
(NULL, 51, 'pjFeature', 1, 'name', 'Walk-in closet', 'data'),
(NULL, 52, 'pjFeature', 1, 'name', 'Washer', 'data'),
(NULL, 53, 'pjFeature', 1, 'name', 'Wheelchair access', 'data'),
(NULL, 54, 'pjFeature', 1, 'name', 'Yard', 'data'),
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Start adding the address and using Google Map API exact address suggestions will be offered.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Properties', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Types', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Features', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Floor metrics', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Price format', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Number of properties per page', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Theme', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Show contact form', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'New request email', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send an email to owner after there is new request for his/her property. Otherwise select ''No''.', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'New request email subject', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'New request email message', 'script'),
(NULL, 544, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Message}', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Registration email', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send an email to owners after they created new account. Otherwise select ''No''.', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Registration email subject', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Registration email message', 'script'),
(NULL, 549, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'New property submitted email', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send an email to owner after they submitted new properties to the system. Otherwise select ''No''.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'New property submitted email subject', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'New property submitted email message', 'script'),
(NULL, 554, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Password recovery email', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Password recovery email subject', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Password recovery email message', 'script'),
(NULL, 558, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Password}', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'New request SMS', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send SMS notifications to owner if there is new request for his/her properties. Otherwise, select ''No''.', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'New request SMS content', 'script'),
(NULL, 562, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Message}', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Registration SMS', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send SMS notifications to owner after they created new account. Otherwise, select ''No''. 	', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Registration SMS content', 'script'),
(NULL, 566, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'New property submitted SMS', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send SMS to owner after they submitted new properties to the system. Otherwise select ''No''.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'New property submitted SMS content', 'script'),
(NULL, 570, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{RefID}\r\n{Type}', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Send to email', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Send to email', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send notification to administrator after new request made. Otherwise, select ''No''.', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send notification to administrator after new account created. Otherwise, select ''No''.', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send notification to administrator after new property submitted. Otherwise, select ''No''.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send SMS to administrator after new account created. Otherwise, select ''No''.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send SMS to administrator after new property submitted. Otherwise, select ''No''.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Owner', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Notifications to owners', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Set and customize email and SMS notifications to your owners to prompt new actions or send them important information. You can enable or disable sending the notifications below. You can personalize emails with subscribers'' names and other information using the available tokens.', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Notifications to system admin', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Create customized email and SMS messages that will be sent to administrators (you). You can enable or disable sending of the notifications below. You can also personalize emails with subscribers'' names and other information using the available tokens.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Notifications updated', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Property Types', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Here you can add, delete and manage property types. It is mandatory to have at least one property type added into the system, because it is mandatory to assign a type to each property.', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'The type name was already used.', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Add type', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Enter type name and then click Save button.', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Type updated', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'All changes made to type have been saved.', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Type added', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'A new type has been added into the list.', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Type failed to add', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'We are sorry that new type could not be added successfully.', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Type not found', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'We are sorry that the type you are looking for is missing.', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Update type', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Edit the name of property type and then click Save button.', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Community features', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Property features', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Send to email subject', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Send to email message', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Notifications to administrators', 'script'),
(NULL, 614, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{YourName}\r\n{YourEmail}\r\n{FriendName}\r\n{FriendEmail}\r\n{URL}', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Feature name', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Feature category', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Features list', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'You can set up and manage a list with pre-defined features which can be used to describe in brief property features. The pre-defined features list which is set here, will show up on Features tab while editing a property.', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Add new feature', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Enter feature name and select category, and then click Save button.', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Update feature', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Edit information on the form below and click Save button.', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Feature updated', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'All changes made to feature have been saved.', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Feature added', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'A new feature has been added into the list.', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Feature failed to add', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'We are sorry that new feature could not be added.', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Feature not found', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'We are sorry that the feature you are looking for is missing.', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Number of properties to show on Featured Properties listing', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'If the number of the properties marked as featured is bigger than the one set here, then they will show on random basis in the Featured Properties listing.', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Allow users to submit properties', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'Automatically activate new owner accounts', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'If you choose ''Yes'' new owner accounts will be active immediately after they are created. If you choose ''No'' you will have to activate new accounts manually (through Users menu), and after that owners will be able to log in and use them.', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'Submissions', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Property Submissions by Users', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'You can allow/disallow website users to submit their own properties after registering into the system. These users are named ''Owner''. You can manage owner''s accounts through Users menu. You can also charge owners for publishing their properties. If you wish to enable user submissions set carefully all options bellow and also set the Notifications tab options.', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Set prices for submitting properties by owners. You can charge different price according to the length of time that the property is active (visible) on your listing. To do this add and manage "period / price" rows below. If you wish to set a "free trial" period then set the number of the days and set "0" into the price field. If you do not wish to charge owners for submitting their properties, then leave just one "period / price" row, define a relevant large number of days into the period filed, and set "0" into the price field.', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Period', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 642, 'pjField', 1, 'title', '+ Add period / price', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Set your PayPal address', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Submissions updated', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'All the changes made to submissions have been saved.', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Are you sure you want to delete selected period/price?', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Featured', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Reference ID', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Publish', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Published', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Not published', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Extend exp. date', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Expire', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Exp. date', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Expiration date + 30 days', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Unlimited', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Add property', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Owner', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Keyword', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Add new property', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Start submitting your property with choosing its type, status and reference ID. All of them are mandatory fields. If you are using the system for the first time and you do not have a type to choose (or you do not see the type you need) then go to Options menu -> Types tab and add the property types you wish to use.', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Make featured', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'The system auto fills an incremental number. You can replace it with an ID of your choice any time.', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'You can add a property but choose not to show it on the website listing by choosing "Inactive". You can publish the property by choosing "Active" or you can make it live only till a certain date by choosing "Based on expiration date".', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'Featured properties go at the top of all listed properties and are marked as such.', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Based on expiration date', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Set a date until the property will be published. Make sure Publish status is set based on exp. date', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'Summary', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Features', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'SEO', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Address not found', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Not active', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'Extend', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'Property summary', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'Pay attention to Expire date status. If it says "Not active" then your property is not published on the website listing yet. Click on "Publish" button and choose the appropriate submission period for you. If there is a specific date as a status, then your property will be live on the website listing till that date. You can extend that period by clicking on "Extend expire date" button. If the status says "Unlimited", then the property will be live until not deleted.', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'Added on', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Last updated on', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'Views', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Floor plan', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'You need to add at least one type. Click {ADD_TYPE_TAG}here{ADD_TYPE_ENDTAG} to add.', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'None', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'Premium', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'Sold', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Under offer', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Special', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'per day', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'per week', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'per month', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'per year', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'Year built', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'Lot dimensions', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Floor area', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Bedrooms', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'Bathrooms', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Upload as many images as you want for this property. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'Features', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'You can use the pre-defined list of features below to describe in brief the property features. To manage the list with pre-defined features go to Options menu -> Features tab.', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'Features', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'You can use the pre-defined list of features below to describe in brief the accommodation property features.', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'SEO settings', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to your property details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Meta title', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'Give a title to your property details web page. For search engines it is highly recommended to have nice, descriptive title with your main keyword phrase. It will also appear in browser headers.', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'Meta keywords', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'This meta tag has lost its importance. You can leave it empty or use it to lit your keywords. Use comma to separate you keyword phrases.', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Meta description', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'Write a short description of what is your web page (property detail page) for. It is best if you limit your description to 160 characters (with the spaces).', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Start adding the address and using Google Map API exact address suggestions will be offered.', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'Show google map', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'Zip / post code', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Click on the button to get the location coordinates from Google Maps API. The full address should be submitted above first. You can also enter long/lat coordinates for your property on your own.', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'Get coordinates from Google Maps API', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'Latitude', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'Longitude', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'Send to email', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'Printed', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'Owner contact', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'If you have "Owner" type of users into the system, then you can assign an owner to a property. If owners submit properties through their accounts then an owner and a property will be linked together automatically.', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'Owner contact', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Choose whether you wish to show your contact detail on property details page or not. You can edit your contact details on Profile menu.', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'Choose owner', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'Show owner contact', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'Choose Yes/No to show/hide the owner contact information on the property details page.', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'Load owner contact details', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'Floor plan file', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'Below you can upload file for floor plan.', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'Do you want to delete this file?', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'File', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'Property updated', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'All changes made to property have been saved.', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'Property added', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'A new property has been added into the list.', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'Property failed to add', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'We are sorry that new property could not be added successfully.', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'Property not found', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'We are sorry that property you are looking for is missing.', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'File not found', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'No permissions', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'You have no permissions to edit the property.', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Extend expire date', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'Extend expiration date', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'To publish your property or to extend its expiration date (if the property has already been published) choose the appropriate submission period. If for the desired period charges are applicable, then click on "Buy now" button and make the payment required. After payment is received the property will be automatically published / extended.', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'Property', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Buy now', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'Property description', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'You can write the full description for the property on the field below.', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'For rent', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'For sale', 'script'),
(NULL, 939, 'pjField', 1, 'title', 'Property summary', 'script'),
(NULL, 940, 'pjField', 1, 'title', 'Here you can see the summary of the property. Pay attention to Expire date status. If it says "Not active" then the property is not published on the website listing yet. ', 'script'),
(NULL, 941, 'pjField', 1, 'title', 'Details information', 'script'),
(NULL, 942, 'pjField', 1, 'title', 'Below you can set more details information for the property.', 'script'),
(NULL, 943, 'pjField', 1, 'title', 'XML Feed', 'script'),
(NULL, 944, 'pjField', 1, 'title', 'Last added', 'script'),
(NULL, 945, 'pjField', 1, 'title', 'Last updated', 'script'),
(NULL, 946, 'pjField', 1, 'title', 'Expiration date', 'script'),
(NULL, 947, 'pjField', 1, 'title', 'ASC', 'script'),
(NULL, 948, 'pjField', 1, 'title', 'DESC', 'script'),
(NULL, 949, 'pjField', 1, 'title', 'Get Feed URL', 'script'),
(NULL, 950, 'pjField', 1, 'title', 'XML Feed', 'script'),
(NULL, 951, 'pjField', 1, 'title', 'Here you can see some parameters to get the feed URL. Please enter the password, so the feed URL can be access from public.', 'script'),
(NULL, 952, 'pjField', 1, 'title', 'Properties feed URL', 'script'),
(NULL, 953, 'pjField', 1, 'title', 'Use the URL below to have access to all properties. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 954, 'pjField', 1, 'title', 'Enter password', 'script'),
(NULL, 955, 'pjField', 1, 'title', 'Order by', 'script'),
(NULL, 956, 'pjField', 1, 'title', 'No access to XML feed', 'script'),
(NULL, 957, 'pjField', 1, 'title', 'total properties', 'script'),
(NULL, 959, 'pjField', 1, 'title', 'active for rent', 'script'),
(NULL, 960, 'pjField', 1, 'title', 'active for sale', 'script'),
(NULL, 961, 'pjField', 1, 'title', 'Latest added', 'script'),
(NULL, 962, 'pjField', 1, 'title', 'Latest updated', 'script'),
(NULL, 963, 'pjField', 1, 'title', 'Next expiring', 'script'),
(NULL, 964, 'pjField', 1, 'title', 'No properties found', 'script'),
(NULL, 965, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 966, 'pjField', 1, 'title', 'Expire on', 'script'),
(NULL, 967, 'pjField', 1, 'title', 'Optional', 'script'),
(NULL, 968, 'pjField', 1, 'title', 'Follow these steps to put the listing on your .php web page using PHP include code:', 'script'),
(NULL, 969, 'pjField', 1, 'title', 'Enter web address for the web page where listing is put:', 'script'),
(NULL, 970, 'pjField', 1, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 971, 'pjField', 1, 'title', 'Step 2. Copy and paste the code below into your html code, where the listing will be displayed.', 'script'),
(NULL, 972, 'pjField', 1, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 973, 'pjField', 1, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 974, 'pjField', 1, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your listings.', 'script'),
(NULL, 975, 'pjField', 1, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 976, 'pjField', 1, 'title', 'Create a file named ".htaccess" in the same directory where your .php page with listing is. Then copy and paste the following code into the file.', 'script'),
(NULL, 977, 'pjField', 1, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 978, 'pjField', 1, 'title', 'For search engines it is important that your web pages have Meta tags. These Meta tags refer to four pages - Home page, Map page, and Account page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.', 'script'),
(NULL, 979, 'pjField', 1, 'title', 'Home page', 'script'),
(NULL, 980, 'pjField', 1, 'title', 'Map page', 'script'),
(NULL, 981, 'pjField', 1, 'title', 'Account page', 'script'),
(NULL, 982, 'pjField', 1, 'title', 'Meta title', 'script'),
(NULL, 983, 'pjField', 1, 'title', 'Meta keywords', 'script'),
(NULL, 984, 'pjField', 1, 'title', 'Meta description', 'script'),
(NULL, 985, 'pjField', 1, 'title', 'Installation settings updated', 'script'),
(NULL, 986, 'pjField', 1, 'title', 'Your configuration settings have been saved.', 'script'),
(NULL, 987, 'pjField', 1, 'title', 'Login / Sign up', 'script'),
(NULL, 988, 'pjField', 1, 'title', 'Map', 'script'),
(NULL, 989, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 990, 'pjField', 1, 'title', 'For Sale', 'script'),
(NULL, 991, 'pjField', 1, 'title', 'For Rent', 'script'),
(NULL, 992, 'pjField', 1, 'title', 'Location', 'script'),
(NULL, 993, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 994, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 995, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 996, 'pjField', 1, 'title', 'Specials', 'script'),
(NULL, 997, 'pjField', 1, 'title', 'Bedrooms', 'script'),
(NULL, 998, 'pjField', 1, 'title', 'Bathrooms', 'script'),
(NULL, 999, 'pjField', 1, 'title', 'Min', 'script'),
(NULL, 1000, 'pjField', 1, 'title', 'Max', 'script'),
(NULL, 1001, 'pjField', 1, 'title', 'Floor area', 'script'),
(NULL, 1002, 'pjField', 1, 'title', 'more filters', 'script'),
(NULL, 1003, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 1004, 'pjField', 1, 'title', 'View details', 'script'),
(NULL, 1005, 'pjField', 1, 'title', 'Area', 'script'),
(NULL, 1006, 'pjField', 1, 'title', 'Beds', 'script'),
(NULL, 1007, 'pjField', 1, 'title', 'Baths', 'script'),
(NULL, 1008, 'pjField', 1, 'title', 'My Account', 'script'),
(NULL, 1009, 'pjField', 1, 'title', 'Sign out', 'script'),
(NULL, 1010, 'pjField', 1, 'title', 'Property with such ID doesn''t exist.', 'script'),
(NULL, 1011, 'pjField', 1, 'title', 'Property is set to inactive.', 'script'),
(NULL, 1012, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 1013, 'pjField', 1, 'title', 'Request Details', 'script'),
(NULL, 1014, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 1015, 'pjField', 1, 'title', 'Send to email', 'script'),
(NULL, 1016, 'pjField', 1, 'title', '%s for rent', 'script'),
(NULL, 1017, 'pjField', 1, 'title', '%s for sale', 'script'),
(NULL, 1018, 'pjField', 1, 'title', 'Reference ID', 'script'),
(NULL, 1019, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1021, 'pjField', 1, 'title', 'Bedroom', 'script'),
(NULL, 1022, 'pjField', 1, 'title', 'Bathroom', 'script'),
(NULL, 1023, 'pjField', 1, 'title', 'Year built', 'script'),
(NULL, 1024, 'pjField', 1, 'title', 'Lot dimensions', 'script'),
(NULL, 1025, 'pjField', 1, 'title', 'Floor plan', 'script'),
(NULL, 1026, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 1027, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1028, 'pjField', 1, 'title', 'Map', 'script'),
(NULL, 1029, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1030, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1031, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1032, 'pjField', 1, 'title', 'Address 1', 'script'),
(NULL, 1033, 'pjField', 1, 'title', 'Address 2', 'script'),
(NULL, 1034, 'pjField', 1, 'title', 'Zip / Post code', 'script'),
(NULL, 1035, 'pjField', 1, 'title', 'More properties for rent', 'script'),
(NULL, 1036, 'pjField', 1, 'title', 'More properties for sale', 'script'),
(NULL, 1037, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 1038, 'pjField', 1, 'title', 'Send to', 'script'),
(NULL, 1039, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 1040, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 1041, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 1042, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1043, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1044, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 1045, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1046, 'pjField', 1, 'title', 'Send to is required.', 'script'),
(NULL, 1047, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 1048, 'pjField', 1, 'title', 'Subject is required.', 'script'),
(NULL, 1049, 'pjField', 1, 'title', 'Message is required.', 'script'),
(NULL, 1050, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 1051, 'pjField', 1, 'title', 'Message is sending...', 'script'),
(NULL, 1052, 'pjField', 1, 'title', 'Message has been sent successfully.', 'script'),
(NULL, 1053, 'pjField', 1, 'title', 'Your request is sending...', 'script'),
(NULL, 1054, 'pjField', 1, 'title', 'Your request has been sent successfully to property''s owner.', 'script'),
(NULL, 1055, 'pjField', 1, 'title', 'Login to your Account', 'script'),
(NULL, 1056, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. ', 'script'),
(NULL, 1057, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 1058, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 1059, 'pjField', 1, 'title', 'Create an Account', 'script'),
(NULL, 1060, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'script'),
(NULL, 1061, 'pjField', 1, 'title', 'Re-enter password', 'script');
INSERT INTO `property_listing_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1062, 'pjField', 1, 'title', 'Submit', 'script'),
(NULL, 1063, 'pjField', 1, 'title', 'Password is required.', 'script'),
(NULL, 1064, 'pjField', 1, 'title', 'Name is required.', 'script'),
(NULL, 1065, 'pjField', 1, 'title', 'Re-enter password is required.', 'script'),
(NULL, 1066, 'pjField', 1, 'title', 'Password does not match.', 'script'),
(NULL, 1067, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 1068, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 1069, 'pjField', 1, 'title', 'Name is missing.', 'script'),
(NULL, 1070, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 1071, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 1072, 'pjField', 1, 'title', 'Re-enter password is missing.', 'script'),
(NULL, 1073, 'pjField', 1, 'title', 'Name cannot be empty.', 'script'),
(NULL, 1074, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 1075, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 1076, 'pjField', 1, 'title', 'Re-enter password cannot be empty.', 'script'),
(NULL, 1077, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 1078, 'pjField', 1, 'title', 'Re-enter password does not match.', 'script'),
(NULL, 1079, 'pjField', 1, 'title', 'Your account has been created and activated successfully.', 'script'),
(NULL, 1080, 'pjField', 1, 'title', 'Your account has been created successfully, but it needs to have confirmation from the administrator.', 'script'),
(NULL, 1081, 'pjField', 1, 'title', 'Your password has been sent to your email.', 'script'),
(NULL, 1082, 'pjField', 1, 'title', 'Please enter your email below, we will send the password to your mail box.', 'script'),
(NULL, 1083, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 1084, 'pjField', 1, 'title', 'Email cannot be empty.', 'script'),
(NULL, 1085, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 1086, 'pjField', 1, 'title', 'Email cannot be found in the system.', 'script'),
(NULL, 1087, 'pjField', 1, 'title', 'Your account is inactive.', 'script'),
(NULL, 1088, 'pjField', 1, 'title', 'Home', 'script'),
(NULL, 1089, 'pjField', 1, 'title', 'View all', 'script'),
(NULL, 1090, 'pjField', 1, 'title', 'for', 'script'),
(NULL, 1091, 'pjField', 1, 'title', 'Rent', 'script'),
(NULL, 1092, 'pjField', 1, 'title', 'Sale', 'script'),
(NULL, 1093, 'pjField', 1, 'title', 'Property Details', 'script'),
(NULL, 1094, 'pjField', 1, 'title', 'Contact Details', 'script'),
(NULL, 1095, 'pjField', 1, 'title', 'Request Information', 'script'),
(NULL, 1274, 'pjField', 1, 'title', 'Property is expired.', 'script'),
(NULL, 1275, 'pjField', 1, 'title', 'Property does not exist.', 'script'),
(NULL, 1276, 'pjField', 1, 'title', 'No properties found.', 'script'),
(NULL, 1277, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 1278, 'pjField', 1, 'title', 'Captcha is required.', 'script'),
(NULL, 1279, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 1280, 'pjField', 1, 'title', 'Captcha is missing.', 'script'),
(NULL, 1281, 'pjField', 1, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 1282, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 1283, 'pjField', 1, 'title', 'Follow these steps to insert the Featured properties listing on your .php web page using PHP include code:', 'script'),
(NULL, 1284, 'pjField', 1, 'title', 'Featured properties', 'script'),
(NULL, 1285, 'pjField', 1, 'title', 'Contact Details', 'script'),
(NULL, 1286, 'pjField', 1, 'title', 'Feed URL invalid.', 'script'),
(NULL, 1287, 'pjField', 1, 'title', 'Please enter digits only.', 'script'),
(NULL, 1288, 'pjField', 1, 'title', 'Please enter positive number.', 'script'),
(NULL, 1289, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 1290, 'pjField', 1, 'title', 'Map', 'script'),
(NULL, 1291, 'pjField', 1, 'title', 'Login / Signup', 'script'),
(NULL, 1292, 'pjField', 1, 'title', 'Location', 'script'),
(NULL, 1293, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 1294, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 1295, 'pjField', 1, 'title', 'Specials', 'script'),
(NULL, 1296, 'pjField', 1, 'title', 'Bedrooms', 'script'),
(NULL, 1297, 'pjField', 1, 'title', 'Min', 'script'),
(NULL, 1298, 'pjField', 1, 'title', 'Max', 'script'),
(NULL, 1299, 'pjField', 1, 'title', 'Bathrooms', 'script'),
(NULL, 1300, 'pjField', 1, 'title', 'Floor area', 'script'),
(NULL, 1301, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 1302, 'pjField', 1, 'title', 'Area', 'script'),
(NULL, 1303, 'pjField', 1, 'title', 'Beds', 'script'),
(NULL, 1304, 'pjField', 1, 'title', 'Baths', 'script'),
(NULL, 1305, 'pjField', 1, 'title', 'None', 'script'),
(NULL, 1306, 'pjField', 1, 'title', 'Premium', 'script'),
(NULL, 1307, 'pjField', 1, 'title', 'Sold', 'script'),
(NULL, 1308, 'pjField', 1, 'title', 'Under offer', 'script'),
(NULL, 1309, 'pjField', 1, 'title', 'For', 'script'),
(NULL, 1310, 'pjField', 1, 'title', 'Rent', 'script'),
(NULL, 1311, 'pjField', 1, 'title', 'Sale', 'script'),
(NULL, 1312, 'pjField', 1, 'title', 'Full Details', 'script'),
(NULL, 1313, 'pjField', 1, 'title', 'Next', 'script'),
(NULL, 1314, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 1315, 'pjField', 1, 'title', 'Reference ID', 'script'),
(NULL, 1316, 'pjField', 1, 'title', 'Bedroom', 'script'),
(NULL, 1317, 'pjField', 1, 'title', 'Bathroom', 'script'),
(NULL, 1318, 'pjField', 1, 'title', 'Year built', 'script'),
(NULL, 1319, 'pjField', 1, 'title', 'Lot dimensions', 'script'),
(NULL, 1320, 'pjField', 1, 'title', 'Floor plan', 'script'),
(NULL, 1321, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 1322, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1323, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1324, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1325, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1326, 'pjField', 1, 'title', 'Address 1', 'script'),
(NULL, 1327, 'pjField', 1, 'title', 'Address 2', 'script'),
(NULL, 1328, 'pjField', 1, 'title', 'Zip code', 'script'),
(NULL, 1329, 'pjField', 1, 'title', 'Contact Details', 'script'),
(NULL, 1330, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1331, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1332, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1333, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 1334, 'pjField', 1, 'title', 'Login to your Account', 'script'),
(NULL, 1335, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 1336, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 1337, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 1338, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 1339, 'pjField', 1, 'title', 'Password is required.', 'script'),
(NULL, 1340, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 1341, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 1342, 'pjField', 1, 'title', 'Create an Account', 'script'),
(NULL, 1343, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 1344, 'pjField', 1, 'title', 'Name is required.', 'script'),
(NULL, 1345, 'pjField', 1, 'title', 'Re-enter password', 'script'),
(NULL, 1346, 'pjField', 1, 'title', 'Re-enter password is required.', 'script'),
(NULL, 1347, 'pjField', 1, 'title', 'Password does not match.', 'script'),
(NULL, 1348, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 1349, 'pjField', 1, 'title', 'Captcha is required.', 'script'),
(NULL, 1350, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 1351, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 1352, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor', 'script'),
(NULL, 1353, 'pjField', 1, 'title', 'Contact', 'script'),
(NULL, 1354, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 1355, 'pjField', 1, 'title', 'Message is required.', 'script'),
(NULL, 1356, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 1357, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 1358, 'pjField', 1, 'title', 'Not available', 'script'),
(NULL, 1359, 'pjField', 1, 'title', 'Directory permission', 'script'),
(NULL, 1360, 'pjField', 1, 'title', 'Floor plan file could not be uploaded because directory app/web/upload/files has no permissions. Please set permissions to 777.', 'script'),
(NULL, 1361, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 1362, 'pjField', 1, 'title', 'Email was already used.', 'script'),
(NULL, 1363, 'pjField', 1, 'title', 'Email was already used.', 'script'),
(NULL, 1364, 'pjField', 1, 'title', 'List of users', 'script'),
(NULL, 1365, 'pjField', 1, 'title', 'You can create different users - administrators (access to everything), editors (access to all properties), owners (access to own properties only).', 'script'),
(NULL, 1366, 'pjField', 1, 'title', 'List of properties', 'script'),
(NULL, 1367, 'pjField', 1, 'title', 'You can find below the list of properties. If you want to view more detail information of certain properties, click on the corresponding Pencil icon.', 'script'),
(NULL, 1368, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 1369, 'pjField', 1, 'title', 'Below you can preview the front-end of the script. Go to the Install page where you can find installation codes to add the script on your web page.', 'script'),
(NULL, 1370, 'pjField', 1, 'title', 'Preview Front End', 'script'),
(NULL, 1371, 'pjField', 1, 'title', 'Preview Featured Properties', 'script'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_registration_subject', 'New account created', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_registration_message', 'New account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPhone: {Phone}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_submission_subject', 'New Property Submitted', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_submission_message', 'Property ID: {RefID}\r\nType: {Type}', 'data'),
(NULL, 1, 'pjOption', 1, 'home_meta_title', 'Home title', 'data'),
(NULL, 1, 'pjOption', 1, 'home_meta_keywords', 'Home keywords', 'data'),
(NULL, 1, 'pjOption', 1, 'home_meta_description', 'Home description', 'data'),
(NULL, 1, 'pjOption', 1, 'map_meta_title', 'Map title', 'data'),
(NULL, 1, 'pjOption', 1, 'map_meta_keywords', 'Map keywords', 'data'),
(NULL, 1, 'pjOption', 1, 'map_meta_description', 'Map description', 'data'),
(NULL, 1, 'pjOption', 1, 'account_meta_title', 'Account title', 'data'),
(NULL, 1, 'pjOption', 1, 'account_meta_keywords', 'Account keywords', 'data'),
(NULL, 1, 'pjOption', 1, 'account_meta_description', 'Account description', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_send_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_request_subject', 'Property Details Request', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_request_message', 'You''ve received a request.\r\n\r\nProperty ID: {RefID}\r\nRequest sent by: {Name}\r\nEmail address: {Email}\r\nPhone: {Phone}\r\n\r\nMessage:\r\n{Message}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_registration_subject', 'Account created', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_registration_message', 'Your account has been created.\r\n\r\nName: {Name}\r\nEmail: {Email}\r\nPassword: {Password}\r\n\r\nRegards,\r\nThe Management', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_submission_subject', 'Property submitted', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_submission_message', 'We''ve received your property submission.\r\n\r\nProperty ID: {RefID}\r\nType:{Type}\r\n\r\nRegards,\r\nThe Management', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_subject', 'Password recovery', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_message', 'Dear {Name}.\r\n\r\nYour password is: {Password}\r\n\r\nRegards,\r\nThe Management', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_request_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_registration_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_submission_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_request_subject', 'Property Details Request', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_request_message', 'Property ID: {RefID}\r\nRequest sent by: {Name}\r\nEmail address: {Email}\r\nPhone: {Phone}\r\n\r\nMessage:\r\n{Message}', 'data'),
(NULL, 1, 'pjType', 1, 'name', 'Commercial property', 'data'),
(NULL, 2, 'pjType', 1, 'name', 'Flat / Apartment', 'data'),
(NULL, 3, 'pjType', 1, 'name', 'House', 'data'),
(NULL, 4, 'pjType', 1, 'name', 'Land', 'data'),
(NULL, 5, 'pjType', 1, 'name', 'Other', 'data');

INSERT INTO `property_listing_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_currency', 1, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_floor_metric', 1, 'sq m|sq ft::sq m', 'sq m|sq ft', 'enum', 2, 1, NULL),
(1, 'o_price_format', 1, '$100000|$100 000|$100,000|$100,000.00::$100,000', '$100000|$100 000|$100,000|$100,000.00', 'enum', 3, 1, NULL),
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 4, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 5, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 6, 0, NULL),
(1, 'o_items_per_page', 1, '10', NULL, 'int', 7, 1, NULL),
(1, 'o_featured_items_per_page', 1, '5', NULL, 'int', 8, 1, NULL),
(1, 'o_layout', 1, 'default|theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::default', 'Default|Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 10, 1, NULL),
(1, 'o_show_contact', 1, 'Yes|No::Yes', NULL, 'enum', 11, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 12, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 13, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 14, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 15, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 16, 1, NULL),

(1, 'o_allow_add_property', 2, 'Yes|No::Yes', NULL, 'enum', 1, 1, NULL),
(1, 'o_owner_is_active', 2, 'Yes|No::No', NULL, 'enum', 2, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 3, 1, NULL),

(1, 'o_email_request', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_request_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_request_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_registration', 3, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_registration_subject', 3, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_registration_message', 3, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_submission', 3, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_email_submission_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_submission_message', 3, '', NULL, 'text', 9, 1, NULL),
(1, 'o_email_forgot_subject', 3, '', NULL, 'string', 11, 1, NULL),
(1, 'o_email_forgot_message', 3, '', NULL, 'text', 12, 1, NULL),
(1, 'o_sms_request', 3, '0|1::1', 'No|Yes', 'enum', 13, 1, NULL),
(1, 'o_sms_request_message', 3, '', NULL, 'text', 14, 1, NULL),
(1, 'o_sms_registration', 3, '0|1::1', 'No|Yes', 'enum', 15, 1, NULL),
(1, 'o_sms_registration_message', 3, '', NULL, 'text', 16, 1, NULL),
(1, 'o_sms_submission', 3, '0|1::1', 'No|Yes', 'enum', 17, 1, NULL),
(1, 'o_sms_submission_message', 3, '', NULL, 'text', 18, 1, NULL),

(1, 'o_admin_email_request', 4, '0|1::1', 'No|Yes', 'enum', 2, 1, NULL),
(1, 'o_admin_email_request_subject', 4, '', NULL, 'string', 3, 1, NULL),
(1, 'o_admin_email_request_message', 4, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_email_registration', 4, '0|1::1', 'No|Yes', 'enum', 5, 1, NULL),
(1, 'o_admin_email_registration_subject', 4, '', NULL, 'string', 6, 1, NULL),
(1, 'o_admin_email_registration_message', 4, '', NULL, 'text', 7, 1, NULL),
(1, 'o_admin_email_submission', 4, '0|1::1', 'No|Yes', 'enum', 8, 1, NULL),
(1, 'o_admin_email_submission_subject', 4, '', NULL, 'string', 9, 1, NULL),
(1, 'o_admin_email_submission_message', 4, '', NULL, 'text', 10, 1, NULL),
(1, 'o_admin_sms_registration', 4, '0|1::1', 'No|Yes', 'enum', 13, 1, NULL),
(1, 'o_admin_sms_registration_message', 4, '', NULL, 'text', 14, 1, NULL),
(1, 'o_admin_sms_submission', 4, '0|1::1', 'No|Yes', 'enum', 15, 1, NULL),
(1, 'o_admin_sms_submission_message', 4, '', NULL, 'text', 16, 1, NULL),

(1, 'o_property_page', 99, '', NULL, 'string', NULL, 0, NULL),
(1, 'o_seo_url', 99, 'Yes|No::No', NULL, 'enum', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `property_listing_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T'),
(3, 'owner', 'T');