DROP TABLE IF EXISTS `knowledgebase_categories`;
CREATE TABLE IF NOT EXISTS `knowledgebase_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL,
  `lft` int(10) unsigned DEFAULT NULL,
  `rgt` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `knowledgebase_questions`;
CREATE TABLE IF NOT EXISTS `knowledgebase_questions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `featured` enum('T','F') NOT NULL DEFAULT 'F',
  `views` int(11) NOT NULL DEFAULT '0',
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `knowledgebase_questions_categories`;
CREATE TABLE IF NOT EXISTS `knowledgebase_questions_categories` (
  `question_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`question_id`,`category_id`),
  KEY `question_id` (`question_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `knowledgebase_votes`;
CREATE TABLE IF NOT EXISTS `knowledgebase_votes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `question_id` int(11) NOT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `vote_rate` decimal(5,2) DEFAULT NULL,
  `vote_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `question_id` (`question_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `knowledgebase_glossaries`;
CREATE TABLE IF NOT EXISTS `knowledgebase_glossaries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `knowledgebase_fields`;
CREATE TABLE IF NOT EXISTS `knowledgebase_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `knowledgebase_multi_lang`;
CREATE TABLE IF NOT EXISTS `knowledgebase_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned NOT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `knowledgebase_options`;
CREATE TABLE IF NOT EXISTS `knowledgebase_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `knowledgebase_roles`;
CREATE TABLE IF NOT EXISTS `knowledgebase_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `knowledgebase_users`;
CREATE TABLE IF NOT EXISTS `knowledgebase_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `knowledgebase_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(293, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(294, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(295, 'delete_confirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(296, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(297, 'error_titles_ARRAY_AG01', 'arrays', 'error_titles_ARRAY_AG01', 'script', NULL),
(298, 'error_bodies_ARRAY_AG01', 'arrays', 'error_bodies_ARRAY_AG01', 'script', NULL),
(299, 'error_titles_ARRAY_AG02', 'arrays', 'error_titles_ARRAY_AG02', 'script', NULL),
(300, 'error_bodies_ARRAY_AG02', 'arrays', 'error_bodies_ARRAY_AG02', 'script', NULL),
(301, 'error_titles_ARRAY_AG05', 'arrays', 'error_titles_ARRAY_AG05', 'script', NULL),
(302, 'error_bodies_ARRAY_AG05', 'arrays', 'error_bodies_ARRAY_AG05', 'script', NULL),
(303, 'error_titles_ARRAY_AG08', 'arrays', 'error_titles_ARRAY_AG08', 'script', NULL),
(304, 'error_bodies_ARRAY_AG08', 'arrays', 'error_bodies_ARRAY_AG08', 'script', NULL),
(305, 'menuCategories', 'backend', 'Menu / Categories', 'script', NULL),
(306, 'lblAddCategory', 'backend', 'Label / Add category', 'script', NULL),
(307, 'error_titles_ARRAY_AC11', 'arrays', 'error_titles_ARRAY_AC11', 'script', NULL),
(308, 'error_bodies_ARRAY_AC11', 'arrays', 'error_bodies_ARRAY_AC11', 'script', NULL),
(309, 'lblCategoryName', 'backend', 'Label / Category name', 'script', NULL),
(310, 'lblQuestions', 'backend', 'Label / Questions', 'script', NULL),
(311, 'lblDown', 'backend', 'Label / down', 'script', NULL),
(312, 'lblUp', 'backend', 'Label / up', 'script', NULL),
(313, 'error_titles_ARRAY_AC12', 'arrays', 'error_titles_ARRAY_AC12', 'script', NULL),
(314, 'error_bodies_ARRAY_AC12', 'arrays', 'error_bodies_ARRAY_AC12', 'script', NULL),
(315, 'lblCategoryParent', 'backend', 'Label / Parent category', 'script', NULL),
(316, 'lblNoParentCategory', 'backend', 'Label / No parent', 'script', NULL),
(317, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(319, 'error_titles_ARRAY_AC13', 'arrays', 'error_titles_ARRAY_AC13', 'script', NULL),
(320, 'error_bodies_ARRAY_AC13', 'arrays', 'error_bodies_ARRAY_AC13', 'script', NULL),
(321, 'lblUpdateCategory', 'backend', 'Label / Update category', 'script', NULL),
(322, 'menuQuestions', 'backend', 'Menu / Questions', 'script', NULL),
(323, 'lblAddQuestion', 'backend', 'Label / Add question', 'script', NULL),
(325, 'lblQuestion', 'backend', 'Label / Question', 'script', NULL),
(326, 'lblActive', 'backend', 'Label / Active', 'script', NULL),
(327, 'lblInActive', 'backend', 'Label / Inactive', 'script', NULL),
(328, 'infoAddQuestionTitle', 'backend', 'Infobox / Add new question', 'script', NULL),
(329, 'infoAddQuestionBody', 'backend', 'Infobox / Add question body', 'script', NULL),
(330, 'lblCategory', 'backend', 'Label / Category', 'script', NULL),
(331, 'lblAnswer', 'backend', 'Label / Answer', 'script', NULL),
(332, 'error_titles_ARRAY_AQ01', 'arrays', 'error_titles_ARRAY_AQ01', 'script', NULL),
(333, 'error_bodies_ARRAY_AQ01', 'arrays', 'error_bodies_ARRAY_AQ01', 'script', NULL),
(334, 'error_titles_ARRAY_AQ03', 'arrays', 'error_titles_ARRAY_AQ03', 'script', NULL),
(335, 'error_bodies_ARRAY_AQ03', 'arrays', 'error_bodies_ARRAY_AQ03', 'script', NULL),
(336, 'error_titles_ARRAY_AQ04', 'arrays', 'error_titles_ARRAY_AQ04', 'script', NULL),
(337, 'error_bodies_ARRAY_AQ04', 'arrays', 'error_bodies_ARRAY_AQ04', 'script', NULL),
(338, 'error_titles_ARRAY_AQ08', 'arrays', 'error_titles_ARRAY_AQ08', 'script', NULL),
(339, 'error_bodies_ARRAY_AQ08', 'arrays', 'error_bodies_ARRAY_AQ08', 'script', NULL),
(340, 'lblUpdateQuestion', 'backend', 'Label / Update question', 'script', NULL),
(341, 'infoUpdateQuestionTitle', 'backend', 'Infobox / Update question title', 'script', NULL),
(342, 'infoUpdateQuestionBody', 'backend', 'Infobox / Update question body', 'script', NULL),
(343, 'menuGlossaries', 'backend', 'Menu / Glossaries', 'script', NULL),
(344, 'error_titles_ARRAY_AGL01', 'arrays', 'error_titles_ARRAY_AGL01', 'script', NULL),
(345, 'error_bodies_ARRAY_AGL01', 'arrays', 'error_bodies_ARRAY_AGL01', 'script', NULL),
(346, 'error_titles_ARRAY_AGL03', 'arrays', 'error_titles_ARRAY_AGL03', 'script', NULL),
(347, 'error_bodies_ARRAY_AGL03', 'arrays', 'error_bodies_ARRAY_AGL03', 'script', NULL),
(348, 'error_titles_ARRAY_AGL04', 'arrays', 'error_titles_ARRAY_AGL04', 'script', NULL),
(349, 'error_bodies_ARRAY_AGL04', 'arrays', 'error_bodies_ARRAY_AGL04', 'script', NULL),
(350, 'error_titles_ARRAY_AGL08', 'arrays', 'error_titles_ARRAY_AGL08', 'script', NULL),
(351, 'error_bodies_ARRAY_AGL08', 'arrays', 'error_bodies_ARRAY_AGL08', 'script', NULL),
(352, 'lblAddGlossary', 'backend', 'Label / Add glossary', 'script', NULL),
(353, 'lblWord', 'backend', 'Label / Word', 'script', NULL),
(355, 'lblUpdateGlossary', 'backend', 'Label / Update glossary', 'script', NULL),
(356, 'infoAddGlossaryTitle', 'backend', 'Infobox / Add glossary title', 'script', NULL),
(357, 'infoAddGlossaryBody', 'backend', 'Infobox / Add glossary body', 'script', NULL),
(358, 'infoUpdateGlossaryTitle', 'backend', 'Infobox / Update glossary title', 'script', NULL),
(359, 'infoUpdateGlossaryBody', 'backend', 'Infobox / Update glossary body', 'script', NULL),
(360, 'lblAuthor', 'backend', 'Label / Author', 'script', NULL),
(361, 'lblCreatedDateTime', 'backend', 'Label / Created date time', 'script', NULL),
(362, 'lblModifiedDateTime', 'backend', 'Label / Modified date time', 'script', NULL),
(363, 'lblNa', 'backend', 'Label / na', 'script', NULL),
(364, 'lblOf', 'backend', 'Label / of', 'script', NULL),
(365, 'lblVotes', 'backend', 'Label / votes', 'script', NULL),
(366, 'lblReset', 'backend', 'Label / Reset', 'script', NULL),
(367, 'lblAvgRating', 'backend', 'Label / Average rating', 'script', NULL),
(368, 'lblResetRating', 'backend', 'Label / Reset rating', 'script', NULL),
(369, 'lblResetConfirmation', 'backend', 'Label / Reset confirmation', 'script', NULL),
(370, 'lblInstall', 'backend', 'Label / Install', 'script', NULL),
(371, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(372, 'lblInstallPhp1_1', 'backend', 'Label / Install PHP step 1', 'script', NULL),
(373, 'lblInstallPhp1Title', 'backend', 'Label / Install title', 'script', NULL),
(374, 'lblInstallPhp1_2', 'backend', 'Label / Install PHP step 2', 'script', NULL),
(375, 'lblInstallPhp1_3', 'backend', 'Label / Install PHP step 3', 'script', NULL),
(376, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(377, 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
(417, 'label_home', 'frontend', 'Label / Home', 'script', NULL),
(418, 'label_categories', 'frontend', 'Label / Categories', 'script', NULL),
(419, 'label_glossary', 'frontend', 'Label / Glossary', 'script', NULL),
(420, 'label_search', 'frontend', 'Label / Search', 'script', NULL),
(421, 'label_featured', 'frontend', 'Label / Featured', 'script', NULL),
(422, 'label_most_popular', 'frontend', 'Label / Most popular', 'script', NULL),
(423, 'label_recently_added', 'frontend', 'Label / Recently added', 'script', NULL),
(424, 'label_select_category', 'frontend', 'Label / Select category', 'script', NULL),
(425, 'label_view', 'frontend', 'Label / View', 'script', NULL),
(426, 'label_by', 'frontend', 'Label / by', 'script', NULL),
(427, 'label_in', 'frontend', 'Label / in', 'script', NULL),
(428, 'label_back', 'frontend', 'Label / Back', 'script', NULL),
(429, 'label_added', 'frontend', 'Label / Added', 'script', NULL),
(430, 'label_last_updated', 'frontend', 'Label / Last updated', 'script', NULL),
(431, 'label_author', 'frontend', 'Label / Author', 'script', NULL),
(432, 'label_category', 'frontend', 'Label / Category', 'script', NULL),
(433, 'label_average_rating', 'frontend', 'Label / Average rating', 'script', NULL),
(434, 'label_print_article', 'frontend', 'Label / Print article', 'script', NULL),
(435, 'label_email_to_friend', 'frontend', 'Label / Email to friend', 'script', NULL),
(436, 'label_all', 'frontend', 'Label / All', 'script', NULL),
(437, 'lable_no_question', 'frontend', 'Label / No question found.', 'script', NULL),
(438, 'lable_no_glossary', 'frontend', 'Label / No glossary found.', 'script', NULL),
(478, 'lblMarkAsFeatured', 'backend', 'Label / Mark as featured', 'script', NULL),
(479, 'lblOptional', 'backend', 'Label / Optional', 'script', NULL),
(480, 'opt_o_install_page', 'backend', 'Label / install page', 'script', NULL),
(481, 'lblInstallPhp1_2a', 'backend', 'Label / Install 2a', 'script', NULL),
(482, 'lblInstallPhp2Title', 'backend', 'Label / Install PHP optional title', 'script', NULL),
(483, 'opt_o_seo_url', 'backend', 'Options / seo url', 'script', NULL),
(484, 'lblInstallPhp1_4', 'backend', 'Install / Step 1 - 4', 'script', NULL),
(485, 'lblInstallPhp1_5', 'backend', 'Install / Ste 1-5', 'script', NULL),
(486, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(487, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(488, 'label_choose', 'frontend', 'Label / Choose', 'script', NULL),
(490, 'label_share_article', 'frontend', 'Label / Email to friend', 'script', NULL),
(491, 'label_to', 'frontend', 'Label / To', 'script', NULL),
(492, 'label_from', 'frontend', 'Label / From', 'script', NULL),
(493, 'label_subject', 'frontend', 'Label / Subject', 'script', NULL),
(494, 'label_message', 'frontend', 'Label / Message', 'script', NULL),
(495, 'label_already_voted', 'frontend', 'Label / already voted', 'script', NULL),
(496, 'label_thank_vote', 'frontend', 'Label / Thanks for voting', 'script', NULL),
(497, 'opt_o_show_glossary', 'backend', 'Options / Show glossaries', 'script', NULL),
(499, 'lblWords', 'backend', 'Label / Words', 'script', NULL),
(500, 'lblUsers', 'backend', 'label / Users', 'script', NULL),
(501, 'lblUser', 'backend', 'Label / User', 'script', NULL),
(502, 'lblPopularQuestions', 'backend', 'Label / Most Popular Questions', 'script', NULL),
(503, 'lblLastUpdatedQuestions', 'backend', 'Label / Last Updated Questions', 'script', NULL),
(504, 'lblLastLoggedUsers', 'backend', 'Label / Last Logged in Users', 'script', NULL),
(505, 'lblUserNotFound', 'backend', 'Label / There is no user found.', 'script', NULL),
(506, 'lblCategoryNotFound', 'backend', 'Label / There is no category found.', 'script', NULL),
(507, 'lblQuestionNotFound', 'backend', 'Label / There is no question found.', 'script', NULL),
(508, 'lblViews', 'backend', 'Label / Views', 'script', NULL),
(509, 'lblView', 'backend', 'Label / View', 'script', NULL),
(549, 'label_questions', 'frontend', 'Label / questions', 'script', NULL),
(550, 'label_question', 'frontend', 'Label / question', 'script', NULL);

INSERT INTO `knowledgebase_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 6, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 6, 'pjField', 3, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'Is Active', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 2, 'title', '??', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 2, 'title', '??', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Email address was already in use', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'Email address was already in use', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'Email address was already in use', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 253, 'pjField', 2, 'title', 'Last login', 'script'),
(NULL, 253, 'pjField', 3, 'title', 'Last login', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 293, 'pjField', 2, 'title', 'All', 'script'),
(NULL, 293, 'pjField', 3, 'title', 'All', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 294, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 294, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 295, 'pjField', 2, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 295, 'pjField', 3, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 296, 'pjField', 2, 'title', 'Time format', 'script'),
(NULL, 296, 'pjField', 3, 'title', 'Time format', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Category added', 'script'),
(NULL, 297, 'pjField', 2, 'title', 'Category added', 'script'),
(NULL, 297, 'pjField', 3, 'title', 'Category added', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'A new category has been added successfully. Now you can add another category.', 'script'),
(NULL, 298, 'pjField', 2, 'title', 'A new category has been added successfully. Now you can add another category.', 'script'),
(NULL, 298, 'pjField', 3, 'title', 'A new category has been added successfully. Now you can add another category.', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Category failed to add', 'script'),
(NULL, 299, 'pjField', 2, 'title', 'Category failed to add', 'script'),
(NULL, 299, 'pjField', 3, 'title', 'Category failed to add', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Category has not been added. Please check your data and try again.', 'script'),
(NULL, 300, 'pjField', 2, 'title', 'Category has not been added. Please check your data and try again.', 'script'),
(NULL, 300, 'pjField', 3, 'title', 'Category has not been added. Please check your data and try again.', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Category updated', 'script'),
(NULL, 301, 'pjField', 2, 'title', 'Category updated', 'script'),
(NULL, 301, 'pjField', 3, 'title', 'Category updated', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 302, 'pjField', 2, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 302, 'pjField', 3, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Category not found', 'script'),
(NULL, 303, 'pjField', 2, 'title', 'Category not found', 'script'),
(NULL, 303, 'pjField', 3, 'title', 'Category not found', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'The category you are looking for does not exist.', 'script'),
(NULL, 304, 'pjField', 2, 'title', 'The category you are looking for does not exist.', 'script'),
(NULL, 304, 'pjField', 3, 'title', 'The category you are looking for does not exist.', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 305, 'pjField', 2, 'title', 'Categories', 'script'),
(NULL, 305, 'pjField', 3, 'title', 'Categories', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Add category', 'script'),
(NULL, 306, 'pjField', 2, 'title', 'Add category', 'script'),
(NULL, 306, 'pjField', 3, 'title', 'Add category', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Category list', 'script'),
(NULL, 307, 'pjField', 2, 'title', 'Category list', 'script'),
(NULL, 307, 'pjField', 3, 'title', 'Category list', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Let use arrows below to re-order your categories.', 'script'),
(NULL, 308, 'pjField', 2, 'title', 'Let use arrows below to re-order your categories.', 'script'),
(NULL, 308, 'pjField', 3, 'title', 'Let use arrows below to re-order your categories.', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Category name', 'script'),
(NULL, 309, 'pjField', 2, 'title', 'Category name', 'script'),
(NULL, 309, 'pjField', 3, 'title', 'Category name', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Questions', 'script'),
(NULL, 310, 'pjField', 2, 'title', 'Questions', 'script'),
(NULL, 310, 'pjField', 3, 'title', 'Questions', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'down', 'script'),
(NULL, 311, 'pjField', 2, 'title', 'down', 'script'),
(NULL, 311, 'pjField', 3, 'title', 'down', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'up', 'script'),
(NULL, 312, 'pjField', 2, 'title', 'up', 'script'),
(NULL, 312, 'pjField', 3, 'title', 'up', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Add new category', 'script'),
(NULL, 313, 'pjField', 2, 'title', 'Add new category', 'script'),
(NULL, 313, 'pjField', 3, 'title', 'Add new category', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Please fill out the form below and click SAVE button to add new category.', 'script'),
(NULL, 314, 'pjField', 2, 'title', 'Please fill out the form below and click SAVE button to add new category.', 'script'),
(NULL, 314, 'pjField', 3, 'title', 'Please fill out the form below and click SAVE button to add new category.', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Parent category', 'script'),
(NULL, 315, 'pjField', 2, 'title', 'Parent category', 'script'),
(NULL, 315, 'pjField', 3, 'title', 'Parent category', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'No parent', 'script'),
(NULL, 316, 'pjField', 2, 'title', 'No parent', 'script'),
(NULL, 316, 'pjField', 3, 'title', 'No parent', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 317, 'pjField', 2, 'title', 'Description', 'script'),
(NULL, 317, 'pjField', 3, 'title', 'Description', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Update category', 'script'),
(NULL, 319, 'pjField', 2, 'title', 'Update category', 'script'),
(NULL, 319, 'pjField', 3, 'title', 'Update category', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Let use the form below and make any change you want to update category.', 'script'),
(NULL, 320, 'pjField', 2, 'title', 'Let use the form below and make any change you want to update category.', 'script'),
(NULL, 320, 'pjField', 3, 'title', 'Let use the form below and make any change you want to update category.', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Update category', 'script'),
(NULL, 321, 'pjField', 2, 'title', 'Update category', 'script'),
(NULL, 321, 'pjField', 3, 'title', 'Update category', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Questions', 'script'),
(NULL, 322, 'pjField', 2, 'title', 'Questions', 'script'),
(NULL, 322, 'pjField', 3, 'title', 'Questions', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Add question', 'script'),
(NULL, 323, 'pjField', 2, 'title', 'Add question', 'script'),
(NULL, 323, 'pjField', 3, 'title', 'Add question', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Question', 'script'),
(NULL, 325, 'pjField', 2, 'title', 'Question', 'script'),
(NULL, 325, 'pjField', 3, 'title', 'Question', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 326, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 326, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 327, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 327, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Add new question', 'script'),
(NULL, 328, 'pjField', 2, 'title', 'Add new question', 'script'),
(NULL, 328, 'pjField', 3, 'title', 'Add new question', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Please fill out the form below and click Save button to add new question.', 'script'),
(NULL, 329, 'pjField', 2, 'title', 'Please fill out the form below and click Save button to add new question.', 'script');
INSERT INTO `knowledgebase_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 329, 'pjField', 3, 'title', 'Please fill out the form below and click Save button to add new question.', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 330, 'pjField', 2, 'title', 'Category', 'script'),
(NULL, 330, 'pjField', 3, 'title', 'Category', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Answer', 'script'),
(NULL, 331, 'pjField', 2, 'title', 'Answer', 'script'),
(NULL, 331, 'pjField', 3, 'title', 'Answer', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Question updated', 'script'),
(NULL, 332, 'pjField', 2, 'title', 'Question updated', 'script'),
(NULL, 332, 'pjField', 3, 'title', 'Question updated', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'All changes made to the question have been saved.', 'script'),
(NULL, 333, 'pjField', 2, 'title', 'All changes made to the question have been saved.', 'script'),
(NULL, 333, 'pjField', 3, 'title', 'All changes made to the question have been saved.', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Question added', 'script'),
(NULL, 334, 'pjField', 2, 'title', 'Question added', 'script'),
(NULL, 334, 'pjField', 3, 'title', 'Question added', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'The question has been added successfully. You now can add another question.', 'script'),
(NULL, 335, 'pjField', 2, 'title', 'The question has been added successfully. You now can add another question.', 'script'),
(NULL, 335, 'pjField', 3, 'title', 'The question has been added successfully. You now can add another question.', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Question failed to add', 'script'),
(NULL, 336, 'pjField', 2, 'title', 'Question failed to add', 'script'),
(NULL, 336, 'pjField', 3, 'title', 'Question failed to add', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'We are sorry that the question could not be added successfully. Please try again.', 'script'),
(NULL, 337, 'pjField', 2, 'title', 'We are sorry that the question could not be added successfully. Please try again.', 'script'),
(NULL, 337, 'pjField', 3, 'title', 'We are sorry that the question could not be added successfully. Please try again.', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Question not found', 'script'),
(NULL, 338, 'pjField', 2, 'title', 'Question not found', 'script'),
(NULL, 338, 'pjField', 3, 'title', 'Question not found', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'We are sorry the question you are looking for does not exist.', 'script'),
(NULL, 339, 'pjField', 2, 'title', 'We are sorry the question you are looking for does not exist.', 'script'),
(NULL, 339, 'pjField', 3, 'title', 'We are sorry the question you are looking for does not exist.', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Update question', 'script'),
(NULL, 340, 'pjField', 2, 'title', 'Update question', 'script'),
(NULL, 340, 'pjField', 3, 'title', 'Update question', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Update question', 'script'),
(NULL, 341, 'pjField', 2, 'title', 'Update question', 'script'),
(NULL, 341, 'pjField', 3, 'title', 'Update question', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Let make any change you want on the form below to update information of the question', 'script'),
(NULL, 342, 'pjField', 2, 'title', 'Let make any change you want on the form below to update information of the question', 'script'),
(NULL, 342, 'pjField', 3, 'title', 'Let make any change you want on the form below to update information of the question', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Glossaries', 'script'),
(NULL, 343, 'pjField', 2, 'title', 'Glossaries', 'script'),
(NULL, 343, 'pjField', 3, 'title', 'Glossaries', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Glossary updated', 'script'),
(NULL, 344, 'pjField', 2, 'title', 'Glossary updated', 'script'),
(NULL, 344, 'pjField', 3, 'title', 'Glossary updated', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'All changes made to the glossary have been saved.', 'script'),
(NULL, 345, 'pjField', 2, 'title', 'All changes made to the glossary have been saved.', 'script'),
(NULL, 345, 'pjField', 3, 'title', 'All changes made to the glossary have been saved.', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Glossary added', 'script'),
(NULL, 346, 'pjField', 2, 'title', 'Glossary added', 'script'),
(NULL, 346, 'pjField', 3, 'title', 'Glossary added', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'A new glossary has been added to the list. Now you can add another glossary.', 'script'),
(NULL, 347, 'pjField', 2, 'title', 'A new glossary has been added to the list. Now you can add another glossary.', 'script'),
(NULL, 347, 'pjField', 3, 'title', 'A new glossary has been added to the list. Now you can add another glossary.', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Glossary failed to add', 'script'),
(NULL, 348, 'pjField', 2, 'title', 'Glossary failed to add', 'script'),
(NULL, 348, 'pjField', 3, 'title', 'Glossary failed to add', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'We are sorry that some error occurred, so the glossary could not be added to the system.', 'script'),
(NULL, 349, 'pjField', 2, 'title', 'We are sorry that some error occurred, so the glossary could not be added to the system.', 'script'),
(NULL, 349, 'pjField', 3, 'title', 'We are sorry that some error occurred, so the glossary could not be added to the system.', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Glossary not found', 'script'),
(NULL, 350, 'pjField', 2, 'title', 'Glossary not found', 'script'),
(NULL, 350, 'pjField', 3, 'title', 'Glossary not found', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'We are sorry that the glossary you are looking for is missing.', 'script'),
(NULL, 351, 'pjField', 2, 'title', 'We are sorry that the glossary you are looking for is missing.', 'script'),
(NULL, 351, 'pjField', 3, 'title', 'We are sorry that the glossary you are looking for is missing.', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Add glossary', 'script'),
(NULL, 352, 'pjField', 2, 'title', 'Add glossary', 'script'),
(NULL, 352, 'pjField', 3, 'title', 'Add glossary', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Word', 'script'),
(NULL, 353, 'pjField', 2, 'title', 'Word', 'script'),
(NULL, 353, 'pjField', 3, 'title', 'Word', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Update glossary', 'script'),
(NULL, 355, 'pjField', 2, 'title', 'Update glossary', 'script'),
(NULL, 355, 'pjField', 3, 'title', 'Update glossary', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Add new glossary', 'script'),
(NULL, 356, 'pjField', 2, 'title', 'Add new glossary', 'script'),
(NULL, 356, 'pjField', 3, 'title', 'Add new glossary', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Enter words and the description for them and click save button to define new glossary.', 'script'),
(NULL, 357, 'pjField', 2, 'title', 'Enter words and the description for them and click save button to define new glossary.', 'script'),
(NULL, 357, 'pjField', 3, 'title', 'Enter words and the description for them and click save button to define new glossary.', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Update glossary', 'script'),
(NULL, 358, 'pjField', 2, 'title', 'Update glossary', 'script'),
(NULL, 358, 'pjField', 3, 'title', 'Update glossary', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Let make any change on the form below and click Save button to update the glossary information.', 'script'),
(NULL, 359, 'pjField', 2, 'title', 'Let make any change on the form below and click Save button to update the glossary information.', 'script'),
(NULL, 359, 'pjField', 3, 'title', 'Let make any change on the form below and click Save button to update the glossary information.', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Author', 'script'),
(NULL, 360, 'pjField', 2, 'title', 'Author', 'script'),
(NULL, 360, 'pjField', 3, 'title', 'Author', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Created date time', 'script'),
(NULL, 361, 'pjField', 2, 'title', 'Created date time', 'script'),
(NULL, 361, 'pjField', 3, 'title', 'Created date time', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Modified date time', 'script'),
(NULL, 362, 'pjField', 2, 'title', 'Modified date time', 'script'),
(NULL, 362, 'pjField', 3, 'title', 'Modified date time', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'n/a', 'script'),
(NULL, 363, 'pjField', 2, 'title', 'n/a', 'script'),
(NULL, 363, 'pjField', 3, 'title', 'n/a', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'of', 'script'),
(NULL, 364, 'pjField', 2, 'title', 'of', 'script'),
(NULL, 364, 'pjField', 3, 'title', 'of', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'votes', 'script'),
(NULL, 365, 'pjField', 2, 'title', 'votes', 'script'),
(NULL, 365, 'pjField', 3, 'title', 'votes', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 366, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 366, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Average rating', 'script'),
(NULL, 367, 'pjField', 2, 'title', 'Average rating', 'script'),
(NULL, 367, 'pjField', 3, 'title', 'Average rating', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Reset rating', 'script'),
(NULL, 368, 'pjField', 2, 'title', 'Reset rating', 'script'),
(NULL, 368, 'pjField', 3, 'title', 'Reset rating', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Are you sure that you want to reset rating of this question?', 'script'),
(NULL, 369, 'pjField', 2, 'title', 'Are you sure that you want to reset rating of this question?', 'script'),
(NULL, 369, 'pjField', 3, 'title', 'Are you sure that you want to reset rating of this question?', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 370, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 370, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 371, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 371, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 372, 'pjField', 2, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 372, 'pjField', 3, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Follow these steps to put the blog on your .php web page using PHP include code:', 'script'),
(NULL, 373, 'pjField', 2, 'title', 'Follow these steps to put the blog on your .php web page using PHP include code:', 'script'),
(NULL, 373, 'pjField', 3, 'title', 'Follow these steps to put the blog on your .php web page using PHP include code:', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Step 2. Copy and paste the code below into your html code, where the content will be displayed.', 'script'),
(NULL, 374, 'pjField', 2, 'title', 'Step 2. Copy and paste the code below into your html code, where the content will be displayed.', 'script'),
(NULL, 374, 'pjField', 3, 'title', 'Step 2. Copy and paste the code below into your html code, where the content will be displayed.', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 375, 'pjField', 2, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 375, 'pjField', 3, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 376, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 376, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Layout', 'script'),
(NULL, 377, 'pjField', 2, 'title', 'Layout', 'script'),
(NULL, 377, 'pjField', 3, 'title', 'Layout', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Home', 'script'),
(NULL, 417, 'pjField', 2, 'title', 'Home', 'script'),
(NULL, 417, 'pjField', 3, 'title', 'Home', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 418, 'pjField', 2, 'title', 'Categories', 'script'),
(NULL, 418, 'pjField', 3, 'title', 'Categories', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Glossary', 'script'),
(NULL, 419, 'pjField', 2, 'title', 'Glossary', 'script'),
(NULL, 419, 'pjField', 3, 'title', 'Glossary', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 420, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 420, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Featured', 'script'),
(NULL, 421, 'pjField', 2, 'title', 'Featured', 'script'),
(NULL, 421, 'pjField', 3, 'title', 'Featured', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Most popular', 'script'),
(NULL, 422, 'pjField', 2, 'title', 'Most popular', 'script'),
(NULL, 422, 'pjField', 3, 'title', 'Most popular', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Recently added', 'script'),
(NULL, 423, 'pjField', 2, 'title', 'Recently added', 'script'),
(NULL, 423, 'pjField', 3, 'title', 'Recently added', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Select category', 'script'),
(NULL, 424, 'pjField', 2, 'title', 'Select category', 'script'),
(NULL, 424, 'pjField', 3, 'title', 'Select category', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'View', 'script'),
(NULL, 425, 'pjField', 2, 'title', 'View', 'script'),
(NULL, 425, 'pjField', 3, 'title', 'View', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'by', 'script'),
(NULL, 426, 'pjField', 2, 'title', 'by', 'script'),
(NULL, 426, 'pjField', 3, 'title', 'by', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'in', 'script'),
(NULL, 427, 'pjField', 2, 'title', 'in', 'script'),
(NULL, 427, 'pjField', 3, 'title', 'in', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 428, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 428, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Added', 'script'),
(NULL, 429, 'pjField', 2, 'title', 'Added', 'script'),
(NULL, 429, 'pjField', 3, 'title', 'Added', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Last updated', 'script'),
(NULL, 430, 'pjField', 2, 'title', 'Last updated', 'script'),
(NULL, 430, 'pjField', 3, 'title', 'Last updated', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Author', 'script'),
(NULL, 431, 'pjField', 2, 'title', 'Author', 'script'),
(NULL, 431, 'pjField', 3, 'title', 'Author', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 432, 'pjField', 2, 'title', 'Category', 'script'),
(NULL, 432, 'pjField', 3, 'title', 'Category', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Average rating', 'script'),
(NULL, 433, 'pjField', 2, 'title', 'Average rating', 'script'),
(NULL, 433, 'pjField', 3, 'title', 'Average rating', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Print article', 'script'),
(NULL, 434, 'pjField', 2, 'title', 'Print article', 'script'),
(NULL, 434, 'pjField', 3, 'title', 'Print article', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Email to friend', 'script'),
(NULL, 435, 'pjField', 2, 'title', 'Email to friend', 'script'),
(NULL, 435, 'pjField', 3, 'title', 'Email to friend', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 436, 'pjField', 2, 'title', 'All', 'script'),
(NULL, 436, 'pjField', 3, 'title', 'All', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'No question found.', 'script'),
(NULL, 437, 'pjField', 2, 'title', 'No question found.', 'script'),
(NULL, 437, 'pjField', 3, 'title', 'No question found.', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'No glossary found.', 'script'),
(NULL, 438, 'pjField', 2, 'title', 'No glossary found.', 'script'),
(NULL, 438, 'pjField', 3, 'title', 'No glossary found.', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Mark as featured', 'script'),
(NULL, 478, 'pjField', 2, 'title', 'Mark as featured', 'script'),
(NULL, 478, 'pjField', 3, 'title', 'Mark as featured', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Optional', 'script'),
(NULL, 479, 'pjField', 2, 'title', 'Optional', 'script'),
(NULL, 479, 'pjField', 3, 'title', 'Optional', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Enter web address for the web page where the question list is put:', 'script'),
(NULL, 480, 'pjField', 2, 'title', 'Enter web address for the web page where the question list is put:', 'script'),
(NULL, 480, 'pjField', 3, 'title', 'Enter web address for the web page where the question list is put:', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 481, 'pjField', 2, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 481, 'pjField', 3, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your question list.', 'script'),
(NULL, 482, 'pjField', 2, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your question list.', 'script'),
(NULL, 482, 'pjField', 3, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your question list.', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 483, 'pjField', 2, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 483, 'pjField', 3, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Step 1. Create a file named ".htaccess" in the same directory where your .php page with knowledge base builder is. Then copy and paste the following code into the file.\r\n', 'script'),
(NULL, 484, 'pjField', 2, 'title', 'Step 1. Create a file named ".htaccess" in the same directory where your .php page with knowledge base builder is. Then copy and paste the following code into the file.\r\n', 'script'),
(NULL, 484, 'pjField', 3, 'title', 'Step 1. Create a file named ".htaccess" in the same directory where your .php page with knowledge base builder is. Then copy and paste the following code into the file.\r\n', 'script'),
(NULL, 485, 'pjField', 1, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 485, 'pjField', 2, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 485, 'pjField', 3, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Install settings updated', 'script'),
(NULL, 486, 'pjField', 2, 'title', 'Install settings updated', 'script'),
(NULL, 486, 'pjField', 3, 'title', 'Install settings updated', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'All changes made to the install settings have been saved.', 'script'),
(NULL, 487, 'pjField', 2, 'title', 'All changes made to the install settings have been saved.', 'script'),
(NULL, 487, 'pjField', 3, 'title', 'All changes made to the install settings have been saved.', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 488, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 488, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Email to friend', 'script'),
(NULL, 490, 'pjField', 2, 'title', 'Email to friend', 'script'),
(NULL, 490, 'pjField', 3, 'title', 'Email to friend', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 491, 'pjField', 2, 'title', 'To', 'script'),
(NULL, 491, 'pjField', 3, 'title', 'To', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 492, 'pjField', 2, 'title', 'From', 'script'),
(NULL, 492, 'pjField', 3, 'title', 'From', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 493, 'pjField', 2, 'title', 'Subject', 'script'),
(NULL, 493, 'pjField', 3, 'title', 'Subject', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 494, 'pjField', 2, 'title', 'Message', 'script'),
(NULL, 494, 'pjField', 3, 'title', 'Message', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'You voted already.', 'script'),
(NULL, 495, 'pjField', 2, 'title', 'You voted already.', 'script'),
(NULL, 495, 'pjField', 3, 'title', 'You voted already.', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Thanks for voting', 'script'),
(NULL, 496, 'pjField', 2, 'title', 'Thanks for voting', 'script'),
(NULL, 496, 'pjField', 3, 'title', 'Thanks for voting', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Show glossaries', 'script'),
(NULL, 497, 'pjField', 2, 'title', 'Show glossaries', 'script'),
(NULL, 497, 'pjField', 3, 'title', 'Show glossaries', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Words', 'script'),
(NULL, 499, 'pjField', 2, 'title', 'Words', 'script'),
(NULL, 499, 'pjField', 3, 'title', 'Words', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 500, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 500, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'User', 'script'),
(NULL, 501, 'pjField', 2, 'title', 'User', 'script'),
(NULL, 501, 'pjField', 3, 'title', 'User', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Most Popular Questions', 'script'),
(NULL, 502, 'pjField', 2, 'title', 'Most Popular Questions', 'script'),
(NULL, 502, 'pjField', 3, 'title', 'Most Popular Questions', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Last Updated Questions', 'script'),
(NULL, 503, 'pjField', 2, 'title', 'Last Updated Questions', 'script'),
(NULL, 503, 'pjField', 3, 'title', 'Last Updated Questions', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Last Logged in Users', 'script'),
(NULL, 504, 'pjField', 2, 'title', 'Last Logged in Users', 'script'),
(NULL, 504, 'pjField', 3, 'title', 'Last Logged in Users', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'There is no user found.', 'script'),
(NULL, 505, 'pjField', 2, 'title', 'There is no user found.', 'script'),
(NULL, 505, 'pjField', 3, 'title', 'There is no user found.', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'There is no category found.', 'script'),
(NULL, 506, 'pjField', 2, 'title', 'There is no category found.', 'script'),
(NULL, 506, 'pjField', 3, 'title', 'There is no category found.', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'There is no question found.', 'script'),
(NULL, 507, 'pjField', 2, 'title', 'There is no question found.', 'script'),
(NULL, 507, 'pjField', 3, 'title', 'There is no question found.', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Views', 'script'),
(NULL, 508, 'pjField', 2, 'title', 'Views', 'script'),
(NULL, 508, 'pjField', 3, 'title', 'Views', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'View', 'script'),
(NULL, 509, 'pjField', 2, 'title', 'View', 'script'),
(NULL, 509, 'pjField', 3, 'title', 'View', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'questions', 'script'),
(NULL, 549, 'pjField', 2, 'title', 'questions', 'script'),
(NULL, 549, 'pjField', 3, 'title', 'questions', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'question', 'script'),
(NULL, 550, 'pjField', 2, 'title', 'question', 'script'),
(NULL, 550, 'pjField', 3, 'title', 'question', 'script');

INSERT INTO `knowledgebase_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_layout', 1, 'layout_1::layout_1', 'Layout 1', 'enum', 3, 1, NULL),
(1, 'o_show_glossary', 1, 'Yes|No::Yes', 'Yes|No', 'enum', 4, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 5, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 6, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 7, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 8, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_install_page', 99, 'http://localhost/SCRIPTS/KnowledgeBase/testpage.php', NULL, 'string', NULL, 0, NULL),
(1, 'o_seo_url', 99, 'Yes|No::No', NULL, 'enum', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL);

INSERT INTO `knowledgebase_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');


INSERT INTO `knowledgebase_categories` (`id`, `parent_id`, `lft`, `rgt`, `name`) VALUES
(1, 0, 1, 2, 'Questions');