<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{
	public $defaultCaptcha = 'StivaSoftCaptcha';
	
	public $defaultLocale = 'front_locale_id';
	
	public $defaultMember = 'front_member';
	
	public $defaultTopic = 'front_topic_id';
	
	public $defaultForm = 'front_comment_form';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
	}

	public function afterFilter()
	{
		$theme = $this->getTheme();
		if($theme == false)
		{
			$theme = $this->option_arr['o_theme'];
		}
		$this->appendCss('pj.bootstrap.min.css', PJ_FRAMEWORK_LIBS_PATH . 'pj/css/');
		$this->appendCss('front.css');
		$this->appendCss($theme.'.css');
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if(isset($_GET['topic_id']))
		{
			$topic_id = pjObject::escapeString($_GET['topic_id']);
			if((int) $topic_id > 0)
			{
				$this->setTopic(pjObject::escapeString($_GET['topic_id']));
			}
		}
		if(isset($_GET['theme']))
		{
			$theme = pjObject::escapeString($_GET['theme']);
			if(!empty($theme))
			{
				$this->setTheme($theme);
			}
		}else{
			if(!isset($_SESSION[$this->defaultTheme]))
			{
				$this->setTheme($this->option_arr['o_theme']);
			}
		}
		
		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		$this->loadSetFields();
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha(PJ_WEB_PATH.'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH.'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		
		if (!isset($_GET['verification']) || empty($_GET['verification']) || strtoupper($_GET['verification']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	public function pjActionCheckEmail()
	{
		$this->setAjax(true);
	
		$email = pjObject::escapeString($_GET['email']);
		$pjMemberModel = pjMemberModel::factory()->where('t1.email', $email);
		if(isset($_GET['id']) && (int) $_GET['id'] > 0)
		{
			$pjMemberModel->where("t1.id <>", $_GET['id']);
		}
		if($pjMemberModel->findCount()->getData() != 0){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	public function pjActionSetLocale()
	{
		$this->setLocaleId(@$_GET['locale']);
		pjUtil::redirect($_SERVER['HTTP_REFERER']);
	}
	
	public function pjActionDownloadFile()
	{
		$id = pjObject::escapeString($_GET['id']);
		$arr = pjFileModel::factory()->find($id)->getData();
		if(!empty($arr))
		{
			if($arr['hash'] == $_GET['hash'])
			{
				pjUtil::downloadFile(PJ_INSTALL_PATH . $arr['file_path'], $arr['file_name'], $arr['mime_type']);
			}
			exit;
		}
	}
	
	public function checkLogin()
	{
		if (isset($_SESSION[$this->defaultMember]) && count($_SESSION[$this->defaultMember]) > 0)
        {
            return true;
	    }
	    return false;
	}
	
	protected function getReceivedEmail($notification_id)
	{
		$arr = array();
		$pjUserNotificationModel = pjUserNotificationModel::factory()
			->select('t1.type, t2.email, t2.phone')
			->join('pjUser', "t2.id=t1.user_id", 'inner')
			->where('t1.notification_id', $notification_id)->where('`type`', 'email');

		$recipients = $pjUserNotificationModel->findAll()->getData();
		foreach ($recipients as $recipient)
		{
			if (empty($recipient['email']))
			{
				continue;
			}
			$arr[] = $recipient['email'];
		}
		
		return $arr;
	}
	
	protected function getAdminEmail()
	{
		$arr = array();
		$pjUserModel = pjUserModel::factory();
		
		$recipients = $pjUserModel->select('t1.email')->where('t1.role_id', '1')->findAll()->getData();
		foreach ($recipients as $recipient)
		{
			if (empty($recipient['email']))
			{
				continue;
			}
			$arr[] = $recipient['email'];
		}
		return $arr;
	}
	
	protected function getReceivedPhone($notification_id){
		$arr = array();
		$pjUserNotificationModel = pjUserNotificationModel::factory()
			->select('t1.type, t2.email, t2.phone')
			->join('pjUser', "t2.id=t1.user_id", 'inner')
			->where('t1.notification_id', $notification_id)->where('`type`', 'sms');

		$recipients = $pjUserNotificationModel->findAll()->getData();
		foreach ($recipients as $recipient)
		{
			if (empty($recipient['phone']))
			{
				continue;
			}
			$arr[] = $recipient['phone'];
		}
		
		return $arr;
	}
	
	protected function sendRegistrationEmail($member_email, $member_name)
	{
		$receiver_arr = $this->getReceivedEmail(1);
		$receiver_arr = array_unique($receiver_arr);
		
		$message = str_replace(array('{Name}', '{Email}'), array($member_name, $member_email), $this->option_arr['o_email_new_member']);
		$subject = $this->option_arr['o_email_new_member_subject'];
		
		$pjEmail = new pjEmail();
		if ($this->option_arr['o_send_email'] == 'smtp')
		{
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($this->option_arr['o_smtp_host'])
				->setSmtpPort($this->option_arr['o_smtp_port'])
				->setSmtpUser($this->option_arr['o_smtp_user'])
				->setSmtpPass($this->option_arr['o_smtp_pass'])
				->setSender($this->option_arr['o_smtp_user'])
			;
		}
		$pjEmail
			->setContentType('text/html')
			->setFrom($this->getFromEmail($this->option_arr))
			->setSubject($subject);
		foreach($receiver_arr as $v)
		{
			$pjEmail
				->setTo($v)
				->send($message);
		}
	}
	
	protected function sendSMS($notification_id){
		
		$text = '';
		if($notification_id == 1)
		{
			$text = $this->option_arr['o_sms_new_member_registration'];
		}
		if($notification_id == 2)
		{
			$text = $this->option_arr['o_sms_new_comment'];
		}
		if($notification_id == 3)
		{
			$text = $this->option_arr['o_sms_comment_reported'];
		}
		
		$recipients = $this->getReceivedPhone($notification_id);
		
		$smsPlugin = (pjObject::getPlugin('pjSms') !== NULL);
		foreach ($recipients as $recipient)
		{
			if (empty($recipient['phone']) || !$smsPlugin)
			{
				continue;
			}
			$this->requestAction(array(
				'controller' => 'pjSms',
				'action' => 'pjActionSend',
				'params' => array(
					'number' => $recipient['phone'],
					'text' => $text,
					'type' => 'unicode',
					'key' => md5($this->option_arr['private_key'] . PJ_SALT)
				)
			), array('return'));
		}
	}
	
	protected function sendActivationEmail($member_email, $member_name, $id)
	{
		$hash = md5(PJ_SALT . $id);
		$activated_url = PJ_INSTALL_URL.'index.php?controller=pjLoad&action=pjActionActivate&id='.$id.'&hash='.$hash;
		
		$member = pjMemberModel::factory()->find($id)->getData();
		
		$message = str_replace(array('{Name}', '{Email}', '{Password}', '{ActivatedURL}'), array($member_name, $member_email, @$member['password'], $activated_url), $this->option_arr['o_email_member_confirmation']);
		$subject = $this->option_arr['o_email_member_confirmation_subject'];
		$pjEmail = new pjEmail();
		if ($this->option_arr['o_send_email'] == 'smtp')
		{
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($this->option_arr['o_smtp_host'])
				->setSmtpPort($this->option_arr['o_smtp_port'])
				->setSmtpUser($this->option_arr['o_smtp_user'])
				->setSmtpPass($this->option_arr['o_smtp_pass'])
				->setSender($this->option_arr['o_smtp_user'])
			;
		}
		$pjEmail->setContentType('text/html');
		$pjEmail->setFrom($this->getFromEmail($this->option_arr))
				->setTo($member_email)
				->setSubject($subject)
				->send($message);
		
	}
	
	protected function resendActivationURLEmail($member_email, $member_name, $id)
	{
		$hash = md5(PJ_SALT . $id);
		$activated_url = PJ_INSTALL_URL.'index.php?controller=pjLoad&action=pjActionActivate&id='.$id.'&hash='.$hash;
		$member = pjMemberModel::factory()->find($id)->getData();
		$message = str_replace(array('{Name}', '{Email}', '{Password}', '{ActivatedURL}'), array($member_name, $member_email, @$member['password'], $activated_url), $this->option_arr['o_resend_activation_url']);
		$subject = $this->option_arr['o_resend_activation_url_subject'];
		$pjEmail = new pjEmail();
		if ($this->option_arr['o_send_email'] == 'smtp')
		{
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($this->option_arr['o_smtp_host'])
				->setSmtpPort($this->option_arr['o_smtp_port'])
				->setSmtpUser($this->option_arr['o_smtp_user'])
				->setSmtpPass($this->option_arr['o_smtp_pass'])
				->setSender($this->option_arr['o_smtp_user'])
			;
		}
		$pjEmail->setContentType('text/html');
		$pjEmail->setFrom($this->getFromEmail($this->option_arr))
				->setTo($member_email)
				->setSubject($subject)
				->send($message);
		
	}
	
	protected function sendCommentEmail($member_email, $comment_id)
	{
		$receiver_arr = $this->getReceivedEmail(2);
		$receiver_arr = array_unique($receiver_arr);
		
		$pjCommentModel = pjCommentModel::factory();
		
		$arr = $pjCommentModel->select("t1.*, t2.topic, t2.id AS topic_id")
				->join('pjTopic', 't2.id=t1.topic_id', 'left')
				->find($comment_id)->getData();
		
		$edit_comment_url = PJ_INSTALL_URL . 'index.php?controller=pjAdminComments&action=pjActionUpdate&id=' . $comment_id;
		$topic_name = $arr['topic'];
		$comment_message = $arr['comment_text'];
		
		$message = str_replace(array('{CommentID}', '{ThreadReferenceId}', '{CommentMessage}', '{EditCommentURL}'), array($comment_id, $topic_name, $comment_message, $edit_comment_url), $this->option_arr['o_email_new_comment']);
		$subject = $this->option_arr['o_email_new_comment_subject'];
		
		$pjEmail = new pjEmail();
		
		if ($this->option_arr['o_send_email'] == 'smtp')
		{
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($this->option_arr['o_smtp_host'])
				->setSmtpPort($this->option_arr['o_smtp_port'])
				->setSmtpUser($this->option_arr['o_smtp_user'])
				->setSmtpPass($this->option_arr['o_smtp_pass'])
				->setSender($this->option_arr['o_smtp_user'])
			;
		}
		$pjEmail
			->setContentType('text/html')
			->setFrom($this->getFromEmail($this->option_arr))
			->setSubject($subject);
		foreach($receiver_arr as $v)
		{
			$pjEmail
				->setTo($v)
				->send($message);
		}
	}
	
	protected function sendReportEmail($comment_id){
		$receiver_arr = $this->getReceivedEmail(3);
		$receiver_arr = array_unique($receiver_arr);
		
		$pjCommentModel = pjCommentModel::factory();
		
		$arr = $pjCommentModel->select("t1.*, t2.topic, t2.id AS topic_id")
				->join('pjTopic', 't2.id=t1.topic_id', 'left')
				->find($comment_id)->getData();
		
		$edit_comment_url = PJ_INSTALL_URL . 'index.php?controller=pjAdminComments&action=pjActionUpdate&id=' . $comment_id;
		$topic_name = $arr['topic'];
		$comment_message = $arr['comment_text'];
		
		$message = str_replace(array('{CommentID}', '{ThreadReferenceId}', '{CommentMessage}', '{EditCommentURL}'), array($comment_id, $topic_name, $comment_message, $edit_comment_url), $this->option_arr['o_email_report']);
		$subject = $this->option_arr['o_email_report_subject'];
		
		$pjEmail = new pjEmail();
		if ($this->option_arr['o_send_email'] == 'smtp' && 
			$this->option_arr['o_smtp_host'] != '' && 
			$this->option_arr['o_smtp_port'] != '' &&
			$this->option_arr['o_smtp_user'] != '' &&
			$this->option_arr['o_smtp_pass'] != '')
		{
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($this->option_arr['o_smtp_host'])
				->setSmtpPort($this->option_arr['o_smtp_port'])
				->setSmtpUser($this->option_arr['o_smtp_user'])
				->setSmtpPass($this->option_arr['o_smtp_pass'])
				->setSender($this->option_arr['o_smtp_user'])
			;
		}
		$pjEmail
			->setContentType('text/html')
			->setFrom($this->getFromEmail($this->option_arr))
			->setSubject($subject);
		foreach($receiver_arr as $v)
		{
			$pjEmail
				->setTo($v)
				->send($message);
		}
	}
	
	protected function sendNewReplyEmail($member_email, $comment_id)
	{
		$topic_id = $this->getTopic();
		
		$pjCommentModel = pjCommentModel::factory();

		$member_arr = $pjCommentModel->select('DISTINCT t2.email, t2.id')->join('pjMember', "t1.member_id=t2.id", 'inner')
						->where('t1.topic_id', $topic_id)
						->where('t1.subscribed', '1')->findAll()->getData();
		
		$arr = $pjCommentModel
			->reset()
			->select("t1.*, t2.topic, t2.page_url")
			->join('pjTopic', 't2.id=t1.topic_id', 'left')
			->find($comment_id)->getData();
		
		$view_comment_url = $arr['page_url'];
		$topic_name = $arr['topic'];
		$comment_message = $arr['comment_text'];
		
		$message = str_replace(array('{CommentID}', '{ThreadReferenceId}', '{CommentMessage}', '{ViewCommentURL}'), array($comment_id, $topic_name, $comment_message, $view_comment_url), $this->option_arr['o_email_new_reply']);
		$subject = str_replace(array('{ThreadReferenceId}'), array($topic_name), $this->option_arr['o_email_new_reply_subject']);
		
		$pjEmail = new pjEmail();
		if ($this->option_arr['o_send_email'] == 'smtp' && 
			$this->option_arr['o_smtp_host'] != '' && 
			$this->option_arr['o_smtp_port'] != '' &&
			$this->option_arr['o_smtp_user'] != '' &&
			$this->option_arr['o_smtp_pass'] != '')
		{
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($this->option_arr['o_smtp_host'])
				->setSmtpPort($this->option_arr['o_smtp_port'])
				->setSmtpUser($this->option_arr['o_smtp_user'])
				->setSmtpPass($this->option_arr['o_smtp_pass'])
				->setSender($this->option_arr['o_smtp_user'])
			;
		}
		$pjEmail
			->setContentType('text/html')
			->setFrom($this->getFromEmail($this->option_arr))
			->setSubject($subject);
		foreach($member_arr as $v)
		{
			if(empty($v['email']))
			{
				continue;
			}
			
			$hash = md5($v['id']);
			$unsubscribe_url = PJ_INSTALL_URL . 'index.php?controller=pjLoad&action=pjActionUnsubscribe&topic_id=' . $topic_id . '&member_id=' . $v['id'] . '&hash=' . $hash;
			$body = $message . "<br/>" . __('front_label_unsubscribe', true) . ' ' . $unsubscribe_url;
			$pjEmail
				->setTo($v['email'])
				->send($body);
			
		}
	}
	
	public function pjActionNoTopic()
	{
		
	}
}
?>