<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminSections extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || ($this->isEditor() && $this->isSectionAllowed()))
		{
			if (isset($_POST['section_create']))
			{
				$pjSectionModel = pjSectionModel::factory();
				$id = $pjSectionModel->setAttributes($_POST)->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $id, 'pjSection', 'data');
					}
					
					$pjUserSectionModel = pjUserSectionModel::factory();
					if(isset($_POST['user_id']))
					{
						$pjUserSectionModel->begin();
						foreach ($_POST['user_id'] as $user_id)
						{
							$data = array();
							$data['user_id'] = $user_id;
							$data['section_id'] = $id;
							$pjUserSectionModel->reset()->setAttributes($data)->insert();
						}
						$pjUserSectionModel->commit();
					}else{
						$data = array();
						$data['user_id'] = $this->getUserId();
						$data['section_id'] = $id;
						$pjUserSectionModel->reset()->setAttributes($data)->insert();
					}
					$err = 'AS03';
				} else {
					$err = 'AS04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminSections&action=pjActionIndex&err=$err");
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$user_arr = pjUserModel::factory()
					->where("t1.status", "T")
					->where('t1.role_id <> 1')
					->orderBy("t1.name ASC")
					->findAll()
					->getData();
				$this->set('user_arr', $user_arr);
				
				if(isset($_GET['id']))
				{
					$arr = pjSectionModel::factory()					
						->select("t1.*, (SELECT GROUP_CONCAT(t2.user_id SEPARATOR '~:~') FROM `".pjUserSectionModel::factory()->getTable()."` AS t2 WHERE t2.section_id=t1.id ) AS user_ids")
						->find($_GET['id'])
						->toArray('user_ids', '~:~')
						->getData();
					$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjSection');
					$this->set('arr', $arr);
				}
		
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('pjAdminSections.js');
				$this->setFileuploaderVars();
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteSection()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$allowed = true;
			if($this->isEditor() && !in_array($_GET['id'], $this->getAllowedSectionIds($this->getUserId())))
			{
				$allowed = false;
			}
			if($allowed == true)
			{
				if (pjSectionModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
				{
					$pjMultiLangModel = pjMultiLangModel::factory();
					$pjHistoryModel = pjHistoryModel::factory();
					$pjMultiLangModel->where('model', 'pjSection')->where('foreign_id', $_GET['id'])->eraseAll();
					pjUserSectionModel::factory()->where('section_id', $_GET['id'])->eraseAll();
					
					$_arr = $pjHistoryModel
						->where('section_id', $_GET['id'])
						->findAll()
						->getDataPair('id', 'id');
					if(!empty($_arr))
					{
						$pjMultiLangModel->reset()->where('model', 'pjHistory')->whereIn('foreign_id', $_arr)->eraseAll();
					}
					$pjHistoryModel->reset()->where('section_id', $_GET['id'])->eraseAll();
					
					$response['code'] = 200;
				} else {
					$response['code'] = 100;
				}
			}else{
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteSectionBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjMultiLangModel = pjMultiLangModel::factory();
				$pjHistoryModel = pjHistoryModel::factory();
					
				$pjMultiLangModel->where('model', 'pjSection')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				pjUserSectionModel::factory()->whereIn('section_id', $_POST['record'])->eraseAll();
				pjSectionModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				
				$_arr = $pjHistoryModel
					->whereIn('section_id', $_POST['record'])
					->findAll()
					->getDataPair('id', 'id');
				if(!empty($_arr))
				{
					$pjMultiLangModel->reset()->where('model', 'pjHistory')->whereIn('foreign_id', $_arr)->eraseAll();
				}
				$pjHistoryModel->reset()->whereIn('section_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetSection()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjSectionModel = pjSectionModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSection' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'section_name'", 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjSectionModel->where('t2.content LIKE', "%$q%");
			}
			if($this->isEditor())
			{
				$pjSectionModel->where("t1.id IN(SELECT t3.section_id FROM `".pjUserSectionModel::factory()->getTable()."` AS t3 WHERE t3.user_id = '".$this->getUserId()."')");
			}
			
			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjSectionModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjSectionModel->select('t1.*, t2.content AS section_name')
				->orderBy("`$column` $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach($data as $k => $v)
			{
				if(empty($v['url']))
				{
					$v['url'] = 'index.php?controller=pjAdminSections&action=pjActionPreview&id=' . $v['id'];
				}
				if(!empty($v['modified']))
				{
					$v['modified'] = pjUtil::formatDate(date('Y-m-d', strtotime($v['modified'])), 'Y-m-d', $this->option_arr['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($v['modified'])), 'H:i:s', $this->option_arr['o_time_format']);
				}else{
					$v['modified'] = __('lblNA', true);
				}
				$data[$k] = $v;
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminSections.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveSection()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjSectionModel = pjSectionModel::factory();
			if (!in_array($_POST['column'], $pjSectionModel->getI18n()))
			{
				$pjSectionModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjSection', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['section_update']))
			{
				pjSectionModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, array('modified' => date('Y-m-d H:i:s'))));
				
				$data = array();
				$data['user_id'] = $this->getUserId();
				$data['section_id'] = $_POST['id'];
				$data['ip'] = pjUtil::getClientIp();
				$data['modified'] = date('Y-m-d H:i:s');
				$hid = pjHistoryModel::factory($data)->insert()->getInsertId();
				if ($hid !== false && (int) $hid > 0)
				{
					$i18n_arr = pjMultiLangModel::factory()->getMultiLang($_POST['id'], 'pjSection');
					
					$locale_arr = pjLocaleModel::factory()
						->select('t1.*')
						->orderBy('t1.sort ASC')
						->findAll()
						->getData();
					foreach ($locale_arr as $item)
					{
						unset($i18n_arr[$item['id']]['section_name']);
					}
					if(!empty($i18n_arr))
					{
						
						pjMultiLangModel::factory()->updateMultiLang($i18n_arr, $hid, 'pjHistory', 'data');
					}
				}
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $_POST['id'], 'pjSection', 'data');
				}
								
				$pjUserSectionModel = pjUserSectionModel::factory();
				$pjUserSectionModel->where('section_id', $_POST['id'])->eraseAll();
				if(isset($_POST['user_id']))
				{
					$pjUserSectionModel->reset()->begin();
					foreach ($_POST['user_id'] as $user_id)
					{
						$data = array();
						$data['user_id'] = $user_id;
						$data['section_id'] = $_POST['id'];
						$pjUserSectionModel->reset()->setAttributes($data)->insert();
					}
					$pjUserSectionModel->commit();
				}else{
					$data = array();
					$data['user_id'] = $this->getUserId();
					$data['section_id'] = $_POST['id'];
					$pjUserSectionModel->reset()->setAttributes($data)->insert();
				}
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminSections&action=pjActionUpdate&id=".$_POST['id']."&err=AS01");
			} else {
				$allowed = true;
				if($this->isEditor() && !in_array($_GET['id'], $this->getAllowedSectionIds($this->getUserId())))
				{
					$allowed = false;
				}
				if($allowed == true)
				{
					$arr = pjSectionModel::factory()					
						->select("t1.*, (SELECT GROUP_CONCAT(t2.user_id SEPARATOR '~:~') FROM `".pjUserSectionModel::factory()->getTable()."` AS t2 WHERE t2.section_id=t1.id ) AS user_ids,
										(SELECT COUNT(t3.section_id) FROM `".pjHistoryModel::factory()->getTable()."` AS t3 WHERE t3.section_id=t1.id) as changes")
						->find($_GET['id'])
						->toArray('user_ids', '~:~')
						->getData();
					if (count($arr) === 0)
					{
						pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminSections&action=pjActionIndex&err=AS08");
					}
					$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjSection');
					$this->set('arr', $arr);
					
					$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
						->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
						->where('t2.file IS NOT NULL')
						->orderBy('t1.sort ASC')->findAll()->getData();
					
					$lp_arr = array();
					foreach ($locale_arr as $item)
					{
						$lp_arr[$item['id']."_"] = $item['file']; 
					}
					$this->set('lp_arr', $locale_arr);
					$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
					
					$user_arr = pjUserModel::factory()
						->where('status', 'T')
						->where('t1.role_id <> 1')
						->orderBy('name ASC')
						->findAll()
						->getData();
					$this->set('user_arr', $user_arr);
					
					if(!empty($arr['modified']))
					{
						$_arr = pjHistoryModel::factory()
							->join('pjUser', "t2.id = t1.user_id", 'left')
							->select('t1.*, t2.name')
							->where('section_id', $_GET['id'])
							->orderBy('t1.modified DESC')
							->limit(1)
							->findAll()
							->getData();
						$this->set('history_arr', $_arr[0]);
					}
					
					
					$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
					$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
					$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
					$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
					$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
					$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
					$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
					$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
					$this->appendJs('pjAdminSections.js');
					$this->setFileuploaderVars();
				}else{
					$this->set('status', 2);
				}
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionInstall()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			$allowed = true;
			if($this->isEditor() && !in_array($_GET['id'], $this->getAllowedSectionIds($this->getUserId())))
			{
				$allowed = false;
			}
			if($allowed == true)
			{
				$arr = pjSectionModel::factory()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSection' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'section_name'", 'left')					
					->select('t1.*, t2.content as section_name')
					->find($_GET['id'])
					->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminSections&action=pjActionIndex&err=AS08");
				}
				$this->set('arr', $arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.title')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left outer')
					->orderBy('t1.sort ASC')->findAll()->getData();
				$this->set('locale_arr', $locale_arr);
				
				$this->appendJs('pjAdminSections.js');
			}else{
				$this->set('status', 2);
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionPreview()
	{
		$this->setLayout('pjActionEmpty');
		
		$allowed = true;
		if($this->isEditor() && !in_array($_GET['id'], $this->getAllowedSectionIds($this->getUserId())))
		{
			$allowed = false;
		}
		if($allowed == true)
		{
			$arr = pjSectionModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSection' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'section_content'", 'left')					
				->select('t1.*, t2.content as section_content')
				->find($_GET['id'])
				->getData();
			
			if (count($arr) === 0)
			{
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminSections&action=pjActionIndex&err=AS08");
			}	
			$this->set('arr', $arr);
		}
	}
	
	public function pjActionPreviewHistory()
	{
		$this->setLayout('pjActionEmpty');
		
		$allowed = true;
		if($this->isEditor() && !in_array($_GET['id'], $this->getAllowedSectionIds($this->getUserId())))
		{
			$allowed = false;
		}
		if($allowed == true)
		{
			$arr = pjHistoryModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjHistory' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'section_content'", 'left')					
				->select('t1.*, t2.content as section_content')
				->find($_GET['id'])
				->getData();
			
			$this->set('arr', $arr);
		}
	}
	
	public function pjActionHistory()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$allowed = true;
			if($this->isEditor() && !in_array($_GET['section_id'], $this->getAllowedSectionIds($this->getUserId())))
			{
				$allowed = false;
			}
			if($allowed == true)
			{
				$arr = pjSectionModel::factory()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSection' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'section_name'", 'left')					
					->select('t1.*, t2.content as section_name')
					->findAll()
					->getData();
				$this->set('arr', $arr);
				
				$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('pjAdminSections.js');
			}else{
				$this->set('status', 2);
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetHistory()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjHistoryModel = pjHistoryModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.section_id AND t2.model = 'pjSection' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'section_name'", 'left')
				->join('pjUser', "t3.id = t1.user_id", 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjHistoryModel->where('t2.content LIKE', "%$q%");
			}
			if (isset($_GET['section_id']) && !empty($_GET['section_id']))
			{
				$section_id = pjObject::escapeString($_GET['section_id']);
				$pjHistoryModel->where("(t1.section_id='".$section_id."')");
			}

			$column = 'modified';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjHistoryModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjHistoryModel->select('t1.*, t2.content AS section_name, t3.name')
				->orderBy("`$column` $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach($data as $k => $v)
			{
				$v['modified'] = pjUtil::formatDate(date('Y-m-d', strtotime($v['modified'])), 'Y-m-d', $this->option_arr['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($v['modified'])), 'H:i:s', $this->option_arr['o_time_format']);
				$v['title'] = __('lblSectionContent', true, false) . ' ' . __('lblBeforeChanged', true) . ' ' . $v['modified'] . ' ' . __('lblBy', true) . ' ' . $v['name'];
				$data[$k] = $v;
			}	
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionDeleteHistory()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$pjHistoryModel = pjHistoryModel::factory();
			$arr = $pjHistoryModel->find($_GET['id'])->getData();
			
			$allowed = true;
			if($this->isEditor() && !in_array($arr['id'], $this->getAllowedSectionIds($this->getUserId())))
			{
				$allowed = false;
			}
			if($allowed == true)
			{
				if ($pjHistoryModel->reset()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
				{
					pjMultiLangModel::factory()->where('model', 'pjHistory')->where('foreign_id', $_GET['id'])->eraseAll();
					$response['code'] = 200;
				} else {
					$response['code'] = 100;
				}
			}else{
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteHistoryBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjMultiLangModel::factory()->where('model', 'pjHistory')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				pjHistoryModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionView()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$allowed = true;
			if($this->isEditor() && !in_array($arr['id'], $this->getAllowedSectionIds($this->getUserId())))
			{
				$allowed = false;
			}
			if($allowed == true)
			{
				$arr = pjHistoryModel::factory()
					->find($_GET['id'])
					->getData();
				
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjHistory');
				$this->set('arr', $arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				$this->set('lp_arr', $locale_arr);
			}
		}
	}
	
	public function pjActionRestore()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if(isset($_GET['id']) && $_GET['section_id'])
			{
				$allowed = true;
				if($this->isEditor() && !in_array($arr['section_id'], $this->getAllowedSectionIds($this->getUserId())))
				{
					$allowed = false;
				}
				if($allowed == true)
				{
					$pjMultiLangModel = pjMultiLangModel::factory();
					$i18n_arr = $pjMultiLangModel->getMultiLang($_GET['id'], 'pjHistory');
					if(!empty($i18n_arr))
					{
						$pjMultiLangModel->reset()->updateMultiLang($i18n_arr, $_GET['section_id'], 'pjSection', 'data');
					}
				}
			}
		}
		exit;
	}
}
?>