<?php
class pjUtil
{
	public static $SKIP_FILES = array('.', '..', '.buildpath', '.project', '.svn', 'Thumbs.db', '.htaccess');
	
	public static $SKIP_EXT = array();
	
	public static function isXHR()
	{
		return @$_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest';
	}
	
	public static function isGet()
	{
		return $_SERVER['REQUEST_METHOD'] == 'GET';
	}
	
	public static function isPost()
	{
		return $_SERVER['REQUEST_METHOD'] == 'POST';
	}
	
	public static function jsonResponse($value)
	{
		header("Content-Type: application/json; charset=utf-8");
		echo json_encode($value);
		exit;
	}
	
	public static function readDir(&$data, $dir, $filter=NULL)
	{
		if ($handle = opendir($dir))
		{
			$sep = $dir{strlen($dir)-1} != '/' ? '/' : NULL;
			while (false !== ($file = readdir($handle)))
			{
				if (in_array($file, self::$SKIP_FILES))
				{
					continue;
				}
				
				if (!is_dir($dir . $sep . $file))
				{
					if (in_array(self::getFileExtension($file), self::$SKIP_EXT))
					{
						continue;
					}
					
					if (!$filter || stripos($file, $filter) !== false)
					{
						$data[md5($file)] = $dir . $sep . $file;
					}
				} else {
					self::readDir($data, $dir . $sep . $file, $filter);
				}
			}
			closedir($handle);
		}
	}
	
	public static function getFileExtension($str)
	{
		$arrSegments = explode('.', $str);
		$strExtension = $arrSegments[count($arrSegments) - 1];
		$strExtension = strtolower($strExtension);
		
		return $strExtension;
	}
	
	public static function iniValueToInt($value)
	{
		$int = preg_replace('/\D/', '', $value);
		
		$char = strtoupper(substr($value, -1, 1));
		
		switch ($char)
		{
			case 'K':
				$int *= 1024;
				break;
			case 'M':
				$int *= 1024 * 1024;
				break;
			case 'G':
				$int *= 1024 * 1024 * 1024;
				break;
			default:
		}
		
		return $int;
	}
	
	public static function getMaxFilesize()
	{
		$value = ini_get('upload_max_filesize');
		
		return self::iniValueToInt($value);
	}
	
	public static function getPostMaxSize()
	{
		$value = ini_get('post_max_size');
		
		return self::iniValueToInt($value);
	}
	
	public static function getMimeType($filename)
	{
		$mimetype = false;
		if (function_exists('finfo_open')) {
			// open with FileInfo
			$finfo = finfo_open(FILEINFO_MIME_TYPE);
			if ($finfo !== FALSE && is_resource($finfo))
			{
				$mimetype = finfo_file($finfo, $filename);
				finfo_close($finfo);
			}
		} elseif (function_exists('mime_content_type')) {
			$mimetype = mime_content_type($filename);
		} elseif (function_exists('getimagesize')) {
			// open with GD
			$tmp = @getimagesize($filename);
			if ($tmp !== false && isset($tmp['mime']))
			{
				$mimetype = $tmp['mime'];
			}
			
		} elseif (function_exists('exif_imagetype')) {
			// open with EXIF
			$imagetype = @exif_imagetype($filename);
			if ($imagetype !== false)
			{
				$mimetype = image_type_to_mime_type($imagetype);
			}
		}
		
		return $mimetype;
	}
	
	public static function sendDownloadHeaders($name, $length=0, $type='application/octet-stream')
	{
		header('Pragma: public');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Cache-Control: private', false);
		header('Content-Transfer-Encoding: binary');
		header('Content-Disposition: attachment; filename="'.$name.'"');
		header('Content-Type: ' . $type);
		if ($length > 0)
		{
			header('Content-Length: ' . $length);
		}
	}
	
	public static function chunckedDownload($file, $type='application/octet-stream', $name=NULL)
	{
		$length = filesize($file);
		$name = empty($name) ? basename($file) : $name;
		
		self::sendDownloadHeaders($name, $length, $type);
		
		$chunkSize = 1024 * 1024;
		$handle = fopen($file, 'rb');
		while (!feof($handle))
		{
			$buffer = fread($handle, $chunkSize);
			echo $buffer;
			ob_flush();
			flush();
		}
		fclose($handle);
	}
	
	public static function isSafari()
	{
		return strpos($_SERVER['HTTP_USER_AGENT'], 'Safari') !== false 
			&& strpos($_SERVER['HTTP_USER_AGENT'], 'Chrome') === false;
	}
}