<?php 
if (isset($source_data) && !empty($source_data))
{
	?>
	<div class="row">
	<?php
	$i = 0;
	foreach ($source_data as $index => $item)
	{
		$source_url = $config['fu_base_folder'] . $config['fu_source_folder'] . basename($item);
		$source_path = $config['fu_source_path'] . basename($item);
		$mimetype = pjUtil::getMimeType($source_path);
		$is_image = stripos($mimetype, 'image/') === 0;
		$is_video = stripos($mimetype, 'video/') === 0;
		if ($is_image)
		{
			$thumb_path = realpath(isset($thumbs_data[$index]) ? $thumbs_data[$index] : $item);
			$thumb_url = isset($thumbs_data[$index]) ? $config['fu_base_folder'] . $config['fu_thumbs_folder'] . basename($item) : $source_url;
		}
		
		$opener = isset($_GET['opener']) && $_GET['opener'] == 1;
		$type = isset($_GET['type']) ? $_GET['type'] : NULL;
		
		if ($type == 'image' && !$is_image)
		{
			continue;
		}
		if ($type == 'media' && !$is_video)
		{
			continue;
		}
		?>
		<div class="col">
			<div class="item">
			<?php
			if ($opener)
			{
				?>
				<div role="button" class="thumb btn-use" data-url="<?php echo $source_url; ?>">
				<?php 
				if ($is_image)
				{
					?><img src="<?php echo $thumb_url; ?>?<?php echo filemtime($thumb_path); ?>" title="<?php echo basename($thumb_path); ?>"><?php 
				} else {
					?><img src="<?php echo 'web/img/file.png'; ?>" title="<?php echo basename($source_path); ?>"><?php
				}
				?>
				</div>
				<?php
			} else {
				?>
				<a target="_blank" class="thumb" href="<?php echo $source_url; ?>" title="<?php echo basename($source_url); ?>">
				<?php 
				if ($is_image)
				{
					?><img src="<?php echo $thumb_url; ?>?<?php echo filemtime($thumb_path); ?>" alt="<?php echo basename($thumb_path); ?>"><?php 
				} else {
					?><img src="<?php echo 'web/img/file.png'; ?>" title="<?php echo basename($source_path); ?>"><?php
				}
				?>
				</a>
				<?php
			}
			?>
				<div class="actions">
				<?php 
				if ($opener)
				{
					?>
					<button type="button" class="btn btn-icon btn-use" title="<?php echo htmlspecialchars($config['fu_label_use']); ?>"
						data-url="<?php echo $source_url; ?>"><i class="icon icon-use"></i></button>
					<?php 
				}
				if ($config['fu_allow_preview'])
				{
					?>
					<a target="_blank" class="btn btn-icon btn-preview" title="<?php echo htmlspecialchars($config['fu_label_preview']); ?>" 
						href="<?php echo $source_url; ?>"><i class="icon icon-preview"></i></a>
					<?php
				}
				if ($config['fu_allow_download'])
				{
					?><button type="button" class="btn btn-icon btn-download" title="<?php echo htmlspecialchars($config['fu_label_download']); ?>"
						data-name="<?php echo basename($item); ?>"><i class="icon icon-download"></i></button>
					<?php
				}
				if ($config['fu_allow_rename'])
				{
					?><button type="button" class="btn btn-icon btn-rename" title="<?php echo htmlspecialchars($config['fu_label_rename']); ?>"
						data-name="<?php echo basename($item); ?>"><i class="icon icon-rename"></i></button>
					<?php
				}
				if ($config['fu_allow_delete'])
				{
					?><button type="button" class="btn btn-icon btn-delete" title="<?php echo htmlspecialchars($config['fu_label_delete']); ?>"
						data-name="<?php echo basename($item); ?>"><i class="icon icon-delete"></i></button>
					<?php
				}
				?>	
				</div>
			</div>
		</div>
		<?php
		$i += 1;
	}
	?>
	</div>
	<?php
	if (!$i)
	{
		?><div class="alert alert-warning" role="alert"><?php echo htmlspecialchars($config['fu_label_no_files']); ?></div><?php
	}
} else {
    ?>
    <div class="alert alert-warning" role="alert"><?php echo htmlspecialchars($config['fu_label_no_files']); ?></div>
    <?php
}
?>