BEGIN;

DROP TABLE IF EXISTS `stivaforum_questions`;
CREATE TABLE IF NOT EXISTS `stivaforum_questions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `question` varchar(250) DEFAULT NULL,
  `description` text,
  `counts` int(11) DEFAULT NULL,
  `ip` varchar(15) default NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('New','Approved','Banned') DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivaforum_replies`;
CREATE TABLE IF NOT EXISTS `stivaforum_replies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `question_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `reply_id` int(11) DEFAULT NULL,
  `reply` varchar(250) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `description` text,
  `likes` int(11) NOT NULL,
  `dislikes` int(11) NOT NULL,
  `report` enum('0','1') DEFAULT '0',
  `ip` varchar(15) default NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('New','Approved','Banned') DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `question_id` (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivaforum_votes`;
CREATE TABLE `stivaforum_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reply_id` int(11) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `value` enum('up','down') DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reply_id` (`reply_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivaforum_categories`;
CREATE TABLE IF NOT EXISTS `stivaforum_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `font_color` varchar(10) DEFAULT 'FFFFFF',
  `background_color` varchar(10) DEFAULT 'F78D3F',
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ;

DROP TABLE IF EXISTS `stivaforum_fields`;
CREATE TABLE IF NOT EXISTS `stivaforum_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivaforum_multi_lang`;
CREATE TABLE IF NOT EXISTS `stivaforum_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivaforum_options`;
CREATE TABLE IF NOT EXISTS `stivaforum_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivaforum_roles`;
CREATE TABLE IF NOT EXISTS `stivaforum_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivaforum_users`;
CREATE TABLE IF NOT EXISTS `stivaforum_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) default NULL,
  `password` blob,
  `name` varchar(255) default NULL,
  `phone` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `notes` text,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `country_id` varchar(255) DEFAULT NULL,
  `avatar_path` varchar(255) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `avatar_hash` varchar(255) DEFAULT NULL,
  `ip` varchar(15) default NULL,
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime default NULL,
  `is_active` enum('T','F') NOT NULL default 'F',
  `status` enum('T','F') NOT NULL default 'T',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `stivaforum_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(360, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(361, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(480, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(481, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(482, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(483, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(484, 'gridEmptyBody', 'backend', 'Grid / You need to select at least a single record.', 'script', NULL),
(485, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(486, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(487, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(488, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(489, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(490, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(491, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(492, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(493, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(595, 'infoGeneralOptionTitle', 'backend', 'Infobox / General options', 'script', NULL),
(596, 'infoGeneralOptionDesc', 'backend', 'Infobox / General options', 'script', NULL),
(597, 'enum_arr_ARRAY_yes', 'arrays', 'enum_arr_ARRAY_yes', 'script', NULL),
(598, 'enum_arr_ARRAY_no', 'arrays', 'enum_arr_ARRAY_no', 'script', NULL),
(599, 'enum_arr_ARRAY_email', 'arrays', 'enum_arr_ARRAY_email', 'script', NULL),
(600, 'enum_arr_ARRAY_admin', 'arrays', 'enum_arr_ARRAY_admin', 'script', NULL),
(601, 'enum_arr_ARRAY_everyone', 'arrays', 'enum_arr_ARRAY_everyone', 'script', NULL),
(602, 'enum_arr_ARRAY_registered', 'arrays', 'enum_arr_ARRAY_registered', 'script', NULL),
(603, 'enum_arr_ARRAY_yes_email', 'arrays', 'enum_arr_ARRAY_yes_email', 'script', NULL),
(604, 'enum_arr_ARRAY_logged', 'arrays', 'enum_arr_ARRAY_logged', 'script', NULL),
(605, 'enum_arr_ARRAY_disabled', 'arrays', 'enum_arr_ARRAY_disabled', 'script', NULL),
(606, 'enum_arr_ARRAY_last', 'arrays', 'enum_arr_ARRAY_last', 'script', NULL),
(607, 'enum_arr_ARRAY_first', 'arrays', 'enum_arr_ARRAY_first', 'script', NULL),
(608, 'enum_arr_ARRAY_unregisterd', 'arrays', 'enum_arr_ARRAY_unregisterd', 'script', NULL),
(609, 'enum_arr_ARRAY_cookie', 'arrays', 'enum_arr_ARRAY_cookie', 'script', NULL),
(610, 'enum_arr_ARRAY_ip', 'arrays', 'enum_arr_ARRAY_ip', 'script', NULL),
(611, 'opt_o_use_categories', 'backend', 'Options / Use categories', 'script', NULL),
(612, 'opt_o_use_registration', 'backend', 'Options / Use registration', 'script', NULL),
(613, 'opt_o_account_confirmation', 'backend', 'Options / Account confirmation', 'script', NULL),
(614, 'opt_o_new_questions', 'backend', 'Options / New questions', 'script', NULL),
(615, 'opt_o_new_replies', 'backend', 'Options / New replies', 'script', NULL),
(616, 'opt_o_approve_questions', 'backend', 'Options / Approve questions', 'script', NULL),
(617, 'opt_o_approve_replies', 'backend', 'Options / Approve replies', 'script', NULL),
(618, 'opt_o_questions_per_page', 'backend', 'Options / Number of questions per page', 'script', NULL),
(619, 'opt_o_replies_per_page', 'backend', 'Options / Number of replies per page', 'script', NULL),
(620, 'opt_o_rating', 'backend', 'Options / Rating', 'script', NULL),
(621, 'opt_o_reporting', 'backend', 'Options / Reporting', 'script', NULL),
(622, 'opt_o_reply_order', 'backend', 'Options / Reply order', 'script', NULL),
(623, 'opt_o_use_captcha', 'backend', 'Options / Use captcha', 'script', NULL),
(624, 'opt_o_prevent_multiple_rating', 'backend', 'Options / Prevent multiple ratings', 'script', NULL),
(625, 'opt_o_block_ip', 'backend', 'Options / Block IP', 'script', NULL),
(626, 'tips_ARRAY_o_use_categories', 'arrays', 'tips_ARRAY_o_use_categories', 'script', NULL),
(627, 'tips_ARRAY_o_use_registration', 'arrays', 'tips_ARRAY_o_use_registration', 'script', NULL),
(628, 'tips_ARRAY_o_account_confirmation', 'arrays', 'tips_ARRAY_o_account_confirmation', 'script', NULL),
(629, 'tips_ARRAY_o_new_questions', 'arrays', 'tips_ARRAY_o_new_questions', 'script', NULL),
(630, 'tips_ARRAY_o_new_replies', 'arrays', 'tips_ARRAY_o_new_replies', 'script', NULL),
(631, 'tips_ARRAY_o_approve_questions', 'arrays', 'tips_ARRAY_o_approve_questions', 'script', NULL),
(632, 'tips_ARRAY_o_approve_replies', 'arrays', 'tips_ARRAY_o_approve_replies', 'script', NULL),
(633, 'tips_ARRAY_o_rating', 'arrays', 'tips_ARRAY_o_rating', 'script', NULL),
(634, 'tips_ARRAY_o_reporting', 'arrays', 'tips_ARRAY_o_reporting', 'script', NULL),
(635, 'tips_ARRAY_o_reply_order', 'arrays', 'tips_ARRAY_o_reply_order', 'script', NULL),
(636, 'tips_ARRAY_o_use_captcha', 'arrays', 'tips_ARRAY_o_use_captcha', 'script', NULL),
(637, 'tips_ARRAY_o_prevent_multiple_rating', 'arrays', 'tips_ARRAY_o_prevent_multiple_rating', 'script', NULL),
(638, 'lblRegistrationTokens', 'backend', 'Label / Tokens', 'script', NULL),
(639, 'lblPasswordTokens', 'backend', 'Label / Tokens', 'script', NULL),
(640, 'lblReplyApprovalTokens', 'backend', 'Label / Tokens', 'script', NULL),
(641, 'lblQuestionApprovalTokens', 'backend', 'Label / Tokens', 'script', NULL),
(642, 'infoAntiSpamTitle', 'backend', 'Infobox / Anti spam', 'script', NULL),
(643, 'infoAntiSpamDesc', 'backend', 'Infobox / Anti spam', 'script', NULL),
(644, 'menuAntiSpam', 'backend', 'Menu / Anti spam', 'script', NULL),
(645, 'menuNotifications', 'backend', 'Menu / Notifications', 'script', NULL),
(646, 'tabToUsers', 'backend', 'Tab / To users', 'script', NULL),
(647, 'tabToAdministrators', 'backend', 'Tab / To administrators', 'script', NULL),
(648, 'infoUsersEmailTitle', 'backend', 'Infobox / Notifications sent to users', 'script', NULL),
(649, 'infoUsersEmailDesc', 'backend', 'Infobox / Notifications sent to users', 'script', NULL),
(650, 'lblSubject', 'backend', 'Label / Subject', 'script', NULL),
(651, 'lblMessage', 'backend', 'Label / Message', 'script', NULL),
(652, 'lblNewAccountConfirmation', 'backend', 'Label / Registration email', 'script', NULL),
(653, 'lblForgotPasswordNotifiation', 'backend', 'Label / Password recovery email', 'script', NULL),
(654, 'lblNewAccountNotification', 'backend', 'Label / Registration notification', 'script', NULL),
(655, 'lblQuestionApprovalNotifiation', 'backend', 'Label / Question approval email', 'script', NULL),
(656, 'lblReplyApprovalSubject', 'backend', 'Label / Reply approval email', 'script', NULL),
(657, 'infoAdminsEmailTitle', 'backend', 'Infobox / Notifications sent to administrators', 'script', NULL),
(659, 'infoAdminsEmailDesc', 'backend', 'Infobox / Notifications sent to administrators', 'script', NULL),
(660, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(661, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(662, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(663, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(664, 'infoInstallTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(665, 'infoInstallDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(666, 'lblInstallPhp1_1', 'backend', 'Label / Install step 1', 'script', NULL),
(667, 'lblInstallPhp1_2', 'backend', 'Label / Install step 2', 'script', NULL),
(668, 'lblInstallPhp1_3', 'backend', 'Label / Install step 3', 'script', NULL),
(669, 'infoThemeTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(670, 'infoThemeDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(671, 'lblInstallTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(672, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(673, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(674, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(675, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(676, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(677, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(678, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(679, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(680, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(681, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(682, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(683, 'btnUseThisTheme', 'backend', 'Label / Use this theme', 'script', NULL),
(802, 'menuCategories', 'backend', 'Menu / Categories', 'script', NULL),
(803, 'infoCategoriesTitle', 'backend', 'Infobox / List of categories', 'script', NULL),
(804, 'infoCategoriesDesc', 'backend', 'Infobox / List of categories', 'script', NULL),
(805, 'btnAddCategory', 'backend', 'Button / + Add category', 'script', NULL),
(806, 'lblCategory', 'backend', 'Label / Category', 'script', NULL),
(807, 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', NULL),
(808, 'lblEmailInvalid', 'backend', 'Label / Email is invalid.', 'script', NULL),
(809, 'infoAddCategoryTitle', 'backend', 'Infobox / Add category', 'script', NULL),
(810, 'infoAddCategoryDesc', 'backend', 'Infobox / Add category', 'script', NULL),
(811, 'infoUpdateCategoryTitle', 'backend', 'Infobox / Update category', 'script', NULL),
(812, 'infoUpdateCategoryDesc', 'backend', 'Infobox / Update category', 'script', NULL),
(813, 'error_titles_ARRAY_ACT01', 'arrays', 'error_titles_ARRAY_ACT01', 'script', NULL),
(814, 'error_bodies_ARRAY_ACT01', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(815, 'error_titles_ARRAY_ACT03', 'arrays', 'error_titles_ARRAY_ACT03', 'script', NULL),
(816, 'error_bodies_ARRAY_ACT03', 'arrays', 'error_bodies_ARRAY_ACT03', 'script', NULL),
(817, 'error_titles_ARRAY_ACT04', 'arrays', 'error_titles_ARRAY_ACT04', 'script', NULL),
(818, 'error_bodies_ARRAY_ACT04', 'arrays', 'error_bodies_ARRAY_ACT04', 'script', NULL),
(819, 'error_titles_ARRAY_ACT08', 'arrays', 'error_titles_ARRAY_ACT08', 'script', NULL),
(820, 'error_bodies_ARRAY_ACT08', 'arrays', 'error_bodies_ARRAY_ACT08', 'script', NULL),
(821, 'lblNotes', 'backend', 'Label / Notes', 'script', NULL),
(822, 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
(823, 'lblCity', 'backend', 'Label / City', 'script', NULL),
(824, 'lblState', 'backend', 'Label / State', 'script', NULL),
(825, 'lblZip', 'backend', 'Label / Zip', 'script', NULL),
(826, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(827, 'lblAvatar', 'backend', 'Label / Avatar', 'script', NULL),
(828, 'error_titles_ARRAY_AU05', 'arrays', 'error_titles_ARRAY_AU05', 'script', NULL),
(829, 'error_bodies_ARRAY_AU05', 'arrays', 'error_bodies_ARRAY_AU05', 'script', NULL),
(830, 'error_titles_ARRAY_AU07', 'arrays', 'error_titles_ARRAY_AU07', 'script', NULL),
(831, 'error_bodies_ARRAY_AU07', 'arrays', 'error_bodies_ARRAY_AU07', 'script', NULL),
(832, 'error_titles_ARRAY_AU09', 'arrays', 'error_titles_ARRAY_AU09', 'script', NULL),
(833, 'error_bodies_ARRAY_AU09', 'arrays', 'error_bodies_ARRAY_AU09', 'script', NULL),
(834, 'lblDeleteAvatar', 'backend', 'Label / Delete Avatar', 'script', NULL),
(835, 'lblDeleteAvatarDesc', 'backend', 'Label / Delete Avatar', 'script', NULL),
(836, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(837, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(838, 'menuQuestions', 'backend', 'Menu / Questions', 'script', NULL),
(839, 'menuReplies', 'backend', 'Menu / Replies', 'script', NULL),
(840, 'statuses_ARRAY_New', 'arrays', 'statuses_ARRAY_New', 'script', NULL),
(841, 'statuses_ARRAY_Approved', 'arrays', 'statuses_ARRAY_Approved', 'script', NULL),
(842, 'statuses_ARRAY_Banned', 'arrays', 'statuses_ARRAY_Banned', 'script', NULL),
(843, 'infoQuestionsTitle', 'backend', 'Infobox / List of questions', 'script', NULL),
(844, 'infoQuestionsDesc', 'backend', 'Infobox / List of questions', 'script', NULL),
(845, 'btnAddQuestion', 'backend', 'Button / + Add question', 'script', NULL),
(846, 'lblQuestion', 'backend', 'Label / Question', 'script', NULL),
(847, 'infoAddQuestionTitle', 'backend', 'Infobox / Add question', 'script', NULL),
(848, 'infoAddQuestionDesc', 'backend', 'Infobox / Add question', 'script', NULL),
(849, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(850, 'infoUpdateQuestionTitle', 'backend', 'Infobox / Update question', 'script', NULL),
(851, 'infoUpdateQuestionDesc', 'backend', 'Infobox / Update question', 'script', NULL),
(852, 'lblViews', 'backend', 'Label / Views', 'script', NULL),
(853, 'lblReplies', 'backend', 'Label / Replies', 'script', NULL),
(854, 'error_titles_ARRAY_AQ01', 'arrays', 'error_titles_ARRAY_AQ01', 'script', NULL),
(855, 'error_bodies_ARRAY_AQ01', 'arrays', 'error_bodies_ARRAY_AQ01', 'script', NULL),
(856, 'error_titles_ARRAY_AQ03', 'arrays', 'error_titles_ARRAY_AQ03', 'script', NULL),
(857, 'error_bodies_ARRAY_AQ03', 'arrays', 'error_bodies_ARRAY_AQ03', 'script', NULL),
(858, 'error_titles_ARRAY_AQ04', 'arrays', 'error_titles_ARRAY_AQ04', 'script', NULL),
(859, 'error_bodies_ARRAY_AQ04', 'arrays', 'error_bodies_ARRAY_AQ04', 'script', NULL),
(860, 'error_titles_ARRAY_AQ08', 'arrays', 'error_titles_ARRAY_AQ08', 'script', NULL),
(861, 'error_bodies_ARRAY_AQ08', 'arrays', 'error_bodies_ARRAY_AQ08', 'script', NULL),
(862, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(863, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(864, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(865, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(866, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(867, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(868, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(869, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(870, 'infoRepliesTitle', 'backend', 'Infobox / List of replies', 'script', NULL),
(871, 'infoRepliesDesc', 'backend', 'Infobox / List of replies', 'script', NULL),
(872, 'btnAddReply', 'backend', 'Button / + Add reply', 'script', NULL),
(873, 'lblReply', 'backend', 'Label / Reply', 'script', NULL),
(874, 'infoAddReplyTitle', 'backend', 'Label / Add reply', 'script', NULL),
(875, 'infoAddReplyDesc', 'backend', 'Label / Add reply', 'script', NULL),
(876, 'lblReport', 'backend', 'Label / Report', 'script', NULL),
(877, 'lblDateTime', 'backend', 'Label / Date & time', 'script', NULL),
(878, 'lblPostedBy', 'backend', 'Label / Posted by', 'script', NULL),
(879, 'lblExistingUser', 'backend', 'Label / Existing user', 'script', NULL),
(880, 'lblUnregisteredUser', 'backend', 'Label / Unregistered user', 'script', NULL),
(881, 'lblUser', 'backend', 'Label / User', 'script', NULL),
(882, 'infoUpdateReplyTitle', 'backend', 'Label / Update reply', 'script', NULL),
(883, 'infoUpdateReplyDesc', 'backend', 'Label / Update reply', 'script', NULL),
(884, 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(885, 'front_menu_home', 'frontend', 'Label / Home', 'script', NULL),
(886, 'front_menu_categories', 'frontend', 'Label / Categories', 'script', NULL),
(887, 'front_menu_new_question', 'frontend', 'Label / + New Question', 'script', NULL),
(888, 'front_menu_my_account', 'frontend', 'Label / My Account', 'script', NULL),
(889, 'front_btn_find', 'frontend', 'Button / Find', 'script', NULL),
(890, 'front_search', 'frontend', 'Label / Search', 'script', NULL),
(891, 'front_menu_create_an_account', 'frontend', 'Label / Create an Account', 'script', NULL),
(892, 'front_menu_login', 'frontend', 'Label / Login', 'script', NULL),
(893, 'front_menu_logout', 'frontend', 'Label / Logout', 'script', NULL),
(894, 'front_field_required', 'frontend', 'Label / This field is required.', 'script', NULL),
(895, 'front_email_invalid', 'frontend', 'Label / Email is invalid.', 'script', NULL),
(896, 'front_email_address', 'frontend', 'Label / Email address', 'script', NULL),
(897, 'front_full_name', 'frontend', 'Label / Full name', 'script', NULL),
(898, 'front_password', 'frontend', 'Label / Password', 'script', NULL),
(899, 'front_reenter_password', 'frontend', 'Label / Re-enter password', 'script', NULL),
(900, 'front_password_not_match', 'frontend', 'Label / Password does not match.', 'script', NULL),
(901, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(902, 'front_avatar', 'frontend', 'Label / Avatar', 'script', NULL),
(903, 'front_add_file', 'frontend', 'Label / + add file', 'script', NULL),
(904, 'front_reset_image', 'frontend', 'Label / Reset image', 'script', NULL),
(905, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(906, 'front_captcha_incorrect', 'frontend', 'Label / Captcha is incorrect.', 'script', NULL),
(907, 'front_btn_register', 'frontend', 'Button / Register', 'script', NULL),
(908, 'front_if_had_account', 'frontend', 'Label / If you already had an account', 'script', NULL),
(909, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(910, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(911, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(912, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(913, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(914, 'front_file_extensions', 'frontend', 'Label / Files with extentions jpg|jpeg|png|gif|bmp are allowed. ', 'script', NULL),
(915, 'front_err_ARRAY_REG01', 'arrays', 'front_err_ARRAY_REG01', 'script', NULL),
(916, 'front_err_ARRAY_REG02', 'arrays', 'front_err_ARRAY_REG02', 'script', NULL),
(917, 'front_err_ARRAY_REG03', 'arrays', 'front_err_ARRAY_REG03', 'script', NULL),
(918, 'front_err_ARRAY_REG04', 'arrays', 'front_err_ARRAY_REG04', 'script', NULL),
(919, 'front_err_ARRAY_REG05', 'arrays', 'front_err_ARRAY_REG05', 'script', NULL),
(920, 'front_err_ARRAY_REG06', 'arrays', 'front_err_ARRAY_REG06', 'script', NULL),
(921, 'front_err_ARRAY_REG07', 'arrays', 'front_err_ARRAY_REG07', 'script', NULL),
(922, 'front_err_ARRAY_REG08', 'arrays', 'front_err_ARRAY_REG08', 'script', NULL),
(923, 'front_err_ARRAY_REG09', 'arrays', 'front_err_ARRAY_REG09', 'script', NULL),
(924, 'front_err_ARRAY_REG10', 'arrays', 'front_err_ARRAY_REG10', 'script', NULL),
(925, 'front_err_ARRAY_REG11', 'arrays', 'front_err_ARRAY_REG11', 'script', NULL),
(926, 'front_err_ARRAY_REG12', 'arrays', 'front_err_ARRAY_REG12', 'script', NULL),
(927, 'front_err_ARRAY_REG13', 'arrays', 'front_err_ARRAY_REG13', 'script', NULL),
(928, 'front_err_ARRAY_REG14', 'arrays', 'front_err_ARRAY_REG14', 'script', NULL),
(929, 'front_err_ARRAY_REG15', 'arrays', 'front_err_ARRAY_REG15', 'script', NULL),
(930, 'front_err_ARRAY_REG16', 'arrays', 'front_err_ARRAY_REG16', 'script', NULL),
(931, 'front_err_ARRAY_REG17', 'arrays', 'front_err_ARRAY_REG17', 'script', NULL),
(932, 'front_msg_ARRAY_REG01', 'arrays', 'front_msg_ARRAY_REG01', 'script', NULL),
(933, 'front_msg_ARRAY_REG02', 'arrays', 'front_msg_ARRAY_REG02', 'script', NULL),
(934, 'front_msg_ARRAY_REG03', 'arrays', 'front_msg_ARRAY_REG03', 'script', NULL),
(935, 'front_website', 'frontend', 'Label / Website', 'script', NULL),
(936, 'front_choose', 'frontend', 'Label / Choose', 'script', NULL),
(937, 'front_login_to_your_account', 'frontend', 'Label / Login to your account', 'script', NULL),
(938, 'front_btn_login', 'frontend', 'Button  / Login', 'script', NULL),
(939, 'front_forgot_password', 'frontend', 'Label / Forgot password?', 'script', NULL),
(940, 'front_err_ARRAY_LOG01', 'arrays', 'front_err_ARRAY_LOG01', 'script', NULL),
(941, 'front_err_ARRAY_LOG02', 'arrays', 'front_err_ARRAY_LOG02', 'script', NULL),
(942, 'front_err_ARRAY_LOG03', 'arrays', 'front_err_ARRAY_LOG03', 'script', NULL),
(943, 'front_err_ARRAY_LOG04', 'arrays', 'front_err_ARRAY_LOG04', 'script', NULL),
(944, 'front_err_ARRAY_LOG05', 'arrays', 'front_err_ARRAY_LOG05', 'script', NULL),
(945, 'front_err_ARRAY_LOG06', 'arrays', 'front_err_ARRAY_LOG06', 'script', NULL),
(946, 'front_err_ARRAY_LOG07', 'arrays', 'front_err_ARRAY_LOG07', 'script', NULL),
(947, 'front_btn_send', 'frontend', 'Button / Send', 'script', NULL),
(948, 'front_err_ARRAY_FOR01', 'arrays', 'front_err_ARRAY_FOR01', 'script', NULL),
(949, 'front_err_ARRAY_FOR02', 'arrays', 'front_err_ARRAY_FOR02', 'script', NULL),
(950, 'front_err_ARRAY_FOR03', 'arrays', 'front_err_ARRAY_FOR03', 'script', NULL),
(951, 'front_err_ARRAY_FOR05', 'arrays', 'front_err_ARRAY_FOR05', 'script', NULL),
(952, 'front_err_ARRAY_FOR04', 'arrays', 'front_err_ARRAY_FOR04', 'script', NULL),
(953, 'front_msg_ARRAY_FOR01', 'arrays', 'front_msg_ARRAY_FOR01', 'script', NULL),
(954, 'front_change', 'frontend', 'Label / Change', 'script', NULL),
(955, 'front_btn_save', 'frontend', 'Button / Save', 'script', NULL),
(956, 'front_msg_ARRAY_PRO01', 'arrays', 'front_msg_ARRAY_PRO01', 'script', NULL),
(957, 'front_err_ARRAY_PRO01', 'arrays', 'front_err_ARRAY_PRO01', 'script', NULL),
(958, 'front_err_ARRAY_PRO02', 'arrays', 'front_err_ARRAY_PRO02', 'script', NULL),
(959, 'front_err_ARRAY_PRO03', 'arrays', 'front_err_ARRAY_PRO03', 'script', NULL),
(960, 'front_ask_question', 'frontend', 'Label / Ask a Question', 'script', NULL),
(961, 'front_login_to_ask', 'frontend', 'Label / You need to login to ask a question.', 'script', NULL),
(962, 'front_question', 'frontend', 'Label / Question', 'script', NULL),
(963, 'front_description', 'frontend', 'Label / Description', 'script', NULL),
(964, 'front_category', 'frontend', 'Label / Category', 'script', NULL),
(965, 'front_err_ARRAY_ASK01', 'arrays', 'front_err_ARRAY_ASK01', 'script', NULL),
(966, 'front_err_ARRAY_ASK02', 'arrays', 'front_err_ARRAY_ASK02', 'script', NULL),
(967, 'front_err_ARRAY_ASK03', 'arrays', 'front_err_ARRAY_ASK03', 'script', NULL),
(968, 'front_err_ARRAY_ASK04', 'arrays', 'front_err_ARRAY_ASK04', 'script', NULL),
(969, 'front_err_ARRAY_ASK05', 'arrays', 'front_err_ARRAY_ASK05', 'script', NULL),
(970, 'front_err_ARRAY_ASK06', 'arrays', 'front_err_ARRAY_ASK06', 'script', NULL),
(971, 'front_err_ARRAY_ASK07', 'arrays', 'front_err_ARRAY_ASK07', 'script', NULL),
(972, 'front_msg_ARRAY_ASK01', 'arrays', 'front_msg_ARRAY_ASK01', 'script', NULL),
(973, 'front_questions', 'frontend', 'Label / Questions', 'script', NULL),
(974, 'front_no_categories_found', 'frontend', 'Label / No categories found.', 'script', NULL),
(975, 'front_ago', 'frontend', 'Label / ago', 'script', NULL),
(976, 'front_minutes', 'frontend', 'Label / minutes', 'script', NULL),
(977, 'front_hours', 'frontend', 'Label / hours', 'script', NULL),
(978, 'front_days', 'frontend', 'Label / days', 'script', NULL),
(979, 'front_posted_by', 'frontend', 'Label / Posted by', 'script', NULL),
(980, 'front_activity', 'frontend', 'Label / Activity', 'script', NULL),
(981, 'front_replies', 'frontend', 'Label / Replies', 'script', NULL),
(982, 'front_no_questions_found', 'frontend', 'Label / No questions found.', 'script', NULL),
(983, 'front_by', 'frontend', 'Label / by', 'script', NULL),
(984, 'front_err_ARRAY_VIE01', 'arrays', 'front_err_ARRAY_VIE01', 'script', NULL),
(985, 'front_menu_back', 'frontend', 'Menu / Back', 'script', NULL),
(986, 'front_reply', 'frontend', 'Label / Reply', 'script', NULL),
(1105, 'front_post_a_reply', 'frontend', 'Label / Post a Reply', 'script', NULL),
(1106, 'front_your_name', 'frontend', 'Label / Your name', 'script', NULL),
(1107, 'front_your_reply', 'frontend', 'Label / Your reply', 'script', NULL),
(1108, 'front_btn_submit', 'frontend', 'Button / Submit', 'script', NULL),
(1109, 'front_err_ARRAY_REP01', 'arrays', 'front_err_ARRAY_REP01', 'script', NULL),
(1110, 'front_err_ARRAY_REP02', 'arrays', 'front_err_ARRAY_REP02', 'script', NULL),
(1111, 'front_msg_ARRAY_REP01', 'arrays', 'front_msg_ARRAY_REP01', 'script', NULL),
(1112, 'front_report_message', 'frontend', 'Label / Reprot reply description', 'script', NULL),
(1113, 'front_btn_cancel', 'frontend', 'Button / Cancel', 'script', NULL),
(1114, 'front_btn_report', 'frontend', 'Button / Report', 'script', NULL),
(1115, 'front_ip_blocked', 'frontend', 'Label / We are sorry that your IP address was blocked.', 'script', NULL),
(1116, 'lblInstallPhp1_2a', 'frontend', 'Install / Step 2a', 'script', NULL),
(1117, 'lblQuestions', 'backend', 'Label / Questions', 'script', NULL),
(1118, 'lblLastReply', 'backend', 'Label / Last reply', 'script', NULL),
(1119, 'front_minute', 'frontend', 'Label / minute', 'script', NULL),
(1120, 'lblDashQuestion', 'frontend', 'Dash / question', 'script', NULL),
(1121, 'lblDashQuestions', 'frontend', 'Dash / questions', 'script', NULL),
(1122, 'lblDashReply', 'frontend', 'Dash / reply', 'script', NULL),
(1123, 'lblDashReplies', 'frontend', 'Dash / replies', 'script', NULL),
(1124, 'lblDashUser', 'frontend', 'Dash / user', 'script', NULL),
(1125, 'lblDashUsers', 'frontend', 'Dash / users', 'script', NULL),
(1126, 'lblDashLatestQuestions', 'frontend', 'Dash / Latest questions', 'script', NULL),
(1127, 'lblDashLatestReplies', 'frontend', 'Dash / Latest replies', 'script', NULL),
(1128, 'lblDashLatestUsers', 'frontend', 'Dash / Latest users', 'script', NULL),
(1129, 'lblDashNoQuestionsFound', 'frontend', 'Dash / No questions found', 'script', NULL),
(1130, 'lblDashNoRepliesFound', 'frontend', 'Dash / No replies found', 'script', NULL),
(1131, 'lblDashNoUsersFound', 'frontend', 'Dash / No users found', 'script', NULL),
(1132, 'front_day', 'frontend', 'Label / day', 'script', NULL),
(1133, 'front_hour', 'frontend', 'Label / hour', 'script', NULL),
(1134, 'lblFontColor', 'backend', 'Label / Font color', 'script', NULL),
(1135, 'lblBackgroundColor', 'backend', 'Label / Background color', 'script', NULL),
(1136, 'lblRate', 'backend', 'Label / Rate', 'script', NULL),
(1137, 'lblReported', 'backend', 'Label / Reported', 'script', NULL),
(1138, 'lblReportEmail', 'backend', 'Label / Report notification email', 'script', NULL),
(1139, 'lblReplyReportTokens', 'backend', 'Label / Tokens', 'script', NULL),
(1140, 'opt_o_listing_page', 'backend', 'Options /  Enter web address for the web page where the forum is put', 'script', NULL),
(1141, 'tabInstallForum', 'backend', 'Tab / Forum', 'script', NULL),
(1142, 'tabInstallSEO', 'backend', 'Tab / SEO', 'script', NULL),
(1143, 'infoInstallSEODESC', 'backend', 'Infobox / Install SEO', 'script', NULL),
(1144, 'opt_o_seo_url', 'backend', 'Options /  Use SEO Friendly URLs', 'script', NULL),
(1145, 'lblInstallPhpHtaccess', 'backend', 'Label / Install htaccess', 'script', NULL),
(1146, 'lblInstallPhpHtaccess2', 'backend', 'Label / Install htaccess 2', 'script', NULL),
(1147, 'lblQuestionReply', 'backend', 'Label / Q / R', 'script', NULL),
(1148, 'opt_o_rf_include_name', 'backend', 'Options / Full name', 'script', NULL),
(1149, 'opt_o_rf_include_email', 'backend', 'Options / Email', 'script', NULL),
(1150, 'opt_o_rf_include_password', 'backend', 'Options / Password', 'script', NULL),
(1151, 'opt_o_rf_include_website', 'backend', 'Options / Website', 'script', NULL),
(1152, 'opt_o_rf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(1153, 'opt_o_rf_include_address', 'backend', 'Options / Address', 'script', NULL),
(1154, 'opt_o_rf_include_country', 'backend', 'Options / Country', 'script', NULL),
(1155, 'opt_o_rf_include_state', 'backend', 'Options / State', 'script', NULL),
(1156, 'opt_o_rf_include_city', 'backend', 'Options / City', 'script', NULL),
(1157, 'opt_o_rf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(1158, 'enum_arr_ARRAY_1', 'arrays', 'enum_arr_ARRAY_1', 'script', NULL),
(1159, 'enum_arr_ARRAY_2', 'arrays', 'enum_arr_ARRAY_2', 'script', NULL),
(1160, 'enum_arr_ARRAY_3', 'arrays', 'enum_arr_ARRAY_3', 'script', NULL),
(1161, 'menuRegistrationForm', 'backend', 'Menu / Registration form', 'script', NULL),
(1162, 'infoRegistrationFormTitle', 'backend', 'Infobox / Registration form', 'script', NULL),
(1163, 'infoRegistrationFormDesc', 'backend', 'Infobox / Registration form', 'script', NULL),
(1164, 'opt_o_rf_include_avatar', 'backend', 'Options / Avatar', 'script', NULL),
(1165, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(1166, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(1167, 'lblResetVotes', 'backend', 'Label / Reset votes', 'script', NULL),
(1168, 'lblDeleteAllVotes', 'backend', 'Label / Delete all votes?', 'script', NULL),
(1169, 'buttons_ARRAY_ok', 'arrays', 'buttons_ARRAY_ok', 'script', NULL),
(1170, 'front_err_ARRAY_VIE02', 'arrays', 'front_err_ARRAY_VIE02', 'script', NULL),
(1171, 'lblNoCategoriesMessage', 'backend', 'Label / No categories found.', 'script', NULL),
(1172, 'front_msg_ARRAY_ASK02', 'arrays', 'front_msg_ARRAY_ASK02', 'script', NULL),
(1173, 'confirm_err_ARRAY_1', 'arrays', 'confirm_err_ARRAY_1', 'script', NULL),
(1174, 'confirm_err_ARRAY_2', 'arrays', 'confirm_err_ARRAY_2', 'script', NULL),
(1175, 'confirm_err_ARRAY_3', 'arrays', 'confirm_err_ARRAY_3', 'script', NULL),
(1176, 'confirm_err_ARRAY_4', 'arrays', 'confirm_err_ARRAY_4', 'script', NULL),
(1177, 'confirm_err_ARRAY_200', 'arrays', 'confirm_err_ARRAY_200', 'script', NULL),
(1178, 'front_btn_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(1179, 'question_err_ARRAY_1', 'arrays', 'question_err_ARRAY_1', 'script', NULL),
(1180, 'question_err_ARRAY_2', 'arrays', 'question_err_ARRAY_2', 'script', NULL),
(1181, 'question_err_ARRAY_3', 'arrays', 'question_err_ARRAY_3', 'script', NULL),
(1182, 'question_err_ARRAY_4', 'arrays', 'question_err_ARRAY_4', 'script', NULL),
(1183, 'question_err_ARRAY_200', 'arrays', 'question_err_ARRAY_200', 'script', NULL),
(1184, 'front_btn_approve', 'frontend', 'Button / Approve', 'script', NULL),
(1185, 'reply_err_ARRAY_1', 'arrays', 'reply_err_ARRAY_1', 'script', NULL),
(1186, 'reply_err_ARRAY_2', 'arrays', 'reply_err_ARRAY_2', 'script', NULL),
(1187, 'reply_err_ARRAY_3', 'arrays', 'reply_err_ARRAY_3', 'script', NULL),
(1188, 'reply_err_ARRAY_4', 'arrays', 'reply_err_ARRAY_4', 'script', NULL),
(1189, 'reply_err_ARRAY_200', 'arrays', 'reply_err_ARRAY_200', 'script', NULL),
(1190, 'front_msg_ARRAY_REP02', 'arrays', 'front_msg_ARRAY_REP02', 'script', NULL),
(1191, 'front_just_now', 'frontend', 'Label / Just', 'script', NULL);

INSERT INTO `stivaforum_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next ', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '&laquo;', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Below you can see users who have access to the forum script. There are three types of users Administrators, Editors, and Users. Users can only login the front end and post questions and replies.', 'script'),
(NULL, 482, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Add User', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'You can add administrator user who has full access to administration page or add an editor user who will only be able to access categories, questions, replies and will not be able to modify options, other users.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Update User', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Change user details using the form below and click on SAVE button to save changes.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Here you can set the General options for the Stiva Forum.', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'General Options', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Set general settings for the forum script.', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Email confirmation', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Everyone', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Registered users only', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Yes, email confirmation', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Logged in users', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Disabled', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Last on top', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'First on top', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Unregistered users', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Cookie', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'IP protection', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Use categories', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Use registration', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Account confirmation', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'New questions', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'New replies', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Approve questions', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Approve replies', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Number of questions per page', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Number of replies per page', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Rating', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Reporting', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Reply order', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Use captcha', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Prevent multiple ratings', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Please enter the list of IP addresses which will be blocked and cannot access the forum. Each IP will be on one line.', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Select "Yes" if you want to display categories on the front end, otherwise select "No"', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Select "Yes" if you want user registration and login page to be displayed on the front end, otherwise select "No"', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Select "Email confirmation" if you want an email with a confirmation link to be sent to the user when new account is created. Select "Administrator" if you want each new account to be unconfirmed until the administrator edits and confirms it. Select "No" if you want all accounts to be automatically confirmed.', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Select "Registered users only" if you want only users who have accounts to post questions, otherwise select "Everyone"', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Select "Registered users only" if you want only users who have accounts to post their replies, otherwise select "Everyone"', 'script'),
(NULL, 631, 'pjField', 1, 'title', '"Yes, email notification" - an email message with link for approval will be sent to administrator, "Yes" - question will not be approved and no email will be sent to administrator, "No" - question will be posted without approval.', 'script'),
(NULL, 632, 'pjField', 1, 'title', '"Yes, email notification" - an email message with link for approval will be sent to administrator, "Yes" - reply will not be approved and no email will be sent to administrator, "No" - reply will be posted without approval.', 'script'),
(NULL, 633, 'pjField', 1, 'title', '"Logged in users" - only users with accounts will be able to rate the replies, "Everyone" - everyone will be able to rate the replies, "Disable" - rating feature will be disabled', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'Select "Yes" if you want to allow reporting a reply, otherwise select "No" 	', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'Select "First on top" if you want to want to display the latest replies on the top, otherwise select "Last on top"', 'script'),
(NULL, 636, 'pjField', 1, 'title', '"Unregistered users" - only unregistered users will be forced to use captcha verification. "Yes" - everyone will be forced to use captcha. "No" - captcha will not be used.', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'You can either use cookies or IP protection to prevent multiple voting on replies.', 'script'),
(NULL, 638, 'pjField', 1, 'title', '<u>Available Tokens</u>:\r\n{FullName}\r\n{Email}\r\n{Password}\r\n{Country}\r\n{Website}\r\n{Phone}\r\n{Status}\r\n{ConfirmURL}', 'script'),
(NULL, 639, 'pjField', 1, 'title', '<u>Available Tokens</u>:\r\n{FullName}\r\n{Email}\r\n{Password}', 'script'),
(NULL, 640, 'pjField', 1, 'title', '<u>Available Tokens</u>:\r\n{ReplyApprovalURL}\r\n{ReplyViewURL}', 'script'),
(NULL, 641, 'pjField', 1, 'title', '<u>Available Tokens</u>:\r\n{QuestionApprovalURL}\r\n{QuestionViewURL}', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Spam Protection', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Set different spam protection options below.', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Spam Protection', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'To users', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'To administrators', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Notifications sent to users', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Set an auto responder message which will be sent to the users once a new registration is made or password recovery is requested. You can use the available tokens to personalize the messages.', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Registration email', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Password recovery email', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Registration notification', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Question approval email', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Reply approval email', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Notifications sent to administrators', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Send an email notifications to the administrator. You can use the available tokens to personalize the messages.', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Anti spam settings updated!', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'All the changes made to anti spam settings have been saved.', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'All the changes made to notifications have been saved.', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Follow these steps to put stiva forum on your .php web page using PHP include code:', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Step 2. Copy and paste the code below into your html code, where the forum will be displayed.', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Front-end', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'Choose theme', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 802, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 803, 'pjField', 1, 'title', 'Question Categories', 'script'),
(NULL, 804, 'pjField', 1, 'title', 'You can create different categories and people will post their questions to specific category. This will help you organize your forum.', 'script'),
(NULL, 805, 'pjField', 1, 'title', '+ Add category', 'script'),
(NULL, 806, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 807, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 808, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 809, 'pjField', 1, 'title', 'Add Category', 'script'),
(NULL, 810, 'pjField', 1, 'title', 'Add category details below and click Save button to add new category.', 'script'),
(NULL, 811, 'pjField', 1, 'title', 'Update Category', 'script'),
(NULL, 812, 'pjField', 1, 'title', 'Change category details and click SAVE button at the bottom to save changes.', 'script'),
(NULL, 813, 'pjField', 1, 'title', 'Category updated!', 'script'),
(NULL, 814, 'pjField', 1, 'title', 'Changes made on the category have been saved.', 'script'),
(NULL, 815, 'pjField', 1, 'title', 'Category added!', 'script'),
(NULL, 816, 'pjField', 1, 'title', 'Category has been added into the system.', 'script'),
(NULL, 817, 'pjField', 1, 'title', 'Category not added!', 'script'),
(NULL, 818, 'pjField', 1, 'title', 'Category has not been added. Please try again.', 'script'),
(NULL, 819, 'pjField', 1, 'title', 'Category not found!', 'script'),
(NULL, 820, 'pjField', 1, 'title', 'Category you are looking for is missing. Please try again.', 'script'),
(NULL, 821, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 822, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 823, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 824, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 825, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 826, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 827, 'pjField', 1, 'title', 'Avatar', 'script'),
(NULL, 828, 'pjField', 1, 'title', 'User not added!', 'script'),
(NULL, 829, 'pjField', 1, 'title', 'User could not be added because the post content is greater than {MAXSIZE}.', 'script'),
(NULL, 830, 'pjField', 1, 'title', 'Avatar not uploaded!', 'script'),
(NULL, 831, 'pjField', 1, 'title', 'User information has been saved, but the avatar could not be uploaded because the image size is greater than {POSTSIZE}.', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'User not updated!', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'User could not be updated because the post content is greater than {MAXSIZE}.', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'Delete avatar', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'Are you sure that you want to delete the avatar?', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 837, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 838, 'pjField', 1, 'title', 'Questions', 'script'),
(NULL, 839, 'pjField', 1, 'title', 'Replies', 'script'),
(NULL, 840, 'pjField', 1, 'title', 'New', 'script'),
(NULL, 841, 'pjField', 1, 'title', 'Approved', 'script'),
(NULL, 842, 'pjField', 1, 'title', 'Banned', 'script'),
(NULL, 843, 'pjField', 1, 'title', 'Forum Questions', 'script'),
(NULL, 844, 'pjField', 1, 'title', 'Below you can see all questions posted. You can add new question, edit or delete existing questions. Click on replies count for each question to see a list with replies to the question.', 'script'),
(NULL, 845, 'pjField', 1, 'title', '+ Add question', 'script'),
(NULL, 846, 'pjField', 1, 'title', 'Question', 'script'),
(NULL, 847, 'pjField', 1, 'title', 'Add Question', 'script'),
(NULL, 848, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new question.', 'script'),
(NULL, 849, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 850, 'pjField', 1, 'title', 'Update Question', 'script'),
(NULL, 851, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update the question.', 'script'),
(NULL, 852, 'pjField', 1, 'title', 'Views', 'script'),
(NULL, 853, 'pjField', 1, 'title', 'Replies', 'script'),
(NULL, 854, 'pjField', 1, 'title', 'Question updated!', 'script'),
(NULL, 855, 'pjField', 1, 'title', 'Changes made have been saved.', 'script'),
(NULL, 856, 'pjField', 1, 'title', 'Question added!', 'script'),
(NULL, 857, 'pjField', 1, 'title', 'Question has been added into the system.', 'script'),
(NULL, 858, 'pjField', 1, 'title', 'Question not added!', 'script'),
(NULL, 859, 'pjField', 1, 'title', 'Question could not be added. Please try again.', 'script'),
(NULL, 860, 'pjField', 1, 'title', 'Question not found!', 'script'),
(NULL, 861, 'pjField', 1, 'title', 'Question you are looking for is missing.', 'script'),
(NULL, 862, 'pjField', 1, 'title', 'Reply updated!', 'script'),
(NULL, 863, 'pjField', 1, 'title', 'All changes made on the reply have been saved.', 'script'),
(NULL, 864, 'pjField', 1, 'title', 'Reply added!', 'script'),
(NULL, 865, 'pjField', 1, 'title', 'Reply has been added into the system.', 'script'),
(NULL, 866, 'pjField', 1, 'title', 'Reply not added!', 'script'),
(NULL, 867, 'pjField', 1, 'title', 'Reply could not be added correctly. Please try again.', 'script'),
(NULL, 868, 'pjField', 1, 'title', 'Reply not found!', 'script'),
(NULL, 869, 'pjField', 1, 'title', 'Reply you are looking for is missing.', 'script'),
(NULL, 870, 'pjField', 1, 'title', 'Replies', 'script'),
(NULL, 871, 'pjField', 1, 'title', 'See a list with all replies. If you want to add new reply, click on the button "+ Add reply". You can also edit/delete any of the replies.', 'script'),
(NULL, 872, 'pjField', 1, 'title', '+ Add reply', 'script'),
(NULL, 873, 'pjField', 1, 'title', 'Reply', 'script'),
(NULL, 874, 'pjField', 1, 'title', 'Add Reply', 'script'),
(NULL, 875, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new reply.', 'script'),
(NULL, 876, 'pjField', 1, 'title', 'Report', 'script'),
(NULL, 877, 'pjField', 1, 'title', 'Date & time', 'script'),
(NULL, 878, 'pjField', 1, 'title', 'Posted by', 'script'),
(NULL, 879, 'pjField', 1, 'title', 'Existing user', 'script'),
(NULL, 880, 'pjField', 1, 'title', 'Unregistered user', 'script'),
(NULL, 881, 'pjField', 1, 'title', 'User', 'script'),
(NULL, 882, 'pjField', 1, 'title', 'Update Reply', 'script'),
(NULL, 883, 'pjField', 1, 'title', 'Make changes to the reply using the form below and click "Save" button.', 'script'),
(NULL, 884, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 885, 'pjField', 1, 'title', 'Home', 'script'),
(NULL, 886, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 887, 'pjField', 1, 'title', '+ New Question', 'script'),
(NULL, 888, 'pjField', 1, 'title', 'My Account', 'script'),
(NULL, 889, 'pjField', 1, 'title', 'Find', 'script'),
(NULL, 890, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 891, 'pjField', 1, 'title', 'Create an Account', 'script'),
(NULL, 892, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 893, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 894, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 895, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 896, 'pjField', 1, 'title', 'Email address', 'script'),
(NULL, 897, 'pjField', 1, 'title', 'Full name', 'script'),
(NULL, 898, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 899, 'pjField', 1, 'title', 'Re-enter password', 'script'),
(NULL, 900, 'pjField', 1, 'title', 'Password does not match.', 'script'),
(NULL, 901, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 902, 'pjField', 1, 'title', 'Avatar', 'script'),
(NULL, 903, 'pjField', 1, 'title', '+ add file', 'script'),
(NULL, 904, 'pjField', 1, 'title', 'Reset image', 'script'),
(NULL, 905, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 906, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 907, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 908, 'pjField', 1, 'title', 'If you already had an account', 'script'),
(NULL, 909, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 910, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 911, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 912, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 913, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 914, 'pjField', 1, 'title', 'Files with extensions jpg|jpeg|png|gif are allowed. ', 'script'),
(NULL, 915, 'pjField', 1, 'title', 'Full name is missing.', 'script'),
(NULL, 916, 'pjField', 1, 'title', 'Full name cannot be empty.', 'script'),
(NULL, 917, 'pjField', 1, 'title', 'Email address is missing.', 'script'),
(NULL, 918, 'pjField', 1, 'title', 'Email address cannot be empty.', 'script'),
(NULL, 919, 'pjField', 1, 'title', 'Email address is invalid.', 'script'),
(NULL, 920, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 921, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 922, 'pjField', 1, 'title', 'Re-enter password is missing.', 'script'),
(NULL, 923, 'pjField', 1, 'title', 'Re-enter password cannot be empty.', 'script'),
(NULL, 924, 'pjField', 1, 'title', 'Password does not match.', 'script'),
(NULL, 925, 'pjField', 1, 'title', 'Captcha is missing.', 'script'),
(NULL, 926, 'pjField', 1, 'title', 'Captcha cannot be empty.', 'script'),
(NULL, 927, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 928, 'pjField', 1, 'title', 'Your account could not be created because the post content size is greater than {MAXSIZE}.', 'script'),
(NULL, 929, 'pjField', 1, 'title', 'Your account could not be created.', 'script'),
(NULL, 930, 'pjField', 1, 'title', 'Avatar could not be uploaded, only files with extensions jpg|png|gif|jpeg are allowed.', 'script'),
(NULL, 931, 'pjField', 1, 'title', 'Avatar could not be uploaded because the file size is greater than {POSTSIZE}.', 'script'),
(NULL, 932, 'pjField', 1, 'title', 'Your account has been created and you can login now.', 'script'),
(NULL, 933, 'pjField', 1, 'title', 'Your account has been created, but you need to wait for approval by the administrator.', 'script'),
(NULL, 934, 'pjField', 1, 'title', 'Your account has been created, and please check your mail box to activate your account.', 'script'),
(NULL, 935, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 936, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 937, 'pjField', 1, 'title', 'Login to your account', 'script'),
(NULL, 938, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 939, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 940, 'pjField', 1, 'title', 'Email address is missing.', 'script'),
(NULL, 941, 'pjField', 1, 'title', 'Email address cannot be empty.', 'script'),
(NULL, 942, 'pjField', 1, 'title', 'Email address is invalid.', 'script'),
(NULL, 943, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 944, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 945, 'pjField', 1, 'title', 'Account with such email does not exist.', 'script'),
(NULL, 946, 'pjField', 1, 'title', 'Your account is not active yet.', 'script'),
(NULL, 947, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 948, 'pjField', 1, 'title', 'Email address is missing.', 'script'),
(NULL, 949, 'pjField', 1, 'title', 'Email address cannot be empty.', 'script'),
(NULL, 950, 'pjField', 1, 'title', 'Email address is invalid.', 'script'),
(NULL, 951, 'pjField', 1, 'title', 'Account with such email does not exist.', 'script'),
(NULL, 952, 'pjField', 1, 'title', 'Your account is not active yet.', 'script'),
(NULL, 953, 'pjField', 1, 'title', 'Password has been sent to your email.', 'script'),
(NULL, 954, 'pjField', 1, 'title', 'Change', 'script'),
(NULL, 955, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 956, 'pjField', 1, 'title', 'Your account has been saved.', 'script'),
(NULL, 957, 'pjField', 1, 'title', 'Your account could not be saved because the post content size is greater than {MAXSIZE}.', 'script'),
(NULL, 958, 'pjField', 1, 'title', 'Your account has been saved, but the avatar could not be uploaded because file extension is allowed. Only files with jpg|jpeg|png|gif are allowed.', 'script'),
(NULL, 959, 'pjField', 1, 'title', 'Your account has been saved, but the avatar could not be uploaded because file size is greater than {POSTSIZE}.', 'script'),
(NULL, 960, 'pjField', 1, 'title', 'Ask a Question', 'script'),
(NULL, 961, 'pjField', 1, 'title', 'You need to login to ask a question.', 'script'),
(NULL, 962, 'pjField', 1, 'title', 'Question', 'script'),
(NULL, 963, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 964, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 965, 'pjField', 1, 'title', 'Question is missing.', 'script'),
(NULL, 966, 'pjField', 1, 'title', 'Question cannot be empty.', 'script'),
(NULL, 967, 'pjField', 1, 'title', 'Description is missing.', 'script'),
(NULL, 968, 'pjField', 1, 'title', 'Description cannot be empty.', 'script'),
(NULL, 969, 'pjField', 1, 'title', 'Category is missing.', 'script'),
(NULL, 970, 'pjField', 1, 'title', 'Category cannot be empty.', 'script'),
(NULL, 971, 'pjField', 1, 'title', 'Question could not be posted successfully.', 'script'),
(NULL, 972, 'pjField', 1, 'title', 'The question has been posted successfully.', 'script'),
(NULL, 973, 'pjField', 1, 'title', 'Questions', 'script'),
(NULL, 974, 'pjField', 1, 'title', 'No categories found.', 'script'),
(NULL, 975, 'pjField', 1, 'title', 'ago', 'script'),
(NULL, 976, 'pjField', 1, 'title', 'minutes', 'script'),
(NULL, 977, 'pjField', 1, 'title', 'hours', 'script'),
(NULL, 978, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 979, 'pjField', 1, 'title', 'Posted by', 'script'),
(NULL, 980, 'pjField', 1, 'title', 'Activity', 'script'),
(NULL, 981, 'pjField', 1, 'title', 'Replies', 'script'),
(NULL, 982, 'pjField', 1, 'title', 'No questions found.', 'script'),
(NULL, 983, 'pjField', 1, 'title', 'by', 'script'),
(NULL, 984, 'pjField', 1, 'title', 'Question with such ID does not exist.', 'script'),
(NULL, 985, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 986, 'pjField', 1, 'title', 'Reply', 'script'),
(NULL, 1105, 'pjField', 1, 'title', 'Post a Reply', 'script'),
(NULL, 1106, 'pjField', 1, 'title', 'Your name', 'script'),
(NULL, 1107, 'pjField', 1, 'title', 'Your reply', 'script'),
(NULL, 1108, 'pjField', 1, 'title', 'Submit', 'script'),
(NULL, 1109, 'pjField', 1, 'title', 'Your reply is missing.', 'script'),
(NULL, 1110, 'pjField', 1, 'title', 'Your reply cannot be empty.', 'script'),
(NULL, 1111, 'pjField', 1, 'title', 'Your reply has been posted successfully.', 'script'),
(NULL, 1112, 'pjField', 1, 'title', '<p>Report this reply if it is:</p>\r\n<ul>\r\n<li>spam</li>\r\n<li>offensive</li>\r\n<li>out of topic</li>\r\n</ul>', 'script'),
(NULL, 1113, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 1114, 'pjField', 1, 'title', 'Report', 'script'),
(NULL, 1115, 'pjField', 1, 'title', 'We are sorry that your IP address was blocked.', 'script'),
(NULL, 1116, 'pjField', 1, 'title', 'Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.', 'script'),
(NULL, 1117, 'pjField', 1, 'title', 'Questions', 'script'),
(NULL, 1118, 'pjField', 1, 'title', 'Last reply', 'script'),
(NULL, 1119, 'pjField', 1, 'title', 'minute', 'script'),
(NULL, 1120, 'pjField', 1, 'title', 'question', 'script'),
(NULL, 1121, 'pjField', 1, 'title', 'questions', 'script'),
(NULL, 1122, 'pjField', 1, 'title', 'reply', 'script'),
(NULL, 1123, 'pjField', 1, 'title', 'replies', 'script'),
(NULL, 1124, 'pjField', 1, 'title', 'user', 'script'),
(NULL, 1125, 'pjField', 1, 'title', 'users', 'script'),
(NULL, 1126, 'pjField', 1, 'title', 'Latest questions', 'script'),
(NULL, 1127, 'pjField', 1, 'title', 'Latest replies', 'script'),
(NULL, 1128, 'pjField', 1, 'title', 'Latest users', 'script'),
(NULL, 1129, 'pjField', 1, 'title', 'No questions found', 'script'),
(NULL, 1130, 'pjField', 1, 'title', 'No replies found', 'script'),
(NULL, 1131, 'pjField', 1, 'title', 'No users found', 'script'),
(NULL, 1132, 'pjField', 1, 'title', 'day', 'script'),
(NULL, 1133, 'pjField', 1, 'title', 'hour', 'script'),
(NULL, 1134, 'pjField', 1, 'title', 'Font color', 'script'),
(NULL, 1135, 'pjField', 1, 'title', 'Background color', 'script'),
(NULL, 1136, 'pjField', 1, 'title', 'Rate', 'script'),
(NULL, 1137, 'pjField', 1, 'title', 'Reported', 'script'),
(NULL, 1138, 'pjField', 1, 'title', 'Report notification email', 'script'),
(NULL, 1139, 'pjField', 1, 'title', '<u>Available Tokens</u>:\r\n{ReplyViewURL}', 'script'),
(NULL, 1140, 'pjField', 1, 'title', 'Enter web address for the web page where the forum is put', 'script'),
(NULL, 1141, 'pjField', 1, 'title', 'Forum', 'script'),
(NULL, 1142, 'pjField', 1, 'title', 'SEO', 'script'),
(NULL, 1143, 'pjField', 1, 'title', 'Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your questions.', 'script'),
(NULL, 1144, 'pjField', 1, 'title', 'Use SEO Friendly URLs', 'script'),
(NULL, 1145, 'pjField', 1, 'title', 'Create a file named ".htaccess" in the same directory where your .php page with forum is. Then copy and paste the following code into the file.', 'script'),
(NULL, 1146, 'pjField', 1, 'title', '(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.', 'script'),
(NULL, 1147, 'pjField', 1, 'title', 'Q / R', 'script'),
(NULL, 1148, 'pjField', 1, 'title', 'Full name', 'script'),
(NULL, 1149, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1150, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 1151, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 1152, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1153, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1154, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1155, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1156, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1157, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 1158, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 1159, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1160, 'pjField', 1, 'title', 'Yes (required)', 'script'),
(NULL, 1161, 'pjField', 1, 'title', 'Registration Form', 'script'),
(NULL, 1162, 'pjField', 1, 'title', 'Registration form', 'script'),
(NULL, 1163, 'pjField', 1, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the registration form, otherwise select ''No''.', 'script'),
(NULL, 1164, 'pjField', 1, 'title', 'Avatar', 'script'),
(NULL, 1165, 'pjField', 1, 'title', 'Registration form options updated!', 'script'),
(NULL, 1166, 'pjField', 1, 'title', 'All changes made on registration form options have been saved.', 'script'),
(NULL, 1167, 'pjField', 1, 'title', 'Reset votes', 'script'),
(NULL, 1168, 'pjField', 1, 'title', 'Delete all votes?', 'script'),
(NULL, 1169, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 1170, 'pjField', 1, 'title', 'The question was banned.', 'script'),
(NULL, 1171, 'pjField', 1, 'title', 'No categories found. Click {STAG}here{ETAG} to add one.', 'script'),
(NULL, 1172, 'pjField', 1, 'title', 'The question has been posted successfully, but it should be approved by administrator before shown up in the forum.', 'script'),
(NULL, 1173, 'pjField', 1, 'title', 'Parameters are missing.', 'script'),
(NULL, 1174, 'pjField', 1, 'title', 'User account with such ID does not exist.', 'script'),
(NULL, 1175, 'pjField', 1, 'title', 'Hash value does not match.', 'script'),
(NULL, 1176, 'pjField', 1, 'title', 'Your account was already confirmed.', 'script'),
(NULL, 1177, 'pjField', 1, 'title', 'Your account has been confirmed.', 'script'),
(NULL, 1178, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 1179, 'pjField', 1, 'title', 'Parameters are missing.', 'script'),
(NULL, 1180, 'pjField', 1, 'title', 'Question with such ID does not exist.', 'script'),
(NULL, 1181, 'pjField', 1, 'title', 'Hash value does not match.', 'script'),
(NULL, 1182, 'pjField', 1, 'title', 'The question was already approved.', 'script'),
(NULL, 1183, 'pjField', 1, 'title', 'The question has been approved.', 'script'),
(NULL, 1184, 'pjField', 1, 'title', 'Approve', 'script'),
(NULL, 1185, 'pjField', 1, 'title', 'Parameters are missing.', 'script'),
(NULL, 1186, 'pjField', 1, 'title', 'Reply with such ID does not exist.', 'script'),
(NULL, 1187, 'pjField', 1, 'title', 'Hash value does not match.', 'script'),
(NULL, 1188, 'pjField', 1, 'title', 'The reply was already approved.', 'script'),
(NULL, 1189, 'pjField', 1, 'title', 'The reply has been approved.', 'script'),
(NULL, 1190, 'pjField', 1, 'title', 'Your reply has been posted successfully, but it should be approved by administrator before shown up in the forum.', 'script'),
(NULL, 1191, 'pjField', 1, 'title', 'Just now', 'script');

INSERT INTO `stivaforum_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 5, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 6, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 7, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 8, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 9, 1, NULL),

(1, 'o_use_categories', 1, 'yes|no::yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_use_registration', 1, 'yes|no::yes', 'Yes|No', 'enum', 11, 1, NULL),
(1, 'o_account_confirmation', 1, 'email|admin|no::email', 'Email confirmation|Administrator|No', 'enum', 12, 1, NULL),
(1, 'o_new_questions', 1, 'everyone|registered::everyone', 'Everyone|Registered users only', 'enum', 13, 1, NULL),
(1, 'o_new_replies', 1, 'everyone|registered::everyone', 'Everyone|Registered users only', 'enum', 14, 1, NULL),
(1, 'o_approve_questions', 1, 'yes|no|yes_email::yes', 'Yes|No|Yes, email confirmation', 'enum', 15, 1, NULL),
(1, 'o_approve_replies', 1, 'yes|no|yes_email::yes', 'Yes|No|Yes, email confirmation', 'enum', 16, 1, NULL),
(1, 'o_questions_per_page', 1, '10', NULL, 'int', 17, 1, NULL),
(1, 'o_replies_per_page', 1, '10', NULL, 'int', 18, 1, NULL),
(1, 'o_rating', 1, 'everyone|logged|disabled::everyone', 'Everyone|Logged in users|Disabled', 'enum', 19, 1, NULL),
(1, 'o_reporting', 1, 'yes|no::yes', 'Yes|No', 'enum', 20, 1, NULL),
(1, 'o_reply_order', 1, 'last|first::last', 'Last on top|First on top', 'enum', 21, 1, NULL),

(1, 'o_use_captcha', 3, 'yes|no|unregisterd::yes', 'Yes|No|Unregistered users', 'enum', 1, 1, NULL),
(1, 'o_prevent_multiple_rating', 3, 'cookie|ip::cookie', 'Cookied|IP protection', 'enum', 2, 1, NULL),
(1, 'o_block_ip', 3, NULL, NULL, 'text', 3, 1, NULL),

(1, 'o_email_register_subject', 4, 'Registration confirmation', NULL, 'string', 1, 1, NULL),
(1, 'o_email_register_message', 4, '<p>Thank you for the registration on our forum.<br /><br />Personal details:<br />Full Name: {FullName}<br />E-Mail: {Email}<br />Password: {Password}<br />Country: {Country}<br />Website: {Website}<br />Phone: {Phone}<br />Status: {Status}<br /><br />Please click on the link below to confirm your account: {ConfirmURL}<br /><br />Thank you.</p>', NULL, 'text', 2, 1, NULL),
(1, 'o_email_forgot_subject', 4, 'Password recovery', NULL, 'string', 3, 1, NULL),
(1, 'o_email_forgot_message', 4, '<p>Hi,<br /><br />Here is your password: {Password}<br /><br />Please use this password to login to the forum. Then change it to your own one.</p>', NULL, 'text', 4, 1, NULL),

(1, 'o_admin_email_register_subject', 5, 'Registration notification', NULL, 'string', 1, 1, NULL),
(1, 'o_admin_email_register_message', 5, '<p>New registration is made on our forum.<br /><br />Personal details:<br />Full Name: {FullName}<br />E-Mail: {Email}<br />Password: {Password}<br />Country: {Country}<br />Website: {Website}<br />Phone: {Phone}<br />Status: {Status}<br /><br />Please click on the link below to confirm your account: {ConfirmURL}<br /><br />Thank you.</p>', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_email_question_approval_subject', 5, 'Question approval', NULL, 'string', 3, 1, NULL),
(1, 'o_admin_email_question_approval_message', 5, '<p>New question has been posted. <br /><br />Click on the link to view it:<br /><br />{QuestionViewURL}<br /><br />Click on the link to approve it:<br /><br />{QuestionApprovalURL}</p>', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_email_reply_approval_subject', 5, 'Reply approval', NULL, 'string', 5, 1, NULL),
(1, 'o_admin_email_reply_approval_message', 5, '<p>New reply has been posted. <br /><br />Click on the link to view it:<br /><br />{ReplyViewURL}<br /><br />Click on the link to approve it:<br /><br />{ReplyApprovalURL}</p>', NULL, 'text', 6, 1, NULL),
(1, 'o_admin_email_report_subject', 5, 'Report notification', NULL, 'string', 1, 1, NULL),
(1, 'o_admin_email_report_message', 5, '<p>There is a report for the reply. <br /><br />Click on the link to view it:<br /><br />{ReplyViewURL}</p>', NULL, 'text', 2, 1, NULL),

(1, 'o_rf_include_name', 6, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_rf_include_email', 6, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_rf_include_password', 6, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_rf_include_website', 6, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_rf_include_phone', 6, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_rf_include_address', 6, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_rf_include_country', 6, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_rf_include_state', 6, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_rf_include_city', 6, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_rf_include_zip', 6, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_rf_include_avatar', 6, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),

(1, 'o_listing_page', 99, 'preview.php', NULL, 'string', NULL, 0, NULL),
(1, 'o_seo_url', 99, 'Yes|No::No', NULL, 'enum', NULL, 0, NULL),
(1, 'o_theme', 99, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 10, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::0', 'Yes|No', 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `stivaforum_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T'),
(3, 'user', 'T');

COMMIT;