<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}

class pjAdminUsers extends pjAdmin
{
	private $imageFillColor = array(255, 255, 255);
	
	public function pjActionCheckEmail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['email']) || empty($_GET['email']))
			{
				echo 'false';
				exit;
			}
			$pjUserModel = pjUserModel::factory()->where('t1.email', $_GET['email']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjUserModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjUserModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminUsers&action=pjActionIndex&err=AU05");
			}
			
			if (isset($_POST['user_create']))
			{
				$pjUserModel = pjUserModel::factory();
				if (!$pjUserModel->validates($_POST))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminUsers&action=pjActionIndex&err=AU04");
				}
				$data = array();
				$data['is_active'] = 'T';
				$data['ip'] = pjUtil::getClientIp();
				
				$id = $pjUserModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AU03';
					
					if (isset($_FILES['avatar']) && !empty($_FILES['avatar']['tmp_name']))
					{
						$Image = new pjImage();
						if ($Image->getErrorCode() !== 200)
						{
							$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
							if ($Image->load($_FILES['avatar']))
							{
								$resp = $Image->isConvertPossible();
								if ($resp['status'] === true)
								{
									$hash = md5(uniqid(rand(), true));
									$image_path = PJ_UPLOAD_PATH . 'avatars/' . $id . '_' . $hash . '.' . $Image->getExtension();
					
									$Image->loadImage();
									$Image->setFillColor($this->imageFillColor);
									$Image->resizeSmart(150, 150);
									$Image->saveImage($image_path);
										
									$data = array();
									$data['avatar_path'] = $image_path;
									$data['mime_type'] = $_FILES['avatar']['type'];
									$data['avatar_hash'] = $hash;
					
									$pjUserModel->reset()->where('id', $id)->limit(1)->modifyAll($data);
								}else if($Image->getErrorCode() == '121'){
									pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminUsers&action=pjActionIndex&err=AU07");
								}
							}else{
								pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminUsers&action=pjActionIndex&err=AU06");
							}
						}
					}
				} else {
					$err = 'AU04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminUsers&action=pjActionIndex&err=$err");
			} else {
				
				$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`country_title` ASC')
					->findAll()
					->getData();
				$this->set('country_arr', $country_arr);
				
				$this->set('role_arr', pjRoleModel::factory()->orderBy('t1.id ASC')->findAll()->getData());
		
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'harvest/chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'harvest/chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminUsers.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteUser()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if ($_GET['id'] != $this->getUserId() && $_GET['id'] != 1)
			{
				$pjUserModel = pjUserModel::factory();
				$arr = $pjUserModel->find($_GET['id'])->getData();
				if ($pjUserModel->reset()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
				{
					@clearstatcache();
					if (!empty($arr['avatar_path']) && is_file(PJ_INSTALL_PATH . $arr['avatar_path']))
					{
						@unlink(PJ_INSTALL_PATH . $arr['avatar_path']);
					}
					$response['code'] = 200;
				} else {
					$response['code'] = 100;
				}
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteUserBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjUserModel = pjUserModel::factory();
				$arr = $pjUserModel
					->where('id !=', $this->getUserId())
					->where('id !=', 1)
					->whereIn('id', $_POST['record'])
					->findAll()
					->getData();
				
				$pjUserModel->eraseAll();
				foreach($arr as $v)
				{
					@clearstatcache();
					if (!empty($v['avatar_path']) && is_file(PJ_INSTALL_PATH . $v['avatar_path']))
					{
						@unlink(PJ_INSTALL_PATH . $v['avatar_path']);
					}
				}
			}
		}
		exit;
	}
	
	public function pjActionExportUser()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjUserModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Users-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetUser()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjUserModel = pjUserModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjUserModel->where('t1.email LIKE', "%$q%");
				$pjUserModel->orWhere('t1.name LIKE', "%$q%");
			}

			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjUserModel->where('t1.status', $_GET['status']);
			}
				
			$column = 'name';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjUserModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = $pjUserModel
				->select("
							t1.id, t1.email, t1.name, t1.created, t1.status, t1.is_active, t1.role_id, t2.role,
							(SELECT COUNT(TQ.id) FROM `".pjQuestionModel::factory()->getTable()."` AS TQ WHERE TQ.user_id=t1.id) AS cnt_questions,
							(SELECT COUNT(TR.id) FROM `".pjReplyModel::factory()->getTable()."` AS TR WHERE TR.user_id=t1.id) AS cnt_replies,
						")
				->join('pjRole', 't2.id=t1.role_id', 'left')
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach($data as $k => $v)
			{
				$v['created'] = date($this->option_arr['o_date_format'], strtotime($v['created'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['created']));
				$data[$k] = $v;
			}
			$data = pjSanitize::clean($data);
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminUsers.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSetActive()
	{
		$this->setAjax(true);

		if ($this->isXHR())
		{
			$pjUserModel = pjUserModel::factory();
			
			$arr = $pjUserModel->find($_POST['id'])->getData();
			
			if (count($arr) > 0)
			{
				switch ($arr['is_active'])
				{
					case 'T':
						$sql_status = 'F';
						break;
					case 'F':
						$sql_status = 'T';
						break;
					default:
						return;
				}
				$pjUserModel->reset()->setAttributes(array('id' => $_POST['id']))->modify(array('is_active' => $sql_status));
			}
		}
		exit;
	}
	
	public function pjActionSaveUser()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjUserModel = pjUserModel::factory();
			
			$pass = true;
			if ((int) $_GET['id'] === 1)
			{
				if(in_array($_POST['column'], array('role_id', 'status', 'is_active')))
				{
					$pass = false;
				}else if(in_array($_POST['column'], array('name', 'email')) && $_POST['value'] == ''){
					$pass = false;
				}else if($_POST['column'] == 'email' && $_POST['value'] != '' && !filter_var($_POST['value'], FILTER_VALIDATE_EMAIL)){
					$pass = false;
				}
			}
			if ($pass)
			{
				$pjUserModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			}
		}
		exit;
	}
	
	public function pjActionStatusUser()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjUserModel::factory()->whereIn('id', $_POST['record'])->where('id <>', 1)->modifyAll(array(
					'status' => ":IF(`status`='F','T','F')"
				));
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminUsers&action=pjActionIndex&err=AU09");
			}
			
			if (isset($_POST['user_update']))
			{
				pjUserModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				
				if (isset($_FILES['avatar']) && !empty($_FILES['avatar']['tmp_name']))
				{
					$Image = new pjImage();
					if ($Image->getErrorCode() !== 200)
					{
						$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
						if ($Image->load($_FILES['avatar']))
						{
							$resp = $Image->isConvertPossible();
							if ($resp['status'] === true)
							{
								$arr = pjUserModel::factory()->find($_POST['id'])->getData();
								if (!empty($arr['avatar_path']) && is_file(PJ_INSTALL_PATH . $arr['avatar_path']))
								{
									@unlink(PJ_INSTALL_PATH . $arr['avatar_path']);
								}
								$hash = md5(uniqid(rand(), true));
								$image_path = PJ_UPLOAD_PATH . 'avatars/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
				
								$Image->loadImage();
								$Image->setFillColor($this->imageFillColor);
								$Image->resizeSmart(150, 150);
								$Image->saveImage($image_path);
									
								$data = array();
								$data['avatar_path'] = $image_path;
								$data['mime_type'] = $_FILES['avatar']['type'];
								$data['avatar_hash'] = $hash;
				
								pjUserModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($data);
							}else if($Image->getErrorCode() == '121'){
								pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminUsers&action=pjActionIndex&err=AU07");
							}
						}
					}
				}
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminUsers&action=pjActionIndex&err=AU01");
				
			} else {
				$arr = pjUserModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminUsers&action=pjActionIndex&err=AU08");
				}
				
				$this->set('arr', $arr);
				$this->set('role_arr', pjRoleModel::factory()->orderBy('t1.id ASC')->findAll()->getData());
				
				$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`country_title` ASC')
					->findAll()
					->getData();
				$this->set('country_arr', $country_arr);
				
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'harvest/chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'harvest/chosen/');
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminUsers.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteAvatar()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (isset($_GET['id']))
			{
				$pjUserModel = pjUserModel::factory();
				$arr = $pjUserModel->find($_GET['id'])->getData();
				@clearstatcache();
				if (!empty($arr['avatar_path']) && is_file(PJ_INSTALL_PATH . $arr['avatar_path']))
				{
					@unlink(PJ_INSTALL_PATH . $arr['avatar_path']);
				}
				$pjUserModel->reset()->where('id', $_GET['id'])->limit(1)->modifyAll(array('avatar_path' => ':NULL', 'mime_type' => ':NULL', 'avatar_hash' => ':NULL'));
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
}
?>