<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{
	public $defaultCaptcha = 'StivaSoftCaptcha';
	
	public $defaultLocale = 'pjStivaForum_LocaleId';
	
	public $defaultFrontUser = 'pjStivaForum_User';
	
	public $defaultTheme = 'pjStivaForum_Theme';
	
	public $defaultError = 'pjStivaForum_Error';
	
	public $defaultMessage = 'pjStivaForum_Message';
	
	public $defaultReturn = 'pjStivaForum_Return';
	
	public $defaultShowReply = 'pjStivaForum_ShowReply';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
	}

	public function afterFilter()
	{
		
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		$theme = $this->option_arr['o_theme'];
		if(isset($_GET['theme']))
		{
			$_SESSION[$this->defaultTheme] = $_GET['theme'];
		}
		
		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		$this->loadSetFields(true);
		
		$this->use_captcha = true;
		$this->can_ask = true;
		$this->can_reply = true;
		$this->can_rating = true;
		
		if($this->option_arr['o_use_captcha'] == 'no')
		{
			$this->use_captcha = false;
		}
		if($this->option_arr['o_use_captcha'] == 'unregisterd' && $this->checkLogin())
		{
			$this->use_captcha = false;
		}
		if($this->option_arr['o_new_questions'] == 'registered' && !$this->checkLogin())
		{
			$this->can_ask = false;
		}
		if($this->option_arr['o_new_replies'] == 'registered' && !$this->checkLogin())
		{
			$this->can_reply = false;
		}
		if($this->option_arr['o_rating'] == 'disabled')
		{
			$this->can_rating = false;
		}
		if($this->option_arr['o_rating'] == 'logged' && !$this->checkLogin())
		{
			$this->can_rating = false;
		}
		
		$this->set('use_captcha', $this->use_captcha );
		$this->set('can_ask', $this->can_ask );
		$this->set('can_reply', $this->can_reply );
		$this->set('can_rating', $this->can_rating );
		
		if(isset($_SESSION[$this->defaultTheme]))
		{
			$theme = $_SESSION[$this->defaultTheme];
		}
		$this->appendCss('pj.bootstrap.min.css', PJ_FRAMEWORK_LIBS_PATH . 'pj/css/');
		$this->appendCss('font-awesome.min.css', PJ_LIBS_PATH . 'pjQ/css/');
		$this->appendCss('pjStivaForum.css', PJ_CSS_PATH);
		$this->appendCss($theme.'.css', PJ_CSS_PATH . 'themes/');
		
		$arr_block_ip = explode("\n", $this->option_arr['o_block_ip']);
		$ip = pjUtil::getClientIp();
		if(in_array($ip, $arr_block_ip) == true && $_GET['action'] != 'pjActionBlock')
		{
			pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionBlock' . (isset($_POST['iframe']) ? '&iframe' : NULL));
		}
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha(PJ_WEB_PATH . 'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH . 'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}


	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
				
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
	}
	
	public function pjActionSetLocale()
	{
		$this->setLocaleId(@$_GET['locale']);
		$this->loadSetFields(true);
		pjUtil::redirect($_SERVER['HTTP_REFERER']);
	}
	
	public function checkLogin()
	{
		if (isset($_SESSION[$this->defaultFrontUser]) && count($_SESSION[$this->defaultFrontUser]) > 0)
		{
			return true;
		}
		return false;
	}
}
?>