<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}

class pjLoad extends pjFront
{
	public function pjActionCheckEmail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['email']) || empty($_GET['email']))
			{
				echo 'false';
				exit;
			}
			$pjUserModel = pjUserModel::factory()->where('t1.email', $_GET['email']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjUserModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjUserModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$pjQuestionModel = pjQuestionModel::factory()
			->join('pjUser', "t2.id=t1.user_id", 'left outer')
			->join('pjCategory', "t3.id=t1.category_id", 'left outer');
			
		if (isset($_GET['keyword']) && !empty($_GET['keyword']))
		{
			$q = pjObject::escapeString($_GET['keyword']);
			$pjQuestionModel->where('t1.question LIKE', "%$q%");
			$pjQuestionModel->orWhere('t1.description LIKE', "%$q%");
		}
		if (isset($_GET['category_id']) && !empty($_GET['category_id']))
		{
			$category_id = pjObject::escapeString($_GET['category_id']);
			$pjQuestionModel->where('t1.category_id', $category_id);
		}
		
		$pjQuestionModel->where('t1.status', 'Approved');
		
		$column = 'last_reply';
		$direction = 'ASC';
		if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
		{
			$column = $_GET['column'];
			$direction = strtoupper($_GET['direction']);
		}
		
		$total = $pjQuestionModel->findCount()->getData();
		$items_per_page = (int) $this->option_arr['o_questions_per_page'] > 0 ? $this->option_arr['o_questions_per_page'] : 10;
		$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : $items_per_page;
		$pages = ceil($total / $rowCount);
		$page = isset($_GET['pjPage']) && (int) $_GET['pjPage'] > 0 ? intval($_GET['pjPage']) : 1;
		$offset = ((int) $page - 1) * $rowCount;
		if ($page > $pages)
		{
			$page = $pages;
		}
			
		$question_arr = $pjQuestionModel
			->select("
						t1.id, t1.category_id, t3.name AS category, t3.font_color, t3.background_color,
						IF(user_id IS NULL, t1.name, t2.name) as name,
						IF(user_id IS NULL, t1.email, t2.email) as email,
						t1.question, t1.counts, t1.created, t1.status,
						(IF(CHAR_LENGTH(t1.description) >= 200, CONCAT(SUBSTRING(t1.description, 1, 200), '...'), t1.description)) AS description,
						(SELECT COUNT(TR.id) FROM `".pjReplyModel::factory()->getTable()."` AS TR WHERE TR.status='Approved' AND TR.question_id=t1.id) AS cnt_replies,
						(IF((SELECT TR.created FROM `".pjReplyModel::factory()->getTable()."` AS TR WHERE TR.status='Approved' AND TR.question_id=t1.id ORDER BY TR.created DESC LIMIT 1) IS NULL , (TIMESTAMPDIFF(SECOND, t1.created, '".date('Y-m-d:H:i:s')."')), TIMESTAMPDIFF(SECOND, (SELECT TR.created FROM `".pjReplyModel::factory()->getTable()."` AS TR WHERE TR.question_id=t1.id ORDER BY TR.created DESC LIMIT 1), '".date('Y-m-d:H:i:s')."')))  AS last_reply
					")
			->orderBy("$column $direction")
			->limit($rowCount, $offset)
			->findAll()->getData();
		
		$this->set('question_arr', $question_arr);
		$this->set('paginator', array('pages' => $pages, 'total' => $total));
	}
	
	public function pjActionView()
	{
		if(isset($_GET['id']))
		{
			$arr = pjQuestionModel::factory()
				->select("
							t1.id, t1.category_id, t3.name AS category, t3.font_color, t3.background_color, 
							IF(user_id IS NULL, t1.name, t2.name) as name,
							IF(user_id IS NULL, t1.email, t2.email) as email,
							t1.question, t1.description, t1.counts, t1.created, t1.status,
							(IF(CHAR_LENGTH(t1.description) >= 150, CONCAT(SUBSTRING(t1.description, 1, 150), '...'), t1.description)) AS meta_description					
						")
				->join('pjUser', "t2.id=t1.user_id", 'left outer')
				->join('pjCategory', "t3.id=t1.category_id", 'left outer')
				->find($_GET['id'])
				->getData();
			if(count($arr) == 0)
			{
				$this->set('status', 'VIE01');
			}else{
				if($arr['status'] == 'Banned')
				{
					$this->set('status', 'VIE02');
				}else{
					$pjReplyModel = pjReplyModel::factory()
						->join('pjUser', "t2.id=t1.user_id", 'left outer')
						->join('pjCategory', "t3.id=t1.category_id", 'left outer')
						->join('pjQuestion', "t4.id=t1.question_id", 'left outer');
						
					$pjReplyModel->where('t1.status', 'Approved');
					$pjReplyModel->where("t1.reply_id IS NULL");
					$pjReplyModel->where("t1.question_id", $_GET['id']);
					
					$column = 'created';
					
					$direction = 'DESC';
					if($this->option_arr['o_reply_order'] == 'first')
					{
						$direction = 'ASC';
					}
					if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
					{
						$column = $_GET['column'];
						$direction = strtoupper($_GET['direction']);
					}
					
					$total = $pjReplyModel->findCount()->getData();
					$items_per_page = (int) $this->option_arr['o_replies_per_page'] > 0 ? $this->option_arr['o_replies_per_page'] : 10;
					$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : $items_per_page;
					$pages = ceil($total / $rowCount);
					$page = isset($_GET['pjPage']) && (int) $_GET['pjPage'] > 0 ? intval($_GET['pjPage']) : 1;
					$offset = ((int) $page - 1) * $rowCount;
					if ($page > $pages)
					{
						$page = $pages;
					}
						
					$reply_arr = $pjReplyModel
						->select("
									t1.id, t3.name AS category, t4.question, t2.avatar_path,
									IF(t1.user_id IS NULL, t1.name, t2.name) as name,
									IF(t1.user_id IS NULL, t1.email, t2.email) as email,
									t1.description, t1.likes, t1.dislikes, t1.created, t1.status,
								")
						->orderBy("$column $direction")
						->limit($rowCount, $offset)
						->findAll()
						->getData();
					
					$reply_id_arr = $pjReplyModel->findAll()->getDataPair(null, 'id');
					$sub_reply_arr = array();
					if(!empty($reply_id_arr))
					{
						$_arr = $pjReplyModel
							->reset()
							->select("
										t1.id, t1.reply_id, t3.name AS category, t2.avatar_path,
										IF(t1.user_id IS NULL, t1.name, t2.name) as name,
										IF(t1.user_id IS NULL, t1.email, t2.email) as email,
										t1.description, t1.likes, t1.dislikes, t1.created, t1.status,
									")
							->join('pjUser', "t2.id=t1.user_id", 'left outer')
							->join('pjCategory', "t3.id=t1.category_id", 'left outer')
							->whereIn('t1.reply_id', $reply_id_arr)
							->orderBy("$column $direction")
							->findAll()
							->getData();
						foreach($_arr as $v)
						{
							$sub_reply_arr[$v['reply_id']][] = $v;
						}
					}
					
					pjQuestionModel::factory()->set('id', $arr['id'])->modify(array('counts' => ((int) $arr['counts']) + 1));
					
					$this->set('meta_arr', array(
							'title' => $arr['question'],
							'description' => $arr['meta_description']
					));
					
					$this->set('arr', $arr);
					$this->set('reply_arr', $reply_arr);
					$this->set('sub_reply_arr', $sub_reply_arr);
					$this->set('paginator', array('pages' => $pages, 'total' => $total));
				}
			}
		}else{
			$this->set('status', 'VIE01');
		}
	}
	
	public function pjActionCategory()
	{
		if($this->option_arr['o_use_categories'] == 'no')
		{
			pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionIndex' . (isset($_POST['iframe']) ? '&iframe' : NULL));
		}
		
		$pjCategoryModel = pjCategoryModel::factory();
		
		$categroy_arr = $pjCategoryModel
			->where('t1.status', 'T')
			->orderBy("name ASC")
			->findAll()
			->getData();
		
		$categroy_id_arr = $pjCategoryModel->reset()->where('t1.status', 'T')->orderBy("name ASC")->findAll()->getDataPair(null, 'id');
		
		$_categroy_arr = array();
		if(!empty($categroy_id_arr))
		{
			$question_arr = pjQuestionModel::factory()
				->select("
							t1.*, 
							(IF((SELECT TR.created FROM `".pjReplyModel::factory()->getTable()."` AS TR WHERE TR.status='Approved' AND TR.question_id=t1.id ORDER BY TR.created DESC LIMIT 1) IS NULL , (TIMESTAMPDIFF(SECOND, t1.created, '".date('Y-m-d:H:i:s')."')), TIMESTAMPDIFF(SECOND, (SELECT TR.created FROM `".pjReplyModel::factory()->getTable()."` AS TR WHERE TR.question_id=t1.id ORDER BY TR.created DESC LIMIT 1), '".date('Y-m-d:H:i:s')."')))  AS last_reply
						")
				->where('t1.status', 'Approved')
				->whereIn('category_id', $categroy_id_arr)
				->orderBy("t1.created DESC")
				->findAll()
				->getData();
			
			foreach($question_arr as $v)
			{
				if(isset($_categroy_arr[$v['category_id']]) && count($_categroy_arr[$v['category_id']]) <= 4)
				{
					$_categroy_arr[$v['category_id']][] = $v;
				} 
			}
		}
		foreach($categroy_arr as $k => $v)
		{
			$v['question'] = (isset($_categroy_arr[$v['id']]) && !empty($_categroy_arr[$v['id']])) ? $_categroy_arr[$v['id']] : array();
			$categroy_arr[$k] = $v;
		}
		$this->set('category_arr', $categroy_arr);
	}
	
	public function pjActionRegister()
	{
		if($this->option_arr['o_use_registration'] == 'no')
		{
			pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionIndex' . (isset($_POST['iframe']) ? '&iframe' : NULL));
		}
		$post_max_size = pjUtil::getPostMaxSize();
		if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
		{
			$_SESSION[$this->defaultError] = 'REG14';
			pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionRegister' . (isset($_POST['iframe']) ? '&iframe' : NULL));
		}
		if(isset($_POST['register']))
		{
			$err = null;
			if((int) $this->option_arr['o_rf_include_name'] === 3)
			{
				if (!isset($_POST['name']))
				{
					$err = 'REG01';
				}
				if (isset($_POST['name']) && !pjValidation::pjActionNotEmpty($_POST['name']))
				{
					$err = 'REG02';
				}
			}
			if((int) $this->option_arr['o_rf_include_email'] === 3)
			{
				if (!isset($_POST['email']))
				{
					$err = 'REG03';
				}
				if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
				{
					$err = 'REG04';
				}
			}
			if((int) $this->option_arr['o_rf_include_password'] === 3)
			{
				if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
				{
					$err = 'REG05';
				}
				if (!isset($_POST['password']))
				{
					$err = 'REG06';
				}
			
				if (isset($_POST['password']) && !pjValidation::pjActionNotEmpty($_POST['password']))
				{
					$err = 'REG07';
				}
				if (!isset($_POST['reenter_password']))
				{
					$err = 'REG08';
				}
				if (isset($_POST['reenter_password']) && !pjValidation::pjActionNotEmpty($_POST['reenter_password']))
				{
					$err = 'REG09';
				}
			}
			if (isset($_POST['password']) && !pjValidation::pjActionNotEmpty($_POST['password']) && isset($_POST['reenter_password']) && !pjValidation::pjActionNotEmpty($_POST['reenter_password']) && $_POST['password'] != $_POST['reenter_password'])
			{
				$err = 'REG10';
			}
			
			if($this->use_captcha == true)
			{
				if (!isset($_POST['captcha']))
				{
					$err = 'REG11';
				}
				if (isset($_POST['captcha']) && !pjValidation::pjActionNotEmpty($_POST['captcha']))
				{
					$err = 'REG12';
				}
				if ($_SESSION[$this->defaultCaptcha]=="" || $_POST['captcha']=="" || strtoupper($_POST['captcha']) != $_SESSION[$this->defaultCaptcha])
				{
					$err = 'REG13';
				}
			}
			
			if($err == null)
			{
				$pjUserModel = pjUserModel::factory();
				
				$data = array();
				$data['is_active'] = 'T';
				$data['role_id'] = '3';
				$data['ip'] = pjUtil::getClientIp();
				$data['status'] = 'F';
				if($this->option_arr['o_account_confirmation'] == 'no')
				{
					$data['status'] = 'T';
				}
				
				$id = $pjUserModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					if (isset($_FILES['avatar']))
					{
						$Image = new pjImage();
						if ($Image->getErrorCode() !== 200)
						{
							$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
							if ($Image->load($_FILES['avatar']))
							{
								$resp = $Image->isConvertPossible();
								if ($resp['status'] === true)
								{
									$hash = md5(uniqid(rand(), true));
									$image_path = PJ_UPLOAD_PATH . 'avatars/' . $id . '_' . $hash . '.' . $Image->getExtension();
										
									$Image->loadImage();
									$Image->setFillColor($this->imageFillColor);
									$Image->resizeSmart(150, 150);
									$Image->saveImage(PJ_INSTALL_PATH . $image_path);
				
									$data = array();
									$data['avatar_path'] = $image_path;
									$data['mime_type'] = $_FILES['avatar']['type'];
									$data['avatar_hash'] = $hash;
										
									$pjUserModel->reset()->where('id', $id)->limit(1)->modifyAll($data);

									switch ($this->option_arr['o_account_confirmation'])
									{
										case 'no':
											$_SESSION[$this->defaultMessage] = 'REG01';;
											break;
										case 'admin':
											$_SESSION[$this->defaultMessage] = 'REG02';;
											break;
										case 'email':
											$_SESSION[$this->defaultMessage] = 'REG03';;
											break;
									}
								}
							}else{
								if($Image->getErrorCode() == '101')
								{
									$_SESSION[$this->defaultError] = 'REG16';
								}
								if($Image->getErrorCode() == '121')
								{
									$_SESSION[$this->defaultError] = 'REG17';
								}
							}
						}
					}
					$this->pjActionRegistrationEmail($id);
				}else{
					$_SESSION[$this->defaultError] = 'REG15';
				}
			}else{
				$_SESSION[$this->defaultError] = $err;
			}
			pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionRegister' . (isset($_POST['iframe']) ? '&iframe' : NULL));
		}else{
			if(isset($_SESSION[$this->defaultError]))
			{
				$this->set('err', $_SESSION[$this->defaultError]);
				unset($_SESSION[$this->defaultError]);
			}
			if(isset($_SESSION[$this->defaultMessage]))
			{
				$this->set('msg', $_SESSION[$this->defaultMessage]);
				unset($_SESSION[$this->defaultMessage]);
			}
			
			$country_arr = pjCountryModel::factory()
				->select('t1.id, t2.content AS country_title')
				->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
				->orderBy('`country_title` ASC')
				->findAll()
				->getData();
			$this->set('country_arr', $country_arr);
		}
	}
	
	public function pjActionLogin()
	{
		if($this->option_arr['o_use_registration'] == 'no')
		{
			pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionIndex' . (isset($_POST['iframe']) ? '&iframe' : NULL));
		}
		if(isset($_POST['login']))
		{
			$err = null;
			if (!isset($_POST['email']))
			{
				$err = 'LOG01';
			}
			if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
			{
				$err = 'LOG02';
			}
			if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
			{
				$err = 'LOG03';
			}
			if (!isset($_POST['password']))
			{
				$err = 'LOG04';
			}
			if (isset($_POST['password']) && !pjValidation::pjActionNotEmpty($_POST['password']))
			{
				$err = 'LOG05';
			}
			if($err == null)
			{
				$pjUserModel = pjUserModel::factory();
				$user = $pjUserModel
					->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`")
					->where('t1.email', $_POST['email'])
					->where(sprintf("t1.password = AES_ENCRYPT('%s', '%s')", pjObject::escapeString($_POST['password']), PJ_SALT))
					->limit(1)
					->findAll()
					->getData();
				if (count($user) != 1)
				{
					$_SESSION[$this->defaultError] = 'LOG06';
					pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionLogin' . (isset($_POST['iframe']) ? '&iframe' : NULL));
				}else{
					$user = $user[0];
					if ($user['status'] == 'F')
					{
						$_SESSION[$this->defaultError] = 'LOG07';
						pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionLogin' . (isset($_POST['iframe']) ? '&iframe' : NULL));
					}
					$_SESSION[$this->defaultFrontUser] = $user;
	
					$data = array();
					$data['last_login'] = date("Y-m-d H:i:s");
					$pjUserModel->reset()->setAttributes(array('id' => $user['id']))->modify($data);
					
					if(isset($_POST['qid']))
					{
						$url = $_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionView&id=' . $_POST['qid'] . (isset($_POST['iframe']) ? '&iframe' : NULL);
						if($this->option_arr['o_seo_url'] == 'Yes')
						{
							$arr = pjQuestionModel::factory()->find($_POST['qid'])->getData();
							$path = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
							$path = $path == '/' ? '' : $path;
							$url = $path .'/'. $this->friendlyURL($arr['question']) . "-". $arr['id'] . ".html";
						}
						pjUtil::redirect($url);
					}else{
						pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionProfile' . (isset($_POST['iframe']) ? '&iframe' : NULL));
					}
				}
			}else{
				$_SESSION[$this->defaultError] = $err;
			}
			
			pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionLogin' . (isset($_POST['iframe']) ? '&iframe' : NULL));
		}else{
			$return_arr = array();
			if(isset($_GET['qid']) && (int) $_GET['qid'] >0)
			{
				$return_arr['qid'] = $_GET['qid'];
				if(isset($_GET['rid']) && (int) $_GET['rid'] >0)
				{
					$return_arr['rid'] = $_GET['rid'];
				}
			}
			if((!isset($_SESSION[$this->defaultReturn]) || (isset($_SESSION[$this->defaultReturn]) && empty($_SESSION[$this->defaultReturn]))) && !empty($return_arr))
			{
				$_SESSION[$this->defaultReturn] = $return_arr;
			}
			
			if(isset($_SESSION[$this->defaultError]))
			{
				$this->set('err', $_SESSION[$this->defaultError]);
				unset($_SESSION[$this->defaultError]);
			}
		}
	}
	
	public function pjActionForgot()
	{
		if(isset($_POST['forgot_password']))
		{
			$err = null;
			if (!isset($_POST['email']))
			{
				$err = 'FOR01';
			}
			if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
			{
				$err = 'FOR02';
			}
			if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
			{
				$err = 'FOR03';
			}
			if($err == null)
			{
				$pjUserModel = pjUserModel::factory();
	
				$user = $pjUserModel
					->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`, t2.content AS country_title")
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.country_id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left')
					->where('t1.email', $_POST['email'])
					->limit(1)
					->findAll()
					->getData();
	
				$statuses = __('u_statarr', true);
				$user = $user[0];
				if(empty($user))
				{
					$_SESSION[$this->defaultError] = 'FOR05';
					pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionForgot' . (isset($_POST['iframe']) ? '&iframe' : NULL));
				}
				if($user['status'] == 'F')
				{
					$_SESSION[$this->defaultError] = 'FOR04';
					pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionForgot' . (isset($_POST['iframe']) ? '&iframe' : NULL));
				}else{
						
					$subject = $this->option_arr['o_email_forgot_subject'];
					$message = $this->option_arr['o_email_forgot_message'];
	
					if(!empty($subject) && !empty($message))
					{
						$search = array("{FullName}", "{Email}", "{Password}", "{Phone}", "{Website}", "{Country}", "{City}", "{State}", "{Zip}", "{Address}", "{Status}");
						$replace = array($user['name'], $user['email'], $user['password'], $user['phone'], @$user['website'], @$user['country_title'], @$user['city'],@$user['state'], @$user['zip'], @$user['address'], $statuses[$user['status']]);
							
						$pjEmail = new pjEmail();
	
						if ($this->option_arr['o_send_email'] == 'smtp')
						{
							$pjEmail
								->setTransport('smtp')
								->setSmtpHost($this->option_arr['o_smtp_host'])
								->setSmtpPort($this->option_arr['o_smtp_port'])
								->setSmtpUser($this->option_arr['o_smtp_user'])
								->setSmtpPass($this->option_arr['o_smtp_pass']);
						}
	
						$to = $_POST['email'];
						$from = $this->getAdminEmail();
	
						$subject = str_replace($search, $replace, $subject);
						$message = str_replace($search, $replace, $message);
	
						$pjEmail->setContentType('text/html');
						$pjEmail->setTo($to);
						$pjEmail->setFrom($from);
						$pjEmail->setSubject($subject);
						$pjEmail->send($message);
	
						$_SESSION[$this->defaultMessage] = 'FOR01';
						pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionForgot' . (isset($_POST['iframe']) ? '&iframe' : NULL));
					}
				}
			}else{
				$_SESSION[$this->defaultError] = $err;
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionForgot' . (isset($_POST['iframe']) ? '&iframe' : NULL));
			}
		}else{
			if(isset($_SESSION[$this->defaultError]))
			{
				$this->set('err', $_SESSION[$this->defaultError]);
				unset($_SESSION[$this->defaultError]);
			}
			if(isset($_SESSION[$this->defaultMessage]))
			{
				$this->set('msg', $_SESSION[$this->defaultMessage]);
				unset($_SESSION[$this->defaultMessage]);
			}
		}
	}
	
	public function pjActionProfile()
	{
		$post_max_size = pjUtil::getPostMaxSize();
		if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
		{
			$_SESSION[$this->defaultError] = 'PRO01';
			pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionProfile' . (isset($_POST['iframe']) ? '&iframe' : NULL));
		}
		if(isset($_POST['profile']))
		{
			$err = null;
				
			if((int) $this->option_arr['o_rf_include_name'] === 3)
			{
				if (!isset($_POST['name']))
				{
					$err = 'REG01';
				}
				if (isset($_POST['name']) && !pjValidation::pjActionNotEmpty($_POST['name']))
				{
					$err = 'REG02';
				}
			}
			if((int) $this->option_arr['o_rf_include_email'] === 3)
			{
				if (!isset($_POST['email']))
				{
					$err = 'REG03';
				}
				if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
				{
					$err = 'REG04';
				}
			}
			if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
			{
				$err = 'REG05';
			}
			if((int) $this->option_arr['o_rf_include_password'] === 3)
			{
				if (!isset($_POST['password']))
				{
					$err = 'REG06';
				}
				if (isset($_POST['password']) && !pjValidation::pjActionNotEmpty($_POST['password']))
				{
					$err = 'REG07';
				}
			}
				
			if($err == null)
			{
				$data = array();
				$data['ip'] = pjUtil::getClientIp();
				$data['modified'] = date('Y-m-d H:i:s');
	
				$pjUserModel = pjUserModel::factory();
				$arr = $pjUserModel->find($_POST['id'])->getData();
				$pjUserModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				$user = $pjUserModel->reset()->find($_POST['id'])->getData();
				$_SESSION[$this->defaultFrontUser] = $user;
				if (isset($_FILES['avatar']) && !empty($_FILES['avatar']['tmp_name']))
				{
					$Image = new pjImage();
					if ($Image->getErrorCode() !== 200)
					{
						$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
						if ($Image->load($_FILES['avatar']))
						{
							$resp = $Image->isConvertPossible();
							if ($resp['status'] === true)
							{
								if (!empty($arr['avatar_path']) && is_file(PJ_INSTALL_PATH . $arr['avatar_path']))
								{
									@unlink(PJ_INSTALL_PATH . $arr['avatar_path']);
								}
								$hash = md5(uniqid(rand(), true));
								$image_path = PJ_UPLOAD_PATH . 'avatars/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
	
								$Image->loadImage();
								$Image->setFillColor($this->imageFillColor);
								$Image->resizeSmart(96, 96);
								$Image->saveImage(PJ_INSTALL_PATH . $image_path);
									
								$data = array();
								$data['avatar_path'] = $image_path;
								$data['mime_type'] = $_FILES['avatar']['type'];
								$data['avatar_hash'] = $hash;
	
								$pjUserModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll($data);
								
								$user = $pjUserModel->reset()->find($_POST['id'])->getData();
								$_SESSION[$this->defaultFrontUser] = $user;
								
								$_SESSION[$this->defaultMessage] = 'PRO01';
								pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionProfile' . (isset($_POST['iframe']) ? '&iframe' : NULL));
							}
						}else{
							if($Image->getErrorCode() == '101')
							{
								$_SESSION[$this->defaultError] = 'PRO02';
							}
							if($Image->getErrorCode() == '121')
							{
								$_SESSION[$this->defaultError] = 'PRO03';
							}
						}
					}
				}
			}else{
				$_SESSION[$this->defaultError] = $err;
			}
			pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionProfile' . (isset($_POST['iframe']) ? '&iframe' : NULL));
		}else{
			$user = $_SESSION[$this->defaultFrontUser];
				
			$arr = pjUserModel::factory()->find($user['id'])->getData();
			
			$country_arr = pjCountryModel::factory()
				->select('t1.id, t2.content AS country_title')
				->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
				->orderBy('`country_title` ASC')
				->findAll()
				->getData();
			
			$pjQuestionModel = pjQuestionModel::factory();
			$column = 'last_reply';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}
			
			$total = $pjQuestionModel->findCount()->getData();
			$items_per_page = (int) $this->option_arr['o_questions_per_page'] > 0 ? $this->option_arr['o_questions_per_page'] : 10;
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : $items_per_page;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['pjPage']) && (int) $_GET['pjPage'] > 0 ? intval($_GET['pjPage']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			$question_arr = $pjQuestionModel
				->select("
							t1.id, t3.name AS category, t3.font_color, t3.background_color,
							IF(user_id IS NULL, t1.name, t2.name) as name,
							IF(user_id IS NULL, t1.email, t2.email) as email,
							t1.question, t1.counts, t1.created, t1.status,
							(IF(CHAR_LENGTH(t1.description) >= 200, CONCAT(SUBSTRING(t1.description, 1, 200), '...'), t1.description)) AS description,
							(SELECT COUNT(TR.id) FROM `".pjReplyModel::factory()->getTable()."` AS TR WHERE TR.question_id=t1.id) AS cnt_replies,
							(SELECT TIMESTAMPDIFF(SECOND, TR.created, '".date('Y-m-d:H:i:s')."') FROM `".pjReplyModel::factory()->getTable()."` AS TR WHERE TR.question_id=t1.id ORDER BY created DESC LIMIT 1) AS last_reply
						")
				->join('pjUser', "t2.id=t1.user_id", 'left outer')
				->join('pjCategory', "t3.id=t1.category_id", 'left outer')
				->where("(t1.user_id='".$user['id']."' OR t1.id IN(SELECT TR.question_id FROM `".pjReplyModel::factory()->getTable()."` AS TR WHERE TR.user_id='".$user['id']."') )")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			
			$this->set('country_arr', $country_arr);
			$this->set('arr', $arr);
			$this->set('question_arr', $question_arr);
			$this->set('paginator', array('pages' => $pages, 'total' => $total));
							
			if(isset($_SESSION[$this->defaultError]))
			{
				$this->set('err', $_SESSION[$this->defaultError]);
				unset($_SESSION[$this->defaultError]);
			}
			if(isset($_SESSION[$this->defaultMessage]))
			{
				$this->set('msg', $_SESSION[$this->defaultMessage]);
				unset($_SESSION[$this->defaultMessage]);
			}
		}
	}
	
	public function pjActionAsk()
	{
		if($this->can_ask == true)
		{
			if(isset($_POST['ask_question']))
			{
				$err = null;
				if(!$this->checkLogin())
				{
					if (!isset($_POST['name']))
					{
						$err = 'REG01';
					}
					if (isset($_POST['name']) && !pjValidation::pjActionNotEmpty($_POST['name']))
					{
						$err = 'REG02';
					}
					if (!isset($_POST['email']))
					{
						$err = 'REG03';
					}
					if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
					{
						$err = 'REG04';
					}
					if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
					{
						$err = 'REG05';
					}
				}
				if (!isset($_POST['question']))
				{
					$err = 'ASK01';
				}
				if (isset($_POST['question']) && !pjValidation::pjActionNotEmpty($_POST['question']))
				{
					$err = 'ASK02';
				}
				if (!isset($_POST['description']))
				{
					$err = 'ASK03';
				}
				if (isset($_POST['description']) && !pjValidation::pjActionNotEmpty($_POST['description']))
				{
					$err = 'ASK04';
				}
				if (!isset($_POST['category_id']))
				{
					$err = 'ASK05';
				}
				if (isset($_POST['category_id']) && !pjValidation::pjActionNotEmpty($_POST['category_id']))
				{
					$err = 'ASK06';
				}
				if($this->use_captcha == true)
				{
					if (!isset($_POST['captcha']))
					{
						$err = 'REG11';
					}
					if (isset($_POST['captcha']) && !pjValidation::pjActionNotEmpty($_POST['captcha']))
					{
						$err = 'REG12';
					}
					if ($_SESSION[$this->defaultCaptcha]=="" || $_POST['captcha']=="" || strtoupper($_POST['captcha']) != $_SESSION[$this->defaultCaptcha])
					{
						$err = 'REG13';
					}
				}
				
				if($err == null)
				{
					$data = array();
					$data['created'] = date('Y-m-d H:i:s');
					$data['ip'] = pjUtil::getClientIp();
					if($this->checkLogin())
					{
						$data['name'] = ':NULL';
						$data['email'] = ':NULL';
						$data['user_id'] = $_SESSION[$this->defaultFrontUser]['id'];
						unset($_POST['name']);
						unset($_POST['email']);
					}else{
						$data['user_id'] = ':NULL';
						unset($_POST['user_id']);
					}
					$data['status'] = 'New';
					if($this->option_arr['o_approve_questions'] == 'no')
					{
						$data['status'] = 'Approved';
					}
					$id = pjQuestionModel::factory()->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
					if ($id !== false && (int) $id > 0)
					{
						if($this->option_arr['o_approve_questions'] == 'yes_email')
						{
							$pjEmail = new pjEmail();
							if ($this->option_arr['o_send_email'] == 'smtp')
							{
								$pjEmail
								->setTransport('smtp')
								->setSmtpHost($this->option_arr['o_smtp_host'])
								->setSmtpPort($this->option_arr['o_smtp_port'])
								->setSmtpUser($this->option_arr['o_smtp_user'])
								->setSmtpPass($this->option_arr['o_smtp_pass']);
							}
							$pjEmail->setContentType('text/html');
							$from = $this->getAdminEmail();
							
							$approval_url = PJ_INSTALL_URL . 'index.php?controller=pjAdminQuestions&action=pjActionApprove&id='.$id.'&hash='.sha1($id . PJ_SALT);
							$view_ur = PJ_INSTALL_URL . 'index.php?controller=pjAdminQuestions&action=pjActionView&id='.$id.'&hash='.sha1($id . PJ_SALT);
							
							$search = array("{QuestionApprovalURL}", "{QuestionViewURL}");
							$replace = array($approval_url, $view_ur);
								
							$subject = $this->option_arr['o_admin_email_question_approval_subject'];
							$message = $this->option_arr['o_admin_email_question_approval_message'];
								
							if(!empty($subject) && !empty($message) && !empty($from))
							{
								$subject = str_replace($search, $replace, $subject);
								$message = str_replace($search, $replace, $message);
								$pjEmail
									->setTo($from)
									->setFrom($from)
									->setSubject($subject)
									->send($message);
							}
						}
						$_SESSION[$this->defaultMessage] = 'ASK01';
						if($this->option_arr['o_approve_questions'] == 'yes_email' || $this->option_arr['o_approve_questions'] == 'yes')
						{
							$_SESSION[$this->defaultMessage] = 'ASK02';
						}
						pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionAsk' . (isset($_POST['iframe']) ? '&iframe' : NULL));
					}else{
						$err = 'ASK07';
					}
				}else{
					$_SESSION[$this->defaultError] = $err;
				}
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionAsk' . (isset($_POST['iframe']) ? '&iframe' : NULL));
			}else{
	
				$this->set('category_arr', pjCategoryModel::factory()->where('t1.status', 'T')->orderBy("name ASC")->findAll()->getData());
				
				if(isset($_SESSION[$this->defaultError]))
				{
					$this->set('err', $_SESSION[$this->defaultError]);
					unset($_SESSION[$this->defaultError]);
				}
				if(isset($_SESSION[$this->defaultMessage]))
				{
					$this->set('msg', $_SESSION[$this->defaultMessage]);
					unset($_SESSION[$this->defaultMessage]);
				}
			}
			$this->set('status', 'OK');
		}else{
			$this->set('status', 'ERR');
		}
	}
	
	public function pjActionSaveReply()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			if($this->can_reply == true)
			{
				if(isset($_POST['post_reply']))
				{
					$front_err = pjSanitize::clean(__('front_err', true));
					$front_msg = pjSanitize::clean(__('front_msg', true));
					$response = array();
					
					$err = null;
					if(!$this->checkLogin())
					{
						if (!isset($_POST['name']))
						{
							$err = 'REG01';
						}
						if (isset($_POST['name']) && !pjValidation::pjActionNotEmpty($_POST['name']))
						{
							$err = 'REG02';
						}
						if (!isset($_POST['email']))
						{
							$err = 'REG03';
						}
						if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
						{
							$err = 'REG04';
						}
						if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
						{
							$err = 'REG05';
						}
					}
					if (!isset($_POST['description']))
					{
						$err = 'REP01';
					}
					if (isset($_POST['description']) && !pjValidation::pjActionNotEmpty($_POST['description']))
					{
						$err = 'REP02';
					}
					if($this->use_captcha == true)
					{
						if (!isset($_POST['captcha']))
						{
							$err = 'REG11';
						}
						if (isset($_POST['captcha']) && !pjValidation::pjActionNotEmpty($_POST['captcha']))
						{
							$err = 'REG12';
						}
						if ($_SESSION[$this->defaultCaptcha]=="" || $_POST['captcha']=="" || strtoupper($_POST['captcha']) != $_SESSION[$this->defaultCaptcha])
						{
							$err = 'REG13';
						}
					}
					if($err == null)
					{
						$data = array();
						$data['created'] = date('Y-m-d H:i:s');
						$data['ip'] = pjUtil::getClientIp();
						if($this->checkLogin())
						{
							$data['name'] = ':NULL';
							$data['email'] = ':NULL';
							$data['user_id'] = $_SESSION[$this->defaultFrontUser]['id'];
							unset($_POST['name']);
							unset($_POST['email']);
						}else{
							$data['user_id'] = ':NULL';
							unset($_POST['user_id']);
						}
						$data['status'] = 'New';
						if($this->option_arr['o_approve_replies'] == 'no')
						{
							$data['status'] = 'Approved';
						}
						
						$id = pjReplyModel::factory()->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
						if ($id !== false && (int) $id > 0)
						{
							if($this->option_arr['o_approve_replies'] == 'yes_email')
							{
								$pjEmail = new pjEmail();
								if ($this->option_arr['o_send_email'] == 'smtp')
								{
									$pjEmail
										->setTransport('smtp')
										->setSmtpHost($this->option_arr['o_smtp_host'])
										->setSmtpPort($this->option_arr['o_smtp_port'])
										->setSmtpUser($this->option_arr['o_smtp_user'])
										->setSmtpPass($this->option_arr['o_smtp_pass']);
								}
								$pjEmail->setContentType('text/html');
								$from = $this->getAdminEmail();
						
								$approval_url = PJ_INSTALL_URL . 'index.php?controller=pjAdminReplies&action=pjActionApprove&id='.$id.'&hash='.sha1($id . PJ_SALT);
								$view_ur = PJ_INSTALL_URL . 'index.php?controller=pjAdminReplies&action=pjActionView&id='.$id.'&hash='.sha1($id . PJ_SALT);
						
								$search = array("{ReplyApprovalURL}", "{ReplyViewURL}");
								$replace = array($approval_url, $view_ur);
									
								$subject = $this->option_arr['o_admin_email_reply_approval_subject'];
								$message = $this->option_arr['o_admin_email_reply_approval_message'];
									
								if(!empty($subject) && !empty($message) && !empty($from))
								{
									$subject = str_replace($search, $replace, $subject);
									$message = str_replace($search, $replace, $message);
									
									$pjEmail
										->setTo($from)
										->setFrom($from)
										->setSubject($subject)
										->send($message);
								}
							}
							if($this->option_arr['o_approve_replies'] == 'no')
							{
								$_SESSION[$this->defaultShowReply] = $id;
								$response['text'] = $front_msg['REP01'];
							}else{
								$response['text'] = $front_msg['REP02'];
							}
							$response['status'] = $data['status'];
							
							pjAppController::jsonResponse($response);
						}else{
							$response['status'] = 'ERR';
							$response['text'] = $front_err[$err];
							pjAppController::jsonResponse($response);
						}
					}else{
						
						$response['status'] = 'ERR';
						$response['text'] = $front_err[$err];
						pjAppController::jsonResponse($response);
					}
				}
			}
			exit;
		}
	}
	
	public function pjActionVote()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if($this->can_rating == true)
			{
				$reply_id = $_GET['reply_id'];
				$vote =  $_GET['vote'];
				$type = $this->option_arr['o_prevent_multiple_rating'];
				$user_ip = pjUtil::getClientIp();
				switch ($type) {
					case 'ip':
						pjVoteModel::factory()->voteIp($reply_id, $user_ip, $vote);
					break;
					
					case 'cookie':
						pjVoteModel::factory()->voteCookie($reply_id, $vote);
					break;
				}
			}
			exit;
		}
	}
	
	public function pjActionReport()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if($this->option_arr['o_reporting'] == 'yes')
			{
				pjReplyModel::factory()->set('id', $_GET['reply_id'])->modify(array('report' => '1'));
				
				$pjEmail = new pjEmail();
				if ($this->option_arr['o_send_email'] == 'smtp')
				{
					$pjEmail
						->setTransport('smtp')
						->setSmtpHost($this->option_arr['o_smtp_host'])
						->setSmtpPort($this->option_arr['o_smtp_port'])
						->setSmtpUser($this->option_arr['o_smtp_user'])
						->setSmtpPass($this->option_arr['o_smtp_pass']);
				}
				$pjEmail->setContentType('text/html');
				$from = $this->getAdminEmail();
				
				$view_url = PJ_INSTALL_URL . 'index.php?controller=pjAdminReplies&action=pjActionView&id='.$_GET['reply_id'].'&hash='.sha1($_GET['reply_id'] . PJ_SALT);
				
				$search = array("{ReplyViewURL}");
				$replace = array($view_url);
					
				$subject = $this->option_arr['o_admin_email_report_subject'];
				$message = $this->option_arr['o_admin_email_report_message'];
					
				if(!empty($subject) && !empty($message) && !empty($from))
				{
					$subject = str_replace($search, $replace, $subject);
					$message = str_replace($search, $replace, $message);
				
					$pjEmail
						->setTo($from)
						->setFrom($from)
						->setSubject($subject)
						->send($message);
				}
			}
			exit;
		}
	}
	
	public function pjActionLogout()
	{
		if ($this->checkLogin())
		{
			unset($_SESSION[$this->defaultFrontUser]);
		}
		pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionIndex' . (isset($_POST['iframe']) ? '&iframe' : NULL));
	}
	
	public function pjActionBlock()
	{
		
	}
	
	public function pjActionConfirm()
	{
		$this->setLayout('pjActionConfirm');
		if (isset($_POST['confirm']))
		{
			$pjUserModel = pjUserModel::factory();
			$user_arr = $pjUserModel->find($_POST['id'])->getData();
			if (count($user_arr) > 0)
			{
				$sql = "UPDATE `".$pjUserModel->getTable()."` SET status = 'T' WHERE SHA1(CONCAT(`id`, `created`, '".PJ_SALT."')) = '" . $_POST['hash'] . "'";
			
				$pjUserModel->reset()->execute($sql);
				
				$arr = $pjUserModel
					->reset()
					->find($_POST['id'])
					->getData();
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjLoad&action=pjActionConfirm&err=200');
			}
		}else{
			if (isset($_GET['hash']) && isset($_GET['id']))
			{
				$arr = pjUserModel::factory()
					->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`, t2.content as country_title")
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.country_id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->find($_GET['id'])
					->getData();
				if (count($arr) == 0)
				{
					$this->set('status', 2);
				}else{
					if ($arr['status'] == 'T')
					{
						$this->set('status', 4);
					}else{
						$hash = sha1($arr['id'] . $arr['created'] . PJ_SALT);
						if ($_GET['hash'] != $hash)
						{
							$this->set('status', 3);
						}else{
			
							$this->set('arr', $arr);
						}
					}
				}
			}else if (!isset($_GET['err'])) {
				$this->set('status', 1);
			}
		}
	}
	
	public function pjActionRegistrationEmail($id)
	{
		$arr = pjUserModel::factory()
			->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`, t2.content as country_title")
			->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.country_id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
			->find($id)
			->getData();
		
		if(!empty($arr))
		{
			$statuses = __('u_statarr', true);
			
			$pjEmail = new pjEmail();
			if ($this->option_arr['o_send_email'] == 'smtp')
			{
				$pjEmail
					->setTransport('smtp')
					->setSmtpHost($this->option_arr['o_smtp_host'])
					->setSmtpPort($this->option_arr['o_smtp_port'])
					->setSmtpUser($this->option_arr['o_smtp_user'])
					->setSmtpPass($this->option_arr['o_smtp_pass']);
			}
			$pjEmail->setContentType('text/html');
			$from = $this->getAdminEmail();
			
			$confirmlURL = '';
			if($this->option_arr['o_account_confirmation'] == 'email')
			{
				$confirmlURL = PJ_INSTALL_URL . 'index.php?controller=pjLoad&action=pjActionConfirm&id='.$arr['id'].'&hash='.sha1($arr['id'].$arr['created'].PJ_SALT);
			}
			
			$search = array("{FullName}", "{Email}", "{Password}", "{Phone}", "{Website}", "{Country}", "{City}", "{State}", "{Zip}", "{Address}", "{Status}", "{ConfirmURL}");
			$replace = array($arr['name'], $arr['email'], $arr['password'], $arr['phone'], @$arr['website'], @$arr['country_title'], @$arr['city'],@$arr['state'], @$arr['zip'], @$arr['address'], $statuses[$arr['status']], $confirmlURL);
			
			$subject = $this->option_arr['o_admin_email_register_subject'];
			$message = $this->option_arr['o_admin_email_register_message'];
			
			if(!empty($subject) && !empty($message) && !empty($from))
			{
				$subject = str_replace($search, $replace, $subject);
				$message = str_replace($search, $replace, $message);

				$pjEmail
					->setTo($from)
					->setFrom($from)
					->setSubject($subject)
					->send($message);
			}
			if($this->option_arr['o_account_confirmation'] == 'email' && !empty($subject) && !empty($message) && !empty($arr['email']))
			{
				$subject = $this->option_arr['o_email_register_subject'];
				$message = $this->option_arr['o_email_register_message'];
				
				$subject = str_replace($search, $replace, $subject);
				$message = str_replace($search, $replace, $message);
				
				$pjEmail
					->setTo($arr['email'])
					->setFrom($from)
					->setSubject($subject)
					->send($message);
			}
		}
	}
}
?>