<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjVoteModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'votes';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'reply_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'ip', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'value', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'created', 'type' => 'datetime', 'default' => ':NULL')
	);
	
	public static function factory($attr=array())
	{
		return new pjVoteModel($attr);
	}
	
	public function voteCookie($reply_id, $vote_value)
	{
		$pjReplyModel = pjReplyModel::factory();
	
		$is_can_vote = true;
		$is_update = 0;
		if(isset($_COOKIE["SForum_Vote" + $reply_id]))
		{
			if($_COOKIE["SForum_Vote" + $reply_id] == $vote_value)
			{
				$is_can_vote = false;
			}else{
				$is_update = 1;
			}
		}
		if($is_can_vote == true)
		{
			$arr = $pjReplyModel->find($reply_id)->getData();
				
			$expire=time() + 60*60*24;
			setcookie("SForum_Vote" + $reply_id, $vote_value, $expire);
			if(!empty($arr))
			{
				$data = array();
				if($is_update == 1){
					if($vote_value == 'up')
					{
						$data['likes'] = intval($arr['likes']) + 1;
						$data['dislikes'] = intval($arr['dislikes']) - 1;
					}else{
						$data['likes'] = intval($arr['likes']) - 1;
						$data['dislikes'] = intval($arr['dislikes']) + 1;
					}
					$pjReplyModel->reset()->set('id', $reply_id)->modify($data);
				}else{
					if($vote_value == 'up')
					{
						$data['likes'] = intval($arr['likes']) + 1;
					}else{
						$data['dislikes'] = intval($arr['dislikes']) + 1;
					}
					$pjReplyModel->reset()->set('id', $reply_id)->modify($data);
				}
	
			}
		}
		$arr =	$pjReplyModel->reset()->find($reply_id)->getData();
		
		pjAppController::jsonResponse($arr);
	}
	
	public function voteIp($reply_id, $user_ip, $vote_value)
	{
		$pjReplyModel = pjReplyModel::factory();
		
		$arr = $pjReplyModel->find($reply_id)->getData();
	
		$vote_arr = $this
			->reset()
			->where("reply_id", $reply_id)
			->where("ip", $user_ip)
			->where("DATE_ADD(created, INTERVAL 1 DAY) >= NOW()")
			->findAll()
			->getData();
		
		$update_vote_date = true;
		if(!empty($vote_arr))
		{
			$val = $vote_arr[0]['value'];
			if($val != $vote_value)
			{
				if($vote_value == 'up')
				{
					$data['likes'] = intval($arr['likes']) + 1;
					$data['dislikes'] = intval($arr['dislikes']) - 1;
				}else{
					$data['likes'] = intval($arr['likes']) - 1;
					$data['dislikes'] = intval($arr['dislikes']) + 1;
				}
				$pjReplyModel->reset()->set('id', $reply_id)->modify($data);
			}else{
				$update_vote_date = false;
			}
		}else{
			if($vote_value == 'up')
			{
				$data['likes'] = intval($arr['likes']) + 1;
			}else{
				$data['dislikes'] = intval($arr['dislikes']) + 1;
			}
			$pjReplyModel->reset()->set('id', $reply_id)->modify($data);
		}
		
		if($update_vote_date == true)
		{
			$this->where("reply_id", $reply_id)->where("id", $user_ip)->eraseAll();
			$vdata = array();
			$vdata['reply_id'] = $reply_id;
			$vdata['ip'] = $user_ip;
			$vdata['value'] = $vote_value;
			$vdata['created'] = date('Y-m-d H:i:s');
			$this->reset()->setAttributes($vdata)->insert();
		}
	
		$arr =	$pjReplyModel->reset()->find($reply_id)->getData();
		
		pjAppController::jsonResponse($arr);
	}
}
?>