<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat questions">
				<div class="info">
					<abbr><?php echo $tpl['cnt_questions'];?></abbr>
					<?php $tpl['cnt_questions'] != 1 ? __('lblDashQuestions') : __('lblDashQuestion');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat replies">
				<div class="info">
					<abbr><?php echo $tpl['cnt_replies'];?></abbr>
					<?php $tpl['cnt_replies'] != 1 ? __('lblDashReplies') : __('lblDashReply');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat users">
				<div class="info">
					<abbr><?php echo $tpl['cnt_users'];?></abbr>
					<?php $tpl['cnt_users'] != 1 ? __('lblDashUsers') : __('lblDashUser');?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblDashLatestQuestions');?></div>
			<div class="dashboard_column_top"><?php __('lblDashLatestReplies');?></div>
			<div class="dashboard_column_top"><?php __('lblDashLatestUsers');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['question_arr']) > 0)
					{
						foreach($tpl['question_arr'] as $v)
						{
							?>
							<div class="dashboard_row">							
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminQuestions&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['question']);?></a></label>
								<label><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['created']));?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('lblDashNoQuestionsFound');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['reply_arr']) > 0)
					{
						foreach($tpl['reply_arr'] as $v)
						{
							?>
							<div class="dashboard_row">							
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReplies&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo stripslashes($v['description']);?></a></label>
								<label><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['created']));?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('lblDashNoRepliesFound');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['user_arr']) > 0)
					{
						foreach($tpl['user_arr'] as $v)
						{
							$can_edit = true;
							if($controller->isEditor() && $v['role_id'] == 1)
							{
								$can_edit = false;
							}
							?>
							<div class="dashboard_row">
								<?php
								if($can_edit == true)
								{ 
									?>							
									<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminUsers&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo stripslashes($v['name']);?></a></label>
									<?php
								}else{
									?><label><?php echo pjSanitize::html($v['name']);?></label><?php
								} 
								?>
								<label><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['created']));?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('lblDashNoRepliesFound');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format']); ?></div>
		</div>
	</div>
	<?php
}
?>