<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	
	pjUtil::printNotice(__('infoAddQuestionTitle', true), __('infoAddQuestionDesc', true));
	
	$statuses = __('statuses', true);
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminQuestions&amp;action=pjActionCreate" method="post" id="frmCreateQuestion" class="pj-form form">
		<input type="hidden" name="question_create" value="1" />
		
		<div class="clear_both">
			<p>
				<label class="title"><?php __('lblCategory'); ?></label>
				<span class="inline_block">
					<?php 
					if(count($tpl['category_arr']) > 0)
					{
						?>
						<select id="category_id" name="category_id" class="pj-form-field w300 required" data-msg-required="<?php __('lblFieldRequired');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['category_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
							}
							?>
						</select>
						<?php
					}else{
						$message = __('lblNoCategoriesMessage', true);
						$message = str_replace("{STAG}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminCategories&amp;action=pjActionCreate">', $message);
						$message = str_replace("{ETAG}", "</a>", $message);
						?><label class="block float_left t5"><?php echo $message;?></label><?php
					} 
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblPostedBy');?></label>
				<span class="inline_block">
					<span class="block float_left t5 r20">
						<input type="radio" id="registered" name="posted_by" value="registered" checked="checked" class="block float_left r3"/><label for="registered" class="block float_left"><?php __('lblExistingUser');?></label>
					</span>
					<span class="block float_left t5 r20">
						<input type="radio" id="unregistered" name="posted_by" value="unregistered" class="block float_left r3"/><label for="unregistered" class="block float_left"><?php __('lblUnregisteredUser');?></label>
					</span>
				</span>
			</p>
			<p class="pjSFExisting">
				<label class="title"><?php __('lblUser'); ?></label>
				<span class="inline_block">
					<select id="user_id" name="user_id" class="pj-form-field w200 required" data-msg-required="<?php __('lblFieldRequired');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach($tpl['user_arr'] as $v)
						{
							?><option value="<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['name']);?></option><?php
						} 
						?>
					</select>
				</span>
			</p>
			<p class="pjSFUnregistered" style="display: none;">
				<label class="title"><?php __('lblName'); ?></label>
				<span class="inline_block">
					<input type="text" name="name" id="name" class="pj-form-field w300" data-msg-required="<?php __('lblFieldRequired');?>"/>
				</span>
			</p>
			<p class="pjSFUnregistered" style="display: none;">
				<label class="title"><?php __('email'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
					<input type="text" name="email" id="email" class="pj-form-field w300" data-msg-required="<?php __('lblFieldRequired');?>" data-msg-email="<?php __('lblEmailInvalid');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblQuestion'); ?></label>
				<span class="inline_block">
					<input type="text" name="question" class="pj-form-field w300 required" data-msg-required="<?php __('lblFieldRequired');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblDescription'); ?></label>
				<span class="inline_block">
					<textarea name="description" class="pj-form-field w500 h150 required" data-msg-required="<?php __('lblFieldRequired');?>"></textarea>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('lblFieldRequired');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach ($statuses as $k => $v)
						{
							?><option value="<?php echo $k; ?>"<?php echo $k == 'New' ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminQuestions&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	</script>
	<?php
}
?>