<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	
	pjUtil::printNotice(__('infoUpdateQuestionTitle', true), __('infoUpdateQuestionDesc', true));
	
	$statuses = __('statuses', true);
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminQuestions&amp;action=pjActionUpdate" method="post" id="frmUpdateQuestion" class="pj-form form">
		<input type="hidden" name="question_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>" />
		
		<div class="clear_both">
			<p>
				<label class="title"><?php __('lblDateTime'); ?></label>
				<span class="inline_block">
					<label class="block t5"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']));?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblIpAddress'); ?></label>
				<span class="inline_block">
					<label class="block t5"><?php echo pjSanitize::html($tpl['arr']['ip']);?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblReplies'); ?></label>
				<span class="inline_block">
					<?php
					if($tpl['arr']['cnt_replies'] == 0)
					{ 
						?><label class="block t5"><?php echo $tpl['arr']['cnt_replies'];?></label><?php
					}else{
						?><label class="block t5"><a href="<?php echo $_SERVER['PHP_SELF'];?>?controller=pjAdminReplies&amp;action=pjActionIndex&question_id=<?php echo $tpl['arr']['id'];?>"><?php echo $tpl['arr']['cnt_replies'];?></a></label><?php
					} 
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblViews'); ?></label>
				<span class="inline_block">
					<label class="block t5"><?php echo intval($tpl['arr']['counts']);?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblCategory'); ?></label>
				<span class="inline_block">
					<select id="category_id" name="category_id" class="pj-form-field w300 required" data-msg-required="<?php __('lblFieldRequired');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach ($tpl['category_arr'] as $k => $v)
						{
							?><option value="<?php echo $v['id']; ?>"<?php echo $v['id'] == $tpl['arr']['category_id'] ? ' selected="selected"' : null;?>><?php echo $v['name']; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblPostedBy');?></label>
				<span class="inline_block">
					<span class="block float_left t5 r20">
						<input type="radio" id="registered" name="posted_by" value="registered"<?php echo !empty($tpl['arr']['user_id']) ? ' checked="checked"' : NULL; ?> class="block float_left r3"/><label for="registered" class="block float_left"><?php __('lblExistingUser');?></label>
					</span>
					<span class="block float_left t5 r20">
						<input type="radio" id="unregistered" name="posted_by" value="unregistered"<?php echo empty($tpl['arr']['user_id']) ? ' checked="checked"' : NULL; ?> class="block float_left r3"/><label for="unregistered" class="block float_left"><?php __('lblUnregisteredUser');?></label>
					</span>
				</span>
			</p>
			<p class="pjSFExisting" style="display:<?php echo !empty($tpl['arr']['user_id']) ? 'block' : 'none'; ?>">
				<label class="title"><?php __('lblUser'); ?></label>
				<span class="inline_block">
					<select id="user_id" name="user_id" class="pj-form-field w200<?php echo !empty($tpl['arr']['user_id']) ? ' required' : NULL; ?>" data-msg-required="<?php __('lblFieldRequired');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach($tpl['user_arr'] as $v)
						{
							?><option value="<?php echo $v['id'];?>"<?php echo $tpl['arr']['user_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo pjSanitize::html($v['name']);?></option><?php
						} 
						?>
					</select>
				</span>
			</p>
			<p class="pjSFUnregistered" style="display:<?php echo empty($tpl['arr']['user_id']) ? 'block' : 'none'; ?>;">
				<label class="title"><?php __('lblName'); ?></label>
				<span class="inline_block">
					<input type="text" name="name" id="name" value="<?php echo pjSanitize::html($tpl['arr']['name']);?>" class="pj-form-field w300<?php echo empty($tpl['arr']['user_id']) ? ' required' : NULL; ?>" data-msg-required="<?php __('lblFieldRequired');?>"/>
				</span>
			</p>
			<p class="pjSFUnregistered" style="display:<?php echo empty($tpl['arr']['user_id']) ? 'block' : 'none'; ?>;">
				<label class="title"><?php __('email'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
					<input type="text" name="email" id="email" class="pj-form-field w300<?php echo empty($tpl['arr']['user_id']) ? ' required email' : NULL; ?>" value="<?php echo pjSanitize::html($tpl['arr']['email']);?>" data-msg-required="<?php __('lblFieldRequired');?>" data-msg-email="<?php __('lblEmailInvalid');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblQuestion'); ?></label>
				<span class="inline_block">
					<input type="text" name="question" value="<?php echo pjSanitize::html($tpl['arr']['question']);?>" class="pj-form-field w300 required" data-msg-required="<?php __('lblFieldRequired');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblDescription'); ?></label>
				<span class="inline_block">
					<textarea name="description" class="pj-form-field w500 h150 required" data-msg-required="<?php __('lblFieldRequired');?>"><?php echo stripslashes($tpl['arr']['description']);?></textarea>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('lblFieldRequired');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach ($statuses as $k => $v)
						{
							?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminQuestions&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	</script>
	<?php
}
?>