<?php
mt_srand();
$index = mt_rand(1, 9999);
?>
<div id="pjWrapper">
	<div class="container-fluid pjCfContainer">
		<?php include_once PJ_VIEWS_PATH . 'pjLoad/elements/header.php';?>
		
		<div class="panel panel-default pjCfBody pjCfForm pjCfFormAccess pjCfFormRegister">
			<header class="panel-heading text-center pjCfFormHead">
				<p class="panel-title pjCfFormTitle"><?php __('front_ask_question');?></p><!-- /.panel-title pjCfFormTitle -->
			</header><!-- /.panel-heading text-center pjCfFormHead -->
			
			<div class="panel-body pjCfFormBody">
				<?php
				if($tpl['status'] == 'OK')
				{ 
					?>
					<form id="pjSFAskForm_<?php echo $index;?>" action="<?php echo $_SERVER['PHP_SELF'];?>?controller=pjLoad&amp;action=pjActionAsk" method="post" data-toggle="validator" role="form">
						<input type="hidden" value="1" name="ask_question">
						<div class="row">
							<div class="col-lg-offset-3 col-lg-6 col-md-offset-3 col-md-6 col-sm-offset-2 col-sm-8 col-xs-12">
								<?php
								if(isset($tpl['err']))
								{
									$front_err = pjSanitize::clean(__('front_err', true));
									$msg = $front_err[$tpl['err']];
									?>
									<div class="alert alert-danger" role="alert"><?php echo $msg;?></div>
									<?php
								}
								if(isset($tpl['msg']))
								{
									$front_msg = pjSanitize::clean(__('front_msg', true));
									?>
									<div class="alert alert-success" role="alert"><?php echo $front_msg[$tpl['msg']];?></div>
									<?php
								} 
								
								if(!$controller->checkLogin())
								{ 
									?>
									<div class="form-group">
										<label for=""><?php __('front_full_name');?>: </label>
							
										<input type="text" name="name" class="form-control required" data-msg-required="<?php __('front_field_required');?>"/>
										
										<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
									</div><!-- /.form-group -->
									<div class="form-group">
										<label for=""><?php __('front_email_address');?>: </label>
										
										<input type="email" name="email" class="form-control required email" data-msg-required="<?php __('front_field_required');?>" data-msg-email="<?php __('front_email_invalid');?>" data-msg-remote="<?php __('front_email_in_used');?>"/>
										<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
									</div><!-- /.form-group -->
									<?php
								}else{
									$USER = $_SESSION[$controller->defaultFrontUser]
									?>
									<div class="form-group">
										<label for=""><?php __('front_full_name');?>: <?php echo pjSanitize::html($USER['name']);?></label>
									</div><!-- /.form-group -->
									<div class="form-group">
										<label for=""><?php __('front_email_address');?>: <?php echo pjSanitize::html($USER['email']);?></label>
									</div><!-- /.form-group -->
									<?php
								} 
								?>
								<div class="form-group">
									<label for=""><?php __('front_question');?>: </label>
						
									<input type="text" name="question" class="form-control required" data-msg-required="<?php __('front_field_required');?>"/>
									
									<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
								</div><!-- /.form-group -->
								<div class="form-group">
									<label for=""><?php __('front_description');?>: </label>
						
									<textarea name="description" cols="30" rows="10" class="form-control required" data-msg-required="<?php __('front_field_required');?>"></textarea>
									
									<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
								</div><!-- /.form-group -->
								<div class="form-group">
									<label for=""><?php __('front_category');?>: </label>
									
									<select name="category_id" class="form-control required">
										<option value="">-- <?php __('front_choose'); ?>--</option>
										<?php
										foreach ($tpl['category_arr'] as $k => $v)
										{
											?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
										}
										?>
									</select>
								</div><!-- /.form-group -->
								<?php
								if($tpl['use_captcha'] == true)
								{ 
									?>
									<div class="form-group pjCfCaptcha">
										<label for=""><?php __('front_captcha');?>: </label>
										<img class="pjSFFormCaptchaImage" src="<?php echo PJ_INSTALL_FOLDER; ?>index.php?controller=pjFront&amp;action=pjActionCaptcha&amp;rand=<?php echo rand(1, 999999); ?>" alt="CAPTCHA"/>
										<input type="text" name="captcha" class="form-control required" maxlength="6" autocomplete="off" data-msg-required="<?php __('front_field_required');?>" data-msg-remote="<?php __('front_captcha_incorrect');?>"/>
										<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
									</div><!-- /.form-group pjCfCaptcha -->
									<?php
								} 
								?>
								<div class="form-group">
									<button type="submit" class="btn btn-default pjCfBtn pjCfBtnPrimary"><?php __('front_btn_save');?></button>
								</div><!-- /.form-group -->
							</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-12 pjCfFormContent -->
						</div><!-- /.row -->
					</form>
					<?php
				}else{
					__('front_login_to_ask');
				} 
				?>
			</div><!-- /.panel-body pjCfFormBody -->
			
		</div><!-- /.panel panel-default pjCfBody pjCfForm pjCfFormAccess pjCfFormRegister -->
		
	</div><!-- /.container-fluid pjCfContainer -->
</div><!-- /#pjWrapper -->

<?php include_once PJ_VIEWS_PATH . 'pjLoad/elements/loadjs.php';?>