DROP TABLE IF EXISTS `catering_orders`;
CREATE TABLE IF NOT EXISTS `catering_orders` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` varchar(255) default NULL,
  `delivery_dt` datetime DEFAULT NULL,
  `subtotal` decimal(9,2) unsigned default NULL,
  `tax` decimal(9,2) unsigned default NULL,
  `total` decimal(9,2) unsigned default NULL,
  `deposit` decimal(9,2) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `status` enum('confirmed','cancelled','pending') default 'pending',
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `created` datetime default NULL,
  `modified` datetime default NULL,
  `ip` varchar(255) default NULL,
  `c_title` varchar(255) default NULL,
  `c_name` varchar(255) default NULL,
  `c_phone` varchar(255) default NULL,
  `c_email` varchar(255) default NULL,
  `c_company` varchar(255) default NULL,
  `c_notes` text default NULL,
  `c_address` varchar(255) default NULL,
  `c_city` varchar(255) default NULL,
  `c_state` varchar(255) default NULL,
  `c_zip` varchar(255) default NULL,
  `c_country` int(10) unsigned default NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uuid` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_orders_payments`;
CREATE TABLE IF NOT EXISTS `catering_orders_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `order_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `order_id` (`order_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_orders_products`;
CREATE TABLE IF NOT EXISTS `catering_orders_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned DEFAULT NULL,
  `type` enum('products','packages') DEFAULT NULL,
  `product_id` int(10) DEFAULT NULL,
  `package_id` int(10) DEFAULT NULL,
  `size_id` int(10) DEFAULT NULL,
  `unit_price` decimal(9,2) unsigned DEFAULT NULL,
  `qty` int(10) DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `package_id` (`package_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_packages`;
CREATE TABLE IF NOT EXISTS `catering_packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `people` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_packages_products`;
CREATE TABLE IF NOT EXISTS `catering_packages_products` (
  `package_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `qty` int(10) unsigned DEFAULT NULL,
  `size_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`package_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_products`;
CREATE TABLE IF NOT EXISTS `catering_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `parent_category_id` int(10) unsigned DEFAULT NULL,
  `set_different_sizes` enum('T','F') DEFAULT 'F',
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `order` int(10) unsigned DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_products_prices`;
CREATE TABLE IF NOT EXISTS `catering_products_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,	
  `product_id` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_products_categories`;
CREATE TABLE IF NOT EXISTS `catering_products_categories` (
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_categories`;
CREATE TABLE IF NOT EXISTS `catering_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `order` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_fields`;
CREATE TABLE IF NOT EXISTS `catering_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_multi_lang`;
CREATE TABLE IF NOT EXISTS `catering_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_options`;
CREATE TABLE IF NOT EXISTS `catering_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_roles`;
CREATE TABLE IF NOT EXISTS `catering_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catering_users`;
CREATE TABLE IF NOT EXISTS `catering_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `catering_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'booking_confirmation_title', 'backend', 'Lable / Send Confirmation Email', 'script', NULL),
(5, 'booking_message', 'backend', 'Label / Email message', 'script', NULL),
(6, 'booking_subject', 'backend', 'Label / Email subject', 'script', NULL),
(7, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(8, 'btnAddCategory', 'backend', 'Button / + Add category', 'script', NULL),
(9, 'btnAddOrder', 'backend', 'Button / + Add order', 'script', NULL),
(10, 'btnAddPackage', 'backend', 'Button / + Add package', 'script', NULL),
(11, 'btnAddProduct', 'backend', 'Button / + Add product', 'script', NULL),
(12, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(13, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(14, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(15, 'btnCalculateTotal', 'backend', 'Button / Calculate Total', 'script', NULL),
(16, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(17, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(18, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(19, 'btnLogin', 'backend', 'Login', 'script', NULL),
(20, 'btnPlusAddProduct', 'backend', 'Button / + Add product', 'script', NULL),
(21, 'btnRemove', 'backend', 'Button / Remove', 'script', NULL),
(22, 'btnReset', 'backend', 'Reset', 'script', NULL),
(23, 'btnSave', 'backend', 'Save', 'script', NULL),
(24, 'btnSearch', 'backend', 'Search', 'script', NULL),
(25, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(26, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(27, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(28, 'created', 'backend', 'Created', 'script', NULL),
(29, 'dash_add_order', 'backend', 'Dash / + Add Order', 'script', NULL),
(30, 'dash_add_package', 'backend', 'Dash / + Add Package', 'script', NULL),
(31, 'dash_add_product', 'backend', 'Dash / + Add Product', 'script', NULL),
(32, 'dash_delivery_date', 'backend', 'Dash / Delivery date', 'script', NULL),
(33, 'dash_email_notifications', 'backend', 'Dash / Set-up email notifications', 'script', NULL),
(34, 'dash_latest_orders', 'backend', 'Dash / Latest orders', 'script', NULL),
(35, 'dash_manage_order_form', 'backend', 'Dash / Manage Order Form', 'script', NULL),
(36, 'dash_no_orders_found', 'backend', 'Dash / No orders found.', 'script', NULL),
(37, 'dash_orders_delivery_today', 'backend', 'Dash / orders to delivery today', 'script', NULL),
(38, 'dash_orders_received_today', 'backend', 'Dash / orders received today', 'script', NULL),
(39, 'dash_order_delivery_today', 'backend', 'Dash / order to delivery today', 'script', NULL),
(40, 'dash_order_for_delivery', 'backend', 'Dash / Order for delivery', 'script', NULL),
(41, 'dash_order_received_today', 'backend', 'Dash / order received today', 'script', NULL),
(42, 'dash_quick_links', 'backend', 'Dash / Quick links', 'script', NULL),
(43, 'dash_setup_payment_options', 'backend', 'Dash / Set-up Payment Options', 'script', NULL),
(44, 'dash_total_orders', 'backend', 'Dash / total orders', 'script', NULL),
(45, 'dash_view_orders', 'backend', 'Dash / View Orders', 'script', NULL),
(46, 'dash_view_products', 'backend', 'Dash / View Products', 'script', NULL),
(47, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(48, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(49, 'email', 'backend', 'E-Mail', 'script', NULL),
(50, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(51, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(52, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(53, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(54, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(55, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(56, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(57, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(58, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(59, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(60, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(61, 'gridEmptyBody', 'backend', 'Grid / No records selected', 'script', NULL),
(62, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(63, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(64, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(65, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(66, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(67, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(68, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(69, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(70, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(71, 'infoAddCategoryDesc', 'backend', 'Infobox / Add category', 'script', NULL),
(72, 'infoAddCategoryTitle', 'backend', 'Infobox / Add category', 'script', NULL),
(73, 'infoAddPackageDesc', 'backend', 'Infobox / Add package', 'script', NULL),
(74, 'infoAddPackageTitle', 'backend', 'Infobox / Add package', 'script', NULL),
(75, 'infoAddProductDesc', 'backend', 'Infobox / Add product', 'script', NULL),
(76, 'infoAddProductTitle', 'backend', 'Infobox / Add product', 'script', NULL),
(77, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(78, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(79, 'infoCategoriesDesc', 'backend', 'Infobox / List of categories', 'script', NULL),
(80, 'infoCategoriesTitle', 'backend', 'Infobox / List of categories', 'script', NULL),
(81, 'infoClientDetailsDesc', 'backend', 'Infobox / Client details', 'script', NULL),
(82, 'infoClientDetailsTitle', 'backend', 'Infobox / Client details', 'script', NULL),
(83, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(84, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(85, 'infoInstallCodeDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(86, 'infoInstallCodeTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(87, 'infoOrderDetailsDesc', 'backend', 'Infobox / Order details', 'script', NULL),
(88, 'infoOrderDetailsTitle', 'backend', 'Infobox / Order details', 'script', NULL),
(89, 'infoOrderFormDesc', 'backend', 'Infobox / Order form', 'script', NULL),
(90, 'infoOrderFormTitle', 'backend', 'Infobox / Order form', 'script', NULL),
(91, 'infoOrdersDesc', 'backend', 'Infobox / Order options', 'script', NULL),
(92, 'infoOrdersListDesc', 'backend', 'Infobox / List of orders', 'script', NULL),
(93, 'infoOrdersListTitle', 'backend', 'Infobox / List of orders', 'script', NULL),
(94, 'infoOrdersTitle', 'backend', 'Infobox / Order options', 'script', NULL),
(95, 'infoPackagesDesc', 'backend', 'Infobox / Packages', 'script', NULL),
(96, 'infoPackagesTitle', 'backend', 'Infobox / Packages', 'script', NULL),
(97, 'infoPreviewDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(98, 'infoPreviewInstallDesc', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(99, 'infoPreviewInstallTitle', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(100, 'infoPreviewTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(101, 'infoProductsDesc', 'backend', 'Infobox / List of products', 'script', NULL),
(102, 'infoProductsTitle', 'backend', 'Infobox / List of products', 'script', NULL),
(103, 'infoTermsDesc', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(104, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(105, 'infoToAdministratorsDesc', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(106, 'infoToAdministratorsTitle', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(107, 'infoToCustomersDesc', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(108, 'infoToCustomersTitle', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(109, 'infoUpdateCategoryDesc', 'backend', 'Infobox / Update category', 'script', NULL),
(110, 'infoUpdateCategoryTitle', 'backend', 'Infobox / Update category', 'script', NULL),
(111, 'infoUpdatePackageDesc', 'backend', 'Infobox / Update package', 'script', NULL),
(112, 'infoUpdatePackageTitle', 'backend', 'Infobox / Update package', 'script', NULL),
(113, 'infoUpdateProductDesc', 'backend', 'Infobox / Update product', 'script', NULL),
(114, 'infoUpdateProductTitle', 'backend', 'Infobox / Update product', 'script', NULL),
(115, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(116, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(117, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(118, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(119, 'lblAddAsMainCategory', 'backend', 'Label / Add as main category', 'script', NULL),
(120, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(121, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(122, 'lblAllCategories', 'backend', 'Label / All categories', 'script', NULL),
(123, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(124, 'lblCapacity', 'backend', 'Label / Capacity', 'script', NULL),
(125, 'lblCategory', 'backend', 'Label / Category', 'script', NULL),
(126, 'lblCategoryTitle', 'backend', 'Label / Category title', 'script', NULL),
(127, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(128, 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL),
(129, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(130, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(131, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(132, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(133, 'lblCount', 'backend', 'Label / Count', 'script', NULL),
(134, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(135, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(136, 'lblDays', 'backend', 'Days', 'script', NULL),
(137, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(138, 'lblDeleteImage', 'backend', 'Label / Delete image', 'script', NULL),
(139, 'lblDeleteImageConfirm', 'backend', 'Label / Delete image', 'script', NULL),
(140, 'lblDeliveryDateTime', 'backend', 'Label / Delivery date', 'script', NULL),
(141, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(142, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(143, 'lblError', 'backend', 'Error', 'script', NULL),
(144, 'lblExport', 'backend', 'Export', 'script', NULL),
(145, 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', NULL),
(146, 'lblFilterBy', 'backend', 'Label / Filter by', 'script', NULL),
(147, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(148, 'lblHere', 'backend', 'Label / here', 'script', NULL),
(149, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(150, 'lblInstallCode', 'backend', 'Label / Install code', 'script', NULL),
(151, 'lblIp', 'backend', 'IP address', 'script', NULL),
(152, 'lblIpAddress', 'backend', 'Label / Ip address', 'script', NULL),
(153, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(154, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(155, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(156, 'lblName', 'backend', 'Name', 'script', NULL),
(157, 'lblNo', 'backend', 'No', 'script', NULL),
(158, 'lblNoCategoriesFound', 'backend', 'Label / No categories found', 'script', NULL),
(159, 'lblNoOrderWithSuchID', 'backend', 'Label / There is no order with such ID.', 'script', NULL),
(160, 'lblNoProductsMessage', 'backend', 'Label / No product message', 'script', NULL),
(161, 'lblNotifications', 'backend', 'Label / Notifications', 'script', NULL),
(162, 'lblOption', 'backend', 'Option', 'script', NULL),
(163, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(164, 'lblPackage', 'backend', 'Label / Package', 'script', NULL),
(165, 'lblPackageTitle', 'backend', 'Label / Title', 'script', NULL),
(166, 'lblParentCategory', 'backend', 'Label / Parent category', 'script', NULL),
(167, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(168, 'lblPeople', 'backend', 'Label / People', 'script', NULL),
(169, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(170, 'lblPositiveNumber', 'backend', 'Label / Please enter positive number.', 'script', NULL),
(171, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(172, 'lblPrintOrder', 'backend', 'Label / Print order', 'script', NULL),
(173, 'lblProduct', 'backend', 'Label /Product', 'script', NULL),
(174, 'lblQty', 'backend', 'Label / Qty', 'script', NULL),
(175, 'lblQuantity', 'backend', 'Label / Quantity', 'script', NULL),
(176, 'lblResvAddress', 'backend', 'Label / Address', 'script', NULL),
(177, 'lblResvCity', 'backend', 'Label / City', 'script', NULL),
(178, 'lblResvCompany', 'backend', 'Label / Company', 'script', NULL),
(179, 'lblResvCountry', 'backend', 'Label / Country', 'script', NULL),
(180, 'lblResvEmail', 'backend', 'Label / Email', 'script', NULL),
(181, 'lblResvName', 'backend', 'Label / Name', 'script', NULL),
(182, 'lblResvNotes', 'backend', 'Label / Special instructions', 'script', NULL),
(183, 'lblResvPhone', 'backend', 'Label / Phone', 'script', NULL),
(184, 'lblResvState', 'backend', 'Label / State', 'script', NULL),
(185, 'lblResvTitle', 'backend', 'Label / Title', 'script', NULL),
(186, 'lblResvZip', 'backend', 'Label / Zip', 'script', NULL),
(187, 'lblRole', 'backend', 'Role', 'script', NULL),
(188, 'lblSameCategory', 'backend', 'Label / Category title is already used.', 'script', NULL),
(189, 'lblSamePackage', 'backend', 'Label / Package is already used.', 'script', NULL),
(190, 'lblSelectPackage', 'backend', 'Label / Select package', 'script', NULL),
(191, 'lblSelectPackageHint', 'backend', 'Label / Please select package.', 'script', NULL),
(192, 'lblSelectProduct', 'backend', 'Label / Select product', 'script', NULL),
(193, 'lblSelectProductHint', 'backend', 'Label / Please select product.', 'script', NULL),
(194, 'lblSelectSize', 'backend', 'Label / Select size', 'script', NULL),
(195, 'lblSendEmailConfirmation', 'backend', 'Label / Send Confirmation Email', 'script', NULL),
(196, 'lblSetDifferentSizes', 'backend', 'Label / Set different sizes', 'script', NULL),
(197, 'lblSize', 'backend', 'Label / Size', 'script', NULL),
(198, 'lblSizePrice', 'backend', 'Label / Size & price', 'script', NULL),
(199, 'lblStatus', 'backend', 'Status', 'script', NULL),
(200, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(201, 'lblSuitableFor', 'backend', 'Label / Suitable for', 'script', NULL),
(202, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(203, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(204, 'lblType', 'backend', 'Type', 'script', NULL),
(205, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(206, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(207, 'lblValue', 'backend', 'Value', 'script', NULL),
(208, 'lblYes', 'backend', 'Yes', 'script', NULL),
(209, 'legendOrderDetails', 'backend', 'Legend / Order details', 'script', NULL),
(210, 'legendPackages', 'backend', 'Legend / Packages', 'script', NULL),
(211, 'legendProducts', 'backend', 'Legend / Products', 'script', NULL),
(212, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(213, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(214, 'locales', 'backend', 'Languages', 'script', NULL),
(215, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(216, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(217, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(218, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(219, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(220, 'menuCategories', 'backend', 'Menu / Categories', 'script', NULL),
(221, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(222, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(223, 'menuInstallPreview', 'backend', 'Menu / Install & Preview', 'script', NULL),
(224, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(225, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(226, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(227, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(228, 'menuOrders', 'backend', 'Menu / Orders', 'script', NULL),
(229, 'menuPackages', 'backend', 'Menu / Packages', 'script', NULL),
(230, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(231, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(232, 'menuProducts', 'backend', 'Menu / Products', 'script', NULL),
(233, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(234, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(235, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(236, 'opt_o_admin_email_cancel_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(237, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / New order confirmation message', 'script', NULL),
(238, 'opt_o_admin_email_payment_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(239, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / Order reminder SMS', 'script', NULL),
(240, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment reminder SMS', 'script', NULL),
(241, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(242, 'opt_o_allow_bank', 'backend', 'Options / Provide Bank account details for wire transfers', 'script', NULL),
(243, 'opt_o_allow_cash', 'backend', 'Options / Allow cash payments', 'script', NULL),
(244, 'opt_o_allow_creditcard', 'backend', 'Options / Collect Credit Card details for offline processing', 'script', NULL),
(245, 'opt_o_allow_paypal', 'backend', 'Options / Allow payments with PayPal', 'script', NULL),
(246, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(247, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(248, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(249, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(250, 'opt_o_bank_account', 'backend', 'Options / Bank Account', 'script', NULL),
(251, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(252, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(253, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(254, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(255, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(256, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(257, 'opt_o_bf_include_name', 'backend', 'Options / Name', 'script', NULL),
(258, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(259, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(260, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(261, 'opt_o_bf_include_title', 'backend', 'Options / Title', 'script', NULL),
(262, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(263, 'opt_o_booking_status', 'backend', 'Options / All orders which are only made but NOT paid will be set with the following status', 'script', NULL),
(264, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(265, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(266, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(267, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(268, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(269, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(270, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(271, 'opt_o_email_confirmation', 'backend', 'Options / New order received email', 'script', NULL),
(272, 'opt_o_email_confirmation_message', 'backend', 'Options / New order confirmation message', 'script', NULL),
(273, 'opt_o_email_confirmation_subject', 'backend', 'Options / New order confirmation subject', 'script', NULL),
(274, 'opt_o_email_confirmation_text', 'backend', 'Options / New order received email', 'script', NULL),
(275, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(276, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(277, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(278, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(279, 'opt_o_payment_disable', 'backend', 'Options / Select "Yes" if you want to disable payments and only collect order details ', 'script', NULL),
(280, 'opt_o_payment_status', 'backend', 'Options / All orders which are made and paid will be set with the following status', 'script', NULL),
(281, 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL),
(282, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(283, 'opt_o_sms_confirmation_message', 'backend', 'Options / Order reminder SMS', 'script', NULL),
(284, 'opt_o_sms_payment_message', 'backend', 'Options / Payment reminder SMS', 'script', NULL),
(285, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(286, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(287, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(288, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(289, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(290, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(291, 'opt_o_thankyou_page', 'backend', 'Options / URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script', NULL),
(292, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(293, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(294, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(295, 'pass', 'backend', 'Password', 'script', NULL),
(296, 'pj_digits_validation', 'backend', 'Label / Please enter only digits.', 'script', NULL),
(297, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(298, 'pj_email_validation', 'backend', 'Label / Please enter a valid email address.', 'script', NULL),
(299, 'pj_number_validation', 'backend', 'Label / Please enter a valid number.', 'script', NULL),
(300, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(301, 'tabClientDetails', 'backend', 'Tab / Client Details', 'script', NULL),
(302, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(303, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(304, 'tabOrderDetails', 'backend', 'Tab / Order Details', 'script', NULL),
(305, 'tabOrderForm', 'backend', 'Tab / Order form', 'script', NULL),
(306, 'tabOrders', 'backend', 'Tab / Orders', 'script', NULL),
(307, 'tabTerms', 'backend', 'Tab / Terms', 'script', NULL),
(308, 'tabToAdministrators', 'backend', 'Tab / To administrators', 'script', NULL),
(309, 'tabToCustomers', 'backend', 'Tab / To customers', 'script', NULL),
(310, 'url', 'backend', 'URL', 'script', NULL),
(311, 'user', 'backend', 'Username', 'script', NULL),
(312, 'front_added_to_cart', 'frontend', 'Label / Added to cart', 'script', NULL),
(313, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(314, 'front_agree_with_terms', 'frontend', 'Label / I agrees with terms and conditions', 'script', NULL),
(315, 'front_all_categories', 'frontend', 'Label / All categories', 'script', NULL),
(316, 'front_btn_cancel', 'frontend', 'Button / Cancel', 'script', NULL),
(317, 'front_btn_close', 'frontend', 'Button / Close', 'script', NULL),
(318, 'front_btn_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(319, 'front_btn_order', 'frontend', 'Button / Order', 'script', NULL),
(320, 'front_btn_preview_booking', 'frontend', 'Button / Preview Booking', 'script', NULL),
(321, 'front_btn_start_over', 'frontend', 'Button / Start over', 'script', NULL),
(322, 'front_cancel_booking_id', 'frontend', 'label / Order ID', 'script', NULL),
(323, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(324, 'front_cart_empty', 'frontend', 'Label / Your cart is empty', 'script', NULL),
(325, 'front_category', 'frontend', 'Label / Category', 'script', NULL),
(326, 'front_cc_code', 'frontend', 'Label / CC code', 'script', NULL),
(327, 'front_cc_exp', 'frontend', 'Label / CC expiration', 'script', NULL),
(328, 'front_cc_number', 'frontend', 'Label / CC number', 'script', NULL),
(329, 'front_cc_type', 'frontend', 'Label / CC type', 'script', NULL),
(330, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(331, 'front_company', 'frontend', 'Label / Company', 'script', NULL),
(332, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(333, 'front_delivery_date', 'frontend', 'Label / Delivery date', 'script', NULL),
(334, 'front_deposit', 'frontend', 'Label / Deposit', 'script', NULL),
(335, 'front_email', 'frontend', 'Label / Email', 'script', NULL),
(336, 'front_email_not_valid', 'frontend', 'Label / Email address is invalid.', 'script', NULL),
(337, 'front_enter_quantity', 'frontend', 'Label / Enter quantity', 'script', NULL),
(338, 'front_field_required', 'frontend', 'Label / This field is required.', 'script', NULL),
(339, 'front_label_txn_id', 'frontend', 'label / Transaction ID', 'script', NULL),
(340, 'front_language', 'frontend', 'Label / Language', 'script', NULL),
(341, 'front_menu', 'frontend', 'Label / Menu', 'script', NULL),
(342, 'front_menu_cart', 'frontend', 'Menu / Cart', 'script', NULL),
(343, 'front_menu_desc', 'frontend', 'Label / Menu description', 'script', NULL),
(344, 'front_menu_title', 'frontend', 'Label / Menu Title Here', 'script', NULL),
(345, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(346, 'front_notes', 'frontend', 'Label / Special instructions', 'script', NULL),
(347, 'front_no_menus_available', 'frontend', 'Label / Menu is not available.', 'script', NULL),
(348, 'front_order_completed', 'frontend', 'Label / Your order completed', 'script', NULL),
(349, 'front_order_details', 'frontend', 'Label / Order details', 'script', NULL),
(350, 'front_packages', 'frontend', 'Label / Packages', 'script', NULL),
(351, 'front_package_desc', 'frontend', 'Label / Package description', 'script', NULL),
(352, 'front_package_not_found', 'frontend', 'Label / Package not found!', 'script', NULL),
(353, 'front_package_title', 'frontend', 'Label / Packages', 'script', NULL),
(354, 'front_payment_medthod', 'frontend', 'Label / Payment method', 'script', NULL),
(355, 'front_people', 'frontend', 'Label / people', 'script', NULL),
(356, 'front_person', 'frontend', 'Label / person', 'script', NULL),
(357, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(358, 'front_processed_on', 'frontend', 'label / Processed on', 'script', NULL),
(359, 'front_product', 'frontend', 'Label / Product', 'script', NULL),
(360, 'front_products', 'frontend', 'Label / Products', 'script', NULL),
(361, 'front_product_not_found', 'frontend', 'Label / Product not found', 'script', NULL),
(362, 'front_quantity', 'frontend', 'Label / Quantity', 'script', NULL),
(363, 'front_size_price', 'frontend', 'Label / Size & price', 'script', NULL),
(364, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(365, 'front_subtotal', 'frontend', 'Label / Sub total', 'script', NULL),
(366, 'front_suitable_for', 'frontend', 'Label / suitable for', 'script', NULL),
(367, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(368, 'front_terms_title', 'frontend', 'Label / Terms and conditions', 'script', NULL),
(369, 'front_time', 'frontend', 'Label / Time', 'script', NULL),
(370, 'front_title', 'frontend', 'Label / Title', 'script', NULL),
(371, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(372, 'front_total_price', 'frontend', 'Label / Total price', 'script', NULL),
(373, 'front_your_details', 'frontend', 'Label / Your details', 'script', NULL),
(374, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(375, 'frotn_incorrect_captcha', 'frontend', 'Label / Captcha is not correct.', 'script', NULL),
(376, 'admin_sms_ARRAY_confirmation', 'arrays', 'admin_sms_arr_ARRAY_confirmation', 'script', NULL),
(377, 'admin_sms_ARRAY_payment', 'arrays', 'admin_sms_arr_ARRAY_payment', 'script', NULL),
(378, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(379, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(380, 'buttons_ARRAY_send', 'arrays', 'buttons_ARRAY_send', 'script', NULL),
(381, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(382, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(383, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(384, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(385, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(386, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(387, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(388, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(389, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(390, 'client_email_ARRAY_cancel', 'arrays', 'client_email_arr_ARRAY_cancel', 'script', NULL),
(391, 'client_email_ARRAY_confirmation', 'arrays', 'client_email_arr_ARRAY_confirmation', 'script', NULL),
(392, 'client_email_ARRAY_payment', 'arrays', 'client_email_arr_ARRAY_payment', 'script', NULL),
(393, 'client_sms_ARRAY_confirmation', 'arrays', 'client_sms_arr_ARRAY_confirmation', 'script', NULL),
(394, 'client_sms_ARRAY_payment', 'arrays', 'client_sms_arr_ARRAY_payment', 'script', NULL),
(395, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(396, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(397, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(398, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(399, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(400, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(401, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(402, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(403, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(404, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(405, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(406, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(407, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(408, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(409, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(410, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(411, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(412, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(413, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(414, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(415, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(416, 'enum_arr_ARRAY_0', 'arrays', 'enum_arr_ARRAY_0', 'script', NULL),
(417, 'enum_arr_ARRAY_1', 'arrays', 'enum_arr_ARRAY_1', 'script', NULL),
(418, 'enum_arr_ARRAY_2', 'arrays', 'enum_arr_ARRAY_2', 'script', NULL),
(419, 'enum_arr_ARRAY_24Hour', 'arrays', 'enum_arr_ARRAY_24Hour', 'script', NULL),
(420, 'enum_arr_ARRAY_cancelled', 'arrays', 'enum_arr_ARRAY_cancelled', 'script', NULL),
(421, 'enum_arr_ARRAY_confirmed', 'arrays', 'enum_arr_ARRAY_confirmed', 'script', NULL),
(422, 'enum_arr_ARRAY_Day', 'arrays', 'enum_arr_ARRAY_Day', 'script', NULL),
(423, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(424, 'enum_arr_ARRAY_Night', 'arrays', 'enum_arr_ARRAY_Night', 'script', NULL),
(425, 'enum_arr_ARRAY_No', 'arrays', 'enum_arr_ARRAY_No', 'script', NULL),
(426, 'enum_arr_ARRAY_pending', 'arrays', 'enum_arr_ARRAY_pending', 'script', NULL),
(427, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(428, 'enum_arr_ARRAY_Yes', 'arrays', 'enum_arr_ARRAY_Yes', 'script', NULL),
(429, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(430, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(431, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(432, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(433, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(434, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(435, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(436, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(437, 'error_bodies_ARRAY_ACT01', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(438, 'error_bodies_ARRAY_ACT03', 'arrays', 'error_bodies_ARRAY_ACT03', 'script', NULL),
(439, 'error_bodies_ARRAY_ACT04', 'arrays', 'error_bodies_ARRAY_ACT04', 'script', NULL),
(440, 'error_bodies_ARRAY_ACT05', 'arrays', 'error_bodies_ARRAY_ACT05', 'script', NULL),
(441, 'error_bodies_ARRAY_ACT06', 'arrays', 'error_bodies_ARRAY_ACT06', 'script', NULL),
(442, 'error_bodies_ARRAY_ACT08', 'arrays', 'error_bodies_ARRAY_ACT08', 'script', NULL),
(443, 'error_bodies_ARRAY_ACT09', 'arrays', 'error_bodies_ARRAY_ACT09', 'script', NULL),
(444, 'error_bodies_ARRAY_ACT10', 'arrays', 'error_bodies_ARRAY_ACT10', 'script', NULL),
(445, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(446, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(447, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(448, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(449, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(450, 'error_bodies_ARRAY_AP01', 'arrays', 'error_bodies_ARRAY_AP01', 'script', NULL),
(451, 'error_bodies_ARRAY_AP03', 'arrays', 'error_bodies_ARRAY_AP03', 'script', NULL),
(452, 'error_bodies_ARRAY_AP04', 'arrays', 'error_bodies_ARRAY_AP04', 'script', NULL),
(453, 'error_bodies_ARRAY_AP05', 'arrays', 'error_bodies_ARRAY_AP05', 'script', NULL),
(454, 'error_bodies_ARRAY_AP06', 'arrays', 'error_bodies_ARRAY_AP06', 'script', NULL),
(455, 'error_bodies_ARRAY_AP08', 'arrays', 'error_bodies_ARRAY_AP08', 'script', NULL),
(456, 'error_bodies_ARRAY_AP09', 'arrays', 'error_bodies_ARRAY_AP09', 'script', NULL),
(457, 'error_bodies_ARRAY_AP10', 'arrays', 'error_bodies_ARRAY_AP10', 'script', NULL),
(458, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(459, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(460, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(461, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(462, 'error_bodies_ARRAY_ASO01', 'arrays', 'error_bodies_ARRAY_ASO01', 'script', NULL),
(463, 'error_bodies_ARRAY_ASO03', 'arrays', 'error_bodies_ARRAY_ASO03', 'script', NULL),
(464, 'error_bodies_ARRAY_ASO04', 'arrays', 'error_bodies_ARRAY_ASO04', 'script', NULL),
(465, 'error_bodies_ARRAY_ASO05', 'arrays', 'error_bodies_ARRAY_ASO05', 'script', NULL),
(466, 'error_bodies_ARRAY_ASO06', 'arrays', 'error_bodies_ARRAY_ASO06', 'script', NULL),
(467, 'error_bodies_ARRAY_ASO08', 'arrays', 'error_bodies_ARRAY_ASO08', 'script', NULL),
(468, 'error_bodies_ARRAY_ASO09', 'arrays', 'error_bodies_ARRAY_ASO09', 'script', NULL),
(469, 'error_bodies_ARRAY_ASO10', 'arrays', 'error_bodies_ARRAY_ASO10', 'script', NULL),
(470, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(471, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(472, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(473, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(474, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(475, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(476, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(477, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(478, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(479, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(480, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(481, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(482, 'error_titles_ARRAY_ACT01', 'arrays', 'error_titles_ARRAY_ACT01', 'script', NULL),
(483, 'error_titles_ARRAY_ACT03', 'arrays', 'error_titles_ARRAY_ACT03', 'script', NULL),
(484, 'error_titles_ARRAY_ACT04', 'arrays', 'error_titles_ARRAY_ACT04', 'script', NULL),
(485, 'error_titles_ARRAY_ACT05', 'arrays', 'error_titles_ARRAY_ACT05', 'script', NULL),
(486, 'error_titles_ARRAY_ACT06', 'arrays', 'error_titles_ARRAY_ACT06', 'script', NULL),
(487, 'error_titles_ARRAY_ACT08', 'arrays', 'error_titles_ARRAY_ACT08', 'script', NULL),
(488, 'error_titles_ARRAY_ACT09', 'arrays', 'error_titles_ARRAY_ACT09', 'script', NULL),
(489, 'error_titles_ARRAY_ACT10', 'arrays', 'error_titles_ARRAY_ACT10', 'script', NULL),
(490, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(491, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(492, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(493, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(494, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(495, 'error_titles_ARRAY_AP01', 'arrays', 'error_titles_ARRAY_AP01', 'script', NULL),
(496, 'error_titles_ARRAY_AP03', 'arrays', 'error_titles_ARRAY_AP03', 'script', NULL),
(497, 'error_titles_ARRAY_AP04', 'arrays', 'error_titles_ARRAY_AP04', 'script', NULL),
(498, 'error_titles_ARRAY_AP05', 'arrays', 'error_titles_ARRAY_AP05', 'script', NULL),
(499, 'error_titles_ARRAY_AP06', 'arrays', 'error_titles_ARRAY_AP06', 'script', NULL),
(500, 'error_titles_ARRAY_AP08', 'arrays', 'error_titles_ARRAY_AP08', 'script', NULL),
(501, 'error_titles_ARRAY_AP09', 'arrays', 'error_titles_ARRAY_AP09', 'script', NULL),
(502, 'error_titles_ARRAY_AP10', 'arrays', 'error_titles_ARRAY_AP10', 'script', NULL),
(503, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(504, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(505, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(506, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(507, 'error_titles_ARRAY_ASO01', 'arrays', 'error_titles_ARRAY_ASO01', 'script', NULL),
(508, 'error_titles_ARRAY_ASO03', 'arrays', 'error_titles_ARRAY_ASO03', 'script', NULL),
(509, 'error_titles_ARRAY_ASO04', 'arrays', 'error_titles_ARRAY_ASO04', 'script', NULL),
(510, 'error_titles_ARRAY_ASO05', 'arrays', 'error_titles_ARRAY_ASO05', 'script', NULL),
(511, 'error_titles_ARRAY_ASO06', 'arrays', 'error_titles_ARRAY_ASO06', 'script', NULL),
(512, 'error_titles_ARRAY_ASO08', 'arrays', 'error_titles_ARRAY_ASO08', 'script', NULL),
(513, 'error_titles_ARRAY_ASO09', 'arrays', 'error_titles_ARRAY_ASO09', 'script', NULL),
(514, 'error_titles_ARRAY_ASO10', 'arrays', 'error_titles_ARRAY_ASO10', 'script', NULL),
(515, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(516, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(517, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(518, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(519, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(520, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(521, 'front_order_statuses_ARRAY_0', 'arrays', 'front_order_statuses_ARRAY_0', 'script', NULL),
(522, 'front_order_statuses_ARRAY_1', 'arrays', 'front_order_statuses_ARRAY_1', 'script', NULL),
(523, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(524, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(525, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(526, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(527, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(528, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(529, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(530, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(531, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(532, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(533, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(534, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(535, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(536, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(537, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(538, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(539, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(540, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(541, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(542, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(543, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(544, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(545, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(546, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(547, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(548, 'order_statuses_ARRAY_cancelled', 'arrays', 'order_statuses_ARRAY_cancelled', 'script', NULL),
(549, 'order_statuses_ARRAY_confirmed', 'arrays', 'order_statuses_ARRAY_confirmed', 'script', NULL),
(550, 'order_statuses_ARRAY_pending', 'arrays', 'order_statuses_ARRAY_pending', 'script', NULL),
(551, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(552, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(553, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(554, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(555, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(556, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(557, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(558, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(559, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(560, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(561, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(562, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(563, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(564, 'role_arr_ARRAY_1', 'arrays', 'role_arr_ARRAY_1', 'script', NULL),
(565, 'role_arr_ARRAY_2', 'arrays', 'role_arr_ARRAY_2', 'script', NULL),
(566, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(567, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(568, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(569, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(570, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(571, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(572, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(573, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(574, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(575, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(576, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(577, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(578, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(579, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(580, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(581, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(582, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(583, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(584, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(585, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(586, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(587, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(588, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(589, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(590, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(591, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(592, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(593, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(594, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(595, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(596, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(597, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(598, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(599, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(600, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(601, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(602, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(603, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(604, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(605, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(606, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(607, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(608, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(609, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(610, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(611, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(612, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(613, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(614, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(615, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(616, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(617, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(618, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(619, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(620, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(621, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(622, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(623, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(624, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(625, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(626, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL);

INSERT INTO `catering_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Send Confirmation Email', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 6, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 7, 'pjField', 1, 'title', '+ Add', 'script'),
(NULL, 8, 'pjField', 1, 'title', '+ Add Category', 'script'),
(NULL, 9, 'pjField', 1, 'title', '+ Add Order', 'script'),
(NULL, 10, 'pjField', 1, 'title', '+ Add Package', 'script'),
(NULL, 11, 'pjField', 1, 'title', '+ Add Product', 'script'),
(NULL, 12, 'pjField', 1, 'title', '+ Add User', 'script'),
(NULL, 13, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Calculate Total', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 20, 'pjField', 1, 'title', '+ Add Product', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 29, 'pjField', 1, 'title', '+ Add Order', 'script'),
(NULL, 30, 'pjField', 1, 'title', '+ Add Package', 'script'),
(NULL, 31, 'pjField', 1, 'title', '+ Add Product', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Delivery date', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Set up Email notifications', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Latest orders', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Customize Order form', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'No orders found.', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'orders to deliver today', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'orders received today', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'order to deliver today', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Orders to be delivered', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'order received today', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Quick links', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Set up Payment options', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'total orders', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'View Orders', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'View Products', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 68, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Create a new category by adding its name, description and image. You can create a main category or a sub-category. One level sub-categories are supported.', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Add category', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'For each package you can add title, description, number of people package is valid for, price, image and products it includes.', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Add Package', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Use the form below to add new product. You can add product name, description, upload an image, and price based on meal size.', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Add product', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Fill in the form below and click "Save" to add a new user.', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'You can create different categories to organize the products in your menu.', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Please, fill in the client information before saving the order.', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Configure the general settings of your Catering System.', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Please copy the install code below and put it on your web page.', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Select the products and / or packages you want to order and set the delivery date and time. You can change order status and set payment terms.', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Order details', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Select the default and required fields on the front-end.  Just choose ''Yes'' if you want to show the field on the Order form, or ''No'' to hide the field.', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Order form', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Here you can choose your payment methods, set payment gateway accounts and preferences.', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Review a list of all orders. Using the quick buttons below, you can manually add a new order, change its status, edit order details, browse and delete orders. ', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'List of orders', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Order options', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Below you can see all available packages. Feel free to create as many packages as you need!', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Packages', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'There are multiple color schemes available for the front-end. Click on each of the thumbnails below to preview themes. Press "Use this theme" button to enable it. Then scroll down and copy/paste the Install code on your web page.', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Below you can find a list with all products in the menu. You can add as many items as you wish, delete or edit existing products.', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Enter your booking Terms & Conditions and click “Save”.', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Terms & Conditions', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Set the automated email notifications sent to script admins. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Notifications sent to script administrators', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Below you can create different types of auto-responders triggered by different events, such as new order, new payment received, and cancellation. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Notifications sent to customers', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Use the form below to change category details.', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Update category', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Use the form below to edit package details.', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Update package', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Use the form below to update product details.', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Update product', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update the user information.', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Below is a list of all users. You can add new users, edit user details and change user status. ', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Add as main category', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'All categories', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Use the tokens below to personalize your email messages. <br/><br/><label>{DeliveryDate}</label><label>{Products}</label><label>{UniqueID}</label><label>{Deposit}</label><label>{Total}</label><label>{Tax}</label><label>{PaymentMethod}</label><label>{CCType}</label><label>{CCNum}</label><label>{CCExp}</label><label>{CCSec}</label><label>{Title}</label><label>{Name}</label><label>{Email}</label><label>{Phone}</label><label>{Country}</label><label>{City}</label><label>{State}</label><label>{Zip}</label><label>{Address}</label><label>{Company}</label><label>{CancelURL}</label>', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Capacity', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Category title', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Choose color theme', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Count', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Delivery date & time', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Description:', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Filter by', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'here', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'No categories found. Add a category', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'There is no order with such ID.', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'No products available. To add one click {STAG}here{ETAG}', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Package', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Parent category:', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'People', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Please enter positive number.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Print order', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Product', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Qty', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Quantity', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Special instructions', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Category title is already used.', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Offer title is already used.', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Select package', 'script'),
(NULL, 191, 'pjField', 1, 'title', ' Please select package.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Select product', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Please select product.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Select size', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Send Confirmation Email', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Set different sizes', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Size', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Size & Price', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Suitable for', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Order details', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Packages', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Orders', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Packages', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a order cancelled. ', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new order made. ', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new payment made. ', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'Order confirmation SMS', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Allow payments via Authorize.Net:', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers:', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Allow cash payments:', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Collect Credit Card details:', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Allow payments via PayPal:', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Authorize.Net MD5 hash', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Authorize.Net merchant ID', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Authorize.Net time zone', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Authorize.Net transaction key', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Please, enter your Bank account information:', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'All orders made but still not paid will be set as:', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Cancel confirmation message', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for cancelling their orders.', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'New order received email', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'New order confirmation message', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'New order confirmation subject', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their orders. ', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Payment confirmation message', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Payment confirmation subject', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Please, select "Yes" if you want to disable payments and only collect order details. ', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'All orders made and paid will be set as:', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'PayPal business Email address:', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Order confirmation SMS', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Terms & Conditions', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'URL of the web page where your clients will be redirected to after a PayPal or Authorize.Net payment:', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Please enter only digits', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Please enter a valid number.', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Client Details', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Order Details', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Order form', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Orders', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'To administrators', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'To customers', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Added to {STAG}cart{ETAG}', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'I agree with the {STAG}Terms & Conditions{ETAG}.', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'All categories', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Cancel Order', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Submit Order', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Start over', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Order ID', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Your cart is still empty.', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Delivery date', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Email address is invalid.', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Enter quantity', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Transaction ID', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Language', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Menu', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Cart', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea ', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Our Menu', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Special instructions', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'No products found.', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Order completed!', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Order details', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Packages', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea ', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Package not found!', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Packages', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'people', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'person', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Product', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'No products found', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Quantity', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Size & Price', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Sub total', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'suitable for', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Terms & Conditions', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Total price', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Your details', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Order confirmation SMS', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Order with such ID does not exist.', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'The order has been cancelled successfully.', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Order is already cancelled.', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'New order received email', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Order confirmation SMS', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Yes (required)', 'script'),
(NULL, 419, 'pjField', 1, 'title', '24 Hour', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Night', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'All changes made to category have been saved.', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Category has been added successfully.', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Category could not be added. Please try again.', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'New category could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'The category could not be updated successfully because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'We are sorry that category you are looking for is missing.', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'New category has been added, but image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'The category has been updated, but image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'All the changes made to General Options have been saved.', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'All changes made to the Order options have been saved successfully.', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'All changes made to order form have been saved successfully.', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'All changes to the product have been saved.', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Product has been added successfully.', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'We are sorry that new product could not be added successfully.', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'New product could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'The product could not be updated successfully because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'We are sorry that product you are looking for is missing.', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'New product has been added, but image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'The product has been updated, but image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'All changes made to the order have been updated.', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'New order has been added into the system.', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'We are sorry that new order could not be added successfully. Please try again.', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'We are sorry that order you are looking for is missing.', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'All changes made to package have been saved.', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Package has been added successfully.', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Package could not be added. Please try again.', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'New package could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'The package could not be updated successfully because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'We are sorry that package you are looking for is missing.', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'New package has been added, but image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'The package has been updated, but image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Category updated', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Category added', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Category failed to added', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Image size too big', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Image size too big', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Category not found', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Order options updated!', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Order form updated!', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Terms & Conditions updated', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Product updated', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Product added', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Product failed to add', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Product not found', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Order updated!', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Order added!', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Order not added!', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Order not found!', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Package updated', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Package added', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Package failed to added', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Image size too big', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Image size too big', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Package not found', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Thank you! Your order has been sent successfully. Please, click on the "Start over" button if you wish to make a new order.', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Authorize.Net', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Wire transfer', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Editor', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'No property for the order found', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'No order found', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'No permisions to edit the order', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'Order received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', '<p>Dear&nbsp;{Name},</p>\r\n<p>&nbsp;</p>\r\n<p>we''ve received your order and will get back to you ASAP.</p>\r\n<p>&nbsp;</p>\r\n<p>Delivery date:&nbsp;{DeliveryDate}</p>\r\n<p>Products:&nbsp;{Products}</p>\r\n<p>Total: {Total}</p>\r\n<p>&nbsp;</p>\r\n<p>Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', 'Order confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', '<p>Dear&nbsp;{Name},</p>\r\n<p>&nbsp;</p>\r\n<p>we''ve received the payment for your order!</p>\r\n<p>&nbsp;</p>\r\n<p>Delivery date:&nbsp;{DeliveryDate}</p>\r\n<p>Products:&nbsp;{Products}</p>\r\n<p>Total: {Total}</p>\r\n<p>&nbsp;</p>\r\n<p>Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Order cancelled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', '<p>Dear&nbsp;{Name},</p>\r\n<p>&nbsp;</p>\r\n<p>order has been cancelled.</p>\r\n<p>&nbsp;</p>\r\n<p>Delivery date:&nbsp;{DeliveryDate}</p>\r\n<p>Products:&nbsp;{Products}</p>\r\n<p>Total: {Total}</p>\r\n<p>&nbsp;</p>\r\n<p>Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', 'New order', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', '<p>A new order has been received.</p>\r\n<p>&nbsp;</p>\r\n<p>Delivery date:&nbsp;{DeliveryDate}</p>\r\n<p>Products:&nbsp;{Products}</p>\r\n<p>Total: {Total}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', 'New payment', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', '<p>A new order payment has been received.</p>\r\n<p>&nbsp;</p>\r\n<p>Delivery date:&nbsp;{DeliveryDate}</p>\r\n<p>Products:&nbsp;{Products}</p>\r\n<p>Total: {Total}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', 'Order cancelled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', '<p>Order has been cancelled.</p>\r\n<p>&nbsp;</p>\r\n<p>Delivery date:&nbsp;{DeliveryDate}</p>\r\n<p>Products:&nbsp;{Products}</p>\r\n<p>Total: {Total}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', NULL, 'data');

INSERT INTO `catering_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_layout', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 13, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_deposit_payment', 2, '10', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 2, '10.00', NULL, 'int', 4, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_thankyou_page', 2, 'http://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::No', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::Yes', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 9, 1, NULL),

(1, 'o_admin_email_confirmation', 4, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 4, '', NULL, 'string', 8, 1, NULL),
(1, 'o_admin_email_confirmation_message', 4, '', NULL, 'text', 9, 1, NULL),
(1, 'o_admin_email_payment', 4, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
(1, 'o_admin_email_payment_subject', 4, '', NULL, 'string', 11, 1, NULL),
(1, 'o_admin_email_payment_message', 4, '', NULL, 'text', 12, 1, NULL),
(1, 'o_admin_email_cancel', 4, '0|1::1', 'No|Yes',  'enum', 13, 1, NULL),
(1, 'o_admin_email_cancel_subject', 4, '', NULL, 'string', 14, 1, NULL),
(1, 'o_admin_email_cancel_message', 4, '', NULL, 'text', 15, 1, NULL),

(1, 'o_sms_confirmation_message', 5, '', NULL, 'text', 2, 1, NULL),
(1, 'o_sms_payment_message', 5, '', NULL, 'text', 3, 1, NULL),

(1, 'o_admin_sms_confirmation_message', 6, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_sms_payment_message', 6, '', NULL, 'text', 5, 1, NULL),

(1, 'o_bf_include_title', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_name', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_email', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_company', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_address', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_country', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_state', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_city', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_bf_include_zip', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_notes', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_captcha', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 15, 1, NULL),

(1, 'o_terms', 8, '', NULL, 'text', 1, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `catering_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');