<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminOrders extends pjAdmin
{
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminOrders.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetOrder()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjOrderModel = pjOrderModel::factory();
				
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjOrderModel->where("(t1.id = '$q' OR t1.uuid = '$q' OR t1.c_name LIKE '%$q%' OR t2.content LIKE '%$q%')");
			}
			
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('confirmed','cancelled','pending')))
			{
				$pjOrderModel->where('t1.status', $_GET['status']);
			}
			
			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjOrderModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array();
			
			$data = $pjOrderModel
				->select("t1.*, AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,
								AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
								AES_DECRYPT(t1.cc_exp_month, '".PJ_SALT."') AS `cc_exp_month`,
								AES_DECRYPT(t1.cc_exp_year, '".PJ_SALT."') AS `cc_exp_year`,
								AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			
			foreach($data as $k => $v)
			{
				$v['delivery_dt'] = date($this->option_arr['o_date_format'], strtotime($v['delivery_dt'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['delivery_dt']));
				$v['total'] = pjUtil::formatCurrencySign($v['total'], $this->option_arr['o_currency']);
				$v['c_name'] = pjSanitize::html($v['c_name'], array('remove' => true) );
				$data[$k] = $v;
			}
			
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionSaveOrder()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjOrderModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
		}
		exit;
	}
	
	public function pjActionExportOrder()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjOrderModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Orders-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionDeleteOrder()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjOrderModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjOrderProductModel::factory()->where('order_id', $_GET['id'])->eraseAll();
				pjOrderPaymentModel::factory()->where('order_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteOrderBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjOrderModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjOrderProductModel::factory()->whereIn('order_id', $_POST['record'])->eraseAll();
				pjOrderPaymentModel::factory()->whereIn('order_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['order_create']))
			{
				$data = array();
				
				$delivery_dt_arr = pjUtil::convertDateTime($_POST['delivery_dt'], $this->option_arr['o_date_format'], $this->option_arr['o_time_format']);
				
				$data['uuid'] = time();
				$data['delivery_dt'] = $delivery_dt_arr['iso_date_time'];
				$data['ip'] = pjUtil::getClientIp();
				
				$id = pjOrderModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$pjOrderProductModel = pjOrderProductModel::factory();
					if(isset($_POST['product_id']) && is_array($_POST['product_id']) && count($_POST['product_id']) > 0)
					{
						foreach($_POST['product_id'] as $index => $product_id)
						{
							$op_data = array();
							$op_data['order_id'] = $id;
							$op_data['type'] = 'products';
							$op_data['product_id'] = $product_id;
							$op_data['package_id'] = ':NULL';
							$op_data['size_id'] = isset($_POST['size_id'][$index]) ? $_POST['size_id'][$index] : ':NULL';
							$op_data['unit_price'] = isset($_POST['product_unit_price'][$index]) ? $_POST['product_unit_price'][$index] : ':NULL';
							$op_data['qty'] = isset($_POST['qty'][$index]) ? $_POST['qty'][$index] : ':NULL';
							$op_data['price'] = isset($_POST['product_price'][$index]) ? $_POST['product_price'][$index] : ':NULL';
							$pjOrderProductModel->reset()->setAttributes($op_data)->insert();
						}
					}
					if(isset($_POST['package_id']) && is_array($_POST['package_id']) && count($_POST['package_id']) > 0)
					{
						foreach($_POST['package_id'] as $index => $package_id)
						{
							$op_data = array();
							$op_data['order_id'] = $id;
							$op_data['type'] = 'packages';
							$op_data['product_id'] = ':NULL';
							$op_data['package_id'] = $package_id;
							$op_data['size_id'] = ':NULL';
							$op_data['unit_price'] = isset($_POST['package_unit_price'][$index]) ? $_POST['package_unit_price'][$index] : ':NULL';
							$op_data['qty'] = isset($_POST['qty'][$index]) ? $_POST['qty'][$index] : ':NULL';
							$op_data['price'] = isset($_POST['package_price'][$index]) ? $_POST['package_price'][$index] : ':NULL';
							$pjOrderProductModel->reset()->setAttributes($op_data)->insert();
						}
					}
					$err = 'AR03';
				}else{
					$err = 'AR04';
				}
				
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminOrders&action=pjActionIndex&err=$err");
			}else{
				
				$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`country_title` ASC')
					->findAll()
					->getData();
				
				$this->set('country_arr', $country_arr);
				
				$sort_arr = array();
				$product_arr = array();
				$category_arr = pjCategoryModel::factory()
					->select("t1.id, t1.parent_id, t1.order,
						(CASE
						    WHEN t1.parent_id=t1.id OR t1.parent_id IS NULL  THEN t1.`order`
						    WHEN t1.parent_id<>t1.id THEN (SELECT t4.`order` FROM `".pjCategoryModel::factory()->getTable()."` AS `t4` WHERE t4.id=t1.parent_id)
						END) AS 'the_order'")
					->orderBy("the_order ASC, t1.order ASC")
					->findAll()
					->getDataPair(null, 'id');
				
				foreach($category_arr as $k => $v)
				{
					$sort_arr[$v] = $k;
				}
				$_arr = pjProductModel::factory()
					->select('t1.*, t2.content as name, t3.content as category, t4.content as parent_category')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->join('pjMultiLang', "t3.foreign_id = t1.category_id AND t3.model = 'pjCategory' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'name'", 'left')
					->join('pjMultiLang', "t4.foreign_id = t1.parent_category_id AND t4.model = 'pjCategory' AND t4.locale = '".$this->getLocaleId()."' AND t4.field = 'name'", 'left')
					->where('t1.status', 'T')
					->orderBy("name ASC")
					->findAll()
					->getData();
				foreach($_arr as $k => $v)
				{
					$product_arr[$sort_arr[$v['category_id']]][] = $v;
				}
				ksort($product_arr);
				$this->set('product_arr', $product_arr);
				
				$package_arr = pjPackageModel::factory()
					->select('t1.*, t2.content as name')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjPackage' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('t1.status', 'T')
					->orderBy("`name` ASC")
					->findAll()
					->getData();
				
				$this->set('package_arr', $package_arr);
				
				$this->appendJs('jquery-ui-timepicker-addon.js', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendCss('jquery-ui-timepicker-addon.css', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminOrders.js');
			}
		} else {
			
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['order_update']))
			{
				$pjOrderModel = pjOrderModel::factory();
				
				$arr = pjOrderModel::factory()->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminOrders&action=pjActionIndex&err=AR08");
				}
				
				$data = array();
				$delivery_dt_arr = pjUtil::convertDateTime($_POST['delivery_dt'], $this->option_arr['o_date_format'], $this->option_arr['o_time_format']);
				
				$data['delivery_dt'] = $delivery_dt_arr['iso_date_time'];
				$data['ip'] = pjUtil::getClientIp();
				$pjOrderModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				
				$pjOrderProductModel = pjOrderProductModel::factory();
				$pjOrderProductModel->where('order_id', $_POST['id'])->eraseAll();
				
				$pjOrderProductModel = pjOrderProductModel::factory();
				if(isset($_POST['product_id']) && is_array($_POST['product_id']) && count($_POST['product_id']) > 0)
				{
					foreach($_POST['product_id'] as $index => $product_id)
					{
						$op_data = array();
						$op_data['order_id'] = $_POST['id'];
						$op_data['type'] = 'products';
						$op_data['product_id'] = $product_id;
						$op_data['package_id'] = ':NULL';
						$op_data['size_id'] = isset($_POST['size_id'][$index]) ? $_POST['size_id'][$index] : ':NULL';
						$op_data['unit_price'] = isset($_POST['product_unit_price'][$index]) ? $_POST['product_unit_price'][$index] : ':NULL';
						$op_data['qty'] = isset($_POST['qty'][$index]) ? $_POST['qty'][$index] : ':NULL';
						$op_data['price'] = isset($_POST['product_price'][$index]) ? $_POST['product_price'][$index] : ':NULL';
						$pjOrderProductModel->reset()->setAttributes($op_data)->insert();
					}
				}
				if(isset($_POST['package_id']) && is_array($_POST['package_id']) && count($_POST['package_id']) > 0)
				{
					foreach($_POST['package_id'] as $index => $package_id)
					{
						$op_data = array();
						$op_data['order_id'] = $_POST['id'];
						$op_data['type'] = 'packages';
						$op_data['product_id'] = ':NULL';
						$op_data['package_id'] = $package_id;
						$op_data['size_id'] = ':NULL';
						$op_data['unit_price'] = isset($_POST['package_unit_price'][$index]) ? $_POST['package_unit_price'][$index] : ':NULL';
						$op_data['qty'] = isset($_POST['qty'][$index]) ? $_POST['qty'][$index] : ':NULL';
						$op_data['price'] = isset($_POST['package_price'][$index]) ? $_POST['package_price'][$index] : ':NULL';
						$pjOrderProductModel->reset()->setAttributes($op_data)->insert();
					}
				}
				
				$err = 'AR01';
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminOrders&action=pjActionIndex&err=$err");
			}else{
				
				$arr = pjOrderModel::factory()->find($_GET['id'])->getData();
				if(count($arr) <= 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminOrders&action=pjActionIndex&err=AR08");
				}
				$this->set('arr', $arr);
				
				$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`country_title` ASC')
					->findAll()
					->getData();
				$this->set('country_arr', $country_arr);
				
				$sort_arr = array();
				$product_arr = array();
				$category_arr = pjCategoryModel::factory()
					->select("t1.id, t1.parent_id, t1.order,
						(CASE
						    WHEN t1.parent_id=t1.id OR t1.parent_id IS NULL  THEN t1.`order`
						    WHEN t1.parent_id<>t1.id THEN (SELECT t4.`order` FROM `".pjCategoryModel::factory()->getTable()."` AS `t4` WHERE t4.id=t1.parent_id)
						END) AS 'the_order'")
					->orderBy("the_order ASC, t1.order ASC")
					->findAll()
					->getDataPair(null, 'id');
				
				foreach($category_arr as $k => $v)
				{
					$sort_arr[$v] = $k;
				}
				$_arr = pjProductModel::factory()
					->select('t1.*, t2.content as name, t3.content as category, t4.content as parent_category')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->join('pjMultiLang', "t3.foreign_id = t1.category_id AND t3.model = 'pjCategory' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'name'", 'left')
					->join('pjMultiLang', "t4.foreign_id = t1.parent_category_id AND t4.model = 'pjCategory' AND t4.locale = '".$this->getLocaleId()."' AND t4.field = 'name'", 'left')
					->where('t1.status', 'T')
					->orderBy("name ASC")
					->findAll()
					->getData();
				foreach($_arr as $k => $v)
				{
					$product_arr[$sort_arr[$v['category_id']]][] = $v;
				}
				ksort($product_arr);
				$this->set('product_arr', $product_arr);
				
				$package_arr = pjPackageModel::factory()
					->select('t1.*, t2.content as name')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjPackage' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('t1.status', 'T')
					->orderBy("`name` ASC")
					->findAll()
					->getData();
				
				$this->set('package_arr', $package_arr);
				
				$pjOrderProductModel = pjOrderProductModel::factory();
				
				$order_package_arr = $pjOrderProductModel
					->where('t1.type', 'packages')
					->where('t1.order_id', $arr['id'])
					->findAll()
					->getData();
				$this->set('order_package_arr', $order_package_arr);
				
				$order_product_arr = $pjOrderProductModel
					->reset()
					->where('t1.type', 'products')
					->where('t1.order_id', $arr['id'])
					->findAll()
					->getData();
				
				$product_id_arr = array();
				$size_arr = array();
				
				foreach($order_product_arr as $k => $v)
				{
					$product_id_arr[] = $v['product_id'];
				}
				
				if(!empty($product_id_arr))
				{
					$temp_size_arr = pjProductPriceModel::factory()
						->select('t1.*, t2.content as size')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'price_name'", 'left')
						->whereIn('t1.product_id', $product_id_arr)
						->findAll()
						->getData();
					foreach($temp_size_arr as $k => $v)
					{
						$size_arr[$v['product_id']][] = $v;
					}
				}
				
				$this->set('order_product_arr', $order_product_arr);
				$this->set('size_arr', $size_arr);
				
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				$this->appendJs('jquery-ui-timepicker-addon.js', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendCss('jquery-ui-timepicker-addon.css', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminOrders.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetSizes()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$size_arr = pjProductPriceModel::factory()
				->select("t1.*, t2.content as size")
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'price_name'", 'left')
				->where('t1.product_id', $_GET['product_id'])
				->findAll()
				->getData();
			$this->set('size_arr', $size_arr);
		}
	}
	
	public function pjActionConfirmation()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['send_confirm']) && !empty($_POST['to']) && !empty($_POST['from']) &&
					!empty($_POST['subject']) && !empty($_POST['message']))
			{
				$Email = new pjEmail();
				$Email->setContentType('text/html');
				if ($this->option_arr['o_send_email'] == 'smtp')
				{
					$Email
						->setTransport('smtp')
						->setSmtpHost($this->option_arr['o_smtp_host'])
						->setSmtpPort($this->option_arr['o_smtp_port'])
						->setSmtpUser($this->option_arr['o_smtp_user'])
						->setSmtpPass($this->option_arr['o_smtp_pass']);
				}
	
				$subject = $_POST['subject'];
				$message = $_POST['message'];
				if (get_magic_quotes_gpc())
				{
					$subject = stripslashes($_POST['subject']);
					$message = stripslashes($_POST['message']);
				}
	
				$r = $Email
					->setTo($_POST['to'])
					->setFrom($_POST['from'])
					->setSubject($subject)
					->send($message);
					
				if ($r)
				{
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Email has been sent.'));
				}
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => 'Email failed to send.'));
			}
	
			if (isset($_GET['order_id']) && (int) $_GET['order_id'] > 0)
			{
				$pjMultiLangModel = pjMultiLangModel::factory();
				$lang_message = $pjMultiLangModel->reset()->select('t1.*')
					->where('t1.model','pjOption')
					->where('t1.locale', $this->getLocaleId())
					->where('t1.field', 'o_email_confirmation_message')
					->limit(0, 1)
					->findAll()->getData();
				$lang_subject = $pjMultiLangModel->reset()->select('t1.*')
					->where('t1.model','pjOption')
					->where('t1.locale', $this->getLocaleId())
					->where('t1.field', 'o_email_confirmation_subject')
					->limit(0, 1)
					->findAll()->getData();
	
				if (count($lang_message) === 1 && count($lang_subject) === 1)
				{
					$order_arr = pjOrderModel::factory()->find($_GET['order_id'])->getData();
					$tokens = pjAppController::getTokens($order_arr, $this->option_arr, PJ_SALT, $this->getLocaleId());
						
					$subject_client = str_replace($tokens['search'], $tokens['replace'], $lang_subject[0]['content']);
					$message_client = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
	
					$this->set('arr', array(
							'to' => $order_arr['c_email'],
							'from' => $this->getAdminEmail(),
							'message' => $message_client,
							'subject' => $subject_client
					));
				}
			} else {
				exit;
			}
		}
	}
	
	public function pjActionPrint()
	{
		$this->setLayout('pjActionPrint');
	
		$pjOrderModel = pjOrderModel::factory();
	
		if(isset($_GET['id']) && (int) $_GET['id'] > 0)
		{
			$arr = $pjOrderModel->find($_GET['id'])->getData();
			if(!empty($arr))
			{
				$locale_id = $this->getLocaleId();
				$pjOrderProductModel = pjOrderProductModel::factory();
				$order_product_arr = $pjOrderProductModel
					->select('t1.*, t2.content AS product_name, t3.content AS price_name')
					->join('pjMultiLang', "t2.model='pjProduct' AND t2.foreign_id=t1.product_id AND t2.field='name' AND t2.locale='".$locale_id."'", 'left outer')
					->join('pjMultiLang', "t3.model='pjProductPrice' AND t3.foreign_id=t1.size_id AND t3.field='price_name' AND t3.locale='".$locale_id."'", 'left outer')
					->where('t1.type', 'products')
					->where('t1.order_id', $arr['id'])
					->findAll()
					->getData();
				$order_package_arr = $pjOrderProductModel
					->reset()
					->select('t1.*, t2.content AS package_name')
					->join('pjMultiLang', "t2.model='pjPackage' AND t2.foreign_id=t1.package_id AND t2.field='name' AND t2.locale='".$locale_id."'", 'left outer')
					->where('t1.type', 'packages')
					->where('t1.order_id', $arr['id'])
					->findAll()
					->getData();
				$country = '';
				$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$locale_id."'", 'left outer')
					->find($arr['c_country'])
					->getData();
				if (!empty($country_arr))
				{
					$country = $country_arr['country_title'];
				}
				
				$this->set('arr', $arr);
				$this->set('country', $country);
				$this->set('order_product_arr', $order_product_arr);
				$this->set('order_package_arr', $order_package_arr);
			}
		}
	}
	
}
?>