<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat orders">
				<div class="info">
					<abbr><?php echo $tpl['cnt_received_today'];?></abbr>
					<label><?php $tpl['cnt_received_today'] != 1 ? __('dash_orders_received_today') : __('dash_order_received_today');?></label>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat orders">
				<div class="info">
					<abbr><?php echo $tpl['cnt_delivery_today'];?></abbr>
					<label><?php $tpl['cnt_delivery_today'] != 1 ? __('dash_orders_delivery_today') : __('dash_order_delivery_today');?></label>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat orders">
				<div class="info">
					<abbr><?php echo $tpl['cnt_total_orders'];?></abbr>
					<label><?php __('dash_total_orders');?></label>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('dash_latest_orders');?></div>
			<div class="dashboard_column_top"><?php __('dash_order_for_delivery');?></div>
			<div class="dashboard_column_top"><?php __('dash_quick_links');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['latest_arr']) > 0)
					{
						foreach($tpl['latest_arr'] as $v)
						{
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['c_name']);?></a></label>
								<?php
								if(!empty($v['c_phone']))
								{ 
									?>
									<label><?php echo pjSanitize::html($v['c_phone']);?></label>
									<?php
								} 
								?>
								<label><?php __('dash_delivery_date');?>: <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['delivery_dt'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['delivery_dt']));?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_orders_found');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['delivery_arr']) > 0)
					{
						foreach($tpl['delivery_arr'] as $v)
						{
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['c_name']);?></a></label>
								<?php
								if(!empty($v['c_phone']))
								{ 
									?>
									<label><?php echo pjSanitize::html($v['c_phone']);?></label>
									<?php
								} 
								?>
								<label><?php __('dash_delivery_date');?>: <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['delivery_dt'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['delivery_dt']));?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_orders_found');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<div class="dashboard_row">
						<a class="block no-decor fs14 b10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionCreate"><?php __('dash_add_order');?></a>
						<?php
						if($controller->isAdmin())
						{ 
							?>
							<a class="block no-decor fs14 b10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminProducts&amp;action=pjActionCreate"><?php __('dash_add_product');?></a>
							<a class="block no-decor fs14 b20" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminPackages&amp;action=pjActionCreate"><?php __('dash_add_package');?></a>
							<?php
						} 
						?>
						
						<a class="block no-decor fs14 b10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionIndex"><?php __('dash_view_orders');?></a>
						<a class="block no-decor fs14 b20" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminProducts&amp;action=pjActionIndex"><?php __('dash_view_products');?></a>
						<?php
						if($controller->isAdmin())
						{ 
							?>
							<a class="block no-decor fs14 b10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOptions&amp;action=pjActionOrderForm"><?php __('dash_manage_order_form');?></a>
							<a class="block no-decor fs14 b10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOptions&amp;action=pjActionOrder"><?php __('dash_setup_payment_options');?></a>
							<a class="block no-decor fs14 b10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOptions&amp;action=pjActionNotification"><?php __('dash_email_notifications');?></a>
							<?php
						} 
						?>
					</div>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $other) = explode("_", date("H:i_l_F d, Y"));
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format'], time()); ?></div>
		</div>
	</div>
	<?php
}
?>